/* guielement.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: guielement.cc,v 1.6 2001/12/09 02:09:03 ralf Exp $ */

#include "guielement.h"
#include "awindow.h"

const char *GUIElement::type="GUIElement";

GUIElement::GUIElement(AGUIX *taguix)
{
  this->aguix=taguix;
  x=0;
  y=0;
  w=1;
  h=1;
  win=0;
  parent=NULL;
  focus=false;
}

GUIElement::~GUIElement()
{
  if(parent!=NULL) {
    parent->removeSubWin(win);
  }
}

void GUIElement::move(int tx,int ty)
{
  this->x=tx;
  this->y=ty;
  if(parent!=NULL) {
    parent->moveSubWin(win,tx,ty);
    redraw();
  }
}

void GUIElement::resize(int tw,int th)
{
  if((tw<1)||(th<1)) return;
  this->w=tw;
  this->h=th;
  if(parent!=NULL) {
    parent->resizeSubWin(win,tw,th);
    redraw();
  }
}

void GUIElement::redraw()
{
}

void GUIElement::flush()
{
}

const char *GUIElement::getType()
{
  return type;
}

bool GUIElement::isType(const char *qtype)
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

bool GUIElement::handleMessage(XEvent *E,Message *msg)
{
  // true falls die Message interessiert
  // false wenn nicht
  return false;
}

void GUIElement::getPos(int *tx,int *ty)
{
  *tx=this->x;
  *ty=this->y;
}

void GUIElement::getSize(int *tw,int *th)
{
  *tw=this->w;
  *th=this->h;
}

void GUIElement::setParent(AWindow *tparent)
{
  this->parent=tparent;
  win=parent->getSubWindow(0,x,y,w,h);
}

bool GUIElement::hasWin(Window twin)
{
  if(this->win==twin) return true;
  return false;
}

Window GUIElement::getWindow()
{
  return win;
}

int GUIElement::getWidth()
{
  return w;
}

int GUIElement::getHeight()
{
  return h;
}

void GUIElement::toBack()
{
  aguix->WindowtoBack(win);
}

void GUIElement::toFront()
{
  aguix->WindowtoFront(win);
}

int GUIElement::getX()
{
  return x;
}

int GUIElement::getY()
{
  return y;
}

bool GUIElement::isParent(Window twin)
{
  if(this->win==twin) return true;
  return false;
}

void GUIElement::paste(unsigned char*buf)
{
}

void GUIElement::cancelpaste()
{
}

void GUIElement::cancelcut()
{
}

void GUIElement::takeFocus()
{
  if(focus==false) {
    if(parent!=NULL) {
      if(parent->isOwner(this)==true) {
	// we are already the owner
	// do nothing
      } else {
	parent->applyFocus(this);
      }
      focus=true;
    }
  }
}

void GUIElement::leaveFocus()
{
  focus=false;
  if(parent!=NULL) {
    if(parent->isOwner(this)==true) {
      // we have the focus
      // so remove it from the awindow
      parent->invalidFocus();
    } else {
      // we are not the owner
      // so do nothing
    }
  }
}

bool GUIElement::hasFocus()
{
  return focus;
}
