/* functionproto.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: functionproto.cc,v 1.7 2001/11/03 17:10:08 ralf Exp $ */

#include "functionproto.h"
#include "worker.h"

const char *FunctionProto::name="FunctionProto";

bool FunctionProto::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FunctionProto::getName()
{
  return name;
}

FunctionProto::FunctionProto(Worker *tworker)
{
  this->worker=tworker;
}

FunctionProto::~FunctionProto()
{
}

int FunctionProto::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Requester *req;
  char *textstr,*buttonstr;
  
  req=new Requester(aguix);
  textstr=catalog.getLocale(292);
  buttonstr=catalog.getLocale(11);
  req->request(catalog.getLocale(124),textstr,buttonstr);
  delete req;

  return 0;
}

int FunctionProto::load(Datei *fh)
{
  int chunksize=fh->getInt();
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

FunctionProto *FunctionProto::duplicate()
{
  return NULL;
}

bool FunctionProto::save(Datei *fh)
{
  fh->putInt(0);
  return false;
}

FunctionProto *FunctionProto::preload(Worker *w,Datei *fh)
{
  int id=fh->getInt();
  FunctionProto *fp=w->getCommand4ID(id);
  fp->load(fh);
  return fp;
}

int FunctionProto::presave(Datei *fh,FunctionProto *fp)
{
  fh->putInt(Worker::getID4Command(fp));
  fp->save(fh);
  return 0;
}

int FunctionProto::run(ActionMessage *msg)
{
  return 0;
}

ActionMessage::ActionMessage()
{
  flags=NULL;
  mode=AM_MODE_NORMAL;
  startLister=NULL;
  extraInfo=NULL;
}

ActionMessage::~ActionMessage()
{
}

const char *FunctionProto::getDescription()
{
  return "Prototype einer Aktion";
}

