/* locale.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: locale.cc,v 1.87 2002/02/28 00:15:07 ralf Exp $ */

#include "locale.h"
#include "wconfig.h"

#define min(a,b) (((a)<(b))?(a):(b))

Locale catalog;

Locale::Locale()
{
  catalog=new char*[CATENTRY];
  catalogcom=new char*[CATCOMENTRY];
  catalogflag=new char*[CATFLAGENTRY];
  initBuiltinLang();
}

void Locale::initBuiltinLang()
{
  catalog[0]="Worker Configuration\0\0";
  catalog[1]="Global Settings\0\0";
  catalog[2]="Colors\0\0";
  catalog[3]="Startup Settings\0\0";
  catalog[4]="Buttons Settings\0\0";
  catalog[5]="Path Settings\0\0";
  catalog[6]="Filetypes\0\0";
  catalog[7]="Save\0\0";
  catalog[8]="Cancel\0\0";
  catalog[9]="Select Language:\0\0";
  catalog[10]="english (builtin)\0\0";
  catalog[11]="Okay\0\0";
  catalog[12]="Welcome to Worker\0\0";
  catalog[13]="Bytes\0\0";
  catalog[14]="Color Count:\0\0";
  catalog[15]="Palette\0\0";
  catalog[16]="Filelister-Settings\0\0";
  catalog[17]="Nr. of Rows for Buttons:\0\0";
  catalog[18]="Nr. of Columns for Buttons:\0\0";
  catalog[19]="Left ListView\0\0";
  catalog[20]="Right ListView\0\0";
  catalog[21]="Horizontal Scroller:\0\0";
  catalog[22]="top:\0\0";
  catalog[23]="Height:\0\0";
  catalog[24]="Vertical Scroller:\0\0";
  catalog[25]="left:\0\0";
  catalog[26]="Width:\0\0";
  catalog[27]="Palette-Entry:\0\0";
  catalog[28]="Red:\0\0";
  catalog[29]="Green:\0\0";
  catalog[30]="Blue:\0\0";
  catalog[31]="Statusbar\0\0";
  catalog[32]="Foreground\0\0";
  catalog[33]="Background\0\0";
  catalog[34]="Selected ListView-Bar\0\0";
  catalog[35]="Unselected ListView-Bar\0\0";
  catalog[36]="unselected dir\0\0";
  catalog[37]="selected dir\0\0";
  catalog[38]="unselected file\0\0";
  catalog[39]="selected file\0\0";
  catalog[40]="Cant' save the config to %s!|Please check the worker installation!\0\0";
  catalog[41]="Retry\0\0";
  catalog[42]="A button named %s already uses this shortcut!|Click Okay to remove the reference to this shortcut|from the button and use it here instead\0\0";
  catalog[43]="clockbar\0\0";
  catalog[44]="Requester\0\0";
  catalog[45]="Choose Color:\0\0";
  catalog[46]="left Startup-Path:\0\0";
  catalog[47]="right Startup-Path:\0\0";
  catalog[48]="Copy Button\0\0";
  catalog[49]="Swap Button\0\0";
  catalog[50]="Delete Button\0\0";
  catalog[51]="left Mousebutton\0\0";
  catalog[52]="right Mousebutton\0\0";
  catalog[53]="Choose Button to edit or Choose Action\0\0";
  catalog[54]="Select Button to copy (or press ESC to cancel)\0\0";
  catalog[55]="Select Destination-Button (will be overwrited) (or press ESC to cancel)\0\0";
  catalog[56]="Select first Button to swap (or press ESC to cancel)\0\0";
  catalog[57]="Select second Button to swap (or press ESC to cancel)\0\0";
  catalog[58]="Select Button to delete (or press ESC to cancel)\0\0";
  catalog[59]="Edit Button\0\0";
  catalog[60]="Button Title:\0\0";
  catalog[61]="Choose Shortcut\0\0";
  catalog[62]="Delete Shortcut\0\0";
  catalog[63]="A Path named %s already uses this shortcut!|Click Okay to remove the reference to this shortcut|from the path and use it here instead\0\0";
  catalog[64]="Flags\0\0";
  catalog[65]="A Hotkey named %s already uses this shortcut!|Click Okay to remove the reference to this shortcut|from the hotkey and use it here instead\0\0";
  catalog[66]="Please press the key for the shortcut!\0\0";
  catalog[67]="The destination directory %s doesn't exists!\0\0";
  catalog[68]="Bank-Nr.:\0\0";
  catalog[69]="next bank\0\0";
  catalog[70]="prev. bank\0\0";
  catalog[71]="new bank\0\0";
  catalog[72]="delete bank\0\0";
  catalog[73]="Copy path\0\0";
  catalog[74]="Swap path\0\0";
  catalog[75]="Delete path\0\0";
  catalog[76]="Choose path to edit or one of the action-Buttons\0\0";
  catalog[77]="Select path to copy (or press ESC to cancel)\0\0";
  catalog[78]="Select Destination-path (will be overwrited) (or press ESC to cancel)\0\0";
  catalog[79]="Select first path to swap (or press ESC to cancel)\0\0";
  catalog[80]="Select second path to swap (or press ESC to cancel)\0\0";
  catalog[81]="Select path to delete (or press ESC to cancel)\0\0";
  catalog[82]="Edit Path\0\0";
  catalog[83]="Path title:\0\0";
  catalog[84]="Enter path:\0\0";
  catalog[85]="New type\0\0";
  catalog[86]="Duplicate type\0\0";
  catalog[87]="Delete type\0\0";
  catalog[88]="Edit type\0\0";
  catalog[89]="Name:\0\0";
  catalog[90]="There is no Worker configuration directory.|Worker will continue and use an intern configuration!|You can start \"worker_inst\" in a shell to install an example configuration in your language!\0\0";
  catalog[91]="Hotkeys\0\0";
  catalog[92]="Hotkey-name:\0\0";
  catalog[93]="Pattern:\0\0";
  catalog[94]="Use Pattern\0\0";
  catalog[95]="Filecontent\0\0";
  catalog[96]="Use filecontent\0\0";
  catalog[97]="Byte\0\0";
  catalog[98]="Edit Byte\0\0";
  catalog[99]="Clear Byte\0\0";
  catalog[100]="Automatic creation\0\0";
  catalog[101]="Edit filecontent\0\0";
  catalog[102]="Enter code or press key\0\0";
  catalog[103]="File\0\0";
  catalog[104]="Enter the image viewing program|The string must contain the following spacefolders:|4 x %d : will replaced by x,y,w,h|%x : will replaced by the hex-number of the window|%s : will replaced by the filename\
  |%s : replaced by the background color in the X11-format \"rgb:rr/gg/bb\"| in this order!\0\0";
  catalog[105]="Free RAM\0\0";
  catalog[106]="Free Swap\0\0";
  catalog[107]="Files\0\0";
  catalog[108]="Dirs\0\0";
  catalog[109]="Dir\0\0";
  catalog[110]="Set to default viewer\0\0";
  catalog[111]="Please enter a correct string (or use the default)!\0\0";
  catalog[112]="Choose the mode to toggle:\0\0";
  catalog[113]="Error while copying %s|Source and destination is the same, skipping!\0\0";
  catalog[114]="Quitting Worker\0\0";
  catalog[115]="Do you really wanna quit Worker ?\0\0";
  catalog[116]="Copy file %s\0\0";
  catalog[117]="to %s\0\0";
  catalog[118]="files to copy:\0\0";
  catalog[119]="dirs to copy:\0\0";
  catalog[120]="bytes copied\0\0";
  catalog[121]="Remaining time:\0\0";
  catalog[122]="Creating Database for copy-process\0\0";
  catalog[123]="Worker Request\0\0";
  catalog[124]="Worker Message\0\0";
  catalog[125]="Worker Warning\0\0";
  catalog[126]="Can't create the directory %s|All subfiles and subdirs are ignored\0\0";
  catalog[127]="Can't create the directory %s!\0\0";
  catalog[128]="Show free disk space\0\0";
  catalog[129]="Updatetime:\0\0";
  catalog[130]="Display of Ownerstring:\0\0";
  catalog[131]="Owner @ group\0\0";
  catalog[132]="Owner.group\0\0";
  catalog[133]="Filter action:\0\0";
  catalog[134]="Terminal program (with %s for file to execute in the term):\0\0";
  catalog[135]="Overwrite all\0\0";
  catalog[136]="Overwrite none\0\0";
  catalog[137]="| Targetsize: %s| Sourcesize: %s|| Targettime: %s| Sourcetime: %s\0\0";
  catalog[138]="Failed to remove the file %s|I will skip this file!\0\0";
  catalog[139]="Failed to remove the destination file|The file %s is probably incomplete!\0\0";
  catalog[140]="Creating Database for deleting\0\0";
  catalog[141]="Deleting dir %s\0\0";
  catalog[142]="remaining files:\0\0";
  catalog[143]="remaining dirs:\0\0";
  catalog[144]="Change dirs not to check\0\0";
  catalog[145]="Do you really want to delete %ld files and %ld dirs recursive?\0\0";
  catalog[146]="The dir %s is not empty|Delete it recursively?\0\0";
  catalog[147]="Can't remove the directory %s!\0\0";
  catalog[148]="Enter new name for %s:\0\0";
  catalog[149]="Rename\0\0";
  catalog[150]="Preserve attributes\0\0";
  catalog[151]="Error while renaming!\0\0";
  catalog[152]="Enter name for directory:\0\0";
  catalog[153]="Delete active entry when no other are selected\0\0";
  catalog[154]="New Hotkey\0\0";
  catalog[155]="Duplicate Hotkey\0\0";
  catalog[156]="Delete Hotkey\0\0";
  catalog[157]="Edit Hotkey\0\0";
  catalog[158]="Sortmode\0\0";
  catalog[159]="Filter\0\0";
  catalog[160]="Name-Sort\0\0";
  catalog[161]="Size-Sort\0\0";
  catalog[162]="Access-Time\0\0";
  catalog[163]="Modification-Time\0\0";
  catalog[164]="Change-Time\0\0";
  catalog[165]="Reverse Sortorder\0\0";
  catalog[166]="Listingmode\0\0";
  catalog[167]="New Filter\0\0";
  catalog[168]="Edit Filter(s)\0\0";
  catalog[169]="Remove selected Filter(s)\0\0";
  catalog[170]="include\0\0";
  catalog[171]="exclude\0\0";
  catalog[172]="Edit Filter\0\0";
  catalog[173]="normal Filelister\0\0";
  catalog[174]="show image mode\0\0";
  catalog[175]="information mode\0\0";
  catalog[176]="Name\0\0";
  catalog[177]="Size\0\0";
  catalog[178]="Type\0\0";
  catalog[179]="Destination\0\0";
  catalog[180]="Permissions\0\0";
  catalog[181]="Add dir\0\0";
  catalog[182]="Edit dir\0\0";
  catalog[183]="Remove dir from list\0\0";
  catalog[184]="Owner\0\0";
  catalog[185]="Position\0\0";
  catalog[186]="real position\0\0";
  catalog[187]="Free space\0\0";
  catalog[188]="of\0\0";
  catalog[189]="No informations available\0\0";
  catalog[190]="There is already a dir named %s\0\0";
  catalog[191]="Include filter\0\0";
  catalog[192]="Exclude filter\0\0";
  catalog[193]="Unset filter\0\0";
  catalog[194]="Unset all filters\0\0";
  catalog[195]="The string is not valid!|Leave it empty or enter a string which contains one \"%s\"|  The filename of the script the terminal should run is inserted there!\0\0";
  catalog[196]="Set to default\0\0";
  catalog[197]="There is no space left at %s !\0\0";
  catalog[198]="Can't open destination file %s !\0\0";
  catalog[199]="Enter dir to ignore for filetype-checking:\0\0";
  catalog[200]="Enter text:\0\0";
  catalog[201]="Press RETURN to continue!\0\0";
  catalog[202]="Enter additional arguments:\0\0";
  catalog[203]="Can't get information about %s!|This file (or directory) will not be visible!\0\0";
  catalog[204]="Font requester\0\0";
  catalog[205]="The symlink %s couldn't be created!\0\0";
  catalog[206]="Enter the destination of the symlink %s:\0\0";
  catalog[207]="Enter the name of the link|which will point to %s:\0\0";
  catalog[208]="About Worker\0\0";
  catalog[209]="Font\0\0";
  catalog[210]="Enter Fontname:\0\0";
  catalog[211]=" - %ld %s/%ld %s free\0\0";
  catalog[212]="Enter destination directory:\0\0";
  catalog[213]="Permissions for %s:\0\0";
  catalog[214]="Owner:\0\0";
  catalog[215]="Group:\0\0";
  catalog[216]="Other:\0\0";
  catalog[217]="Special:\0\0";
  catalog[218]="Read\0\0";
  catalog[219]="Write\0\0";
  catalog[220]="Execute\0\0";
  catalog[221]="Set UID\0\0";
  catalog[222]="Set GID\0\0";
  catalog[223]="Sticky\0\0";
  catalog[224]="Ok to all\0\0";
  catalog[225]="Skip\0\0";
  catalog[226]="Can't change permissions on %s!\0\0";
  catalog[227]="Action-mode:\0\0";
  catalog[228]="basic (action is used once)\0\0";
  catalog[229]="extended (action can used until ESC or reclick on the action-button)\0\0";
  catalog[230]="Enter new name\0\0";
  catalog[231]="Load\0\0";
  catalog[232]="Save as\0\0";
  catalog[233]="Number of Directory-Buffers:\0\0";
  catalog[234]="This will affect first after saving!\0\0";
  catalog[235]="Display-properties\0\0";
  catalog[236]="Up\0\0";
  catalog[237]="Down\0\0";
  catalog[238]="used options\0\0";
  catalog[239]="Remove >>\0\0";
  catalog[240]="<< Add\0\0";
  catalog[241]="Global used Font\0\0";
  catalog[242]="Font for Action- and Path-Buttons\0\0";
  catalog[243]="Font for left listview\0\0";
  catalog[244]="Font for right listview\0\0";
  catalog[245]="Commands\0\0";
  catalog[246]="Add Command\0\0";
  catalog[247]="Remove Command\0\0";
  catalog[248]="Configure\0\0";
  catalog[249]="Choose Command\0\0";
  catalog[250]="Actions\0\0";
  catalog[251]="Drag'n'Drop-Action\0\0";
  catalog[252]="DoubleClick-Action\0\0";
  catalog[253]="Show-Action\0\0";
  catalog[254]="RawShow-Action\0\0";
  catalog[255]="User0-Action\0\0";
  catalog[256]="User1-Action\0\0";
  catalog[257]="User2-Action\0\0";
  catalog[258]="User3-Action\0\0";
  catalog[259]="User4-Action\0\0";
  catalog[260]="User5-Action\0\0";
  catalog[261]="User6-Action\0\0";
  catalog[262]="User7-Action\0\0";
  catalog[263]="User8-Action\0\0";
  catalog[264]="User9-Action\0\0";
  catalog[265]="Select file\0\0";      // Titelleiste beim Requester bei AutoCreate
  catalog[266]="Select the file of the filetype you want create:\0\0";
  catalog[267]="Please select three existing files as source|for automatic creation!\0\0";
  catalog[268]="Select entries\0\0";
  catalog[269]="Deselect entries\0\0";
  catalog[270]="Enter the pattern the matching entries will be selected for:\0\0";
  catalog[271]="Enter the pattern the matching entries will be deselected for:\0\0";
  catalog[272]="Want to handle dirs instead of files? Enter \"/\" as first char!\0\0";
  catalog[273]="Use this dir\0\0";
  catalog[274]="Delete link\0\0";
  catalog[275]="There is already a symlink named %s, which points to a dir|You can use it so the destination dir is used|or delete the link to create a real directory\0\0";
  catalog[276]="Failed to remove this file|Please enter new name!\0\0";
  catalog[277]="Delete file\0\0";
  catalog[278]="There is already a link named %s\0\0";
  catalog[279]="There is already a file named %s\0\0";
  catalog[280]="Overwrite\0\0";
  catalog[281]="Failed to open the file %s\0\0";
  catalog[282]="Can't overwrite the file %s|Shall I try to delete it?\0\0";
  catalog[283]="Error while executing %s\0\0";
  catalog[284]="copied files\0\0";
  catalog[285]="copied dirs\0\0";
  catalog[286]="Failed to remove the file %s!\0\0";
  catalog[287]="Delete all\0\0";
  catalog[288]="Delete no nonempty dirs\0\0";
  catalog[289]="The dir %s is not completely deleted!\0\0";
  catalog[290]="Enter dir you want to cd to:\0\0";
  catalog[291]="Can't remove %s!\0\0";  
  catalog[292]="No options available\0\0";
  catalog[293]="Configure \"%s\"\0\0";
  catalog[294]="Request these flags\0\0";
  catalog[295]="do changes on files\0\0";
  catalog[296]="do changes on dirs\0\0";
  catalog[297]="do recursive\0\0";
  catalog[298]="Follow symlinks\0\0";
  catalog[299]="Move\0\0";
  catalog[300]="Rename\0\0";
  catalog[301]="Same dir\0\0";
  catalog[302]="Request destination\0\0";
  catalog[303]="Overwrite-mode\0\0";
  catalog[304]="request\0\0";
  catalog[305]="always\0\0";
  catalog[306]="never\0\0";
  catalog[307]="copy-mode\0\0";
  catalog[308]="normal\0\0";
  catalog[309]="fast\0\0";
  catalog[310]="copy program\0\0";
  catalog[311]="copy program for overwriting\0\0";
  catalog[312]="value not allowed|Please change it or leave it blank\0\0";
  catalog[313]="Change\0\0";
  catalog[314]="Blank\0\0";
  catalog[315]="Create symlink in same directory\0\0";
  catalog[316]="Create local symlink\0\0";
  catalog[317]="Action\0\0";
  catalog[318]="enter active entry\0\0";
  catalog[319]="enter active entry on other side\0\0";
  catalog[320]="special dir\0\0";
  catalog[321]="request directory\0\0";
  catalog[322]="special dir:\0\0";
  catalog[323]="Side to edit\0\0";
  catalog[324]="current side\0\0";
  catalog[325]="other side\0\0";
  catalog[326]="left side\0\0";
  catalog[327]="right side\0\0";
  catalog[328]="With quotes\0\0";
  catalog[329]="Seperate each entry\0\0";
  catalog[330]="Recursive\0\0";
  catalog[331]="Startmode\0\0";
  catalog[332]="normal mode\0\0";
  catalog[333]="in terminal\0\0";
  catalog[334]="in terminal and wait for key\0\0";
  catalog[335]="show output\0\0";
  catalog[336]="program:\0\0";
  catalog[337]="program for viewing output:\0\0";
  catalog[338]="Select flag:\0\0";
  catalog[339]="Side to reload\0\0";
  catalog[340]="Direction\0\0";
  catalog[341]="left\0\0";
  catalog[342]="right\0\0";
  catalog[343]="global program\0\0";
  catalog[344]="Not yet checked\0\0";
  catalog[345]="Unknown filetype\0\0";
  catalog[346]="NoSelect-type\0\0";
  catalog[347]="Error\0\0";
  catalog[348]="Side:\0\0";
  catalog[349]="Enter default filter:\0\0";
  catalog[350]="Worker quit mode\0\0";
  catalog[351]="request\0\0";
  catalog[352]="quick\0\0";
  catalog[353]="Dir positions:\0\0";
  catalog[354]="Dirs first\0\0";
  catalog[355]="Dirs last\0\0";
  catalog[356]="Dirs mixed\0\0";
  catalog[357]="Show hidden entries\0\0";
  catalog[358]="Don't use\0\0";
  catalog[359]="Error while writing %s !\0\0";
  catalog[360]="toggle Hidden-flag\0\0";
  catalog[361]="don't show hidden files\0\0";
  catalog[362]="show hidden files\0\0";
  catalog[363]="I changed the behaviour of \"Separate Each Entry\" in \"own command\"|Read the doc for details\0\0";
  catalog[364]="Importing old config...\0\0";
  catalog[365]="Sorry, there is no such font!\0\0";
  catalog[366]="Found old config, importing...\0\0";
  catalog[367]="The file %s isn't a worker configfile!|Using default config\0\0";
  catalog[368]="Clockbar settings\0\0";
  catalog[369]="Clockbar mode:\0\0";
  catalog[370]="Show current time and free ram/swap (on linux)\0\0";
  catalog[371]="Show current time\0\0";
  catalog[372]="Show worker version\0\0";
  catalog[373]="Show output of an extern program\0\0";
  catalog[374]="program:\0\0";
  catalog[375]="unselected active dir\0\0";
  catalog[376]="selected active dir\0\0";
  catalog[377]="unselected active file\0\0";
  catalog[378]="selected active file\0\0";
  catalog[379]="listview background\0\0";
  catalog[380]="Select font:\0\0";
  catalog[381]="Enter own font (with X name)\0\0";
  catalog[382]="Font example\0\0";
  catalog[383]="X font name:\0\0";
  catalog[384]="The configuration file is from a newer Worker version and cannot be loaded!|Please update atleast to version %d.%d.%d.|I will continue with the default config.\0\0";
  catalog[385]="Reset directory sizes\0\0";
  catalog[386]="Use <DIR> for unknown dir sizes\0\0";
  catalog[387]="Activate shortkey\0\0";
  catalog[388]="Select shortkey:\0\0";
  catalog[389]="Button:\0\0";
  catalog[390]="Path:\0\0";
  catalog[391]="Hotkey:\0\0";
  catalog[392]="Activate\0\0";
  catalog[393]="The destination file %s is incomplete!|Keep this file or delete it?\0\0";
  catalog[394]="Keep\0\0";
  catalog[395]="Delete\0\0";
  catalog[396]="Import/Export\0\0";
  catalog[397]="Import\0\0";
  catalog[398]="Export\0\0";
  catalog[399]="Changes made here only affect the exported config|not your real configuration!\0\0";
  catalog[400]="File %s isn't a valid worker export file!\0\0";
  catalog[401]="configure Buttons to export\0\0";
  catalog[402]="configure Hotkeys to export\0\0";
  catalog[403]="configure Filetypes to export\0\0";
  catalog[404]="Filename:\0\0";
  catalog[405]="Choose\0\0";
  catalog[406]="Please select or enter file to export to:\0\0";
  catalog[407]="Please mark which elements you want to export|and enter the filename!\0\0";
  catalog[408]="%s is a dir, please enter an other name\0\0";
  catalog[409]="%s already exists, overwrite?\0\0";
  catalog[410]="Export to %s finished.\0\0";
  catalog[411]="Can't open %s for writing, please select an other file\0\0";
  catalog[412]="%s isn't a file!\0\0";
  catalog[413]="Export file is from a newer worker version!|Update atleast to version %d.%d.%d to use it.\0\0";
  catalog[414]="The configuration contains %d button bank(s), %d hotkey(s) and %d filetype(s).|You can now change these parts before importing them.\0\0";
  catalog[415]="Please enter the filename to import from\0\0";
  catalog[416]="You can change the import configuration before|the selected parts will be imported.\0\0";
  catalog[417]="Please mark which parts you want to import.\0\0";
  catalog[418]="There are no elements in the selected configuration!\0\0";
  catalog[419]="The new button %s uses the same shortkey as the button %s!\0\0";
  catalog[420]="The new hotkey %s uses the same shortkey as the button %s!\0\0";
  catalog[421]="The new button %s uses the same shortkey as the hotkey %s!\0\0";
  catalog[422]="The new hotkey %s uses the same shortkey as the hotkey %s!\0\0";
  catalog[423]="The new button %s uses the same shortkey as the path %s!\0\0";
  catalog[424]="The new hotkey %s uses the same shortkey as the path %s!\0\0";
  catalog[425]="Leave shortkey at original element\0\0";
  catalog[426]="Use shortkey for new element\0\0";
  catalog[427]="Use original\0\0";
  catalog[428]="Use new\0\0";
  catalog[429]="The importconfiguration contains the special filetype %s|which would overwrite the original type %s!|Which one do you want to use?\0\0";
  catalog[430]="Import successful\0\0";
  catalog[431]="Never use shortkey for new element\0\0";
  catalog[432]="Filetype-Sort\0\0";
  catalog[433]="Owner-Sort\0\0";
  catalog[434]="Keep filetypes\0\0";
  catalog[435]="Run in background\0\0";
  catalog[436]="Yesterday\0\0";
  catalog[437]="Today\0\0";
  catalog[438]="Tomorrow\0\0";
  catalog[439]="Date/Time-Settings\0\0";
  catalog[440]="Date:\0\0";
  catalog[441]="Own format (strftime style):\0\0";
  catalog[442]="Name substitution (Today, Yesterday, ...)\0\0";
  catalog[443]="own format\0\0";
  catalog[444]="Time:\0\0";
  catalog[445]="Date before time\0\0";

//  catalog[]="\0\0";
  
  catalogcom[0]="DragNDrop-Action\0\0";
  catalogcom[1]="DoubleClick-Action\0\0";
  catalogcom[2]="Show-Action\0\0";
  catalogcom[3]="RawShow-Action\0\0";
  catalogcom[4]="User-Action\0\0";
  catalogcom[5]="One row up\0\0";
  catalogcom[6]="One row down\0\0";
  catalogcom[7]="Change hidden flag\0\0";
  catalogcom[8]="Copy\0\0";
  catalogcom[9]="First Entry\0\0";
  catalogcom[10]="Last Entry\0\0";
  catalogcom[11]="Page Up\0\0";
  catalogcom[12]="Page Down\0\0";
  catalogcom[13]="(De)Select active entry\0\0";
  catalogcom[14]="Select all entries\0\0";
  catalogcom[15]="Deselect all entries\0\0";
  catalogcom[16]="invert selection\0\0";
  catalogcom[17]="go to parent dir\0\0";
  catalogcom[18]="go to dir\0\0";
  catalogcom[19]="Change ListView settings\0\0";
  catalogcom[20]="switch to other listview\0\0";
  catalogcom[21]="pattern select\0\0";
  catalogcom[22]="pattern unselect\0\0";
  catalogcom[23]="path to other side\0\0";
  catalogcom[24]="Quit worker\0\0";
  catalogcom[25]="Delete\0\0";
  catalogcom[26]="Reload\0\0";
  catalogcom[27]="Make dir\0\0";
  catalogcom[28]="own command\0\0";
  catalogcom[29]="rename\0\0";
  catalogcom[30]="dirsize\0\0";
  catalogcom[31]="simulate doubleclick\0\0";
  catalogcom[32]="start prog\0\0";
  catalogcom[33]="search entry\0\0";
  catalogcom[34]="edit path (in the text field)\0\0";
  catalogcom[35]="scroll listview\0\0";
  catalogcom[36]="create symlink\0\0";
  catalogcom[37]="change symlink\0\0";
  catalogcom[38]="change permissions\0\0";
  catalogcom[39]="toggle listviewmode\0\0";
  catalogcom[40]="set sortmode\0\0";
  catalogcom[41]="set filter\0\0";
  catalogcom[42]="activate shortkey from list\0\0";
  
  catalogflag[0]="Stringrequester\0\0";
  catalogflag[1]="path\0\0";
  catalogflag[2]="other path\0\0";
  catalogflag[3]="left path\0\0";
  catalogflag[4]="right path\0\0";
  catalogflag[5]="first selected entry without path\0\0";
  catalogflag[6]="first selected entry with path\0\0";
  catalogflag[7]="all selected entry without path\0\0";
  catalogflag[8]="all selected entry with path\0\0";
  catalogflag[9]="first selected entry without path (no extension)\0\0";
  catalogflag[10]="first selected entry with path (no extension)\0\0";
  catalogflag[11]="all selected entry without path (no extension)\0\0";
  catalogflag[12]="all selected entry with path (no extension)\0\0";
  catalogflag[13]="first selected entry without path (no unselect)\0\0";
  catalogflag[14]="first selected entry with path (no unselect)\0\0";
  catalogflag[15]="all selected entry without path (no unselect)\0\0";
  catalogflag[16]="all selected entry with path (no unselect)\0\0";
  catalogflag[17]="first selected entry without path (no unselect, no extension)\0\0";
  catalogflag[18]="first selected entry with path (no unselect, no extension)\0\0";
  catalogflag[19]="all selected entry without path (no unselect, no extension)\0\0";
  catalogflag[20]="all selected entry with path (no unselect, no extension)\0\0";
  catalogflag[21]="other side: first selected entry without path\0\0";
  catalogflag[22]="other side: first selected entry with path\0\0";
  catalogflag[23]="other side: all selected entry without path\0\0";
  catalogflag[24]="other side: all selected entry with path\0\0";
  catalogflag[25]="other side: first selected entry without path (no extension)\0\0";
  catalogflag[26]="other side: first selected entry with path (no extension)\0\0";
  catalogflag[27]="other side: all selected entry without path (no extension)\0\0";
  catalogflag[28]="other side: all selected entry with path (no extension)\0\0";
  catalogflag[29]="other side: first selected entry without path (no unselect)\0\0";
  catalogflag[30]="other side: first selected entry with path (no unselect)\0\0";
  catalogflag[31]="other side: all selected entry without path (no unselect)\0\0";
  catalogflag[32]="other side: all selected entry with path (no unselect)\0\0";
  catalogflag[33]="other side: first selected entry without path (no unselect, no extension)\0\0";
  catalogflag[34]="other side: first selected entry with path (no unselect, no extension)\0\0";
  catalogflag[35]="other side: all selected entry without path (no unselect, no extension)\0\0";
  catalogflag[36]="other side: all selected entry with path (no unselect, no extension)\0\0";
  catalogflag[37]="destination path (for DND)\0\0";
}

Locale::~Locale()
{
  freeLanguage();
  delete catalog;
  delete catalogcom;
  delete catalogflag;
}

int Locale::openCatFile(Datei*file,const char *name,const char *ext)
{
  bool ok=false;
  int len;
  char *mainstr;
  const char *home=wconfig->getHome();
#ifdef GLOBALDATADIR
  len=strlen(GLOBALDATADIR);
  if(len>0) {
    mainstr=(char*)_allocsafe((len+
                               strlen("/catalogs/")+
                               strlen(name)+strlen(".catalog2")+
                               strlen(ext)+1)*sizeof(char));
    strcpy(mainstr,GLOBALDATADIR);
    if(len>1) if(mainstr[len-1]!='/') strcat(mainstr,"/");
    strcat(mainstr,"catalogs/");
    strcat(mainstr,name);
  #ifdef USEOWNCONFIGFILES
    strcat(mainstr,".catalog2");
  #else
    strcat(mainstr,".catalog");
  #endif
    strcat(mainstr,ext);
    if(file->open(mainstr,"r")==0) ok=true;
    _freesafe(mainstr);
  }
#endif
  if(ok==false) {
    len=strlen(home);
    if(len<1) return 1;
    mainstr=(char*)_allocsafe((len+1+
                               strlen("catalogs/")+
                               strlen(name)+strlen(".catalog2")+
                               strlen(ext)+1)*sizeof(char));
    strcpy(mainstr,home);
    if(len>1) if(home[len-1]!='/') strcat(mainstr,"/");
    strcat(mainstr,"catalogs/");
    strcat(mainstr,name);
  #ifdef USEOWNCONFIGFILES
    strcat(mainstr,".catalog2");
  #else
    strcat(mainstr,".catalog");
  #endif
    strcat(mainstr,ext);
    if(file->open(mainstr,"r")==0) ok=true;
    _freesafe(mainstr);
  }
  if(ok==true) return 0;
  return 1;
}

int Locale::loadLanguage(const char *name)
{
  freeLanguage();
  Datei *file=new Datei();

  if(openCatFile(file,name,"")==0) {
    parse(file,0);
    file->close();

    if(openCatFile(file,name,".coms")==0) {
      parse(file,1);
      file->close();
    }

    if(openCatFile(file,name,".flags")==0) {
      parse(file,2);
      file->close();
    }
  } else debugmsg("selected language not available, using builtin!\n");
  delete file;
  return 0;
}

void Locale::parse(Datei *file,int cat)
{
  char *buffer=(char*)_allocsafe(128*1024);
  int mode,bufpos;
  int entrynr;
  int ch,len;
  char *tstr;

  mode=0;
  bufpos=0;
  entrynr=0;
  
  for(;;) {
    ch=file->getCharAsInt();
    if(ch==EOF) break;
    switch(mode) {
      case 1:
        if(ch=='\n') {
          mode=0;
          bufpos=0;
          entrynr=0;
        }
        break;
      case 2:
        // old style
        if(ch=='\n') {
          buffer[bufpos]=0;
          entrynr++;
          bufpos=0;
        } else {
          buffer[min(128*1024-1,bufpos)]=(char)ch;
          bufpos++;
        }
        break;
      case 3:
        if(ch=='\\') {
          mode=4;
        } else if((ch=='\n')||(ch=='#')) {
          buffer[bufpos]=0;
          if(strlen(buffer)>0) {
            // store buffer in entrynr
            tstr=(char*)_allocsafe(strlen(buffer)+2);
            strcpy(tstr,buffer);
            tstr[strlen(tstr)+1]='\1';
            switch(cat) {
              case 0:
                // normal
                if(entrynr<CATENTRY) {
                  len=strlen(catalog[entrynr]);
                  if(catalog[entrynr][len+1]=='\1') _freesafe(catalog[entrynr]);
                  catalog[entrynr]=tstr;
                } else _freesafe(tstr);
                break;
              case 1:
                // com
                if(entrynr<CATCOMENTRY) {
                  len=strlen(catalogcom[entrynr]);
                  if(catalogcom[entrynr][len+1]=='\1') _freesafe(catalogcom[entrynr]);
                  catalogcom[entrynr]=tstr;
                } else _freesafe(tstr);
                break;
              case 2:
                // flag
                if(entrynr<CATFLAGENTRY) {
                  len=strlen(catalogflag[entrynr]);
                  if(catalogflag[entrynr][len+1]=='\1') _freesafe(catalogflag[entrynr]);
                  catalogflag[entrynr]=tstr;
                } else _freesafe(tstr);
                break;
              default:
                _freesafe(tstr);
                break;
            }
          }
          if(ch=='#') mode=1;
          else {
            mode=0;
            bufpos=0;
            entrynr=0;
          }
        } else {
          buffer[min(128*1024-1,bufpos)]=(char)ch;
          bufpos++;
        }
        break;
      case 4:
        if(ch!='\n') {
          buffer[min(128*1024-1,bufpos)]=(char)ch;
          bufpos++;
        }
        mode=3;
        break;
      default:
        if(isdigit(ch)!=0) {
          buffer[min(128*1024-1,bufpos)]=(char)ch;
          bufpos++;
        } else if(ch=='#') {
          mode=1;
        } else if(ch==':') {
          buffer[bufpos]=0;
          entrynr=0;
          sscanf(buffer,"%d",&entrynr);
          mode=3;
          bufpos=0;
        } else if(ch=='\n') {
        } else {
          // old style
          //TODO: bessere Meldung
          printf("oldstyle-catalog-format not supported\n");
          mode=2;
          buffer[min(128*1024-1,bufpos)]=(char)ch;
          bufpos++;
          entrynr=0;
        }
        break;
    }
  }
  _freesafe(buffer);
}

void Locale::freeLanguage()
{
  int len,i;
  for(i=0;i<CATENTRY;i++) {
    len=strlen(catalog[i]);
    if(catalog[i][len+1]=='\1') {
      // loaded entry
//      printf("free cat-entry %d\n",i);
      _freesafe(catalog[i]);
    }
  }
  for(i=0;i<CATCOMENTRY;i++) {
    len=strlen(catalogcom[i]);
    if(catalogcom[i][len+1]=='\1') {
      // loaded entry
//      debugmsg("free catcom-entry\n");
      _freesafe(catalogcom[i]);
    }
  }
  for(i=0;i<CATFLAGENTRY;i++) {
    len=strlen(catalogflag[i]);
    if(catalogflag[i][len+1]=='\1') {
      // loaded entry
//      debugmsg("free catflag-entry\n");
      _freesafe(catalogflag[i]);
    }
  }
  initBuiltinLang();
}

char *Locale::getLocale(int index2)
{
  if((index2<0)||(index2>=CATENTRY)) return NULL;
  return catalog[index2];
}

char *Locale::getLocaleCom(int index2)
{
  if((index2<0)||(index2>=CATCOMENTRY)) return NULL;
  return catalogcom[index2];
}

char *Locale::getLocaleFlag(int index2)
{
  if((index2<0)||(index2>=CATFLAGENTRY)) return NULL;
  return catalogflag[index2];
}

//void Locale::init(const char*)
//{
//}

