/* guielement.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: guielement.h,v 1.6 2001/12/09 02:08:42 ralf Exp $ */

#ifndef GUIELEMENT_H
#define GUIELEMENT_H

#include "aguixdefs.h"
#include "message.h"

class AGUIX;
class AWindow;

class GUIElement {
public:
  GUIElement() {}
  GUIElement(AGUIX *aguix);
  virtual ~GUIElement();
  void move(int x,int y);
  virtual void resize(int w,int h);
  virtual void redraw();
  virtual void flush();
  virtual const char *getType();
  virtual bool isType(const char *type);
  virtual bool handleMessage(XEvent *E,Message *msg);
  void getPos(int*,int*);
  void getSize(int*,int*);
  int getWidth();
  int getHeight();
  int getX();
  int getY();
  virtual void setParent(AWindow *parent);
  void toBack();
  void toFront();
  bool hasWin(Window win);
  Window getWindow();
  virtual bool isParent(Window);
  virtual void paste(unsigned char*);
  virtual void cancelpaste();
  virtual void cancelcut();
  void takeFocus();
  void leaveFocus();
  bool hasFocus();
protected:
  int x,y;
  int w,h;
  AGUIX *aguix;
  AWindow *parent;
  Window win;
  static const char *type;
  bool focus;
};

#endif

