/* listview.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: listview.h,v 1.13 2001/12/09 21:18:41 ralf Exp $ */

#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <X11/Xlib.h>
#include <X11/X.h>
#include "util.h"
#include "guielement.h"
#include "aguixdefs.h"

class AGUIX;
class ListViewContent;
class AGUIXFont;

class ListView:public GUIElement {
public:
  ListView(AGUIX *aguix);
  ListView(AGUIX *aguix,int x,int y,int width,int height,int data);
  virtual ~ListView();
  virtual void resize(int w,int h);
  int getData();
  void setData(int);
  virtual void redraw();
  virtual void flush();
  virtual bool handleMessage(XEvent *E,Message *msg);
  void setXOffset(int new_offset);
  int getXOffset();
  void setYOffset(int new_offset);
  int getYOffset();
  virtual void setParent(AWindow *parent);
  int getElements();
  int getMaxLen();
  int getMAXdisplayv();
  int getMAXdisplayh();
  void setHBarState(int state);
  void setVBarState(int state);
  int getHBarState();
  int getVBarState();
  void setVBarWidth(int new_width);
  int getVBarWidth();
  void setHBarHeight(int new_height);
  int getHBarHeight();
  ListViewContent *add(ListViewContent *);
  ListViewContent *add(ListViewContent *,int);
  int remove(ListViewContent *);
  int remove(int);
  int removeAll();
  ListViewContent *get(int);
  ListViewContent *getNext();
  void check4newlen(ListViewContent*);
  void redrawlvc(ListViewContent*);
  void setActiveLVC(ListViewContent *tlvc);
  ListViewContent *getActiveLVC();
  void scrollV(int delta);
  void scrollV1(int dir);
  void setSelectHandler(void (*nsh)(ListView*,ListViewContent*,int));
  void showActive();
  void centerActive();
  int getPos(ListViewContent*);
  int setFont(char*);
  virtual const char *getType();
  virtual bool isType(const char *type);
  virtual bool isParent(Window);
  void startQuickAdd();
  void endQuickAdd();
  void setSize(int);
  void finish();
  void showlvc(ListViewContent*lvc);
  int initLVCEnum();
  void closeLVCEnum(int);
  ListViewContent *get(int id,int pos);
  ListViewContent *getNext(int id);
  int getLVCHeight();
  int getMBG();
  void setMBG(int color);
  
  int maximizeX();
  int maximizeY();
protected:
  int data;
  int xoffset;
  int yoffset;
  static const char *type;
  bool bgset;
  int maxdisplayh,maxdisplayv;
  void updateWin();
  int hbar;
  int hbar_height;
  int hbar_dir;
  bool hbar_pressed;
  int vbar;
  int vbar_width;
  int vbar_dir;
  bool vbar_pressed;
  int maxlen;
  void recalcMAXValues();
  void mredraw();
  void hbarredraw();
  void vbarredraw();
  void redrawlvc(int);
  void redrawalllvc();
  Window *subwins;
  Window hbarwin,vbarwin;
  int *winbgs;
  ArrayList *lvcs;
  ListViewContent **vislvcs;
  ListViewContent *activelvc;
  void buildvisList();
  void setupsubwins();
  void calcMaxLen();
  void rebuildSubWins(int oldsize);
  void reconfSubWins();
  void handleExpose(Window msgwin);
  virtual void handleSelect(Message *msg);
  virtual void handleMiddle(Message *msg);
  void handleThird(Message *msg);
  bool handleHBar(Message *msg);
  bool handleVBar(Message *msg);
  void (*selecthandler)(ListView*,ListViewContent*,int);
  void setupBars();
  virtual void runSelectHandler(ListViewContent*,int);
  bool handleKeys(Message *msg);
  
  AGUIXFont *font;
  bool quickAdd;
  int qastartlvcpos;
  struct timeval lastwheel;
  int mbg;
};

class ListViewContent
{
public:
  ListViewContent();
  ListViewContent(const char *text,int fg0,int fg1,int fg2,int fg3,
                  int bg0,int bg1,int bg2, int bg3,int data);
  ~ListViewContent();
  void setText(const char *);
  const char *getText();
  void useText(char *);
  void useTextQ(char *);
  void setFG(int,int);
  int getFG(int);
  void setBG(int,int);
  int getBG(int);
  void setData(int);
  int getData();
  void setSelect(bool);
  bool getSelect();
  void setActive(bool);
  bool getActive();
  int redraw(AGUIX*,Window,AGUIXFont*,int,int);
  void setParent(ListView*);
  void setFGQ(int,int);
  void setBGQ(int,int);
  void setSelectQ(bool);
  void setActiveQ(bool);
  void setTextQ(const char *);
private:
  char *text;
  int fg[4];
  int bg[4];
  int data;
  bool select;
  bool active;
  ListView *parent;
};

#endif
