/* import.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: import.cc,v 1.9 2002/02/06 20:56:20 ralf Exp $ */

#include "import.h"
#include "worker_commands.h"

int WConfig::parseChunk(Datei *fp)
{
  /* 0 kein Fehler
     1 kein gltiger Chunk
     2 Dateiende
     3 Fehler */
  int returnvalue,y;
  unsigned char red,green,blue;
  char *tstr,*chunkname;
  int len,slen;
  int sl,cl,il,ll;
  int colorsize;
  List *l1,*l2;
  WC_Color *col;
  WCButton *b1;
  WCPath *p1;
  WCShortkey *key;
  WCFiletype *ft1;
  WCHotkey *h1;
  unsigned long comnr,flag1,flag2;
  char *usercomstr;
  FunctionProto *funpro;
  int x;
  short filedesc[64];
  
  l1=new List();
  l2=new List();
  key=new WCShortkey();

  sl=Datei::getUShortSize();
  cl=Datei::getUCharSize();
  il=Datei::getIntSize();
  ll=Datei::getULongSize();

  returnvalue=0;
  chunkname=fp->getString(4);
  if(strcmp("GLBL",chunkname)==0) {
    len=fp->getULong();
    colorsize=fp->getUShort();
    len-=sl;
    while(len>0) {
      red=fp->getUChar();
      green=fp->getUChar();
      blue=fp->getUChar();
      col=new WC_Color(red,green,blue);
      l1->addElement(col);
      len-=3*cl;
    }
    setColors(l1);
    applyColorList(colors);
    col=(WC_Color*)l1->getFirstElement();
    while(col!=NULL) {
      delete col;
      col=(WC_Color*)l1->getNextElement();
    }
    l1->removeAllElements();
  } else if(strcmp("LANG",chunkname)==0) {
    len=fp->getULong();
    if(fp->errors()!=0) {
      returnvalue=2;
    }
    tstr=fp->getString(len);
    setLang(tstr);
    _freesafe(tstr);
  } else if(strcmp("COLD",chunkname)==0) {
    len=fp->getULong();
    setStatusbar(0,fp->getUShort());
    setStatusbar(1,fp->getUShort());
    setSelLVB(0,fp->getUShort());
    setSelLVB(1,fp->getUShort());
    setUnselLVB(0,fp->getUShort());
    setUnselLVB(1,fp->getUShort());
    setSelDir(0,fp->getUShort());
    setSelDir(1,fp->getUShort());
    setUnselDir(0,fp->getUShort());
    setUnselDir(1,fp->getUShort());
    setSelFile(0,fp->getUShort());
    setSelFile(1,fp->getUShort());
    setUnselFile(0,fp->getUShort());
    setUnselFile(1,fp->getUShort());
    setClockbar(0,fp->getUShort());
    setClockbar(1,fp->getUShort());
    setRequest(0,fp->getUShort());
    setRequest(1,fp->getUShort());
    fp->getUShort(); // no use
    fp->getUShort(); // no use
    fp->getUShort(); // no use
    fp->getUShort(); // no use
    len-=22*sl;
    if(len>0) {
      /* da gibts noch Informationen, die ich nicht auswerten kann.
         damit's weiter geht, diesen bereich berspringen */
      fp->seek(len,SEEK_CUR);
    }
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("LDEF",chunkname)==0) {
    len=fp->getULong();
    setVBarLeft(0,(fp->getUChar()==1)?true:false);
    setHBarTop(0,(fp->getUChar()==1)?true:false);
    setHBarHeight(0,fp->getUShort());
    setVBarWidth(0,fp->getUShort());
    setVBarLeft(1,(fp->getUChar()==1)?true:false);
    setHBarTop(1,(fp->getUChar()==1)?true:false);
    setHBarHeight(1,fp->getUShort());
    setVBarWidth(1,fp->getUShort());
    setColumns(fp->getUChar());
    setRows(fp->getUChar());
    len-=6*cl+4*sl;
    if(len>0) {
      fp->seek(len,SEEK_CUR);
    }
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("DIRS",chunkname)==0) {
    len=fp->getULong();
    slen=fp->getULong();
    tstr=fp->getString(slen);
    setStartDir(0,tstr);
    _freesafe(tstr);
    len-=slen+ll;
    slen=fp->getULong();
    tstr=fp->getString(slen);
    setStartDir(1,tstr);
    _freesafe(tstr);
    len-=slen+ll;
    if(len>0) {
      fp->seek(len,SEEK_CUR);
    }
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("BUTD",chunkname)==0) {
    len=fp->getULong();
    while(len>0) {
      b1=new WCButton();
      
      b1->setCheck((fp->getUChar()==1)?true:false);
      len-=cl;
      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      b1->setText(tstr);
      _freesafe(tstr);
      len-=y;
      b1->setFG(fp->getUShort());
      b1->setBG(fp->getUShort());

      key->setShortkey(fp->getULong());
      key->setMod(fp->getUShort());  //TODO: ob das alte Mod und das neue kompatible sind?
                                     // erstmal lasse ich es so, aber das muss geprueft werden
      b1->setKey(key);
      
      comnr=fp->getULong();
      flag1=fp->getULong();
      flag2=fp->getULong();

      len-=4*ll+3*sl;
      y=fp->getULong();
      len-=ll;
      usercomstr=fp->getString(y);
      len-=y;

      if(b1->getCheck()==true) {
        getFunctionProtoOldStyle(comnr,flag1,flag2,usercomstr,l2);
        b1->setComs(l2);
      }

      funpro=(FunctionProto*)l2->getFirstElement();
      while(funpro!=NULL) {
        delete funpro;
        funpro=(FunctionProto*)l2->getNextElement();
      }
      l2->removeAllElements();

      _freesafe(usercomstr);
      
      l1->addElement(b1);
    }
    setButtons(l1);
    b1=(WCButton*)l1->getFirstElement();
    while(b1!=NULL) {
      delete b1;
      b1=(WCButton*)l1->getNextElement();
    }
    l1->removeAllElements();
    
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("PATD",chunkname)==0) {
    len=fp->getULong();
    while(len>0) {
      p1=new WCPath();
      
      p1->setCheck((fp->getUChar()==1)?true:false);
      len-=cl;
      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      len-=y;
      p1->setName(tstr);
      _freesafe(tstr);
      
      p1->setFG(fp->getUShort());
      p1->setBG(fp->getUShort());
      
      key->setShortkey(fp->getULong());
      key->setMod(fp->getUShort());  //TODO: ob das alte Mod und das neue kompatible sind?
                                     // erstmal lasse ich es so, aber das muss geprueft werden
      p1->setKey(key);
      len-=3*sl+ll;

      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      len-=y;
      p1->setPath(tstr);
      _freesafe(tstr);

      l1->addElement(p1);
    }
    setPaths(l1);
    p1=(WCPath*)l1->getFirstElement();
    while(p1!=NULL) {
      delete p1;
      p1=(WCPath*)l1->getNextElement();
    }
    l1->removeAllElements();
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("FITY",chunkname)==0) {
    len=fp->getULong();
    while(len>0) {
      ft1=new WCFiletype();
      
      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      len-=y;
      ft1->setName(tstr);
      _freesafe(tstr);
      
      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      len-=y;
      _freesafe(tstr);
      
      comnr=fp->getULong();
      flag1=fp->getULong();
      flag2=fp->getULong();
      len-=3*ll;
      y=fp->getULong();
      len-=ll;
      usercomstr=fp->getString(y);
      len-=y;
      
      getFunctionProtoOldStyle(comnr,flag1,flag2,usercomstr,l2);
      ft1->setDoubleClickActions(l2);

      funpro=(FunctionProto*)l2->getFirstElement();
      while(funpro!=NULL) {
        delete funpro;
        funpro=(FunctionProto*)l2->getNextElement();
      }
      l2->removeAllElements();

      _freesafe(usercomstr);
      
      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      len-=y;
      ft1->setPattern(tstr);
      _freesafe(tstr);

      for(x=0;x<64;x++) {
        filedesc[x]=(signed short)fp->getUShort();
        len-=sl;
      }
      ft1->setFiledesc(filedesc);
      ft1->setUsePattern((fp->getUChar()==1)?true:false);
      ft1->setUseFiledesc((fp->getUChar()==1)?true:false);
      len-=2*cl;

      l1->addElement(ft1);
    }
    setFiletypes(l1);
    initFixTypes(filetypes);
    ft1=(WCFiletype*)l1->getFirstElement();
    while(ft1!=NULL) {
      delete ft1;
      ft1=(WCFiletype*)l1->getNextElement();
    }
    l1->removeAllElements();
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("HOTS",chunkname)==0) {
    len=fp->getULong();
    while(len>0) {
      h1=new WCHotkey();

      y=fp->getULong();
      len-=ll;
      tstr=fp->getString(y);
      len-=y;
      h1->setName(tstr);
      _freesafe(tstr);

      key->setShortkey(fp->getULong());
      key->setMod(fp->getUShort());  //TODO: ob das alte Mod und das neue kompatible sind?
                                     // erstmal lasse ich es so, aber das muss geprueft werden
      h1->setKey(key);

      comnr=fp->getULong();
      flag1=fp->getULong();
      flag2=fp->getULong();
      len-=4*ll+sl;
      y=fp->getULong();
      len-=ll;
      usercomstr=fp->getString(y);
      len-=y;
      
      getFunctionProtoOldStyle(comnr,flag1,flag2,usercomstr,l2);
      h1->setComs(l2);

      funpro=(FunctionProto*)l2->getFirstElement();
      while(funpro!=NULL) {
        delete funpro;
        funpro=(FunctionProto*)l2->getNextElement();
      }
      l2->removeAllElements();

      _freesafe(usercomstr);
      
      l1->addElement(h1);
    }
    setHotkeys(l1);
    h1=(WCHotkey*)l1->getFirstElement();
    while(h1!=NULL) {
      delete h1;
      h1=(WCHotkey*)l1->getNextElement();
    }
    l1->removeAllElements();
    
    if(fp->errors()!=0) {
      returnvalue=2;
    }
  } else if(strcmp("FONT",chunkname)==0) {
    len=fp->getULong();
    if(fp->errors()!=0) {
      returnvalue=2;
    }
    tstr=fp->getString(len);
    setFont(0,tstr);
    setFont(1,tstr);
    setFont(2,tstr);
    setFont(3,tstr);
    _freesafe(tstr);
  } else {
    returnvalue=1;
  }
  _freesafe(chunkname);
  
  delete l1;
  delete l2;
  delete key;
  
  return returnvalue;
}

int WConfig::read1Config(Datei *fp)
{
  char *tstr,*buttonstr,*textstr;
  int x;
  Requester *req;

  showOldRequest=false;
  fp->seek(0,SEEK_SET);
  tstr=fp->getString(4);
  if(strcmp("FORM",tstr)==0) {
    fp->seek(4,SEEK_CUR);
    _freesafe(tstr);
    tstr=fp->getString(4);
    if(strcmp("WCFG",tstr)==0) {
      _freesafe(tstr);
      req=new Requester(worker->getAGUIX());
      textstr=catalog.getLocale(366);
      buttonstr=catalog.getLocale(11);
      req->request(catalog.getLocale(124),textstr,buttonstr);
      delete req;
      do {
        x=parseChunk(fp);
      } while(x==0);
    } else {
      _freesafe(tstr);
    }
  } else {
    _freesafe(tstr);
    return 1;
  }
  if(fp->errors()==0) return 0; else return 1;
}

void WConfig::setDefaultConfig()
{
  int ndis[2][9];
  List *np,*nb,*nh;
  WCPath *p1;
  WCShortkey *key;
  WCButton *b1;
  WCHotkey *h1;
  List *nc;
  FunctionProto *fp,*rfp;
  int i;

  setLang("");
  setRows(6);
  setColumns(7);
  setCacheSize(10);
  List *ncolors=new List();
  ncolors->addElement(new WC_Color(160,160,160));
  ncolors->addElement(new WC_Color(0,0,0));
  ncolors->addElement(new WC_Color(255,255,255));
  ncolors->addElement(new WC_Color(0,85,187));
  ncolors->addElement(new WC_Color(204,34,0));
  ncolors->addElement(new WC_Color(50,180,20));
  ncolors->addElement(new WC_Color(119,0,119));
  ncolors->addElement(new WC_Color(238,170,68));
  setColors(ncolors);
  WC_Color *col=(WC_Color*)ncolors->getFirstElement();
  while(col!=NULL) {
    delete col;
    col=(WC_Color*)ncolors->getNextElement();
  }
  delete ncolors;
  setHBarTop(0,false);
  setHBarTop(1,false);
  setVBarLeft(0,false);
  setVBarLeft(1,true);
  setHBarHeight(0,10);
  setHBarHeight(1,10);
  setVBarWidth(0,10);
  setVBarWidth(1,10);
  ndis[0][0]=3;
  ndis[0][1]=1;
  ndis[0][2]=0;
  ndis[0][3]=2;
  ndis[0][4]=-1;
  ndis[0][5]=-1;
  ndis[0][6]=-1;
  ndis[0][7]=-1;
  ndis[0][8]=-1;
  ndis[1][0]=3;
  ndis[1][1]=1;
  ndis[1][2]=0;
  ndis[1][3]=2;
  ndis[1][4]=-1;
  ndis[1][5]=-1;
  ndis[1][6]=-1;
  ndis[1][7]=-1;
  ndis[1][8]=-1;
  setDisplay(0,ndis[0]);
  setDisplay(1,ndis[1]);
  setStatusbar(0,2);
  setStatusbar(1,3);
  setSelLVB(0,2);
  setSelLVB(1,4);
  setUnselLVB(0,1);
  setUnselLVB(1,0);
  setSelDir(0,2);
  setSelDir(1,3);
  setUnselDir(0,3);
  setUnselDir(1,0);
  setSelFile(0,2);
  setSelFile(1,1);
  setUnselFile(0,1);
  setUnselFile(1,0);
  setClockbar(0,2);
  setClockbar(1,6);
  setRequest(0,1);
  setRequest(1,0);
  setStartDir(0,"");
  setStartDir(1,"");
  setFont(0,"fixed");
  setFont(1,"fixed");
  setFont(2,"fixed");
  setFont(3,"fixed");
  
  // now setup paths
  key=new WCShortkey();
  np=new List();

  p1=new WCPath();
  p1->setName("/");
  p1->setFG(2);
  p1->setBG(3);
  p1->setPath("/");
  p1->setCheck(true);
  
  key->setMod(0);
  key->setShortkey(XK_1);
  
  p1->setKey(key);
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("/home");
  p1->setPath("/home");
  p1->setCheck(true);
  
  key->setMod(0);
  key->setShortkey(XK_2);
  
  p1->setKey(key);
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("/usr");
  p1->setPath("/usr");
  p1->setCheck(true);
  
  key->setMod(0);
  key->setShortkey(XK_3);
  
  p1->setKey(key);
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("/usr/local");
  p1->setPath("/usr/local");
  p1->setCheck(true);
  
  key->setMod(0);
  key->setShortkey(XK_4);
  
  p1->setKey(key);
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("CD");
  p1->setPath("/cdrom");
  p1->setCheck(true);
  
  key->setMod(0);
  key->setShortkey(XK_5);
  
  p1->setKey(key);
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("Floppy");
  p1->setPath("/floppy");
  p1->setCheck(true);
  
  key->setMod(0);
  key->setShortkey(XK_6);
  
  p1->setKey(key);
  np->addElement(p1);

  setPaths(np);
  
  p1=(WCPath*)np->getFirstElement();
  while(p1!=NULL) {
    delete p1;
    p1=(WCPath*)np->getNextElement();
  }
  delete np;
  
  // setup buttons
  nc=new List();
  nb=new List();
  
  b1=new WCButton();
  b1->setText("All");
  b1->setCheck(true);
  key->setShortkey(XK_KP_Add);
  key->setMod(0);
  b1->setKey(key);
  fp=new SelectAllOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("None");
  b1->setCheck(true);
  key->setShortkey(XK_KP_Subtract);
  key->setMod(0);
  b1->setKey(key);
  fp=new SelectNoneOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);
  
  b1=new WCButton();
  b1->setText("Invert selection");
  b1->setCheck(true);
  key->setShortkey(XK_KP_Multiply);
  key->setMod(0);
  b1->setKey(key);
  fp=new InvertAllOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Patternselect");
  b1->setCheck(true);
  key->setShortkey(XK_KP_Divide);
  key->setMod(0);
  b1->setKey(key);
  fp=new FilterSelectOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("PatternUnselect");
  b1->setCheck(true);
  fp=new FilterUnSelectOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Path2otherside");
  b1->setCheck(true);
  fp=new Path2OSideOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Active2Other");
  b1->setCheck(true);
  fp=new EnterDirOp(worker);
  ((EnterDirOp*)fp)->setMode(EnterDirOp::ENTERDIROP_ACTIVE2OTHER);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Reload");
  b1->setCheck(true);
  key->setShortkey(XK_u);
  key->setMod(0);
  b1->setKey(key);
  fp=new ReloadOp(worker);
  ((ReloadOp*)fp)->setReloadside(ReloadOp::RELOADOP_THISSIDE);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Reload other");
  b1->setCheck(true);
  fp=new ReloadOp(worker);
  ((ReloadOp*)fp)->setReloadside(ReloadOp::RELOADOP_OTHERSIDE);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<4;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Run");
  b1->setCheck(true);
  key->setMod(ControlMask);
  key->setShortkey(XK_x);
  b1->setKey(key);
  fp=new StartProgOp(worker);
  ((StartProgOp*)fp)->setStart(StartProgOp::STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY);
  ((StartProgOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<13;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Copy");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(6);
  key->setShortkey(XK_F5);
  key->setMod(0);
  b1->setKey(key);
  fp=new CopyOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Copy++");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(6);
  key->setMod(ShiftMask);
  key->setShortkey(XK_F5);
  b1->setKey(key);
  fp=new CopyOp(worker);
  ((CopyOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Delete");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(4);
  key->setShortkey(XK_F8);
  key->setMod(0);
  b1->setKey(key);
  fp=new DeleteOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Rename");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(3);
  key->setShortkey(XK_n);
  key->setMod(0);
  b1->setKey(key);
  fp=new RenameOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Move");
  b1->setCheck(true);
  b1->setFG(1);
  b1->setBG(7);
  key->setShortkey(XK_F6);
  key->setMod(0);
  b1->setKey(key);
  fp=new CopyOp(worker);
  ((CopyOp*)fp)->setMove(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Move++");
  b1->setCheck(true);
  b1->setFG(1);
  b1->setBG(7);
  key->setMod(ShiftMask);
  key->setShortkey(XK_F6);
  b1->setKey(key);
  fp=new CopyOp(worker);
  ((CopyOp*)fp)->setMove(true);
  ((CopyOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Create Symlink");
  b1->setCheck(true);
  fp=new CreateSymlinkOp(worker);
  ((CreateSymlinkOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("new dir");
  b1->setCheck(true);
  fp=new MakeDirOp(worker);
  key->setShortkey(XK_F7);
  key->setMod(0);
  b1->setKey(key);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  nb->addElement(new WCButton());
  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Show pics");
  b1->setCheck(true);
  fp=new OwnOp(worker);
  key->setShortkey(XK_F3);
  key->setMod(0);
  b1->setKey(key);
  ((OwnOp*)fp)->setWithApo(true);
  ((OwnOp*)fp)->setComStr("xv {A}");
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Show");
  b1->setCheck(true);
  fp=new ShowAction(worker);
  key->setMod(ShiftMask);
  key->setShortkey(XK_F3);
  b1->setKey(key);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Edit");
  b1->setCheck(true);
  key->setShortkey(XK_F4);
  key->setMod(0);
  b1->setKey(key);
  fp=new OwnOp(worker);
  ((OwnOp*)fp)->setWithApo(true);
  ((OwnOp*)fp)->setComStr("nedit {f}");
  nc->addElement(fp);
  rfp=new ReloadOp(worker);
  nc->addElement(rfp);
  b1->setComs(nc);
  delete fp;
  delete rfp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<5;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Change Symlink");
  b1->setCheck(true);
  fp=new ChangeSymlinkOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<3;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("DirSize");
  b1->setCheck(true);
  fp=new DirSizeOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<15;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("ChMod");
  b1->setCheck(true);
  fp=new ChModOp(worker);
  ((ChModOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<12;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Quit");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(1);
  fp=new QuitOp(worker);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  // apply list
  setButtons(nb);
  
  b1=(WCButton*)nb->getFirstElement();
  while(b1!=NULL) {
    delete b1;
    b1=(WCButton*)nb->getNextElement();
  }
  delete nb;
  
  // setup hotkeys
  nh=new List();
  
  h1=new WCHotkey();
  h1->setName("Up");
  key->setShortkey(XK_Up);
  key->setMod(0);
  h1->setKey(key);
  fp=new RowUp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Down");
  key->setShortkey(XK_Down);
  key->setMod(0);
  h1->setKey(key);
  fp=new RowDown(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Toggle HiddenFlag");
  key->setShortkey(XK_asciicircum);
  key->setMod(0);
  h1->setKey(key);
  fp=new ChangeHiddenFlag(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Top");
  key->setShortkey(XK_Home);
  key->setMod(0);
  h1->setKey(key);
  fp=new FirstRow(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Last");
  key->setShortkey(XK_End);
  key->setMod(0);
  h1->setKey(key);
  fp=new LastRow(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("PageUp");
  key->setShortkey(XK_Prior);
  key->setMod(0);
  h1->setKey(key);
  fp=new PageUp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("PageDown");
  key->setShortkey(XK_Next);
  key->setMod(0);
  h1->setKey(key);
  fp=new PageDown(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Invert actual entry");
  key->setShortkey(XK_Insert);
  key->setMod(0);
  h1->setKey(key);
  fp=new SelectOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Parent");
  key->setShortkey(XK_Left);
  key->setMod(0);
  h1->setKey(key);
  fp=new ParentDirOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("EnterDir");
  key->setShortkey(XK_Right);
  key->setMod(0);
  h1->setKey(key);
  fp=new EnterDirOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Change lister settings (left)");
  key->setMod(Mod1Mask);
  key->setShortkey(XK_F1);
  h1->setKey(key);
  fp=new ChangeListerSetOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Change lister settings (right)");
  key->setMod(Mod1Mask);
  key->setShortkey(XK_F2);
  h1->setKey(key);
  fp=new ChangeListerSetOp(worker);
  ((ChangeListerSetOp*)fp)->setMode(ChangeListerSetOp::CLS_RIGHT_LISTER);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Switch side");
  key->setShortkey(XK_Tab);
  key->setMod(0);
  h1->setKey(key);
  fp=new SwitchListerOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Simulate DoubleClick");
  key->setShortkey(XK_Return);
  key->setMod(0);
  h1->setKey(key);
  fp=new SimDDOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Search Entry");
  key->setShortkey(XK_s);
  key->setMod(ControlMask);
  h1->setKey(key);
  fp=new SearchEntryOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Edit path");
  key->setShortkey(XK_Return);
  key->setMod(ControlMask);
  h1->setKey(key);
  fp=new EnterPathOp(worker);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Edit other path");
  key->setShortkey(XK_Return);
  key->setMod(ControlMask|ShiftMask);
  h1->setKey(key);
  fp=new EnterPathOp(worker);
  ((EnterPathOp*)fp)->setSide(EnterPathOp::ENTERPATHOP_OTHERSIDE);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Scroll left");
  key->setShortkey(XK_Left);
  key->setMod(ControlMask);
  h1->setKey(key);
  fp=new ScrollListerOp(worker);
  ((ScrollListerOp*)fp)->setDir(ScrollListerOp::SCROLLLISTEROP_LEFT);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Scroll rigth");
  key->setShortkey(XK_Right);
  key->setMod(ControlMask);
  h1->setKey(key);
  fp=new ScrollListerOp(worker);
  ((ScrollListerOp*)fp)->setDir(ScrollListerOp::SCROLLLISTEROP_RIGHT);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  setHotkeys(nh);
  
  h1=(WCHotkey*)nh->getFirstElement();
  while(h1!=NULL) {
    delete h1;
    h1=(WCHotkey*)nh->getNextElement();
  }
  delete nh;
  
  notyettype=NULL;
  initFixTypes(filetypes);
  maxfiletypelen=0;

  delete nc;
  delete key;
}

void WConfig::getFunctionProtoOldStyle(const unsigned long comnr,
                                       const unsigned long flag1,
                                       const unsigned long flag2,
                                       const char *usercomstr,
                                       List *l2)
{
  FunctionProto *funpro=NULL;
  char *tstr,*buttonstr,*textstr;
  Requester *req;

  switch(comnr) {
    case USER:
      funpro=new OwnOp(worker);
      if(usercomstr!=NULL) {
        changeRS(usercomstr,&tstr);
        ((OwnOp*)funpro)->setComStr(tstr);
        _freesafe(tstr);
      }
      if((flag1&1)==1) {
        ((OwnOp*)funpro)->setSeparateEachEntry(true);
        if(showOldRequest==false) {
          req=new Requester(worker->getAGUIX());
          textstr=catalog.getLocale(363);
          buttonstr=catalog.getLocale(11);
          req->request(catalog.getLocale(364),textstr,buttonstr);
          delete req;
          showOldRequest=true;
        }
      } else ((OwnOp*)funpro)->setSeparateEachEntry(false);
      if((flag1&2)==2) ((OwnOp*)funpro)->setRecursive(true);
      else ((OwnOp*)funpro)->setRecursive(false);
      if((flag1&32)==32) ((OwnOp*)funpro)->setWithApo(true);
      else ((OwnOp*)funpro)->setWithApo(false);
      
      if((flag1&4)==4) ((OwnOp*)funpro)->setOwnStart(OwnOp::OWNOP_START_IN_TERMINAL);
      else if((flag1&8)==8) ((OwnOp*)funpro)->setOwnStart(OwnOp::OWNOP_START_IN_TERMINAL_AND_WAIT4KEY);
      else if((flag1&16)==16) ((OwnOp*)funpro)->setOwnStart(OwnOp::OWNOP_SHOW_OUTPUT);
      else ((OwnOp*)funpro)->setOwnStart(OwnOp::OWNOP_START_NORMAL);
      l2->addElement(funpro);
      funpro=NULL;
      if((flag1&64)==64) {
        funpro=new ReloadOp(worker);
        ((ReloadOp*)funpro)->setReloadside(ReloadOp::RELOADOP_THISSIDE);
        l2->addElement(funpro);
        funpro=NULL;
      }
      if((flag1&128)==128) {
        funpro=new ReloadOp(worker);
        ((ReloadOp*)funpro)->setReloadside(ReloadOp::RELOADOP_OTHERSIDE);
        l2->addElement(funpro);
        funpro=NULL;
      }
      break;
    case QUIT:
      funpro=new QuitOp(worker);
      if(flag1!=0) ((QuitOp*)funpro)->setMode(QuitOp::Q_QUICK_QUIT);
      break;
    case COPY:
      funpro=new CopyOp(worker);
      ((CopyOp*)funpro)->setMove(false);
      if((flag1&1)==1) ((CopyOp*)funpro)->setFollowSymlinks(true);
      else ((CopyOp*)funpro)->setFollowSymlinks(false);
      if((flag1&2)==2) ((CopyOp*)funpro)->setOverwrite(CopyOp::COPYOP_OVERWRITE_ALWAYS);
      else if((flag1&4)==4) ((CopyOp*)funpro)->setOverwrite(CopyOp::COPYOP_OVERWRITE_NEVER);
      else ((CopyOp*)funpro)->setOverwrite(CopyOp::COPYOP_OVERWRITE_NORMAL);
      if((flag1&8)==8) ((CopyOp*)funpro)->setRename(true);
      else ((CopyOp*)funpro)->setRename(false);
      if((flag1&16)==16) ((CopyOp*)funpro)->setSameDir(true);
      else ((CopyOp*)funpro)->setSameDir(false);
      if((flag1&32)==32) ((CopyOp*)funpro)->setRequestDest(true);
      else ((CopyOp*)funpro)->setRequestDest(false);
      if((flag1&64)==64) ((CopyOp*)funpro)->setRequestFlags(true);
      else ((CopyOp*)funpro)->setRequestFlags(false);
      break;
    case MOVE:
      funpro=new CopyOp(worker);
      ((CopyOp*)funpro)->setMove(true);
      if((flag1&1)==1) ((CopyOp*)funpro)->setOverwrite(CopyOp::COPYOP_OVERWRITE_ALWAYS);
      else if((flag1&2)==2) ((CopyOp*)funpro)->setOverwrite(CopyOp::COPYOP_OVERWRITE_NEVER);
      else ((CopyOp*)funpro)->setOverwrite(CopyOp::COPYOP_OVERWRITE_NORMAL);
      if((flag1&4)==4) ((CopyOp*)funpro)->setRename(true);
      else ((CopyOp*)funpro)->setRename(false);
      if((flag1&8)==8) ((CopyOp*)funpro)->setRequestFlags(true);
      else ((CopyOp*)funpro)->setRequestFlags(false);
      break;
    case DELETE:
      funpro=new DeleteOp(worker);
      break;
    case MAKEDIR:
      funpro=new MakeDirOp(worker);
      break;
    case RENAME:
      funpro=new RenameOp(worker);
      break;
    case SELECTALL:
      funpro=new SelectAllOp(worker);
      break;
    case SELECTNONE:
      funpro=new SelectNoneOp(worker);
      break;
    case INVERT:
      funpro=new InvertAllOp(worker);
      break;
    case RELOAD:
      funpro=new ReloadOp(worker);
      break;
    case PREVITEM:
      funpro=new RowUp(worker);
      break;
    case NEXTITEM:
      funpro=new RowDown(worker);
      break;
    case PARENT:
      funpro=new ParentDirOp(worker);
      break;
    case GODIR:
      funpro=new EnterDirOp(worker);
      break;
    case FIRSTITEM:
      funpro=new FirstRow(worker);
      break;
    case LASTITEM:
      funpro=new LastRow(worker);
      break;
    case PAGEUP:
      funpro=new PageUp(worker);
      break;
    case PAGEDOWN:
      funpro=new PageDown(worker);
      break;
    case SELECT:
      funpro=new SelectOp(worker);
      break;
    case MAIN_FUNC:
      funpro=new SimDDOp(worker);
      break;
    case RUNPROGRAM:
      funpro=new StartProgOp(worker);
      if((flag1&1)==1) ((StartProgOp*)funpro)->setStart(StartProgOp::STARTPROGOP_START_IN_TERMINAL);
      else if((flag1&2)==2) ((StartProgOp*)funpro)->setStart(StartProgOp::STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY);
      else if((flag1&4)==4) ((StartProgOp*)funpro)->setStart(StartProgOp::STARTPROGOP_SHOW_OUTPUT);
      else ((StartProgOp*)funpro)->setStart(StartProgOp::STARTPROGOP_START_NORMAL);
      if((flag1&8)==8) ((StartProgOp*)funpro)->setGlobal(true);
      else ((StartProgOp*)funpro)->setGlobal(false);
      if((flag1&16)==16) ((StartProgOp*)funpro)->setRequestFlags(true);
      else ((StartProgOp*)funpro)->setRequestFlags(false);
      break;
    case LISTEROPTIONS:
      funpro=new ChangeListerSetOp(worker);
      if((flag1&1)==1) ((ChangeListerSetOp*)funpro)->setMode(ChangeListerSetOp::CLS_LEFT_LISTER);
      else if((flag1&2)==2) ((ChangeListerSetOp*)funpro)->setMode(ChangeListerSetOp::CLS_RIGHT_LISTER);
      else ((ChangeListerSetOp*)funpro)->setMode(ChangeListerSetOp::CLS_ACTUAL_LISTER);
      break;
    case LISTERSCROLLLEFT:
      funpro=new ScrollListerOp(worker);
      ((ScrollListerOp*)funpro)->setDir(ScrollListerOp::SCROLLLISTEROP_LEFT);
      break;
    case LISTERSCROLLRIGHT:
      funpro=new ScrollListerOp(worker);
      ((ScrollListerOp*)funpro)->setDir(ScrollListerOp::SCROLLLISTEROP_RIGHT);
      break;
    case FILTERSELECT:
      funpro=new FilterSelectOp(worker);
      break;
    case DIRSIZE:
      funpro=new DirSizeOp(worker);
      break;
    case CREATESYMLINK:
      funpro=new CreateSymlinkOp(worker);
      if((flag1&1)==1) ((CreateSymlinkOp*)funpro)->setSameDir(true);
      else ((CreateSymlinkOp*)funpro)->setSameDir(false);
      if((flag1&2)==2) ((CreateSymlinkOp*)funpro)->setLocal(true);
      else ((CreateSymlinkOp*)funpro)->setLocal(false);
      if((flag1&4)==4) ((CreateSymlinkOp*)funpro)->setRequestFlags(true);
      else ((CreateSymlinkOp*)funpro)->setRequestFlags(false);
      break;
    case CHANGESYMLINK:
      funpro=new ChangeSymlinkOp(worker);
      break;
    case CHANGEMOD:
      funpro=new ChModOp(worker);
      if((flag1&1)==1) ((ChModOp*)funpro)->setOnFiles(true);
      else ((ChModOp*)funpro)->setOnFiles(false);
      if((flag1&2)==2) ((ChModOp*)funpro)->setOnDirs(true);
      else ((ChModOp*)funpro)->setOnDirs(false);
      if((flag1&4)==4) ((ChModOp*)funpro)->setRecursive(true);
      else ((ChModOp*)funpro)->setRecursive(false);
      if((flag1&8)==8) ((ChModOp*)funpro)->setRequestFlags(true);
      else ((ChModOp*)funpro)->setRequestFlags(false);
      break;
    case TOGGLEINFOMODE:
      funpro=new ToggleListermodeOp(worker);
      ((ToggleListermodeOp*)funpro)->setMode(2);
      break;
    case SEARCHENTRY:
      funpro=new SearchEntryOp(worker);
      break;
    case PATH2OTHERLISTER:
      funpro=new Path2OSideOp(worker);
      break;
    case ENTERPATH:
      funpro=new EnterPathOp(worker);
      if((flag1&1)==1) ((EnterPathOp*)funpro)->setSide(EnterPathOp::ENTERPATHOP_OTHERSIDE);
      else if((flag1&2)==2) ((EnterPathOp*)funpro)->setSide(EnterPathOp::ENTERPATHOP_LEFTSIDE);
      else if((flag1&4)==4) ((EnterPathOp*)funpro)->setSide(EnterPathOp::ENTERPATHOP_RIGHTSIDE);
      else ((EnterPathOp*)funpro)->setSide(EnterPathOp::ENTERPATHOP_THISSIDE);
      break;
  }
  if(funpro!=NULL) l2->addElement(funpro);
}

void WConfig::changeRS(const char *old,char **newstr)
{
  char *tstr=dupstring(old),ch;
  int mode=0,pos=0;
  for(;;) {
    ch=tstr[pos];
    if(ch==0) break;
    switch(mode) {
      case 1:
        if(ch=='R') mode=2;
        else mode=0;
        break;
      case 2:
        if(ch=='s') mode=3;
        else mode=0;
        break;
      case 3:
        if(ch=='<') tstr[pos]='{';
        else if(ch=='>') tstr[pos]='}';
        else if(ch=='}') mode=0;
        break;
      default:
        if(ch=='{') mode=1;
        break;
    }
    pos++;
  }
  *newstr=tstr;
}

