/* setsortmodeop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: setsortmodeop.h,v 1.3 2001/11/03 17:10:44 ralf Exp $ */

#ifndef SETSORTMODEOP_H
#define SETSORTMODEOP_H

#include "functionproto.h"
class Worker;

class SetSortmodeOp:public FunctionProto
{
public:
  SetSortmodeOp(Worker*);
  virtual ~SetSortmodeOp();
  virtual SetSortmodeOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual int load(Datei*);
  virtual const char *getDescription();
  virtual int configure();
protected:
  static const char *name;
  int mode;
};

#endif

