/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PropertySet {
    private Hashtable properties = new Hashtable();
    private String sName = "";

    public String getProperty(String sPropName) {
        if (sPropName != null) {
            String sValue = (String)this.properties.get(sPropName);
            if (sValue != null && sValue.endsWith("inch")) {
                return sValue.substring(0, sValue.length() - 2);
            }
            return sValue;
        }
        return null;
    }

    public String getName() {
        return this.sName;
    }

    public void loadFromDOM(Node node) {
        NamedNodeMap attrNodes;
        this.sName = node.getNodeName();
        if (node != null && (attrNodes = node.getAttributes()) != null) {
            int nLen = attrNodes.getLength();
            int i = 0;
            while (i < nLen) {
                Node attr = attrNodes.item(i);
                this.properties.put(attr.getNodeName(), attr.getNodeValue());
                ++i;
            }
        }
    }

    public boolean containsProperty(String sProperty) {
        return sProperty != null && this.properties.containsKey(sProperty);
    }

    public void setProperty(String sProperty, String sValue) {
        this.properties.put(sProperty, sValue);
    }

    public String toString() {
        String s = "";
        Enumeration keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String sKey = (String)keys.nextElement();
            String sValue = (String)this.properties.get(sKey);
            s = s + sKey + "=" + sValue + " ";
        }
        return s;
    }
}

