/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44AverageMessage.h"
#include "JT44Defs.h"

CJT44AverageMessage::CJT44AverageMessage() :
CJT44MessageBase(),
m_id(wxEmptyString),
m_count(0),
m_mutex()
{
}

CJT44AverageMessage::~CJT44AverageMessage()
{
}

void CJT44AverageMessage::clear()
{
	m_mutex.Lock();

	m_id    = wxEmptyString;
	m_count = 0;

	clearData();
	clearSync();
	clearNoise();

	m_mutex.Unlock();
}

void CJT44AverageMessage::setId(const wxString& id)
{
	m_id = id;
}

wxString CJT44AverageMessage::getId() const
{
	return m_id;
}

int CJT44AverageMessage::getCount() const
{
	return m_count;
}

/*
 * Add the contents of one message to another for use in the "average"
 * message.
 */
void CJT44AverageMessage::addMessage(const CJT44Message& message)
{
	m_mutex.Lock();

	for (int pos = 0; pos < 135; pos++) {
		addSync(pos, message.getSync(pos));
		addNoise(pos, message.getNoise(pos));

		for (int letter = 0; letter < JT44_ALPHABET_COUNT; letter++)
			addData(letter, pos, message.getData(letter, pos));
	}

	m_count++;

	m_mutex.Unlock();
}

/*
 * Remove the contents of one message from the "average" message, this is
 * used when either excluding a message or clearing.
 */
void CJT44AverageMessage::subtractMessage(const CJT44Message& message)
{
	wxASSERT(m_count > 0);

	m_mutex.Lock();

	for (int pos = 0; pos < 135; pos++) {
		subtractSync(pos, message.getSync(pos));
		subtractNoise(pos, message.getNoise(pos));

		for (int letter = 0; letter < JT44_ALPHABET_COUNT; letter++)
			subtractData(letter, pos, message.getData(letter, pos));
	}

	m_count--;

	m_mutex.Unlock();
}
