/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44FileReceive.h"
#include "JT44Defs.h"
#include "JT44App.h"

#include "common/SoundFile.h"
#include "common/Exception.h"

#include <wx/debug.h>
#include <wx/log.h>
#include <wx/filename.h>

CJT44FileReceive::CJT44FileReceive(const wxString& name, EWho who) :
CJT44Receive(name, who),
m_fileName(wxEmptyString),
m_soundDev(NULL)
{
}

CJT44FileReceive::~CJT44FileReceive()
{
}

bool CJT44FileReceive::getEndTime()
{
	return false;
}

void CJT44FileReceive::setFileName(const wxString& fileName)
{
	wxASSERT(m_soundDev == NULL);

	m_fileName = fileName;

	m_soundDev = new CSoundFile(fileName, JT44_SAMPLE_RATE);
	m_soundDev->openRead();
}

void CJT44FileReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);
}

void CJT44FileReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
	delete m_soundDev;

	m_soundDev = NULL;
}

void CJT44FileReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);
}

wxString CJT44FileReceive::createId()
{
	wxFileName fileName(m_fileName);

	return fileName.GetName();
}

void CJT44FileReceive::error(const wxString& text)
{
	::wxLogError(wxT("%s: %s"), getName().c_str(), text.c_str());

	::wxGetApp().error(text);
}
