# format: class : {method : (prototype1, prototype2)}
# using a "*" means all prototypes
ignored_methods = {
    "wxIcon": {'wxIcon': (['const char', 'int', 'int'], )},
}

# these classes are either replaced by different data types in bindings, or have equivalent / better
# functionality provided by the target language.
excluded_classes = [
        "wxAny",
        "wxAnyValueType",
        "wxArchiveClassFactory",
        "wxArchiveEntry",
        "wxArchiveInputStream",
        "wxArchiveIterator",
        "wxArchiveNotifier",
        "wxArchiveOutputStream",
        "wxArray< T >", 
        "wxArrayString",
        "wxAutomationObject",
        "wxBufferedInputStream",
        "wxBufferedOutputStream",
        "wxCharBuffer",
        "wxCharTypeBuffer",
        "wxClassInfo",
        "wxCmdLineParser",
        "wxCondition",
        "wxConnection",
        "wxConnectionBase",
        "wxConvAuto",
        "wxCountingOutputStream",
        "wxCriticalSection",
        "wxCriticalSectionLocker",
        "wxCSConv",
        "wxDatagramSocket",
        "wxDataInputStream",
        "wxDataOutputStream",
        "wxDir",
        "wxDirTraverser",
        "wxFFile",
        "wxFFileInputStream",
        "wxFFileOutputStream",
        "wxFile",
        "wxFileInputStream",
        "wxFileName",
        "wxFileOutputStream",
        "wxFileStream",
        "wxFilterClassFactory",
        "wxFilterInputStream",
        "wxFilterOutputStream",
        "wxFSFile",
        "wxFSVolume",
        "wxFTP",
        "wxHashMap",
        "wxHashSet",
        "wxHashTable",
        "wxHTTP",
        "wxImage::HSVValue",
        "wxImage::RGBValue",
        "wxInputStream",
        "wxIPAddress",
        "wxIPV4Address",
        "wxList< T >",
        "wxLongLong",
        "wxMBConv",
        "wxMBConvFile",
        "wxMBConvUTF7",
        "wxMBConvUTF8",
        "wxMBConvUTF16",
        "wxMBConvUTF32",
        "wxMemoryBuffer",
        "wxMemoryFSHandler",
        "wxMemoryInputStream",
        "wxMemoryOutputStream",
        "wxMessageQueue< T >",
        "wxModule",
        "wxMutex",
        "wxMutexLocker",
        "wxNode< T >",
        "wxObjectDataPtr< T >",
        "wxObjectRefData",
        "wxOutputStream",
        "wxProcess",
        "wxProcessEvent",
        "wxProtocol",
        "wxProtocolLog",
        "wxRecursionGuard",
        "wxRecursionGuardFlag",
        "wxRegKey",
        "wxScopedArray",
        "wxScopedCharTypeBuffer",
        "wxScopedPtr",
        "wxScopedPtr< T >",
        "wxSharedPtr< T >",
        "wxServer",
        "wxSockAddress",
        "wxSocketBase",
        "wxSocketClient",
        "wxSocketEvent",
        "wxSocketInputStream",
        "wxSocketOutputStream",
        "wxSortedArrayString",
        "wxStopWatch",
        "wxStreamBase",
        "wxStreamBuffer",
        "wxStreamToTextRedirector",
        "wxString",
        "wxStringBuffer",
        "wxStringBufferLength",
        "wxStringClientData",
        "wxStringInputStream",
        "wxStringOutputStream",
        "wxTarClassFactory",
        "wxTarEntry",
        "wxTarInputStream",
        "wxTarOutputStream",
        "wxTCPClient",
        "wxTCPConnection",
        "wxTCPServer",
        "wxTempFile",
        "wxTempFileOutputStream",
        "wxTextInputStream",
        "wxTextOutputStream",
        "wxThread",
        "wxThreadEvent",
        "wxThreadHelper",
        "wxULongLong",
        "wxUniChar",
        "wxUniCharRef",
        "wxURI",
        "wxURL",
        "wxUString",
        "wxVariant",
        "wxVariantData",
        "wxVector< T >",
        "wxVector< T >::reverse_iterator",
        "wxWCharBuffer",
        "wxWeakRef< T >",
        "wxWeakRefDynamic< T >",
        "wxZipInputStream",
        "wxZipOutputStream",
        "wxZlibInputStream",
        "wxZlibOutputStream",
        ]

def get_first_value(alist):
    if len(alist) > 0:
        return alist[0]
    else:
        return ""

def make_enums(aclass):
    retval = ""
    for enum in aclass.enums:
        retval += "enum %s {\n" % enum
        num_values = len(aclass.enums[enum])
        for value in aclass.enums[enum]:
            retval += "    %s" % value
            if not value == aclass.enums[enum][-1]:
                retval += ", "
            retval += "\n"
        retval += "};\n\n"
    
    return retval
