/* -*-Mode: C++;-*-
 * $Id: dbfs_errs.h 1.12 Tue, 15 May 2001 16:33:56 -0700 jmacd $
 *
 * Copyright (C) 1998, 1999, 2000, Joshua P. MacDonald
 * <jmacd@CS.Berkeley.EDU> and The Regents of the University of
 * California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _DBFS_ERRS_H_
#define _DBFS_ERRS_H_

#include <strstream>

char*       dbfs_strerror     (int      num);
void        dbfs_set_streams  (ostream *out,
			       ostream *err);

class MESSAGE_CLASS;

class MESSAGE_TYPE
{
public:

    MESSAGE_TYPE (const char *kind, MESSAGE_CLASS &mclass);

    bool                 active;
    string               kind;
    const MESSAGE_CLASS &mclass;

    elink<MESSAGE_TYPE>  link;
};

typedef ELIST(MESSAGE_TYPE,link) MESSAGE_TYPE_LIST;

class MESSAGE_CLASS
{
public:

    MESSAGE_CLASS (const char *kind,
		   ostream    *print_str,
		   bool        is_fatal,
		   bool        is_prefix,
		   bool        no_prefix);

    void register_type (MESSAGE_TYPE *mtype);

    const char *const  kind;
    ostream    *const  print_str;
    bool        const  is_fatal;
    bool        const  is_prefix;
    bool        const  no_prefix;
    MESSAGE_TYPE_LIST  type_list;
};

extern MESSAGE_CLASS MCLASS_LOG;
extern MESSAGE_CLASS MCLASS_INFO;
extern MESSAGE_CLASS MCLASS_DEBUG;
extern MESSAGE_CLASS MCLASS_ERROR;
extern MESSAGE_CLASS MCLASS_WARN;
extern MESSAGE_CLASS MCLASS_FATAL;
extern MESSAGE_CLASS MCLASS_NOPREFIX;

#define DEBUG_TAG(x) ((DEBUG_ ## x ## _MESSAGE).active)
#define LOG_TAG(x)   ((LOG_ ## x ## _MESSAGE).active)
#define WARN_TAG(x)  ((WARN_ ## x ## _MESSAGE).active)

#define MESSAGE_CLOSURE_FL(x) MESSAGE_CLOSURE(x,__FILE__,__LINE__)

#define MK_ERROR_MESSAGE(type) if (ERROR_ ## type ## _MESSAGE.active) MESSAGE_CLOSURE_FL (ERROR_ ## type ## _MESSAGE)
#define MK_INFO_MESSAGE(type)  if (INFO_  ## type ## _MESSAGE.active) MESSAGE_CLOSURE_FL (INFO_  ## type ## _MESSAGE)
#define MK_PLAIN_MESSAGE(type) if (          type ## _MESSAGE.active) MESSAGE_CLOSURE_FL (          type ## _MESSAGE)
#define MK_DEBUG_MESSAGE(type) if (DEBUG_ ## type ## _MESSAGE.active) MESSAGE_CLOSURE_FL (DEBUG_ ## type ## _MESSAGE)
#define MK_WARN_MESSAGE(type)  if (WARN_  ## type ## _MESSAGE.active) MESSAGE_CLOSURE_FL (WARN_  ## type ## _MESSAGE)
#define MK_LOG_MESSAGE(type)   if (LOG_   ## type ## _MESSAGE.active) MESSAGE_CLOSURE_FL (LOG_   ## type ## _MESSAGE)

extern MESSAGE_TYPE ERROR_TEST_MESSAGE;
extern MESSAGE_TYPE ERROR_DBFS_MESSAGE;
extern MESSAGE_TYPE ERROR_DB_MESSAGE;
extern MESSAGE_TYPE ERROR_PROP_MESSAGE;
extern MESSAGE_TYPE ERROR_SYS_MESSAGE;
extern MESSAGE_TYPE ERROR_XDFS_MESSAGE;

extern MESSAGE_TYPE WARN_DBFS_MESSAGE;

extern MESSAGE_TYPE NOPREFIX_MESSAGE;
extern MESSAGE_TYPE DBFS_FATAL_MESSAGE;

extern MESSAGE_TYPE DEBUG_FREELIST_MESSAGE;
extern MESSAGE_TYPE DEBUG_PRECOMMIT_MESSAGE;
extern MESSAGE_TYPE DEBUG_TXN_MESSAGE;
extern MESSAGE_TYPE DEBUG_SYNC_MESSAGE;
extern MESSAGE_TYPE DEBUG_MAINT_MESSAGE;
extern MESSAGE_TYPE DEBUG_XDFS_MESSAGE;
extern MESSAGE_TYPE DEBUG_CURSOR_MESSAGE;
extern MESSAGE_TYPE DEBUG_CACHE_MESSAGE;
extern MESSAGE_TYPE DEBUG_REFS_MESSAGE;
extern MESSAGE_TYPE DEBUG_LINK_MESSAGE;
extern MESSAGE_TYPE DEBUG_ENLARGE_MESSAGE;
extern MESSAGE_TYPE DEBUG_SHARED_MESSAGE;
extern MESSAGE_TYPE DEBUG_DBFS_MESSAGE;
extern MESSAGE_TYPE DEBUG_ALLOC_MESSAGE;
extern MESSAGE_TYPE DEBUG_SIGNAL_MESSAGE;

extern MESSAGE_TYPE INFO_DBFS_MESSAGE;
extern MESSAGE_TYPE INFO_XDFS_MESSAGE;
extern MESSAGE_TYPE INFO_TEST_MESSAGE;

#define DBFS_ERROR      MK_ERROR_MESSAGE (DBFS)
#define DB_ERROR        MK_ERROR_MESSAGE (DB)
#define PROP_ERROR      MK_ERROR_MESSAGE (PROP)
#define SYS_ERROR       MK_ERROR_MESSAGE (SYS)
#define TEST_ERROR      MK_ERROR_MESSAGE (TEST)
#define XDFS_ERROR      MK_ERROR_MESSAGE (XDFS)

#define DBFS_WARN       MK_WARN_MESSAGE  (DBFS)

#define NOPREFIX_OUT    MK_PLAIN_MESSAGE (NOPREFIX)
#define DBFS_FATAL      MK_PLAIN_MESSAGE (DBFS_FATAL)

#define DEBUG_FREELIST  MK_DEBUG_MESSAGE (FREELIST)
#define DEBUG_PRECOMMIT MK_DEBUG_MESSAGE (PRECOMMIT)
#define DEBUG_TXN       MK_DEBUG_MESSAGE (TXN)
#define DEBUG_SYNC      MK_DEBUG_MESSAGE (SYNC)
#define DEBUG_MAINT     MK_DEBUG_MESSAGE (MAINT)
#define DEBUG_XDFS      MK_DEBUG_MESSAGE (XDFS)
#define DEBUG_CURSOR    MK_DEBUG_MESSAGE (CURSOR)
#define DEBUG_REFS      MK_DEBUG_MESSAGE (REFS)
#define DEBUG_LINK      MK_DEBUG_MESSAGE (LINK)
#define DEBUG_CACHE     MK_DEBUG_MESSAGE (CACHE)
#define DEBUG_ENLARGE   MK_DEBUG_MESSAGE (ENLARGE)
#define DEBUG_SHARED    MK_DEBUG_MESSAGE (SHARED)
#define DEBUG_DBFS      MK_DEBUG_MESSAGE (DBFS)
#define DEBUG_ALLOC     MK_DEBUG_MESSAGE (ALLOC)
#define DEBUG_SIGNAL    MK_DEBUG_MESSAGE (SIGNAL)

#define INFO_DBFS       MK_INFO_MESSAGE  (DBFS)
#define INFO_XDFS       MK_INFO_MESSAGE  (XDFS)
#define INFO_TEST       MK_INFO_MESSAGE  (TEST)

class MESSAGE_CLOSURE
{
public:
    MESSAGE_CLOSURE  (MESSAGE_TYPE &type,
		      const char   *file,
		      int           line);

    ~MESSAGE_CLOSURE ();

    ostream&          operator () (void) { prefix (); return _msg; }

    // Special meaning for errno values
    MESSAGE_CLOSURE&  operator () (int               errnum);

    MESSAGE_CLOSURE&  operator () (const NODEC      *node);
    MESSAGE_CLOSURE&  operator () (const NODEC      &node);
    MESSAGE_CLOSURE&  operator () (const MAJORC     *node);
    MESSAGE_CLOSURE&  operator () (const MAJORC     &node);
    MESSAGE_CLOSURE&  operator () (const SAREA      *node);
    MESSAGE_CLOSURE&  operator () (const SAREA      &node);
    MESSAGE_CLOSURE&  operator () (const MAJOR_DESC &node);
    MESSAGE_CLOSURE&  operator () (const MAJOR_DESC *node);
    MESSAGE_CLOSURE&  operator () (const MINOR_DESC &node);
    MESSAGE_CLOSURE&  operator () (const MINOR_DESC *node);
    MESSAGE_CLOSURE&  operator () (const SAREA_DESC &node);
    MESSAGE_CLOSURE&  operator () (const SAREA_DESC *node);
    MESSAGE_CLOSURE&  operator () (const DBCREF     *dbc);
    MESSAGE_CLOSURE&  operator () (const COMDBT     &dbt);
    MESSAGE_CLOSURE&  operator () (const SHFD_DESC  *shfd);
    MESSAGE_CLOSURE&  operator () (const SHDB_DESC  *shdb);
    MESSAGE_CLOSURE&  operator () (const SHPG_DESC  *shpg);
    MESSAGE_CLOSURE&  operator () (const STXN       &txn);
    MESSAGE_CLOSURE&  operator () (const STXN       &txn,
				   DbTxn            *dbtxn);
    MESSAGE_CLOSURE&  operator () (const DKEY       &dkey);

    template <class T>
    MESSAGE_CLOSURE&  operator () (const SAFEINT<T> &i);

    MESSAGE_CLOSURE&  operator () (const string     &s);
    MESSAGE_CLOSURE&  operator () (const char       *fmt, ...) __attribute__((format (printf, 2, 3)));

private:

    void prefix       ();

    MESSAGE_TYPE  &_type;
    const char    *_file;
    int            _line;
    int            _error;
    int            _op_count;
    strstream      _msg;
};

template <class T>
inline MESSAGE_CLOSURE&
MESSAGE_CLOSURE::operator () (const SAFEINT<T> &i)
{
    _msg << i.key ();
    return *this;
}

#endif /* _DBFS_ERRS_H_ */
