/* -*-Mode: C++;-*-
 * $Id: seqv.cc 1.6 Tue, 15 May 2001 16:33:56 -0700 jmacd $
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "xdfs_cpp.h"
#include "seqv.h"

int
SEQV::create ()
{
    int  ret;
    STXN txn;

    if ((ret = txn.begin (_dbfs, DBFS_TXN_NOSYNC_INTERNAL))) {
	PROP_ERROR (ret) ("txn_begin: seqv_create");
	return ret;
    }

    XSEQNO init (1);

    if ((ret = _dbfs._seqv_db.template append_T<XSEQNO> (txn, _id, init))) {
	PROP_ERROR (ret) ("seqv_append");
	return ret;
    }

    if ((ret = txn.commit ())) {
	PROP_ERROR (ret) ("txn_commit: seqv_create");
	return ret;
    }

    return 0;
}

int
SEQV::next (guint32 &val)
{
    int     ret;
    STXN    txn;
    guint32 curval;

    g_assert (id ().key () != 0);

    if ((ret = txn.begin (_dbfs, DBFS_TXN_NOSYNC_INTERNAL))) {
	PROP_ERROR (ret) ("txn_begin: seqv_next");
	return ret;
    }

    DBCREF dbc;

    if ((ret = _dbfs._seqv_db.cursor (txn, dbc))) {
	PROP_ERROR (ret) ("seqv_cursor");
	return ret;
    }

    if ((ret = dbc.template get_must_exist_T<XSEQNO,guint32> (_id, curval, DBFS_RMW))) {
	PROP_ERROR (ret) ("get_must_exist");
	return ret;
    }

    val     = curval;
    curval += 1;

    if ((ret = dbc.template put_current_T<guint32> (curval))) {
	PROP_ERROR (ret) ("put_current");
	return ret;
    }

    if ((ret = dbc.close ())) {
	PROP_ERROR (ret) ("dbc_close");
	return ret;
    }

    if ((ret = txn.commit ())) {
	PROP_ERROR (ret) ("txn_commit: seqv_next");
	return ret;
    }

    return 0;
}
