#ifndef globals_h
#define globals_h

#include <pthread.h>
#include <glib.h>

#define MAX_SIML_REQ 10

//#define PARSE_DEBUG // define this to include debug messages from parse.cc

//#define POST_DEBUG

#define STATUS_304 "304 Not Modified"
#define STATUS_400 "400 Bad Request"
#define STATUS_501 "501 Not Implemented"
#define STATUS_500 "500 Internal Server Error"
#define STATUS_502 "502 Bad Gateway"

#define GTIMER_NEW() g_timer_new()
#define GTIMER_START(timer) g_timer_reset(timer); g_timer_start(timer)
#define GTIMER_STOP(timer) g_timer_stop(timer)
#define GTIMER_ELAPSED(timer) g_timer_elapsed(timer, NULL)
#define GTIMER_DESTROY(timer) g_timer_destroy(timer)

enum RequestState {
  UNUSED,
  RECEIVE_CLIENT_REQUEST,
  PROCESS_CLIENT_REQUEST, // might not need this
  WAIT_TO_SEND_SERVER_REQUEST,
  SEND_SERVER_REQUEST,
  RECEIVE_SERVER_RESPONSE,
  PROCESS_SERVER_RESPONSE, // might not need this
  WAIT_TO_SEND_CLIENT_RESPONSE,
  SEND_CLIENT_RESPONSE
};

enum RequestHeaderState {
  FULL_REQUEST,
  PARTIAL_REQUEST,
  BAD_REQUEST,
  METHOD_NOT_IMPLEMENTED
};

enum ResponseHeaderState {
  FULL_RESPONSE,
  PARTIAL_RESPONSE,
  BAD_RESPONSE
};

enum TransferState {
  DONE,
  PARTIAL,
  ERROR
};

enum MessageType {
  REQUEST,
  RESPONSE
};

#endif
