#include "helper.h"
#include "storage.h"

const char allMonths[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
const char allDays[7][4] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

bool strToTime(char *str, time_t *t) {
  struct tm date;
  char month[4];
  int n;

  if (strlen(str) < 4)
    return false;

  /* Handle rfc1123-date. */
  if (str[3] == ',') {
    n = sscanf(str, "%*s %d %3s %d %d:%d:%d %*s", &(date.tm_mday), month, &(date.tm_year), &(date.tm_hour), &(date.tm_min), &(date.tm_sec));
    if (n != 6)
      return false;
    date.tm_year -= 1900;
  }
  /* Handle asctime-date. */
  else if (str[3] == ' ') {
    n = sscanf(str, "%*s %3s %d %d:%d:%d %d", month, &(date.tm_mday), &(date.tm_hour), &(date.tm_min), &(date.tm_sec), &(date.tm_year));
    if (n != 6)
      return false;
    date.tm_year -= 1900;
  }
  /* Handle rfc850-date. */
  else {
    n = sscanf(str, "%*s %d-%3s-%d %d:%d:%d %*s", &(date.tm_mday), month, &(date.tm_year), &(date.tm_hour), &(date.tm_min), &(date.tm_sec));
    if (n != 6)
      return false;
  }

  date.tm_isdst = 1;
  if (strcasecmp(month, "jan") == 0)
    date.tm_mon = 0;
  else if (strcasecmp(month, "feb") == 0)
    date.tm_mon = 1;
  else if (strcasecmp(month, "mar") == 0)
    date.tm_mon = 2;
  else if (strcasecmp(month, "apr") == 0)
    date.tm_mon = 3;
  else if (strcasecmp(month, "may") == 0)
    date.tm_mon = 4;
  else if (strcasecmp(month, "jun") == 0)
    date.tm_mon = 5;
  else if (strcasecmp(month, "jul") == 0)
    date.tm_mon = 6;
  else if (strcasecmp(month, "aug") == 0)
    date.tm_mon = 7;
  else if (strcasecmp(month, "sep") == 0)
    date.tm_mon = 8;
  else if (strcasecmp(month, "oct") == 0)
    date.tm_mon = 9;
  else if (strcasecmp(month, "nov") == 0)
    date.tm_mon = 10;
  else if (strcasecmp(month, "dec") == 0)
    date.tm_mon = 11;

  *t = mktime(&date);

  return true;
}

bool timeToStr(time_t t, char str[32]) {
  struct tm *date;
  char month[4], day[4];

  if (t < 0) {
    strcpy(str, "0");
    return true;
  }

  /* Standard GMT time. */
  date = gmtime(&t);
  if (date == NULL)
    return false;
  strcpy(month, allMonths[date->tm_mon]);
  strcpy(day, allDays[date->tm_wday]);
  sprintf(str, "%s, %02d %s %4d %02d:%02d:%02d GMT", day, date->tm_mday, month, date->tm_year+1900, date->tm_hour, date->tm_min, date->tm_sec);

  return true;
}

void reallocateBuffer(char **buffer, int *allocatedLength, int desiredLength) {
  char *temp;

  DEBUG_HELPER ("reallocateBuffer: allocatedLength = %d, desiredLength = %d\n", *allocatedLength, desiredLength);

  if ((temp = new char[desiredLength]) == NULL) {
      fprintf (stderr, "can't allocate any more memory");
      abort ();
  }
  memmove(temp, *buffer, *allocatedLength);
  delete [] (*buffer);
  *buffer = temp;
  *allocatedLength = desiredLength;
}
