/*
 *  xdemorse: An application to decode Morse signals to text
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H	1

#include "common.h"

/*------------------------------------------------------------------------*/

/* Global widgets */
extern GtkWidget
  *gbl_rx_scrolledwindow,
  *gbl_scope,
  *gbl_waterfall,
  *gbl_scope_label;

/* Speed and squelch spin button */
extern GtkSpinButton
  *gbl_speed,
  *gbl_squelch,
  *gbl_ratio;

/* Runtime config data */
extern rc_data_t rc_data;

/* DSP samples buffer */
extern samples_buffer_t samples_buffer;

/* Waterfall window pixbuf */
extern GdkPixbuf *gbl_wfall_pixbuf;
extern guchar *gbl_wfall_pixels;
extern gint
  gbl_wfall_rowstride,
  gbl_wfall_n_channels,
  gbl_wfall_width,
  gbl_wfall_height;

/* Text buffer for text viewer */
extern GtkTextBuffer *gbl_rx_text_buffer;

/* Text buffer for text viewer */
extern GtkTextBuffer *gbl_rx_text_buffer;

extern gint
  gbl_scope_width,
  gbl_scope_height;

/* Average bin values */
extern int *gbl_bin_ave;

/* fft in/out buffers */
extern int
  *fft_in_r,
  *fft_out_r,
  *fft_out_i;

/*------------------------------------------------------------------------*/

#endif
