// file      : tests/cxx/parser/validation/built-in/long-long/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test the built-in long and unsigned long types validation.
//
#include <cassert>

#include <xsde/cxx/parser/validating/long-long.hxx>
#include <xsde/cxx/parser/validating/unsigned-long-long.hxx>

using namespace xsde::cxx::parser::validating;

int
main (int argc, char* argv[])
{
  // Good.
  //
  {
    long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-9223372036854775808");
    p._post ();
    assert (!p._error_type () &&
            p.post_long () == (-9223372036854775807LL - 1));
  }

  {
    long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_long () == 0);
  }

  {
    long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("9223372036854775807");
    p._post ();
    assert (!p._error_type () && p.post_long () == 9223372036854775807LL);
  }

  {
    unsigned_long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_unsigned_long () == 0);
  }

  {
    unsigned_long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("18446744073709551615");
    p._post ();
    assert (!p._error_type () &&
            p.post_unsigned_long () == 18446744073709551615ULL);
  }

  // Bad
  //

  {
    unsigned_long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-123");
    p._post ();
    assert (p._schema_error ());
  }


  // Ranges
  //
  {
    long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-9223372036854775809");
    p._post ();
    assert (p._schema_error ());
  }

  {
    long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("9223372036854775808");
    p._post ();
    assert (p._schema_error ());
  }

  {
    unsigned_long_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("18446744073709551616");
    p._post ();
    assert (p._schema_error ());
  }
}
