%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  clp(q,r)                                         version 1.3.2 %
%                                                                 %
%  (c) Copyright 1992,1993,1994,1995                              %
%  Austrian Research Institute for Artificial Intelligence (OFAI) %
%  Schottengasse 3                                                %
%  A-1010 Vienna, Austria                                         %
%                                                                 %
%  File:   mip.pl                                                 %
%  Author: Christian Holzbaur           christian@ai.univie.ac.at %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


example( N) :-
  example( N, O, _, I, _),
  statistics( runtime, _),
    bb_inf( I, O, Inf, _, 0.001),
    print( N:Inf), nl,
  statistics( runtime, [_,T]),
  print_time( T).

print_time( T) :- print_time( '%%% Timing', T).

%
% milliseconds
%
print_time( What, T) :-
        Seconds is T/1000,
        Hour is T // 3600000, 
        R0 is T-Hour*3600000,
        Min is R0 // 60000,
        R1 is R0-Min*60000,
        Sec is R1/1000,
        format( "~|~w~t~15+ ~|~`0t~d~2+:~|~`0t~d~2+:~|~`0t~3f~6+ ~t~3f~10+~n", 
                [What,Hour,Min,Sec,Seconds]).


%
% s20196, pp.427, Opt = 13, X1=2,X2=1
%
example( 1, Obj, Vs, Vs, []) :-
  Vs = [X1,X2],
  {
    3*X1 +   X2 >= 2,
      X1 + 4*X2 >= 5,
    3*X1 + 2*X2 >= 7,
      X1	>= 0,
	     X2 >= 0
  },
  attach_name( X1, x1),
  attach_name( X2, x2),
  Obj =  4*X1 + 5*X2.

%
% s22738, pp.303
%
example( 2, Obj, Vs, [X1,X2], []) :-
  Vs = [X1,X2,X3],
  {
    3*X1 + 7*X2 + 3*X3 =< 14,
    9*X1 + 5*X2 + 3*X3 =< 37,
    X1 >= 0,
    X2 >= 0,
    X3 >= 0
  },
  attach_name( X1, x1),
  attach_name( X2, x2),
  attach_name( X3, x3),
  Obj = 32*X1 - 21*X2 + 12*X3.

%
% translated examples from miplib
%

%
% example( Name, Obj, Opt, Allvars, Integer, Bool)
%

%
  % imin( [Stm2, Stm5, Anm1, Anm4, Stm4, Anm3, Anm6, Stm3, Stm6, Anm2, Anm5], Obj).
  %
  % same integerization ordering as in lp_solve
  %
  % imin( [Stm6, Stm5, Stm4, Stm3, Stm2, Anm6, Anm5, Anm4, Anm3, Anm2, Anm1], Obj).
%
example( flugpl, Obj, Vs, Ints, []) :-

  Vs = [ Anm1,Anm2,Anm3,Anm4,Anm5,Anm6,
	 Stm1,Stm2,Stm3,Stm4,Stm5,Stm6,
	 UE1,UE2,UE3,UE4,UE5,UE6
       ],

  Ints = [Stm6, Stm5, Stm4, Stm3, Stm2, Anm6, Anm5, Anm4, Anm3, Anm2, Anm1],

  Obj =   +2700*Stm1 +1500*Anm1 +30*UE1
	  +2700*Stm2 +1500*Anm2 +30*UE2
	  +2700*Stm3 +1500*Anm3 +30*UE3
	  +2700*Stm4 +1500*Anm4 +30*UE4
	  +2700*Stm5 +1500*Anm5 +30*UE5
	  +2700*Stm6 +1500*Anm6 +30*UE6,

  attach_name( Stm2, stm2),
  attach_name( Stm5, stm5),
  attach_name( Anm1, anm1),
  attach_name( Anm4, anm4),
  attach_name( Stm4, stm4),
  attach_name( Anm3, anm3),
  attach_name( Anm6, anm6),
  attach_name( Stm3, stm3),
  attach_name( Stm6, stm6),
  attach_name( Anm2, anm2),
  attach_name( Anm5, anm5),

  allpos( Vs),
  {
   +1*Stm1  = 60,
   +0.9*Stm1 +1*Anm1 -1*Stm2  = 0,
   +0.9*Stm2 +1*Anm2 -1*Stm3  = 0,
   +0.9*Stm3 +1*Anm3 -1*Stm4  = 0,
   +0.9*Stm4 +1*Anm4 -1*Stm5  = 0,
   +0.9*Stm5 +1*Anm5 -1*Stm6  = 0,
   +150*Stm1 -100*Anm1 +1*UE1 >= 8000,
   +150*Stm2 -100*Anm2 +1*UE2 >= 9000,
   +150*Stm3 -100*Anm3 +1*UE3 >= 8000,
   +150*Stm4 -100*Anm4 +1*UE4 >= 10000,
   +150*Stm5 -100*Anm5 +1*UE5 >= 9000,
   +150*Stm6 -100*Anm6 +1*UE6 >= 12000,
   -20*Stm1 +1*UE1 =< 0,
   -20*Stm2 +1*UE2 =< 0,
   -20*Stm3 +1*UE3 =< 0,
   -20*Stm4 +1*UE4 =< 0,
   -20*Stm5 +1*UE5 =< 0,
   -20*Stm6 +1*UE6 =< 0,
     Anm1 =< 18,
     57 =< Stm2,
     Stm2 =< 75,
     Anm2 =< 18,
     57 =< Stm3,
     Stm3 =< 75,
     Anm3 =< 18,
     57 =< Stm4,
     Stm4 =< 75,
     Anm4 =< 18,
     57 =< Stm5,
     Stm5 =< 75,
     Anm5 =< 18,
     57 =< Stm6,
     Stm6 =< 75,
     Anm6 =< 18
  }.

%
% Do not edit this file! It was produced automatically by mps2prolog.
%
% NAME: 	flugpl
% ROWS: 	18
% COLUMNS:	18
% INTEGER:	11
% NONZERO:	46
% BEST SOLN:	1201500 (opt)
% LP SOLN:	1167185.73
% SOURCE:	Harvey M. Wagner
%		John W. Gregory (Cray Research)
%		E. Andrew Boyd (Rice University)
% APPLICATION:	airline model
% COMMENTS:	no integer variables are binary
%
%
%
example( flugplan, Min, Vs, Ints, Bins) :-
  Vs = [X1, X10, X11, X12, X13, X14, X15, X16, X17, X18, X2, X3, X4,
  X5, X6, X7, X8, X9],
  Ints = [X10, X11, X13, X14, X16, X17, X2, X4, X5, X7, X8],
  Bins = [],
  Min =  +2700*X1 +1500*X2 +30*X3 +2700*X4 +1500*X5 +30*X6 +2700*X7
  +1500*X8 +30*X9 +2700*X10 +1500*X11 +30*X12 +2700*X13 +1500*X14
  +30*X15 +2700*X16 +1500*X17 +30*X18,
  {
     0 =< X1,
     57 =< X10, X10 =< 75,
     0 =< X11, X11 =< 18,
     0 =< X12,
     57 =< X13, X13 =< 75,
     0 =< X14, X14 =< 18,
     0 =< X15,
     57 =< X16, X16 =< 75,
     0 =< X17, X17 =< 18,
     0 =< X18,
     0 =< X2, X2 =< 18,
     0 =< X3,
     57 =< X4, X4 =< 75,
     0 =< X5, X5 =< 18,
     0 =< X6,
     57 =< X7, X7 =< 75,
     0 =< X8, X8 =< 18,
     0 =< X9,
      -20*X1 +X3 =< 0,
      -20*X10 +X12 =< 0,
      +0.9*X4 +X5 -X7 = 0,
      +150*X1 -100*X2 +X3 >= 8000,
      +0.9*X13 +X14 -X16 = 0,
      +150*X10 -100*X11 +X12 >= 10000,
      -20*X7 +X9 =< 0,
      +0.9*X1 +X2 -X4 = 0,
      -20*X16 +X18 =< 0,
      +0.9*X10 +X11 -X13 = 0,
      +150*X7 -100*X8 +X9 >= 8000,
      +150*X16 -100*X17 +X18 >= 12000,
      -20*X4 +X6 =< 0,
      +X1 = 60,
      -20*X13 +X15 =< 0,
      +0.9*X7 +X8 -X10 = 0,
      +150*X4 -100*X5 +X6 >= 9000,
      +150*X13 -100*X14 +X15 >= 9000
  },
  attach_name(X2,'ANM1'),
  attach_name(X5,'ANM2'),
  attach_name(X8,'ANM3'),
  attach_name(X11,'ANM4'),
  attach_name(X14,'ANM5'),
  attach_name(X17,'ANM6'),
  attach_name(X1,'STM1'),
  attach_name(X4,'STM2'),
  attach_name(X7,'STM3'),
  attach_name(X10,'STM4'),
  attach_name(X13,'STM5'),
  attach_name(X16,'STM6'),
  attach_name(X3,'UE1'),
  attach_name(X6,'UE2'),
  attach_name(X9,'UE3'),
  attach_name(X12,'UE4'),
  attach_name(X15,'UE5'),
  attach_name(X18,'UE6'),
  true.


%
% Do not edit this file! It was produced automatically by mps2prolog.
%
% NAME: 	stein15
% ROWS: 	36
% COLUMNS:	15
% INTEGER:	15
% NONZERO:	120
% BEST SOLN:	9 (opt)
% LP SOLN:	7.0
% SOURCE:	George L. Nemhauser (Georgia Institute of Technology)
%		John W. Gregory (Cray Research)
%		E. Andrew Boyd (Rice University)
% APPLICATION:	unknown
% COMMENTS:	pure 0/1 IP
%
% lp_solve Integerization strategy:
%   v0009, v0008, v0015, v0007, v0014, v0006, v0013, v0005, v0012,
%   v0004, v0011, v0003, v0010, v0002, v0001
%
%
example( stein15, Min, Vs, Ints, Bins) :-
  Vs = [X1, X10, X11, X12, X13, X14, X15, X2, X3, X4, X5, X6, X7, X8,
  X9],
% Ints = [X1, X10, X11, X12, X13, X14, X15, X2, X3, X4, X5, X6, X7, X8, X9],
  Ints = [X9, X8, X15, X7, X14, X6, X13, X5, X12, X4, X11, X3, X10, X2, X1],
  Bins = [],
  Min =  +X1 +X2 +X3 +X4 +X5 +X6 +X7 +X8 +X9 +X10 +X11 +X12 +X13 +X14
  +X15,
  {
  0 =< X1, X1 =< 1,
  0 =< X10, X10 =< 1,
  0 =< X11, X11 =< 1,
  0 =< X12, X12 =< 1,
  0 =< X13, X13 =< 1,
  0 =< X14, X14 =< 1,
  0 =< X15, X15 =< 1,
  0 =< X2, X2 =< 1,
  0 =< X3, X3 =< 1,
  0 =< X4, X4 =< 1,
  0 =< X5, X5 =< 1,
  0 =< X6, X6 =< 1,
  0 =< X7, X7 =< 1,
  0 =< X8, X8 =< 1,
  0 =< X9, X9 =< 1,
   +X7 +X10 +X11 >= 1,
   +X1 +X12 +X15 >= 1,
   +X2 +X3 +X10 >= 1,
   +X6 +X8 +X12 >= 1,
   +X1 +X4 +X10 >= 1,
   +X2 +X11 +X13 >= 1,
   +X6 +X9 +X15 >= 1,
   +X1 +X2 +X3 +X4 +X5 +X6 +X7 +X8 +X9 +X10 +X11 +X12 +X13 +X14 +X15
  >= 7,
   +X5 +X11 +X14 >= 1,
   +X4 +X5 +X7 >= 1,
   +X7 +X9 +X13 >= 1,
   +X8 +X9 +X11 >= 1,
   +X1 +X3 +X7 >= 1,
   +X3 +X12 +X14 >= 1,
   +X1 +X13 +X14 >= 1,
   +X1 +X6 +X11 >= 1,
   +X8 +X10 +X14 >= 1,
   +X9 +X10 +X12 >= 1,
   +X4 +X13 +X15 >= 1,
   +X1 +X2 +X9 >= 1,
   +X2 +X14 +X15 >= 1,
   +X2 +X7 +X12 >= 1,
   +X3 +X5 +X9 >= 1,
   +X6 +X10 +X13 >= 1,
   +X3 +X11 +X15 >= 1,
   +X3 +X4 +X6 >= 1,
   +X3 +X8 +X13 >= 1,
   +X2 +X5 +X6 >= 1,
   +X6 +X7 +X14 >= 1,
   +X4 +X11 +X12 >= 1,
   +X4 +X9 +X14 >= 1,
   +X7 +X8 +X15 >= 1,
   +X1 +X5 +X8 >= 1,
   +X5 +X12 +X13 >= 1,
   +X2 +X4 +X8 >= 1,
   +X5 +X10 +X15 >= 1
  },
  attach_name(X1,'0001'),
  attach_name(X2,'0002'),
  attach_name(X3,'0003'),
  attach_name(X4,'0004'),
  attach_name(X5,'0005'),
  attach_name(X6,'0006'),
  attach_name(X7,'0007'),
  attach_name(X8,'0008'),
  attach_name(X9,'0009'),
  attach_name(X10,'0010'),
  attach_name(X11,'0011'),
  attach_name(X12,'0012'),
  attach_name(X13,'0013'),
  attach_name(X14,'0014'),
  attach_name(X15,'0015'),
  true.

%
% Do not edit this file! It was produced automatically by mps2prolog.
%
% NAME: 	sample2
% ROWS: 	45
% COLUMNS:	67
% INTEGER:	21
% NONZERO:	146
% BEST SOLN:	375 (opt)
% LP SOLN:	247.0
% SOURCE:
%		Laurence A. Wolsey (University of Louvain)
%		Martin W. P. Savelsbergh (Eindhoven Univ. of Technology)
% APPLICATION:	unknown
% COMMENTS:	all integer variables are binary
%
%
% lp_solve Integerization strategy:
%    I.W03W03, I.W02W02, I.W01W01, I.D04C03, I.D04C02, I.D04C01, I.D03D03,
%    I.D03C03, I.D03C02, I.D03C01, I.D02D02, I.D02C03, I.D02C02, I.D02C01,
%    I.D01D01, I.D01C03, I.D01C02, I.D01C01, I....F03, I....F02, I....F01
%
%
example( sample2, Min, Vs, Ints, Bins) :-
  Vs = [X1, X10, X11, X12, X13, X14, X15, X16, X17, X18, X19, X2, X20,
  X21, X22, X23, X24, X25, X26, X27, X28, X29, X3, X30, X31, X32, X33,
  X34, X35, X36, X37, X38, X39, X4, X40, X41, X42, X43, X44, X45, X46,
  X47, X48, X49, X5, X50, X51, X52, X53, X54, X55, X56, X57, X58, X59,
  X6, X60, X61, X62, X63, X64, X65, X66, X67, X7, X8, X9],
  Ints = [X6, X5, X4, X21, X20, X19, X9, X18, X17, X16, X8, X15, X14, X13, X7,
	  X12, X11, X10, X3, X2, X1],
  Bins = [],
  Min =  +100*X1 +100*X2 +100*X3 +60*X4 +60*X5 +60*X6 +40*X7 +40*X8
  +40*X9 +X25 +2*X26 +X29 +2*X30 +2*X31 +X33 +2*X38 +4*X39 +6*X40
  +6*X41 +2*X43 +4*X44 +4*X45 +6*X46 +2*X48 +X53 +3*X55 +X56 +3*X57
  +3*X59 +X61 +3*X62 +3*X63 +3*X64,
  {
  X66 = 15,
  X67 = 15,
  X65 = 15,
  0 =< X1, X1 =< 1,
  0 =< X10, X10 =< 1,
  0 =< X11, X11 =< 1,
  0 =< X12, X12 =< 1,
  0 =< X13, X13 =< 1,
  0 =< X14, X14 =< 1,
  0 =< X15, X15 =< 1,
  0 =< X16, X16 =< 1,
  0 =< X17, X17 =< 1,
  0 =< X18, X18 =< 1,
  0 =< X19, X19 =< 1,
  0 =< X2, X2 =< 1,
  0 =< X20, X20 =< 1,
  0 =< X21, X21 =< 1,
  0 =< X22,
  0 =< X23,
  0 =< X24,
  0 =< X25,
  0 =< X26,
  0 =< X27,
  0 =< X28,
  0 =< X29,
  0 =< X3, X3 =< 1,
  0 =< X30,
  0 =< X31,
  0 =< X32,
  0 =< X33,
  0 =< X34,
  0 =< X35,
  0 =< X36,
  0 =< X37,
  0 =< X38,
  0 =< X39,
  0 =< X4, X4 =< 1,
  0 =< X40,
  0 =< X41,
  0 =< X42,
  0 =< X43,
  0 =< X44,
  0 =< X45,
  0 =< X46,
  0 =< X47,
  0 =< X48,
  0 =< X49,
  0 =< X5, X5 =< 1,
  0 =< X50,
  0 =< X51,
  0 =< X52, X52 =< 25,
  0 =< X53,
  0 =< X54,
  0 =< X55,
  0 =< X56,
  0 =< X57,
  0 =< X58,
  0 =< X59,
  0 =< X6, X6 =< 1,
  0 =< X60,
  0 =< X61,
  0 =< X62,
  0 =< X63,
  0 =< X64,
  0 =< X65,
  0 =< X66,
  0 =< X67,
  0 =< X7, X7 =< 1,
  0 =< X8, X8 =< 1,
  0 =< X9, X9 =< 1,
   -X51 +X59 +X60 +X61 = 0,
   -45*X16 +X59 =< 0,
   -45*X14 +X57 =< 0,
   -45*X12 +X55 =< 0,
   -45*X6 +X36 =< 0,
   -X53 -X56 -X59 -X62 +X65 = 0,
   -X37 -X41 -X45 +X49 = 0,
   -X49 +X53 +X54 +X55 = 0,
   +X22 +X23 +X24 -X65 -X66 -X67 = 0,
   -45*X13 +X56 =< 0,
   -45*X11 +X54 =< 0,
   +X11 +X14 +X17 +X20 =< 1,
   -25*X8 +X50 =< 0,
   -X26 -X29 -X32 +X35 = 0,
   -X23 +X28 +X29 +X30 = 0,
   -X35 +X41 +X42 +X43 +X44 = 0,
   -X40 -X44 -X48 +X52 = 0,
   -45*X10 +X53 =< 0,
   -45*X3 +X24 =< 0,
   -X54 -X57 -X60 -X63 +X66 = 0,
   -X52 +X62 +X63 +X64 = 0,
   -45*X5 +X35 =< 0,
   +X10 +X13 +X16 +X19 =< 1,
   -X38 -X42 -X46 +X50 = 0,
   -45*X2 +X23 =< 0,
   -25*X7 +X49 =< 0,
   -X24 +X31 +X32 +X33 = 0,
   -X50 +X56 +X57 +X58 = 0,
   -45*X21 +X64 =< 0,
   -X27 -X30 -X33 +X36 = 0,
   -X55 -X58 -X61 -X64 +X67 = 0,
   -45*X1 +X22 =< 0,
   -X36 +X45 +X46 +X47 +X48 = 0,
   -45*X4 +X34 =< 0,
   -45*X18 +X61 =< 0,
   -45*X20 +X63 =< 0,
   -X25 -X28 -X31 +X34 = 0,
   -X34 +X37 +X38 +X39 +X40 = 0,
   -25*X9 +X51 =< 0,
   -45*X15 +X58 =< 0,
   -45*X17 +X60 =< 0,
   -45*X19 +X62 =< 0,
   -X39 -X43 -X47 +X51 = 0,
   +X12 +X15 +X18 +X21 =< 1,
   -X22 +X25 +X26 +X27 = 0
  },
  attach_name(X22,'F....F01'),
  attach_name(X23,'F....F02'),
  attach_name(X24,'F....F03'),
  attach_name(X65,'F.C01...'),
  attach_name(X66,'F.C02...'),
  attach_name(X67,'F.C03...'),
  attach_name(X53,'F.D01C01'),
  attach_name(X54,'F.D01C02'),
  attach_name(X55,'F.D01C03'),
  attach_name(X49,'F.D01D01'),
  attach_name(X56,'F.D02C01'),
  attach_name(X57,'F.D02C02'),
  attach_name(X58,'F.D02C03'),
  attach_name(X50,'F.D02D02'),
  attach_name(X59,'F.D03C01'),
  attach_name(X60,'F.D03C02'),
  attach_name(X61,'F.D03C03'),
  attach_name(X51,'F.D03D03'),
  attach_name(X62,'F.D04C01'),
  attach_name(X63,'F.D04C02'),
  attach_name(X64,'F.D04C03'),
  attach_name(X52,'F.D04D04'),
  attach_name(X25,'F.F01W01'),
  attach_name(X26,'F.F01W02'),
  attach_name(X27,'F.F01W03'),
  attach_name(X28,'F.F02W01'),
  attach_name(X29,'F.F02W02'),
  attach_name(X30,'F.F02W03'),
  attach_name(X31,'F.F03W01'),
  attach_name(X32,'F.F03W02'),
  attach_name(X33,'F.F03W03'),
  attach_name(X37,'F.W01D01'),
  attach_name(X38,'F.W01D02'),
  attach_name(X39,'F.W01D03'),
  attach_name(X40,'F.W01D04'),
  attach_name(X34,'F.W01W01'),
  attach_name(X41,'F.W02D01'),
  attach_name(X42,'F.W02D02'),
  attach_name(X43,'F.W02D03'),
  attach_name(X44,'F.W02D04'),
  attach_name(X35,'F.W02W02'),
  attach_name(X45,'F.W03D01'),
  attach_name(X46,'F.W03D02'),
  attach_name(X47,'F.W03D03'),
  attach_name(X48,'F.W03D04'),
  attach_name(X36,'F.W03W03'),
  attach_name(X1,'I....F01'),
  attach_name(X2,'I....F02'),
  attach_name(X3,'I....F03'),
  attach_name(X10,'I.D01C01'),
  attach_name(X11,'I.D01C02'),
  attach_name(X12,'I.D01C03'),
  attach_name(X7,'I.D01D01'),
  attach_name(X13,'I.D02C01'),
  attach_name(X14,'I.D02C02'),
  attach_name(X15,'I.D02C03'),
  attach_name(X8,'I.D02D02'),
  attach_name(X16,'I.D03C01'),
  attach_name(X17,'I.D03C02'),
  attach_name(X18,'I.D03C03'),
  attach_name(X9,'I.D03D03'),
  attach_name(X19,'I.D04C01'),
  attach_name(X20,'I.D04C02'),
  attach_name(X21,'I.D04C03'),
  attach_name(X4,'I.W01W01'),
  attach_name(X5,'I.W02W02'),
  attach_name(X6,'I.W03W03'),
  true.


%
% Do not edit this file! It was produced automatically by mps2prolog.
%
% NAME: 	noswot
% ROWS: 	182
% COLUMNS:	128
% INTEGER:	100
% NONZERO:	735
% BEST SOLN:	-43 (opt)
% LP SOLN:	-43.0
% SOURCE:
%		Linus E. Schrage (U. Chicago)
%		John W. Gregory (Cray Research)
% APPLICATION:	unknown
% COMMENTS:	75 of the integer variables are binary
%		problem originally formulated as a max - changed to min
%
% lp_solve Integerization strategy:
%      T455, T454, T453, T452, T451, T355, T354, T353, T345, T352, T344, T351,
%      T343, T255, T342, T254, T341, T253, T245, T252, T244, T251, T243, T235,
%      T155, T242, T234, T154, T241, T233, T153, T145, T232, T152, T144, T231,
%      T151, T143, T135, T142, T134, T141, T133, T125, T132, T124, T131, T123,
%      T122, T121, X55, X54, X53, X45, X52, X44, X51, X43, X35, W55, X42, X34,
%      W54, X41, X33, X25, W53, W45, X32, X24, W52, W44, X31, X23, X15, W51,
%      W43, W35, X22, X14, W42, W34, X21, X13, W41, W33, W25, X12, W32, W24,
%      X11, W31, W23, W15, W22, W14, W21, W13, W12, W11
%
example( noswot, Min, Vs, Ints, Bins) :-
  Vs = [X1, X10, X100, X101, X102, X103, X104, X105, X106, X107, X108,
  X109, X11, X110, X111, X112, X113, X114, X115, X116, X117, X118,
  X119, X12, X120, X121, X122, X123, X124, X125, X126, X127, X128,
  X13, X14, X15, X16, X17, X18, X19, X2, X20, X21, X22, X23, X24, X25,
  X26, X27, X28, X29, X3, X30, X31, X32, X33, X34, X35, X36, X37, X38,
  X39, X4, X40, X41, X42, X43, X44, X45, X46, X47, X48, X49, X5, X50,
  X51, X52, X53, X54, X55, X56, X57, X58, X59, X6, X60, X61, X62, X63,
  X64, X65, X66, X67, X68, X69, X7, X70, X71, X72, X73, X74, X75, X76,
  X77, X78, X79, X8, X80, X81, X82, X83, X84, X85, X86, X87, X88, X89,
  X9, X90, X91, X92, X93, X94, X95, X96, X97, X98, X99],
/*
  Ints = [X1, X10, X100, X11, X12, X13, X14, X15, X16, X17, X18, X19,
  X2, X20, X21, X22, X23, X24, X25, X26, X27, X28, X29, X3, X30, X31,
  X32, X33, X34, X35, X36, X37, X38, X39, X4, X40, X41, X42, X43, X44,
  X45, X46, X47, X48, X49, X5, X50, X51, X52, X53, X54, X55, X56, X57,
  X58, X59, X6, X60, X61, X62, X63, X64, X65, X66, X67, X68, X69, X7,
  X70, X71, X72, X73, X74, X75, X76, X77, X78, X79, X8, X80, X81, X82,
  X83, X84, X85, X86, X87, X88, X89, X9, X90, X91, X92, X93, X94, X95,
  X96, X97, X98, X99],
*/
  Ints = [X50, X49, X48, X47, X46, X45, X44, X86, X40, X84, X39, X82,
	  X38, X80, X37, X78, X36, X33, X30, X32, X29, X31, X28, X25,
	  X20, X27, X24, X19, X26, X23, X18, X60, X64, X17, X14, X62,
	  X16, X13, X10, X12, X9, X94, X8, X5, X7, X4, X6, X3,
	  X2, X1, X100, X98, X96, X90, X94, X88, X92, X86, X80, X99, X84, X78,
	  X97, X82, X76, X70, X95, X89, X74, X68, X93, X87, X72, X66, X60, X91,
	  X85, X79, X64, X58, X83, X77, X62, X56, X81, X75, X69, X98, X73, X67,
	  X94, X71, X65, X59, X63, X57, X61, X55, X53, X51
	 ],
  Bins = [],
  Min =  -X52 -X54 -X56 -X58 -X60 -X62 -X64 -X66 -X68 -X70 -X72 -X74 -
  X76 -X78 -X80 -X82 -X84 -X86 -X88 -X90 -X92 -X94 -X96 -X98 -X100,
 {
  0 =< X1, X1 =< 1,
  0 =< X10, X10 =< 1,
  0 =< X100, X100 =< 100000,
  0 =< X101,
  0 =< X102,
  0 =< X103,
  0 =< X104,
  0 =< X105,
  0 =< X106,
  0 =< X107,
  0 =< X108,
  0 =< X109,
  0 =< X11, X11 =< 1,
  0 =< X110,
  0 =< X111,
  0 =< X112,
  0 =< X113,
  0 =< X114,
  0 =< X115,
  0 =< X116,
  0 =< X117,
  0 =< X118,
  0 =< X119,
  0 =< X12, X12 =< 1,
  0 =< X120,
  0 =< X121,
  0 =< X122,
  0 =< X123,
  0 =< X124,
  0 =< X125,
  0 =< X126,
  0 =< X127,
  0 =< X128,
  0 =< X13, X13 =< 1,
  0 =< X14, X14 =< 1,
  0 =< X15, X15 =< 1,
  0 =< X16, X16 =< 1,
  0 =< X17, X17 =< 1,
  0 =< X18, X18 =< 1,
  0 =< X19, X19 =< 1,
  0 =< X2, X2 =< 1,
  0 =< X20, X20 =< 1,
  0 =< X21, X21 =< 1,
  0 =< X22, X22 =< 1,
  0 =< X23, X23 =< 1,
  0 =< X24, X24 =< 1,
  0 =< X25, X25 =< 1,
  0 =< X26, X26 =< 1,
  0 =< X27, X27 =< 1,
  0 =< X28, X28 =< 1,
  0 =< X29, X29 =< 1,
  0 =< X3, X3 =< 1,
  0 =< X30, X30 =< 1,
  0 =< X31, X31 =< 1,
  0 =< X32, X32 =< 1,
  0 =< X33, X33 =< 1,
  0 =< X34, X34 =< 1,
  0 =< X35, X35 =< 1,
  0 =< X36, X36 =< 1,
  0 =< X37, X37 =< 1,
  0 =< X38, X38 =< 1,
  0 =< X39, X39 =< 1,
  0 =< X4, X4 =< 1,
  0 =< X40, X40 =< 1,
  0 =< X41, X41 =< 1,
  0 =< X42, X42 =< 1,
  0 =< X43, X43 =< 1,
  0 =< X44, X44 =< 1,
  0 =< X45, X45 =< 1,
  0 =< X46, X46 =< 1,
  0 =< X47, X47 =< 1,
  0 =< X48, X48 =< 1,
  0 =< X49, X49 =< 1,
  0 =< X5, X5 =< 1,
  0 =< X50, X50 =< 1,
  0 =< X51, X51 =< 1,
  0 =< X52, X52 =< 100000,
  0 =< X53, X53 =< 1,
  0 =< X54, X54 =< 100000,
  0 =< X55, X55 =< 1,
  0 =< X56, X56 =< 100000,
  0 =< X57, X57 =< 1,
  0 =< X58, X58 =< 100000,
  0 =< X59, X59 =< 1,
  0 =< X6, X6 =< 1,
  0 =< X60, X60 =< 100000,
  0 =< X61, X61 =< 1,
  0 =< X62, X62 =< 100000,
  0 =< X63, X63 =< 1,
  0 =< X64, X64 =< 100000,
  0 =< X65, X65 =< 1,
  0 =< X66, X66 =< 100000,
  0 =< X67, X67 =< 1,
  0 =< X68, X68 =< 100000,
  0 =< X69, X69 =< 1,
  0 =< X7, X7 =< 1,
  0 =< X70, X70 =< 100000,
  0 =< X71, X71 =< 1,
  0 =< X72, X72 =< 100000,
  0 =< X73, X73 =< 1,
  0 =< X74, X74 =< 100000,
  0 =< X75, X75 =< 1,
  0 =< X76, X76 =< 100000,
  0 =< X77, X77 =< 1,
  0 =< X78, X78 =< 100000,
  0 =< X79, X79 =< 1,
  0 =< X8, X8 =< 1,
  0 =< X80, X80 =< 100000,
  0 =< X81, X81 =< 1,
  0 =< X82, X82 =< 100000,
  0 =< X83, X83 =< 1,
  0 =< X84, X84 =< 100000,
  0 =< X85, X85 =< 1,
  0 =< X86, X86 =< 100000,
  0 =< X87, X87 =< 1,
  0 =< X88, X88 =< 100000,
  0 =< X89, X89 =< 1,
  0 =< X9, X9 =< 1,
  0 =< X90, X90 =< 100000,
  0 =< X91, X91 =< 1,
  0 =< X92, X92 =< 100000,
  0 =< X93, X93 =< 1,
  0 =< X94, X94 =< 100000,
  0 =< X95, X95 =< 1,
  0 =< X96, X96 =< 100000,
  0 =< X97, X97 =< 1,
  0 =< X98, X98 =< 100000,
  0 =< X99, X99 =< 1,
   -20*X75 +3.4721999*X76 +X113 =< 0,
   -21*X50 -0.25*X89 -2.2400999*X90 -X120 +X125 >= -21,
   -21*X40 -0.666700006*X79 -3.4721999*X80 -X115 +X120 >= -21,
   -X55 +X56 >= 0,
   -X81 +X82 >= 0,
   -21*X29 -0.666700006*X67 -2.9762001*X68 -X109 +X119 >= -21,
   +21*X26 -0.75*X81 -2.2400999*X82 +X106 -X116 >= 0,
   -21*X22 -0.666700006*X63 -2.9762001*X64 -X107 +X112 >= -21,
   -X71 +X72 >= 0,
   -16*X59 +2.0833001*X60 +X105 =< 0,
   -21*X39 -0.666700006*X77 -3.4721999*X78 -X114 +X119 >= -21,
   -8.9280005*X83 +X84 +X126 = 0,
   +21*X17 -0.666700006*X93 -2.0833001*X94 +X102 -X122 >= 0,
   -21*X13 -0.25*X55 -2.0833001*X56 -X103 +X118 >= -21,
   +21*X10 -0.666700006*X79 -3.4721999*X80 +X105 -X115 >= 0,
   -21*X6 -0.666700006*X51 -2.0833001*X52 -X101 +X111 >= -21,
   +X82 +X84 +X86 +X88 +X90 =< 1,
   -20*X77 +3.4721999*X78 +X114 =< 0,
   +21*X41 -0.666700006*X91 -2.0833001*X92 +X111 -X121 >= 0,
   -8.9280005*X81 +X82 +X127 = 0,
   -20*X95 +2.0833001*X96 +X123 =< 0,
   -5.7600002*X71 +X72 =< 0,
   -6.7199998*X63 +X64 =< 0,
   -21*X24 -0.666700006*X67 -2.9762001*X68 -X109 +X114 >= -21,
   +21*X21 -0.75*X71 -3.4721999*X72 +X106 -X111 >= 0,
   +21*X40 -0.666700006*X89 -2.2400999*X90 +X115 -X120 >= 0,
   -X85 +X86 >= 0,
   +X52 +X54 +X56 +X58 +X60 +X62 +X64 +X66 +X68 +X70 +X72 +X74 +X76
  +X78 +X80 +X82 +X84 +X86 +X88 +X90 +X92 +X94 +X96 +X98 +X100 =< 43,
   -20*X91 +2.0833001*X92 +X121 =< 0,
   -21*X41 -0.666700006*X71 -3.4721999*X72 -X111 +X121 >= -21,
   +21*X12 -0.25*X83 -2.2400999*X84 +X102 -X117 >= 0,
   -21*X1 -0.75*X51 -2.0833001*X52 -X101 +X106 >= -21,
   +21*X5 -0.666700006*X69 -2.9762001*X70 +X105 -X110 >= 0,
   -21*X8 -0.666700006*X55 -2.0833001*X56 -X103 +X113 >= -21,
   +21*X33 -0.75*X95 -2.0833001*X96 +X108 -X123 >= 0,
   -X83 +X84 >= 0,
   -20*X97 +2.0833001*X98 +X124 =< 0,
   -X73 +X74 >= 0,
   -8.9280005*X85 +X86 +2*X128 =< 0,
   -6.7199998*X67 +X68 =< 0,
   -X61 +X62 >= 0,
   -21*X20 -0.25*X59 -2.0833001*X60 -X105 +X125 >= -21,
   -20*X93 +2.0833001*X94 +X122 =< 0,
   +21*X42 -0.666700006*X93 -2.0833001*X94 +X112 -X122 >= 0,
   -X59 +X60 >= 0,
   -21*X3 -0.75*X55 -2.0833001*X56 -X103 +X108 >= -21,
   +21*X7 -0.666700006*X73 -3.4721999*X74 +X102 -X112 >= 0,
   -16*X99 +2.0833001*X100 +X125 =< 0,
   -5.7600002*X73 +X74 =< 0,
   -21*X31 -0.666700006*X61 -2.9762001*X62 -X106 +X121 >= -21,
   +21*X28 -0.75*X85 -2.2400999*X86 +X108 -X118 >= 0,
   -X87 +X88 >= 0,
   -20*X65 +2.9762001*X66 +X108 =< 0,
   -20*X55 +2.0833001*X56 +X103 =< 0,
   -21*X15 -0.25*X59 -2.0833001*X60 -X105 +X120 >= -21,
   +21*X19 -0.666700006*X97 -2.0833001*X98 +X104 -X124 >= 0,
   -21*X42 -0.666700006*X73 -3.4721999*X74 -X112 +X122 >= -21,
   -X91 +X92 >= 0,
   -X75 +X76 >= 0,
   -9.6000004*X55 +X56 =< 0,
   +21*X2 -0.666700006*X63 -2.9762001*X64 +X102 -X107 >= 0,
   +21*X30 -0.75*X89 -2.2400999*X90 +X110 -X120 >= 0,
   +21*X23 -0.75*X75 -3.4721999*X76 +X108 -X113 >= 0,
   -21*X26 -0.666700006*X61 -2.9762001*X62 -X106 +X116 >= -21,
   -8.9280005*X87 +X88 +3*X128 =< 0,
   +21*X43 -0.666700006*X95 -2.0833001*X96 +X113 -X123 >= 0,
   -21*X10 -0.666700006*X59 -2.0833001*X60 -X105 +X115 >= -21,
   +21*X14 -0.25*X87 -2.2400999*X88 +X104 -X119 >= 0,
   -21*X17 -0.25*X53 -2.0833001*X54 -X102 +X122 >= -21,
   -9.6000004*X91 +X92 =< 0,
   -5.7600002*X75 +X76 =< 0,
   -X89 +X90 >= 0,
   -X53 +X54 >= 0,
   -X65 +X66 >= 0,
   -21*X21 -0.666700006*X61 -2.9762001*X62 -X106 +X111 >= -21,
   +21*X25 -0.75*X79 -3.4721999*X80 +X110 -X115 >= 0,
   -X51 +X52 >= 0,
   -21*X43 -0.666700006*X75 -3.4721999*X76 -X113 +X123 >= -21,
   +21*X34 -0.75*X97 -2.0833001*X98 +X109 -X124 >= 0,
   -X93 +X94 >= 0,
   -X77 +X78 >= 0,
   +21*X9 -0.666700006*X77 -3.4721999*X78 +X104 -X114 >= 0,
   -21*X5 -0.75*X59 -2.0833001*X60 -X105 +X110 >= -21,
   -21*X12 -0.25*X53 -2.0833001*X54 -X102 +X117 >= -21,
   -21*X33 -0.666700006*X65 -2.9762001*X66 -X108 +X123 >= -21,
   -7.1423998*X89 +X90 +4*X128 =< 0,
   -4.6079998*X79 +X80 =< 0,
   -X69 +X70 >= 0,
   -6.7199998*X61 +X62 =< 0,
   +21*X44 -0.666700006*X97 -2.0833001*X98 +X114 -X124 >= 0,
   +X52 +X54 +X56 +X58 +X60 =< 38,
   -21*X34 -0.666700006*X67 -2.9762001*X68 -X109 +X124 >= -21,
   -20*X51 +2.0833001*X52 +X101 =< 0,
   -9.6000004*X93 +X94 =< 0,
   -5.7600002*X77 +X78 =< 0,
   -21*X45 -0.666700006*X79 -3.4721999*X80 -X115 +X125 >= -21,
   -7.6799998*X59 +X60 =< 0,
   +21*X4 -0.666700006*X67 -2.9762001*X68 +X104 -X109 >= 0,
   -21*X7 -0.666700006*X53 -2.0833001*X54 -X102 +X112 >= -21,
   -21*X28 -0.666700006*X65 -2.9762001*X66 -X108 +X118 >= -21,
   +21*X32 -0.75*X93 -2.0833001*X94 +X107 -X122 >= 0,
   +21*X46 -0.666700006*X91 -2.0833001*X92 +X116 -X121 >= 0,
   +21*X36 -0.666700006*X81 -2.2400999*X82 +X111 -X116 >= 0,
   -21*X44 -0.666700006*X77 -3.4721999*X78 -X114 +X124 >= -21,
   +21*X35 -0.75*X99 -2.0833001*X100 +X110 -X125 >= 0,
   -21*X47 -0.25*X83 -2.2400999*X84 -X117 +X122 >= -21,
   -20*X67 +2.9762001*X68 +X109 =< 0,
   +21*X16 -0.666700006*X91 -2.0833001*X92 +X101 -X121 >= 0,
   -21*X19 -0.25*X57 -2.0833001*X58 -X104 +X124 >= -21,
   -X95 +X96 >= 0,
   -X79 +X80 >= 0,
   +X72 +X74 +X76 +X78 +X80 =< 2,
   -21*X46 -0.25*X81 -2.2400999*X82 -X116 +X121 >= -21,
   -9.6000004*X97 +X98 =< 0,
   -X57 +X58 >= 0,
   -21*X2 -0.75*X53 -2.0833001*X54 -X102 +X107 >= -21,
   -21*X36 -0.666700006*X71 -3.4721999*X72 -X111 +X116 >= -21,
   -21*X23 -0.666700006*X65 -2.9762001*X66 -X108 +X113 >= -21,
   +21*X27 -0.75*X83 -2.2400999*X84 +X107 -X117 >= 0,
   -21*X30 -0.666700006*X69 -2.9762001*X70 -X110 +X120 >= -21,
   +21*X45 -0.666700006*X99 -2.0833001*X100 +X115 -X125 >= 0,
   -21*X35 -0.666700006*X69 -2.9762001*X70 -X110 +X125 >= -21,
   +21*X48 -0.666700006*X95 -2.0833001*X96 +X118 -X123 >= 0,
   -9.6000004*X95 +X96 =< 0,
   -20*X57 +2.0833001*X58 +X104 =< 0,
   -20*X81 +2.2400999*X82 +X116 =< 0,
   +21*X11 -0.25*X81 -2.2400999*X82 +X101 -X116 >= 0,
   -21*X14 -0.25*X57 -2.0833001*X58 -X104 +X119 >= -21,
   +21*X18 -0.666700006*X95 -2.0833001*X96 +X103 -X123 >= 0,
   +21*X47 -0.666700006*X93 -2.0833001*X94 +X117 -X122 >= 0,
   -X99 +X100 >= 0,
   +21*X37 -0.666700006*X83 -2.2400999*X84 +X112 -X117 >= 0,
   -9.6000004*X53 +X54 =< 0,
   -6.7199998*X65 +X66 =< 0,
   +X62 +X64 +X66 +X68 +X70 >= 5,
   +21*X22 -0.75*X73 -3.4721999*X74 +X107 -X112 >= 0,
   -21*X25 -0.666700006*X69 -2.9762001*X70 -X110 +X115 >= -21,
   +21*X29 -0.75*X87 -2.2400999*X88 +X109 -X119 >= 0,
   -21*X48 -0.25*X85 -2.2400999*X86 -X118 +X123 >= -21,
   -X97 +X98 >= 0,
   -20*X83 +2.2400999*X84 +X117 =< 0,
   +21*X13 -0.25*X85 -2.2400999*X86 +X103 -X118 >= 0,
   -21*X9 -0.666700006*X57 -2.0833001*X58 -X104 +X114 >= -21,
   +21*X6 -0.666700006*X71 -3.4721999*X72 +X101 -X111 >= 0,
   -7.6799998*X99 +X100 =< 0,
   -21*X37 -0.666700006*X73 -3.4721999*X74 -X112 +X117 >= -21,
   +X62 +X64 +X66 +X68 +X70 =< 9,
   +21*X49 -0.666700006*X97 -2.0833001*X98 +X119 -X124 >= 0,
   -5.3759999*X69 +X70 =< 0,
   -X63 +X64 >= 0,
   -20*X61 +2.9762001*X62 +X106 =< 0,
   +21*X24 -0.75*X77 -3.4721999*X78 +X109 -X114 >= 0,
   -20*X85 +2.2400999*X86 +X118 =< 0,
   -9.6000004*X51 +X52 =< 0,
   +X92 +X94 +X96 +X98 +X100 =< 2,
   +21*X38 -0.666700006*X85 -2.2400999*X86 +X113 -X118 >= 0,
   +21*X8 -0.666700006*X75 -3.4721999*X76 +X103 -X113 >= 0,
   -21*X4 -0.75*X57 -2.0833001*X58 -X104 +X109 >= -21,
   +21*X1 -0.666700006*X61 -2.9762001*X62 +X101 -X106 >= 0,
   -21*X32 -0.666700006*X63 -2.9762001*X64 -X107 +X122 >= -21,
   -20*X71 +3.4721999*X72 +X111 =< 0,
   -21*X49 -0.25*X87 -2.2400999*X88 -X119 +X124 >= -21,
   -20*X87 +2.2400999*X88 +X119 =< 0,
   -16*X69 +2.9762001*X70 +X110 =< 0,
   -X67 +X68 >= 0,
   +21*X20 -0.666700006*X99 -2.0833001*X100 +X105 -X125 >= 0,
   -21*X16 -0.25*X51 -2.0833001*X52 -X101 +X121 >= -21,
   -20*X53 +2.0833001*X54 +X102 =< 0,
   -21*X38 -0.666700006*X75 -3.4721999*X76 -X113 +X118 >= -21,
   -20*X73 +3.4721999*X74 +X112 =< 0,
   -9.6000004*X57 +X58 =< 0,
   +21*X3 -0.666700006*X65 -2.9762001*X66 +X103 -X108 >= 0,
   +21*X50 -0.666700006*X99 -2.0833001*X100 +X120 -X125 >= 0,
   -21*X27 -0.666700006*X63 -2.9762001*X64 -X107 +X117 >= -21,
   +21*X31 -0.75*X91 -2.0833001*X92 +X106 -X121 >= 0,
   -16*X89 +2.2400999*X90 +X120 =< 0,
   -16*X79 +3.4721999*X80 +X115 =< 0,
   -20*X63 +2.9762001*X64 +X107 =< 0,
   -21*X18 -0.25*X55 -2.0833001*X56 -X103 +X123 >= -21,
   +21*X15 -0.25*X89 -2.2400999*X90 +X105 -X120 >= 0,
   -21*X11 -0.25*X51 -2.0833001*X52 -X101 +X116 >= -21,
   +21*X39 -0.666700006*X87 -2.2400999*X88 +X114 -X119 >= 0
  },
  attach_name(X128,'Q246'),
  attach_name(X101,'S11'),
  attach_name(X102,'S12'),
  attach_name(X103,'S13'),
  attach_name(X104,'S14'),
  attach_name(X105,'S15'),
  attach_name(X106,'S21'),
  attach_name(X107,'S22'),
  attach_name(X108,'S23'),
  attach_name(X109,'S24'),
  attach_name(X110,'S25'),
  attach_name(X111,'S31'),
  attach_name(X112,'S32'),
  attach_name(X113,'S33'),
  attach_name(X114,'S34'),
  attach_name(X115,'S35'),
  attach_name(X116,'S41'),
  attach_name(X117,'S42'),
  attach_name(X118,'S43'),
  attach_name(X119,'S44'),
  attach_name(X120,'S45'),
  attach_name(X121,'S51'),
  attach_name(X122,'S52'),
  attach_name(X123,'S53'),
  attach_name(X124,'S54'),
  attach_name(X125,'S55'),
  attach_name(X1,'T121'),
  attach_name(X2,'T122'),
  attach_name(X3,'T123'),
  attach_name(X4,'T124'),
  attach_name(X5,'T125'),
  attach_name(X6,'T131'),
  attach_name(X7,'T132'),
  attach_name(X8,'T133'),
  attach_name(X9,'T134'),
  attach_name(X10,'T135'),
  attach_name(X11,'T141'),
  attach_name(X12,'T142'),
  attach_name(X13,'T143'),
  attach_name(X14,'T144'),
  attach_name(X15,'T145'),
  attach_name(X16,'T151'),
  attach_name(X17,'T152'),
  attach_name(X18,'T153'),
  attach_name(X19,'T154'),
  attach_name(X20,'T155'),
  attach_name(X21,'T231'),
  attach_name(X22,'T232'),
  attach_name(X23,'T233'),
  attach_name(X24,'T234'),
  attach_name(X25,'T235'),
  attach_name(X26,'T241'),
  attach_name(X27,'T242'),
  attach_name(X28,'T243'),
  attach_name(X29,'T244'),
  attach_name(X30,'T245'),
  attach_name(X31,'T251'),
  attach_name(X32,'T252'),
  attach_name(X33,'T253'),
  attach_name(X34,'T254'),
  attach_name(X35,'T255'),
  attach_name(X36,'T341'),
  attach_name(X37,'T342'),
  attach_name(X38,'T343'),
  attach_name(X39,'T344'),
  attach_name(X40,'T345'),
  attach_name(X41,'T351'),
  attach_name(X42,'T352'),
  attach_name(X43,'T353'),
  attach_name(X44,'T354'),
  attach_name(X45,'T355'),
  attach_name(X46,'T451'),
  attach_name(X47,'T452'),
  attach_name(X48,'T453'),
  attach_name(X49,'T454'),
  attach_name(X50,'T455'),
  attach_name(X127,'V148'),
  attach_name(X126,'V150'),
  attach_name(X51,'W11'),
  attach_name(X53,'W12'),
  attach_name(X55,'W13'),
  attach_name(X57,'W14'),
  attach_name(X59,'W15'),
  attach_name(X61,'W21'),
  attach_name(X63,'W22'),
  attach_name(X65,'W23'),
  attach_name(X67,'W24'),
  attach_name(X69,'W25'),
  attach_name(X71,'W31'),
  attach_name(X73,'W32'),
  attach_name(X75,'W33'),
  attach_name(X77,'W34'),
  attach_name(X79,'W35'),
  attach_name(X81,'W41'),
  attach_name(X83,'W42'),
  attach_name(X85,'W43'),
  attach_name(X87,'W44'),
  attach_name(X89,'W45'),
  attach_name(X91,'W51'),
  attach_name(X93,'W52'),
  attach_name(X95,'W53'),
  attach_name(X97,'W54'),
  attach_name(X99,'W55'),
  attach_name(X52,'X11'),
  attach_name(X54,'X12'),
  attach_name(X56,'X13'),
  attach_name(X58,'X14'),
  attach_name(X60,'X15'),
  attach_name(X62,'X21'),
  attach_name(X64,'X22'),
  attach_name(X66,'X23'),
  attach_name(X68,'X24'),
  attach_name(X70,'X25'),
  attach_name(X72,'X31'),
  attach_name(X74,'X32'),
  attach_name(X76,'X33'),
  attach_name(X78,'X34'),
  attach_name(X80,'X35'),
  attach_name(X82,'X41'),
  attach_name(X84,'X42'),
  attach_name(X86,'X43'),
  attach_name(X88,'X44'),
  attach_name(X90,'X45'),
  attach_name(X92,'X51'),
  attach_name(X94,'X52'),
  attach_name(X96,'X53'),
  attach_name(X98,'X54'),
  attach_name(X100,'X55'),
  true.

/*

lp_solve has problems with this one:

Error: rhsmincol called with rownr: 185, Rows: 182
This indicates numerical instability
If this happened with a small model, please send it to michel@es.ele.tue.nl
440.100u 0.390s 17:20.09 42.3% 0+401k 6+0io 8pf+0w

| ?- example(noswot).
incumbent(-37507399360171328215441611691007/956819227975228289496672500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84858086996886989418093669/956819227975228289496672500000,3,0,0,0,2,5,0,0,0,0,4,0,0,0,6,0,0,0,0,5892922503501787338/382727691190091315798669,1,0,0,1,1,0,1,0,1,1,1])
incumbent(-20679553649402263964041653892005232507098192277/527357499396939193162537760967541655971250000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84858086996886989418093669/956819227975228289496672500000,3,0,0,1,1,5,0,0,0,0,4,0,0,1,7,0,0,0,0,5892922503501787338/382727691190091315798669,1,0,1,1,1,0,1,1,1,1,1])
incumbent(-38464218588146556504938284191007/956819227975228289496672500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84858086996886989418093669/956819227975228289496672500000,5,0,0,0,0,5,0,0,0,0,2,0,0,0,9,0,0,0,0,5892922503501787338/382727691190091315798669,1,0,0,0,1,0,1,0,1,1,1])
incumbent(-21206911148799203157204191652972774163069442277/527357499396939193162537760967541655971250000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84858086996886989418093669/956819227975228289496672500000,4,0,0,1,0,5,0,0,0,0,3,0,0,1,9,0,0,0,0,5892922503501787338/382727691190091315798669,1,0,1,0,1,0,1,1,1,1,1])
incumbent(-782167041139900591606331/19290490762765827500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,2,0,5,0,0,0,0,4,0,0,2,9,0,0,0,0,0,1,0,1,0,1,0,1,1,1,1,1])
incumbent(-314807692893068268/7716196305106331,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,5,0,0,0,1,6,0,0,2,9,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1])
incumbent(-316644793474061606/7716196305106331,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,1,0,5,0,0,0,1,6,0,0,2,9,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1])
incumbent(-802375152901385609106331/19290490762765827500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1913565439163003113010581906331/956825148625000000000000000000,2,0,0,84858086996886989418093669/956825148625000000000000000000,0,5,0,0,0,3,6,0,0,0,9,0,0,0,0,1,1,0,2946461251750893669/191365029725000000000000,0,1,1,1,0,1,1,1])
incumbent(-810643034807633109106331/19290490762765827500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,1,0,5,0,0,0,0,6,0,0,2,9,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,1])
incumbent(-820748022665432246606331/19290490762765827500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,2,0,5,0,0,0,0,6,0,0,2,9,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,1])
incumbent(-821665643664151436606331/19290490762765827500000,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,0,0,0,0,5,0,0,0,3,6,0,0,0,9,0,0,1,0,1,1,0,0,0,1,1,1,0,1,1,1])
incumbent(-330607133902768606/7716196305106331,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,5,0,0,0,2,9,0,0,2,9,0,0,1,0,1,0,0,1,0,1,1,1,1,1,1,1])
incumbent(-43,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,382727112988748249106331/191365029725000000000000,0,0,0,2946461251750893669/191365029725000000000000,0,5,0,0,0,4,9,0,0,0,9,0,0,1,0,1,0,0,2946461251750893669/191365029725000000000000,0,1,1,1,0,1,1,1])
noswot:-43
%%% Timing 01:04:49.840  3889.840
*/


%
% Do not edit this file! It was produced automatically by mps2prolog.
%
% NAME: 	bell3a
% ROWS: 	123
% COLUMNS:	133
% INTEGER:	71
% NONZERO:	347
% BEST SOLN:	878430.32 (opt)
% LP SOLN:	862578.64
% SOURCE:	William Cook (Bellcore)
%		       William Cook (Bellcore)
%		William Cook (Bellcore)
% APPLICATION:	fiber optic network design
% COMMENTS:	39 of the integer variables are binary
%		hard problem
%		solved with new code based on Lovasz-Scarf basis reduction
%
% lp_solve Integerization strategy:
%    h17, h16, h15, g17, h21, h13, g16, h20, h12, g15, h10, g21, g13, g20,
%    g12, g10, d17, d16, d15, c19, c18, d21, d13, c17, d20, d12, c16, c23,
%    c15, d10, c22, c14, c21, c13, c20, c12, c11, c10, h9, g9, h7, h6, g7,
%    h5, g6, h4, g5, h3, g4, h2, g3, h1, d9, g2, g1, d7, c9, d6, c8, d5,
%    c7, d4, c6, d3, c5, d2, c4, d1, c3, c2, c1
%
example( bell3a, Min, Vs, Ints, Bins) :-
  Vs = [X1, X10, X100, X101, X102, X103, X104, X105, X106, X107, X108,
  X109, X11, X110, X111, X112, X113, X114, X115, X116, X117, X118,
  X119, X12, X120, X121, X122, X123, X124, X125, X126, X127, X128,
  X129, X13, X130, X131, X132, X133, X14, X15, X16, X17, X18, X19, X2,
  X20, X21, X22, X23, X24, X25, X26, X27, X28, X29, X3, X30, X31, X32,
  X33, X34, X35, X36, X37, X38, X39, X4, X40, X41, X42, X43, X44, X45,
  X46, X47, X48, X49, X5, X50, X51, X52, X53, X54, X55, X56, X57, X58,
  X59, X6, X60, X61, X62, X63, X64, X65, X66, X67, X68, X69, X7, X70,
  X71, X72, X73, X74, X75, X76, X77, X78, X79, X8, X80, X81, X82, X83,
  X84, X85, X86, X87, X88, X89, X9, X90, X91, X92, X93, X94, X95, X96,
  X97, X98, X99],
/**/
  Ints = [X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12, X13, X14,
  X15, X16, X17, X18, X19, X20, X21, X22, X23, X24, X25, X26, X27,
  X28, X29, X30, X31, X32, X33, X34, X35, X36, X37, X38, X39, X40,
  X41, X42, X43, X44, X45, X46, X47, X48, X49, X50, X51, X52, X53,
  X54, X55, X56, X57, X58, X59, X60, X61, X62, X63, X64, X65, X66,
  X67, X68, X69, X70, X71],
/**/
/*
%
% lp_solve Integerization strategy:
%
  Ints = [
   X53, X52, X51, X69, X55, X50, X68, X54, X49, X67, X48, X71, X66, X70,
   X65, X64, X37, X36, X35, X19, X18, X39, X34, X17, X38, X33, X16, X23,
   X15, X32, X22, X14, X21, X13, X20, X12, X11, X10, X47, X63, X46, X45, X62,
   X44, X61, X43, X60, X42, X59, X41, X58, X40, X31, X57, X56, X30, X9, X29, X8, X28,
   X7, X27, X6, X26, X5, X25, X4, X24, X3, X2, X1 ],
*/
  Bins = [],
  Min =  +43000*X24 +43000*X25 +43000*X26 +43000*X27 +43000*X28
  +43000*X29 +43000*X30 +43000*X31 +43000*X32 +43000*X33 +43000*X34
  +43000*X35 +43000*X36 +44000*X37 +43000*X38 +43000*X39 +58000*X40
  +58000*X41 +58000*X42 +58000*X43 +58000*X44 +58000*X45 +59000*X46
  +60000*X47 +59000*X48 +59000*X49 +59000*X50 +59000*X51 +59000*X52
  +60000*X53 +59000*X54 +59000*X55 +10000*X56 +10000*X57 +10000*X58
  +10000*X59 +10000*X60 +10000*X61 +10000*X62 +10000*X63 +10000*X64
  +10000*X65 +10000*X66 +10000*X67 +10000*X68 +10000*X69 +10000*X70
  +10000*X71 +12.775*X72 +16.425*X73 +18.25*X74 +21.17*X75 +18.98*X76
  +14.6*X77 +36.5*X78 +73*X79 +73*X80 +18.25*X81 +10.95*X82 +21.9*X83
  +51.1*X84 +10.585*X85 +80.8475*X86 +88.5125*X87 +95.63*X88
  +25.55*X89 +14.6*X90 +58.4*X91 +73*X92 +21.9*X93 +0.073*X94
  +1.2775*X95 +1.6425*X96 +1.825*X97 +2.117*X98 +1.898*X99 +1.46*X100
  +3.65*X101 +7.3*X102 +7.3*X103 +1.825*X104 +1.095*X105 +2.19*X106
  +5.11*X107 +1.0585*X108 +8.08475*X109 +8.85125*X110 +9.563*X111
  +2.555*X112 +1.46*X113 +5.84*X114 +7.3*X115 +2.19*X116 +0.0073*X117,
  {
  0 =< X1, X1 =< 1,
  0 =< X10, X10 =< 1,
  0 =< X100,
  0 =< X101,
  0 =< X102,
  0 =< X103,
  0 =< X104,
  0 =< X105,
  0 =< X106,
  0 =< X107,
  0 =< X108,
  0 =< X109,
  0 =< X11, X11 =< 1,
  0 =< X110,
  0 =< X111,
  0 =< X112,
  0 =< X113,
  0 =< X114,
  0 =< X115,
  0 =< X116,
  0 =< X117,
  0 =< X118,
  0 =< X119,
  0 =< X12, X12 =< 1,
  0 =< X120,
  0 =< X121,
  0 =< X122,
  0 =< X123,
  0 =< X124,
  0 =< X125,
  0 =< X126,
  0 =< X127,
  0 =< X128,
  0 =< X129,
  0 =< X13, X13 =< 1,
  0 =< X130,
  0 =< X131,
  0 =< X132,
  0 =< X133,
  0 =< X14, X14 =< 1,
  0 =< X15, X15 =< 1,
  0 =< X16, X16 =< 1,
  0 =< X17, X17 =< 1,
  0 =< X18, X18 =< 1,
  0 =< X19, X19 =< 1,
  0 =< X2, X2 =< 1,
  0 =< X20, X20 =< 1,
  0 =< X21, X21 =< 1,
  0 =< X22, X22 =< 1,
  0 =< X23, X23 =< 1,
  0 =< X24, X24 =< 1,
  0 =< X25, X25 =< 1,
  0 =< X26, X26 =< 1,
  0 =< X27, X27 =< 1,
  0 =< X28, X28 =< 1,
  0 =< X29, X29 =< 1,
  0 =< X3, X3 =< 1,
  0 =< X30, X30 =< 1,
  0 =< X31, X31 =< 1,
  0 =< X32, X32 =< 1,
  0 =< X33, X33 =< 1,
  0 =< X34, X34 =< 1,
  0 =< X35, X35 =< 1,
  0 =< X36, X36 =< 1,
  0 =< X37, X37 =< 1,
  0 =< X38, X38 =< 1,
  0 =< X39, X39 =< 1,
  0 =< X4, X4 =< 1,
  0 =< X40, X40 =< 1000,
  0 =< X41, X41 =< 1000,
  0 =< X42, X42 =< 1000,
  0 =< X43, X43 =< 1000,
  0 =< X44, X44 =< 1000,
  0 =< X45, X45 =< 1000,
  0 =< X46, X46 =< 1000,
  0 =< X47, X47 =< 1000,
  0 =< X48, X48 =< 1000,
  0 =< X49, X49 =< 1000,
  0 =< X5, X5 =< 1,
  0 =< X50, X50 =< 1000,
  0 =< X51, X51 =< 1000,
  0 =< X52, X52 =< 1000,
  0 =< X53, X53 =< 1000,
  0 =< X54, X54 =< 1000,
  0 =< X55, X55 =< 1000,
  0 =< X56, X56 =< 1000,
  0 =< X57, X57 =< 1000,
  0 =< X58, X58 =< 1000,
  0 =< X59, X59 =< 1000,
  0 =< X6, X6 =< 1,
  0 =< X60, X60 =< 1000,
  0 =< X61, X61 =< 1000,
  0 =< X62, X62 =< 1000,
  0 =< X63, X63 =< 1000,
  0 =< X64, X64 =< 1000,
  0 =< X65, X65 =< 1000,
  0 =< X66, X66 =< 1000,
  0 =< X67, X67 =< 1000,
  0 =< X68, X68 =< 1000,
  0 =< X69, X69 =< 1000,
  0 =< X7, X7 =< 1,
  0 =< X70, X70 =< 1000,
  0 =< X71, X71 =< 1000,
  0 =< X72,
  0 =< X73,
  0 =< X74,
  0 =< X75,
  0 =< X76,
  0 =< X77,
  0 =< X78,
  0 =< X79,
  0 =< X8, X8 =< 1,
  0 =< X80,
  0 =< X81,
  0 =< X82,
  0 =< X83,
  0 =< X84,
  0 =< X85,
  0 =< X86,
  0 =< X87,
  0 =< X88,
  0 =< X89,
  0 =< X9, X9 =< 1,
  0 =< X90,
  0 =< X91,
  0 =< X92,
  0 =< X93,
  0 =< X94,
  0 =< X95,
  0 =< X96,
  0 =< X97,
  0 =< X98,
  0 =< X99 },
 {
   -X72 +X73 -X118 =< -100,
   -24*X59 +X121 =< 0,
   -672*X30 -1344*X46 -X101 +X102 +X115 +X124 =< 0,
   -X90 +X91 =< 0,
   +X19 +8.33E-4*X90 +8.3E-5*X113 =< 1,
   -X108 =< 0,
   -X83 +X84 -X127 =< -160,
   -24*X66 +X128 =< 0,
   -X16 +X17 =< 0,
   -20*X15 +X35 +X51 =< 0,
   +X12 +8.33E-4*X83 +8.3E-5*X106 =< 3,
   -X77 +X78 +X90 +X93 +X94 -X123 =< 0,
   -24*X63 +X125 =< 0,
   +X4 +8.33E-4*X75 +8.3E-5*X98 =< 1,
   -X93 =< -100,
   +X22 +8.33E-4*X93 +8.3E-5*X116 =< 13,
   +X9 +8.33E-4*X80 +8.3E-5*X103 =< 2,
   -X5 +X6 =< 0,
   -20*X2 +X25 +X41 =< 0,
   +X20 +8.33E-4*X91 +8.3E-5*X114 =< 1,
   -X84 -X128 =< -100,
   -24*X56 +X118 =< 0,
   -672*X35 -1344*X51 -X109 +X110 +X129 =< 0,
   -672*X27 -1344*X43 -X98 +X99 +X121 =< 0,
   -X17 +X18 =< 0,
   -20*X16 +X36 +X52 =< 0,
   +X13 +8.33E-4*X84 +8.3E-5*X107 =< 2,
   -20*X7 +X30 +X46 =< 0,
   -X10 +X11 =< 0,
   -X94 =< -50,
   -X74 +X75 -X120 =< -200,
   -24*X61 +X123 =< 0,
   -672*X31 -1344*X47 -X103 +X125 =< 0,
   +X23 +8.33E-4*X94 +8.3E-5*X117 =< 99,
   +X1 +8.33E-4*X72 +8.3E-5*X95 =< 2,
   -X7 +X21 =< 0,
   -X79 +X80 =< -10,
   +X6 +8.33E-4*X77 +8.3E-5*X100 =< 13,
   -X2 +X3 =< 0,
   -X85 =< -300,
   -24*X67 +X129 =< 0,
   -672*X36 -1344*X52 -X110 +X111 +X130 =< 0,
   -20*X17 +X37 +X53 =< 0,
   +X14 +8.33E-4*X85 +8.3E-5*X108 =< 2,
   -X6 +X19 =< 0,
   -X11 +X12 =< 0,
   -20*X10 +X32 +X48 =< 0,
   -672*X24 -1344*X40 -X95 +X96 +X118 =< 0,
   -20*X4 +X27 +X43 =< 0,
   -X7 +X8 =< 0,
   -20*X20 +X38 +X54 =< 0,
   -X6 +X22 =< 0,
   -24*X58 +X120 =< 0,
   -672*X29 -1344*X45 -X100 +X101 +X113 +X116 +X117 +X123 =< 0,
   -20*X9 +X31 +X47 =< 0,
   -X76 +X77 +X81 +X86 -X122 =< 0,
   +X3 +8.33E-4*X74 +8.3E-5*X97 =< 2,
   -X86 +X87 -X129 =< -100,
   -24*X68 +X130 =< 0,
   -672*X37 -1344*X53 -X111 +X112 +X131 =< 0,
   -X19 +X20 =< 0,
   +X15 +8.33E-4*X86 +8.3E-5*X109 =< 2,
   -672*X32 -1344*X48 -X104 +X105 +X108 +X126 =< 0,
   -X12 +X13 =< 0,
   +X8 +8.33E-4*X79 +8.3E-5*X102 =< 1,
   -672*X38 -1344*X54 -X114 +X132 =< 0,
   -20*X21 +X39 +X55 =< 0,
   -20*X1 +X24 +X40 =< 0,
   -X4 +X5 =< 0,
   -X6 +X23 =< 0,
   -672*X26 -1344*X42 -X97 +X98 +X120 =< 0,
   -X5 +X10 =< 0,
   -20*X6 +X29 +X45 =< 0,
   -X112 =< 0,
   -X87 +X88 -X130 =< -150,
   -24*X69 +X131 =< 0,
   +X16 +8.33E-4*X87 +8.3E-5*X110 =< 2,
   -X105 +X106 =< 0,
   -X102 +X103 =< 0,
   -X73 +X74 -X119 =< -50,
   -24*X64 +X126 =< 0,
   -24*X60 +X122 =< 0,
   -20*X12 +X33 +X49 =< 0,
   -X10 +X14 =< 0,
   -X78 +X79 +X92 -X124 =< -150,
   -24*X70 +X132 =< 0,
   -672*X39 -1344*X55 -X115 +X133 =< 0,
   +X5 +8.33E-4*X76 +8.3E-5*X99 =< 1,
   -X1 +X2 =< 0,
   +X10 +8.33E-4*X81 +8.3E-5*X104 =< 13,
   -X113 +X114 =< 0,
   -X88 +X89 -X131 =< -10,
   +X17 +8.33E-4*X88 +8.3E-5*X111 =< 2,
   -20*X3 +X26 +X42 =< 0,
   -X6 +X7 =< 0,
   -X81 +X82 +X85 -X126 =< 0,
   -672*X33 -1344*X49 -X106 +X107 +X127 =< 0,
   -20*X13 +X34 +X50 =< 0,
   -X5 +X15 =< 0,
   -24*X57 +X119 =< 0,
   -672*X28 -1344*X44 -X99 +X100 +X104 +X109 +X122 =< 0,
   -X116 =< 0,
   -X91 -X132 =< -600,
   -24*X71 +X133 =< 0,
   -X75 +X76 -X121 =< -10,
   -24*X62 +X124 =< 0,
   +X2 +8.33E-4*X73 +8.3E-5*X96 =< 1,
   -X89 =< -20,
   -X80 -X125 =< -500,
   +X18 +8.33E-4*X89 +8.3E-5*X112 =< 2,
   +X7 +8.33E-4*X78 +8.3E-5*X101 =< 2,
   -X82 +X83 =< -50,
   -24*X65 +X127 =< 0,
   -672*X34 -1344*X50 -X107 +X128 =< 0,
   -X15 +X16 =< 0,
   +X11 +8.33E-4*X82 +8.3E-5*X105 =< 1,
   -X3 +X4 =< 0,
   -X117 =< 0,
   -X92 -X133 =< -200,
   +X21 +8.33E-4*X92 +8.3E-5*X115 =< 2,
   -672*X25 -1344*X41 -X96 +X97 +X119 =< 0,
   -20*X5 +X28 +X44 =< 0,
   -X8 +X9 =< 0
  },
  attach_name(X72,'a1'),
  attach_name(X81,'a10'),
  attach_name(X82,'a11'),
  attach_name(X83,'a12'),
  attach_name(X84,'a13'),
  attach_name(X85,'a14'),
  attach_name(X86,'a15'),
  attach_name(X87,'a16'),
  attach_name(X88,'a17'),
  attach_name(X89,'a18'),
  attach_name(X90,'a19'),
  attach_name(X73,'a2'),
  attach_name(X91,'a20'),
  attach_name(X92,'a21'),
  attach_name(X93,'a22'),
  attach_name(X94,'a23'),
  attach_name(X74,'a3'),
  attach_name(X75,'a4'),
  attach_name(X76,'a5'),
  attach_name(X77,'a6'),
  attach_name(X78,'a7'),
  attach_name(X79,'a8'),
  attach_name(X80,'a9'),
  attach_name(X95,'b1'),
  attach_name(X104,'b10'),
  attach_name(X105,'b11'),
  attach_name(X106,'b12'),
  attach_name(X107,'b13'),
  attach_name(X108,'b14'),
  attach_name(X109,'b15'),
  attach_name(X110,'b16'),
  attach_name(X111,'b17'),
  attach_name(X112,'b18'),
  attach_name(X113,'b19'),
  attach_name(X96,'b2'),
  attach_name(X114,'b20'),
  attach_name(X115,'b21'),
  attach_name(X116,'b22'),
  attach_name(X117,'b23'),
  attach_name(X97,'b3'),
  attach_name(X98,'b4'),
  attach_name(X99,'b5'),
  attach_name(X100,'b6'),
  attach_name(X101,'b7'),
  attach_name(X102,'b8'),
  attach_name(X103,'b9'),
  attach_name(X1,'c1'),
  attach_name(X10,'c10'),
  attach_name(X11,'c11'),
  attach_name(X12,'c12'),
  attach_name(X13,'c13'),
  attach_name(X14,'c14'),
  attach_name(X15,'c15'),
  attach_name(X16,'c16'),
  attach_name(X17,'c17'),
  attach_name(X18,'c18'),
  attach_name(X19,'c19'),
  attach_name(X2,'c2'),
  attach_name(X20,'c20'),
  attach_name(X21,'c21'),
  attach_name(X22,'c22'),
  attach_name(X23,'c23'),
  attach_name(X3,'c3'),
  attach_name(X4,'c4'),
  attach_name(X5,'c5'),
  attach_name(X6,'c6'),
  attach_name(X7,'c7'),
  attach_name(X8,'c8'),
  attach_name(X9,'c9'),
  attach_name(X24,'d1'),
  attach_name(X32,'d10'),
  attach_name(X33,'d12'),
  attach_name(X34,'d13'),
  attach_name(X35,'d15'),
  attach_name(X36,'d16'),
  attach_name(X37,'d17'),
  attach_name(X25,'d2'),
  attach_name(X38,'d20'),
  attach_name(X39,'d21'),
  attach_name(X26,'d3'),
  attach_name(X27,'d4'),
  attach_name(X28,'d5'),
  attach_name(X29,'d6'),
  attach_name(X30,'d7'),
  attach_name(X31,'d9'),
  attach_name(X118,'f1'),
  attach_name(X126,'f10'),
  attach_name(X127,'f12'),
  attach_name(X128,'f13'),
  attach_name(X129,'f15'),
  attach_name(X130,'f16'),
  attach_name(X131,'f17'),
  attach_name(X119,'f2'),
  attach_name(X132,'f20'),
  attach_name(X133,'f21'),
  attach_name(X120,'f3'),
  attach_name(X121,'f4'),
  attach_name(X122,'f5'),
  attach_name(X123,'f6'),
  attach_name(X124,'f7'),
  attach_name(X125,'f9'),
  attach_name(X56,'g1'),
  attach_name(X64,'g10'),
  attach_name(X65,'g12'),
  attach_name(X66,'g13'),
  attach_name(X67,'g15'),
  attach_name(X68,'g16'),
  attach_name(X69,'g17'),
  attach_name(X57,'g2'),
  attach_name(X70,'g20'),
  attach_name(X71,'g21'),
  attach_name(X58,'g3'),
  attach_name(X59,'g4'),
  attach_name(X60,'g5'),
  attach_name(X61,'g6'),
  attach_name(X62,'g7'),
  attach_name(X63,'g9'),
  attach_name(X40,'h1'),
  attach_name(X48,'h10'),
  attach_name(X49,'h12'),
  attach_name(X50,'h13'),
  attach_name(X51,'h15'),
  attach_name(X52,'h16'),
  attach_name(X53,'h17'),
  attach_name(X41,'h2'),
  attach_name(X54,'h20'),
  attach_name(X55,'h21'),
  attach_name(X42,'h3'),
  attach_name(X43,'h4'),
  attach_name(X44,'h5'),
  attach_name(X45,'h6'),
  attach_name(X46,'h7'),
  attach_name(X47,'h9'),
  true.

example( bell3a_nonred, Min, Vs, Ints, Bins) :-
   Bins = [],
   Ints = [X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32,X33,X34,X35,X36,X37,X38,X39,X40,X41,X42,X43,X44,X45,X46,X47,X48,X49,X50,X51,X52,X53,X54,X55,X56,X57,X58,X59,X60,X61,X62,X63,X64,X65,X66,X67,X68,X69,X70,X71],
   Min = 43000*X24+43000*X25+43000*X26+43000*X27+43000*X28+43000*X29+43000*X30+43000*X31+43000*X32+43000*X33+43000*X34+43000*X35+43000*X36+44000*X37+43000*X38+43000*X39+58000*X40+58000*X41+58000*X42+58000*X43+58000*X44+58000*X45+59000*X46+60000*X47+59000*X48+59000*X49+59000*X50+59000*X51+59000*X52+60000*X53+59000*X54+59000*X55+10000*X56+10000*X57+10000*X58+10000*X59+10000*X60+10000*X61+10000*X62+10000*X63+10000*X64+10000*X65+10000*X66+10000*X67+10000*X68+10000*X69+10000*X70+10000*X71+12.775*X72+16.425*X73+18.25*X74+21.17*X75+18.98*X76+14.6*X77+36.5*X78+73*X79+73*X80+18.25*X81+10.95*X82+21.9*X83+51.1*X84+10.585*X85+80.8475*X86+88.5125*X87+95.63*X88+25.55*X89+14.6*X90+58.4*X91+73*X92+21.9*X93+0.073*X94+1.2775*X95+1.6425*X96+1.825*X97+2.117*X98+1.898*X99+1.46*X100+3.65*X101+7.3*X102+7.3*X103+1.825*X104+1.095*X105+2.19*X106+5.11*X107+1.0585*X108+8.08475*X109+8.85125*X110+9.563*X111+2.555*X112+1.46*X113+5.84*X114+7.3*X115+2.19*X116+0.0073*X117,
   Vs = [X1,X10,X100,X101,X102,X103,X104,X105,X106,X107,X108,X109,X11,X110,X111,X112,X113,X114,X115,X116,X117,X118,X119,X12,X120,X121,X122,X123,X124,X125,X126,X127,X128,X129,X13,X130,X131,X132,X133,X14,X15,X16,X17,X18,X19,X2,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X3,X30,X31,X32,X33,X34,X35,X36,X37,X38,X39,X4,X40,X41,X42,X43,X44,X45,X46,X47,X48,X49,X5,X50,X51,X52,X53,X54,X55,X56,X57,X58,X59,X6,X60,X61,X62,X63,X64,X65,X66,X67,X68,X69,X7,X70,X71,X72,X73,X74,X75,X76,X77,X78,X79,X8,X80,X81,X82,X83,X84,X85,X86,X87,X88,X89,X9,X90,X91,X92,X93,X94,X95,X96,X97,X98,X99],
  {
   X63-1/24*X125>=0,
   X93+1000000/833*X22+83/833*X116=<13000000/833,
   X56-1/24*X118>=0,
   X47+1/2*X31-1/1344*X125+1/1344*X103>=0,
   X85+1000000/833*X14+83/833*X108=<2000000/833,
   X58-1/24*X120>=0,
   X40+X24-20*X1=<0,
   X69-1/24*X131>=0,
   X60-1/24*X122>=0,
   X70-1/24*X132>=0,
   X98-X97-1344*X42-672*X26+X120=<0,
   X57-1/24*X119>=0,
   X99+1344*X44+672*X28-X122-X109-X104-X100>=0,
   X20-X19=<0,
   X71-1/24*X133>=0,
   X89+1000000/833*X18+83/833*X112=<2000000/833,
   X97-X96-1344*X41-672*X25+X119=<0,
   X1>=0,
   X1=<1,
   X100>=0,
   X101>=0,
   X103>=0,
   X104>=0,
   X106>=0,
   X107>=0,
   X108>=0,
   X109>=0,
   X110>=0,
   X111>=0,
   X112>=0,
   X114>=0,
   X115>=0,
   X116>=0,
   X117>=0,
   X118>=0,
   X119>=0,
   X120>=0,
   X121>=0,
   X122>=0,
   X125>=0,
   X127>=0,
   X128>=0,
   X131>=0,
   X132>=0,
   X133>=0,
   X24>=0,
   X24=<1,
   X25>=0,
   X25=<1,
   X26>=0,
   X26=<1,
   X27>=0,
   X27=<1,
   X28>=0,
   X28=<1,
   X29>=0,
   X29=<1,
   X30>=0,
   X30=<1,
   X31>=0,
   X31=<1,
   X32>=0,
   X32=<1,
   X33>=0,
   X33=<1,
   X34>=0,
   X34=<1,
   X35>=0,
   X35=<1,
   X36>=0,
   X36=<1,
   X37>=0,
   X37=<1,
   X38>=0,
   X38=<1,
   X39>=0,
   X39=<1,
   X56>=0,
   X56=<1000,
   X57>=0,
   X57=<1000,
   X58>=0,
   X58=<1000,
   X59>=0,
   X59=<1000,
   X60>=0,
   X60=<1000,
   X61>=0,
   X61=<1000,
   X62>=0,
   X62=<1000,
   X63>=0,
   X63=<1000,
   X64>=0,
   X64=<1000,
   X65>=0,
   X65=<1000,
   X66>=0,
   X66=<1000,
   X67>=0,
   X67=<1000,
   X68>=0,
   X68=<1000,
   X69>=0,
   X69=<1000,
   X70>=0,
   X70=<1000,
   X71>=0,
   X71=<1000,
   X74>=0,
   X75>=0,
   X85>=300,
   X89>=20,
   X93>=100,
   X94>=50,
   X95>=0,
   X97>=0,
   X98>=0,
   X99>=0,
   X84>=0,
   X83>=0,
   X87>=0,
   X86>=0,
   X88>=0,
   X81>=0,
   X76>=0,
   X77>=0,
   X73>=0,
   X72>=0,
   X96>=0,
   X130>=0,
   X129>=0,
   X14>=0,
   X18>=0,
   X22>=0,
   X23>=0,
   X41>=0,
   X44>=0,
   X47>=0,
   X46>=0,
   X43>=0,
   X20>=0,
   X54>=0,
   X40>=0,
   X91+X132>=600,
   X114-X113=<0,
   X91>=0,
   X42>=0,
   X82+1000000/833*X11+83/833*X105=<1000000/833,
   X85+X82-X81-X126=<0,
   X64-1/24*X126>=0,
   X106-X105=<0,
   X126>=0,
   X19>=0,
   X80+X125>=500,
   X9-X8=<0,
   X92+X133>=200,
   X62-1/24*X124>=0,
   X7-X6=<0,
   X55+1/2*X39-1/1344*X133+1/1344*X115>=0,
   X103-X102=<0,
   X6-1/20*X45-1/20*X29>=0,
   X55>=0,
   X80>=0,
   X61-1/24*X123>=0,
   X78>=0,
   X123>=0,
   X7-1/20*X46-1/20*X30>=0,
   X124>=0,
   X92>=0,
   X50>=0,
   X49>=0,
   X45>=0,
   X53>=0,
   X52>=0,
   X51>=0,
   X48>=0,
   X99-X98-1344*X43-672*X27+X121=<0,
   X76-X75-X121=< -10,
   X59-1/24*X121>=0,
   X84-X83-X127=< -160,
   X65-1/24*X127>=0,
   X49+1/2*X33-1/1344*X127-1/1344*X107+1/1344*X106>=0,
   X84+X128>=100,
   X50+1/2*X34-1/1344*X128+1/1344*X107>=0,
   X66-1/24*X128>=0,
   X92+1000000/833*X21+83/833*X115=<2000000/833,
   X75-X74-X120=< -200,
   X5-1/20*X44-1/20*X28>=0,
   X42-20*X3+X26=<0,
   X88+1000000/833*X17+83/833*X111=<2000000/833,
   X81+83/833*X104+1000000/833*X10=<13000000/833,
   X2-X1=<0,
   X99+833/83*X76+1000000/83*X5=<1000000/83,
   X14-X10=<0,
   X87+1000000/833*X16+83/833*X110=<2000000/833,
   X88-X87-X130=< -150,
   X6-X23>=0,
   X86+1000000/833*X15+83/833*X109=<2000000/833,
   X53+1/2*X37-1/1344*X131-1/1344*X112+1/1344*X111>=0,
   X68-1/24*X130>=0,
   X87-X86-X129=< -100,
   X6-X22>=0,
   X6-X19>=0,
   X77+1000000/833*X6+83/833*X100=<13000000/833,
   X18-X17=<0,
   X67-1/24*X129>=0,
   X43-20*X4+X27=<0,
   X98+833/83*X75+1000000/83*X4=<1000000/83,
   X41+X25-20*X2=<0,
   X84+1000000/833*X13+83/833*X107=<2000000/833,
   X96-X95-1344*X40-672*X24+X118=<0,
   X8-X7=<0,
   X74-X73-X119=< -50,
   X97+833/83*X74+1000000/83*X3=<2000000/83,
   X54+X38-20*X20=<0,
   X54+1/2*X38-1/1344*X132+1/1344*X114>=0,
   X7-X21>=0,
   X55+X39-20*X21=<0,
   X89-X88-X131=< -10,
   X4-X3=<0,
   X90+1000000/833*X19+83/833*X113=<1000000/833,
   X91-X90=<0,
   X86+X81+X77-X76-X122=<0,
   X95+833/83*X72+1000000/83*X1=<2000000/83,
   X73-X72-X118=< -100,
   X46+1/2*X30-1/1344*X124-1/1344*X115-1/1344*X102+1/1344*X101>=0,
   X83-X82=< -50,
   X8+833/1000000*X79+83/1000000*X102=<1,
   X80-X79=< -10,
   X96+833/83*X73+1000000/83*X2=<1000000/83,
   X3-X2=<0,
   X50+X34-20*X13=<0,
   X78+1000000/833*X7+83/833*X101=<2000000/833,
   X45+1/2*X29-1/1344*X123-1/1344*X117-1/1344*X116-1/1344*X113-1/1344*X101+1/1344*X100>=0,
   X94+X93+X90+X78-X77-X123=<0,
   X49+X33-20*X12=<0,
   X6-X5=<0,
   X16-X15=<0,
   X53+X37-20*X17=<0,
   X52+X36-20*X16=<0,
   X17-X16=<0,
   X52+1/2*X36-1/1344*X130-1/1344*X111+1/1344*X110>=0,
   X5-X15>=0,
   X51+X35-20*X15=<0,
   X51+1/2*X35-1/1344*X129-1/1344*X110+1/1344*X109>=0,
   X5-X4=<0,
   X5-X10>=0,
   X48+X32-20*X10=<0,
   X13-X12=<0,
   X12-X11=<0,
   X11-X10=<0,
   X48+1/2*X32-1/1344*X126-1/1344*X108-1/1344*X105+1/1344*X104>=0,
   X92+X79-X78-X124=< -150,
   X9-1/20*X47-1/20*X31>=0
  }.

allpos( []).
allpos( [V|Vs]) :-
  { V >= 0 },
  allpos( Vs).

attach_name( _, _).
