/*
 * GtkZclock - A simple but powerful clock widget for GTK/GNOME
 * Copyright (C) 2000  Zack Hobson <zack@malfunktion.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef INC_GTK_ZCLOCK_H
#define INC_GTK_ZCLOCK_H

#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_ZCLOCK(obj)		GTK_CHECK_CAST(obj, gtk_zclock_get_type(), GtkZclock)
#define GTK_ZCLOCK_CLASS(klass)	GTK_CHECK_CAST(klass, gtk_zclock_get_type(), GtkZclockClass)
#define GTK_IS_ZCLOCK(obj)	GTK_CHECK_TYPE(obj, gtk_zclock_get_type())

typedef struct _GtkZclock		GtkZclock;
typedef struct _GtkZclockClass	GtkZclockClass;

struct _GtkZclock 
{
	/* base widget */
	GtkFrame	parent_widget;

	/* child widgets */
	GtkWidget*		label;

	/* attributes */
	gchar*		format;

	/* gtk timeout vars (don't mess with these) */
	guint	timeout;
	guint	timeout_interval;
};

struct _GtkZclockClass
{
	GtkFrameClass parent_class;
};

guint gtk_zclock_get_type (void);
GtkWidget* gtk_zclock_new (const gchar *);
void gtk_zclock_set_format(GtkZclock *, const gchar *);
void gtk_zclock_get_arg (GtkObject *, GtkArg *, guint);
void gtk_zclock_set_arg (GtkObject *, GtkArg *, guint);

#define gtk_zclock_set_justify(zclock, jtype) \
	gtk_label_set_justify(GTK_LABEL(GTK_ZCLOCK(zclock)->label), (jtype)) 

#define gtk_zclock_set_label_padding(zclock, xpad, ypad) \
	gtk_misc_set_padding(GTK_MISC(GTK_ZCLOCK(zclock)->label), (xpad), (ypad))

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* INC_GTK_ZCLOCK_H */

