/* log-test.c generated by valac 0.39.91, the Vala compiler
 * generated from log-test.vala, do not modify */

/* log-test.vala
 *
 * Copyright © 2012 Christian Dywan <christian@twotoasts.de>
 *
 * Based upon a C implementation (© 2010 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist.h"
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"

#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	GArray* event_ids;
	GPtrArray* expected_events;
	GMainLoop* mainloop;
};

struct _Block3Data {
	int _ref_count_;
	GMainLoop* mainloop;
	GPtrArray* expected_events;
};



gint _vala_main (gchar** argv,
                 int argv_length1);
void insert_get_delete_test (void);
static void _insert_get_delete_test_gtest_func (void);
void get_default_test (void);
static void _get_default_test_gtest_func (void);
void events_received (ZeitgeistLog* log,
                      GAsyncResult* res,
                      GPtrArray* expected_events,
                      GArray* event_ids,
                      GMainLoop* mainloop);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda6_ (Block1Data* _data1_);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
void events_inserted (ZeitgeistLog* log,
                      GAsyncResult* res,
                      GPtrArray* expected_events,
                      GMainLoop* mainloop);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_,
                 GObject* log,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
gboolean quit_main_loop (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void __lambda4_ (Block3Data* _data3_,
                 GObject* log,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static gboolean _quit_main_loop_gsource_func (gpointer self);


static void
_insert_get_delete_test_gtest_func (void)
{
#line 30 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	insert_get_delete_test ();
#line 115 "log-test.c"
}


static void
_get_default_test_gtest_func (void)
{
#line 31 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	get_default_test ();
#line 124 "log-test.c"
}


gint
_vala_main (gchar** argv,
            int argv_length1)
{
	gint result = 0;
#line 28 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_test_init (&argv_length1, &argv, NULL);
#line 30 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_test_add_func ("/Log/InsertGetDelete", _insert_get_delete_test_gtest_func);
#line 31 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_test_add_func ("/Log/GetDefault", _get_default_test_gtest_func);
#line 33 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	result = g_test_run ();
#line 33 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return result;
#line 143 "log-test.c"
}


int
main (int argc,
      char ** argv)
{
#line 26 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return _vala_main (argv, argc);
#line 153 "log-test.c"
}


static gpointer
_g_main_loop_ref0 (gpointer self)
{
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 162 "log-test.c"
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return _data1_;
#line 173 "log-test.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 188 "log-test.c"
	}
}


static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	guint _tmp0_;
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 206 "log-test.c"
}


static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
#line 5002 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 5002 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, value);
#line 218 "log-test.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 54 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 227 "log-test.c"
}


static void
__lambda6_ (Block1Data* _data1_)
{
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_main_loop_quit (_data1_->mainloop);
#line 236 "log-test.c"
}


static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	__lambda6_ (self);
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	block1_data_unref (self);
#line 249 "log-test.c"
}


void
events_received (ZeitgeistLog* log,
                 GAsyncResult* res,
                 GPtrArray* expected_events,
                 GArray* event_ids,
                 GMainLoop* mainloop)
{
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	ZeitgeistResultSet* events = NULL;
	gint _tmp6_;
	gint _tmp7_;
	ZeitgeistResultSet* _tmp8_;
	GError * _inner_error_ = NULL;
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (log != NULL);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (expected_events != NULL);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (event_ids != NULL);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (mainloop != NULL);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data1_->_ref_count_ = 1;
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = _g_main_loop_ref0 (mainloop);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_main_loop_unref0 (_data1_->mainloop);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data1_->mainloop = _tmp0_;
#line 287 "log-test.c"
	{
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistResultSet* _tmp2_;
		ZeitgeistResultSet* _tmp3_;
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp2_ = zeitgeist_log_get_events_finish (log, res, &_inner_error_);
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp1_ = _tmp2_;
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 298 "log-test.c"
			goto __catch0_g_error;
		}
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp3_ = _tmp1_;
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp1_ = NULL;
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (events);
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		events = _tmp3_;
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (_tmp1_);
#line 311 "log-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_error_ = _inner_error_;
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_inner_error_ = NULL;
#line 46 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp4_ = _error_;
#line 46 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp5_ = _tmp4_->message;
#line 46 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_critical ("log-test.vala:46: Failed to get events: %s", _tmp5_);
#line 47 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_error_free0 (_error_);
#line 47 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (events);
#line 47 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		block1_data_unref (_data1_);
#line 47 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_data1_ = NULL;
#line 47 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		return;
#line 339 "log-test.c"
	}
	__finally0:
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (events);
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		block1_data_unref (_data1_);
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_data1_ = NULL;
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_clear_error (&_inner_error_);
#line 42 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		return;
#line 356 "log-test.c"
	}
#line 51 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp6_ = g_ptr_array_get_length (expected_events);
#line 51 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp7_ = _tmp6_;
#line 51 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp8_ = events;
#line 51 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_vala_assert (((guint) _tmp7_) == zeitgeist_result_set_size (_tmp8_), "expected_events.length == events.size()");
#line 366 "log-test.c"
	{
		gint i = 0;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		i = 0;
#line 371 "log-test.c"
		{
			gboolean _tmp9_ = FALSE;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
			_tmp9_ = TRUE;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
			while (TRUE) {
#line 378 "log-test.c"
				gint _tmp11_;
				ZeitgeistResultSet* _tmp12_;
				ZeitgeistEvent* exp_event = NULL;
				gint _tmp13_;
				gconstpointer _tmp14_;
				ZeitgeistEvent* _tmp15_;
				ZeitgeistEvent* event = NULL;
				ZeitgeistResultSet* _tmp16_;
				ZeitgeistEvent* _tmp17_;
				ZeitgeistEvent* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				ZeitgeistEvent* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				ZeitgeistEvent* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ZeitgeistEvent* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ZeitgeistEvent* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				ZeitgeistEvent* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				ZeitgeistEvent* _tmp36_;
				ZeitgeistEvent* _tmp37_;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				if (!_tmp9_) {
#line 410 "log-test.c"
					gint _tmp10_;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
					_tmp10_ = i;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
					i = _tmp10_ + 1;
#line 416 "log-test.c"
				}
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp9_ = FALSE;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp11_ = i;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp12_ = events;
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				if (!(((guint) _tmp11_) < zeitgeist_result_set_size (_tmp12_))) {
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
					break;
#line 428 "log-test.c"
				}
#line 54 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp13_ = i;
#line 54 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp14_ = g_ptr_array_index (expected_events, (guint) _tmp13_);
#line 54 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp15_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp14_);
#line 54 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				exp_event = _tmp15_;
#line 55 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp16_ = events;
#line 55 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp17_ = zeitgeist_result_set_next_value (_tmp16_);
#line 55 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				event = _tmp17_;
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp18_ = event;
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp19_ = zeitgeist_event_get_interpretation (_tmp18_);
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp20_ = _tmp19_;
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp21_ = exp_event;
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp22_ = zeitgeist_event_get_interpretation (_tmp21_);
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp23_ = _tmp22_;
#line 56 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_vala_assert (g_strcmp0 (_tmp20_, _tmp23_) == 0, "event.interpretation == exp_event.interpretation");
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp24_ = event;
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp25_ = zeitgeist_event_get_manifestation (_tmp24_);
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp26_ = _tmp25_;
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp27_ = exp_event;
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp28_ = zeitgeist_event_get_manifestation (_tmp27_);
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp29_ = _tmp28_;
#line 57 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_vala_assert (g_strcmp0 (_tmp26_, _tmp29_) == 0, "event.manifestation == exp_event.manifestation");
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp30_ = event;
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp31_ = zeitgeist_event_get_actor (_tmp30_);
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp32_ = _tmp31_;
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp33_ = exp_event;
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp34_ = zeitgeist_event_get_actor (_tmp33_);
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp35_ = _tmp34_;
#line 58 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_vala_assert (g_strcmp0 (_tmp32_, _tmp35_) == 0, "event.actor == exp_event.actor");
#line 59 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp36_ = event;
#line 59 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_tmp37_ = exp_event;
#line 59 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_vala_assert (zeitgeist_event_num_subjects (_tmp36_) == zeitgeist_event_num_subjects (_tmp37_), "event.num_subjects () == exp_event.num_subjects ()");
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_g_object_unref0 (event);
#line 52 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
				_g_object_unref0 (exp_event);
#line 496 "log-test.c"
			}
		}
	}
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_log_delete_events (log, event_ids, NULL, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (events);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	block1_data_unref (_data1_);
#line 36 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data1_ = NULL;
#line 508 "log-test.c"
}


static gpointer
_g_ptr_array_ref0 (gpointer self)
{
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return self ? g_ptr_array_ref (self) : NULL;
#line 517 "log-test.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return _data2_;
#line 528 "log-test.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_array_unref0 (_data2_->event_ids);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_ptr_array_unref0 (_data2_->expected_events);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_main_loop_unref0 (_data2_->mainloop);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 547 "log-test.c"
	}
}


static void
__lambda5_ (Block2Data* _data2_,
            GObject* log,
            GAsyncResult* res)
{
	GArray* _tmp0_;
#line 80 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 81 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = _data2_->event_ids;
#line 81 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	events_received (G_TYPE_CHECK_INSTANCE_CAST (log, ZEITGEIST_TYPE_LOG, ZeitgeistLog), res, _data2_->expected_events, _tmp0_, _data2_->mainloop);
#line 564 "log-test.c"
}


static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 80 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	__lambda5_ (self, source_object, res);
#line 80 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	block2_data_unref (self);
#line 577 "log-test.c"
}


void
events_inserted (ZeitgeistLog* log,
                 GAsyncResult* res,
                 GPtrArray* expected_events,
                 GMainLoop* mainloop)
{
	Block2Data* _data2_;
	GPtrArray* _tmp0_;
	GMainLoop* _tmp1_;
	gint _tmp7_;
	gint _tmp8_;
	GArray* _tmp9_;
	guint _tmp10_;
	GArray* _tmp11_;
	GError * _inner_error_ = NULL;
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (log != NULL);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (expected_events != NULL);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (mainloop != NULL);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data2_->_ref_count_ = 1;
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = _g_ptr_array_ref0 (expected_events);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_ptr_array_unref0 (_data2_->expected_events);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data2_->expected_events = _tmp0_;
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = _g_main_loop_ref0 (mainloop);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_main_loop_unref0 (_data2_->mainloop);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data2_->mainloop = _tmp1_;
#line 620 "log-test.c"
	{
		GArray* _tmp2_ = NULL;
		GArray* _tmp3_;
		GArray* _tmp4_;
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp3_ = zeitgeist_log_insert_events_finish (log, res, &_inner_error_);
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp2_ = _tmp3_;
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 631 "log-test.c"
			goto __catch1_g_error;
		}
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp4_ = _tmp2_;
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp2_ = NULL;
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_array_unref0 (_data2_->event_ids);
#line 72 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_data2_->event_ids = _tmp4_;
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_array_unref0 (_tmp2_);
#line 644 "log-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_error_ = _inner_error_;
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_inner_error_ = NULL;
#line 75 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp5_ = _error_;
#line 75 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_tmp6_ = _tmp5_->message;
#line 75 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_critical ("log-test.vala:75: Failed to insert events: %s", _tmp6_);
#line 76 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_error_free0 (_error_);
#line 76 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		block2_data_unref (_data2_);
#line 76 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_data2_ = NULL;
#line 76 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		return;
#line 670 "log-test.c"
	}
	__finally1:
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		block2_data_unref (_data2_);
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_data2_ = NULL;
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_clear_error (&_inner_error_);
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		return;
#line 685 "log-test.c"
	}
#line 78 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp7_ = g_ptr_array_get_length (_data2_->expected_events);
#line 78 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp8_ = _tmp7_;
#line 78 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp9_ = _data2_->event_ids;
#line 78 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp10_ = _tmp9_->len;
#line 78 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_vala_assert (((guint) _tmp8_) == _tmp10_, "expected_events.length == event_ids.length");
#line 80 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp11_ = _data2_->event_ids;
#line 80 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_log_get_events (log, _tmp11_, NULL, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	block2_data_unref (_data2_);
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data2_ = NULL;
#line 705 "log-test.c"
}


gboolean
quit_main_loop (void)
{
	gboolean result = FALSE;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GMainLoop* _tmp2_;
#line 87 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = g_main_context_default ();
#line 87 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = g_main_loop_new (_tmp0_, FALSE);
#line 87 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp2_ = _tmp1_;
#line 87 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_main_loop_quit (_tmp2_);
#line 87 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_main_loop_unref0 (_tmp2_);
#line 88 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	result = FALSE;
#line 88 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return result;
#line 730 "log-test.c"
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return _data3_;
#line 741 "log-test.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_ptr_array_unref0 (_data3_->expected_events);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		_g_main_loop_unref0 (_data3_->mainloop);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 758 "log-test.c"
	}
}


static void
_g_object_unref0_ (gpointer var)
{
#line 94 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 768 "log-test.c"
}


static void
__lambda4_ (Block3Data* _data3_,
            GObject* log,
            GAsyncResult* res)
{
#line 113 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 114 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	events_inserted (G_TYPE_CHECK_INSTANCE_CAST (log, ZEITGEIST_TYPE_LOG, ZeitgeistLog), res, _data3_->expected_events, _data3_->mainloop);
#line 781 "log-test.c"
}


static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	__lambda4_ (self, source_object, res);
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	block3_data_unref (self);
#line 794 "log-test.c"
}


static gboolean
_quit_main_loop_gsource_func (gpointer self)
{
	gboolean result;
	result = quit_main_loop ();
#line 118 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	return result;
#line 805 "log-test.c"
}


void
insert_get_delete_test (void)
{
	Block3Data* _data3_;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GPtrArray* _tmp2_;
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistSubject* su = NULL;
	ZeitgeistSubject* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistLog* _tmp6_;
	ZeitgeistLog* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data3_->_ref_count_ = 1;
#line 93 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = g_main_context_default ();
#line 93 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = g_main_loop_new (_tmp0_, FALSE);
#line 93 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data3_->mainloop = _tmp1_;
#line 94 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 94 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data3_->expected_events = _tmp2_;
#line 95 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp3_ = zeitgeist_event_new ();
#line 95 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	ev = _tmp3_;
#line 96 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp4_ = zeitgeist_subject_new ();
#line 96 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	su = _tmp4_;
#line 97 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_add_subject (ev, su);
#line 98 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp5_ = _g_object_ref0 (ev);
#line 98 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_ptr_array_add (_data3_->expected_events, _tmp5_);
#line 99 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_set_interpretation (ev, "foo://Interp");
#line 100 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_set_manifestation (ev, "foo://Manif");
#line 101 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_set_actor (ev, "app://firefox.desktop");
#line 103 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_uri (su, "file:///tmp/bar.txt");
#line 104 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_interpretation (su, "foo://TextDoc");
#line 105 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_manifestation (su, "foo://File");
#line 106 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_mimetype (su, "text/plain");
#line 107 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_origin (su, "file:///tmp");
#line 108 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_text (su, "bar.txt");
#line 109 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_storage (su, "bfb486f6-f5f8-4296-8871-0cc749cf8ef7");
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp6_ = zeitgeist_log_get_default ();
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp7_ = _tmp6_;
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	zeitgeist_log_insert_events (_tmp7_, _data3_->expected_events, NULL, ___lambda4__gasync_ready_callback, block3_data_ref (_data3_));
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (_tmp7_);
#line 116 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp8_ = g_ptr_array_get_length (_data3_->expected_events);
#line 116 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp9_ = _tmp8_;
#line 116 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_vala_assert (_tmp9_ == 1, "expected_events.length == 1");
#line 118 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _quit_main_loop_gsource_func, NULL, NULL);
#line 119 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	g_main_loop_run (_data3_->mainloop);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (su);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (ev);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	block3_data_unref (_data3_);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_data3_ = NULL;
#line 899 "log-test.c"
}


void
get_default_test (void)
{
	ZeitgeistLog* log1 = NULL;
	ZeitgeistLog* _tmp0_;
	ZeitgeistLog* log2 = NULL;
	ZeitgeistLog* _tmp1_;
#line 124 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = zeitgeist_log_get_default ();
#line 124 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	log1 = _tmp0_;
#line 125 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = zeitgeist_log_get_default ();
#line 125 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	log2 = _tmp1_;
#line 126 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_vala_assert (log1 == log2, "log1 == log2");
#line 122 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (log2);
#line 122 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (log1);
#line 924 "log-test.c"
}



