/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.ServerDescriptor;
import IceGrid.ServerInstanceDescriptor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.Node;
import IceGridGUI.Application.PlainServer;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.UpdateFailedException;
import javax.swing.JOptionPane;

abstract class AbstractServerEditor
extends Editor {
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractServerEditor() {
    }

    protected abstract void writeDescriptor();

    protected abstract boolean isSimpleUpdate();

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Server Properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyUpdate() {
        Root root = this._target.getRoot();
        Server server = (Server)((Object)this._target);
        root.disableSelectionListener();
        try {
            if (this._target.isEphemeral()) {
                Node node = (Node)this._target.getParent();
                this.writeDescriptor();
                this._target.destroy();
                try {
                    if (server instanceof PlainServer) {
                        node.tryAdd((ServerDescriptor)server.getDescriptor(), true);
                    } else {
                        node.tryAdd((ServerInstanceDescriptor)server.getDescriptor(), true);
                    }
                }
                catch (UpdateFailedException e) {
                    block21: {
                        try {
                            node.insertServer(this._target, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block21;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                this._target = node.findChildWithDescriptor(server.getDescriptor());
                root.updated();
                root.setSelectedNode(this._target);
            } else if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                root.updated();
                server.getEditable().markModified();
            } else {
                Object savedDescriptor = server.saveDescriptor();
                Node node = (Node)this._target.getParent();
                this.writeDescriptor();
                node.removeServer(this._target);
                try {
                    if (server instanceof PlainServer) {
                        node.tryAdd((ServerDescriptor)server.getDescriptor(), false);
                    } else {
                        node.tryAdd((ServerInstanceDescriptor)server.getDescriptor(), false);
                    }
                }
                catch (UpdateFailedException e) {
                    block22: {
                        try {
                            node.insertServer(this._target, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block22;
                            throw new AssertionError();
                        }
                    }
                    server.restoreDescriptor(savedDescriptor);
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                node.getEditable().removeElement(this._target.getId(), server.getEditable(), Server.class);
                this._target = node.findChildWithDescriptor(server.getDescriptor());
                root.updated();
                root.setSelectedNode(this._target);
            }
            root.getCoordinator().getCurrentTab().showNode(this._target);
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    static {
        $assertionsDisabled = !AbstractServerEditor.class.desiredAssertionStatus();
    }
}

