/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.ObjectPrx;
import IceGrid.AdapterDescriptor;
import IceGrid.AdapterDynamicInfo;
import IceGrid.AdminSessionPrx;
import IceGrid.DbEnvDescriptor;
import IceGrid.DeploymentException;
import IceGrid.FileIteratorPrx;
import IceGrid.FileIteratorPrxHelper;
import IceGrid.FileNotAvailableException;
import IceGrid.NodeUnreachableException;
import IceGrid.PropertySetDescriptor;
import IceGrid.ServerNotExistException;
import IceGrid.ServiceDescriptor;
import IceGrid.ServiceInstanceDescriptor;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.Adapter;
import IceGridGUI.LiveDeployment.DbEnv;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ListArrayTreeNode;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.Server;
import IceGridGUI.LiveDeployment.ServiceEditor;
import IceGridGUI.LiveDeployment.ShowLogDialog;
import IceGridGUI.Utils;
import java.awt.Component;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Service
extends ListArrayTreeNode {
    private final ServiceInstanceDescriptor _instanceDescriptor;
    private final ServiceDescriptor _serviceDescriptor;
    private final PropertySetDescriptor _serverInstancePSDescriptor;
    private final Utils.Resolver _resolver;
    private final List _adapters = new LinkedList();
    private final List _dbEnvs = new LinkedList();
    private static ServiceEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[19];
        if (((Server)this._parent).getState() != null) {
            actions[14] = this._serviceDescriptor.logs.length > 0;
        }
        return actions;
    }

    public void retrieveLog() {
        if (!$assertionsDisabled && this._serviceDescriptor.logs.length <= 0) {
            throw new AssertionError();
        }
        String path = null;
        if (this._serviceDescriptor.logs.length == 1) {
            path = this._resolver.substitute(this._serviceDescriptor.logs[0]);
        } else {
            Object[] pathArray = new Object[this._serviceDescriptor.logs.length];
            for (int i = 0; i < this._serviceDescriptor.logs.length; ++i) {
                pathArray[i] = this._resolver.substitute(this._serviceDescriptor.logs[i]);
            }
            path = (String)JOptionPane.showInputDialog(this.getCoordinator().getMainFrame(), "Which log file do you want to retrieve?", "Retrieve Log File", 3, null, pathArray, pathArray[0]);
        }
        if (path != null) {
            final String fPath = path;
            this.getRoot().openShowLogDialog(new ShowLogDialog.FileIteratorFactory(){

                public FileIteratorPrx open(int count) throws FileNotAvailableException, ServerNotExistException, NodeUnreachableException, DeploymentException {
                    AdminSessionPrx session = Service.this.getRoot().getCoordinator().getSession();
                    FileIteratorPrx result = session.openServerLog(Service.this._parent.getId(), fPath, count);
                    if (Service.this.getRoot().getCoordinator().getCommunicator().getDefaultRouter() == null) {
                        result = FileIteratorPrxHelper.uncheckedCast(result.ice_endpoints(session.ice_getEndpoints()));
                    }
                    return result;
                }

                public String getTitle() {
                    return "Service " + Service.this._parent.getId() + "/" + Service.this._id + " " + new File(fPath).getName();
                }

                public String getDefaultFilename() {
                    return new File(fPath).getName();
                }
            });
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/service.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/service.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new ServiceEditor();
        }
        _editor.show(this);
        return _editor;
    }

    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(14));
        }
        la.setTarget(this);
        return _popup;
    }

    Service(Server parent, String serviceName, Utils.Resolver resolver, ServiceInstanceDescriptor descriptor, ServiceDescriptor serviceDescriptor, PropertySetDescriptor serverInstancePSDescriptor) {
        super(parent, serviceName, 2);
        this._resolver = resolver;
        this._instanceDescriptor = descriptor;
        this._serviceDescriptor = serviceDescriptor;
        this._serverInstancePSDescriptor = serverInstancePSDescriptor;
        this._childrenArray[0] = this._adapters;
        this._childrenArray[1] = this._dbEnvs;
        this.createAdapters();
        this.createDbEnvs();
    }

    boolean updateAdapter(AdapterDynamicInfo info) {
        Iterator p = this._adapters.iterator();
        while (p.hasNext()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(info)) continue;
            return true;
        }
        return false;
    }

    int updateAdapters(List infoList) {
        int result = 0;
        Iterator p = this._adapters.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(infoList)) continue;
            ++result;
        }
        return result;
    }

    void nodeDown() {
        Iterator p = this._adapters.iterator();
        while (p.hasNext()) {
            Adapter adapter = (Adapter)p.next();
            adapter.update((AdapterDynamicInfo)null);
        }
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    ServiceDescriptor getServiceDescriptor() {
        return this._serviceDescriptor;
    }

    SortedMap getProperties() {
        LinkedList<Utils.ExpandedPropertySet> psList = new LinkedList<Utils.ExpandedPropertySet>();
        Node node = (Node)this._parent.getParent();
        String applicationName = ((Server)this._parent).getApplication().name;
        psList.add(node.expand(this._serviceDescriptor.propertySet, applicationName, this._resolver));
        if (this._instanceDescriptor != null) {
            psList.add(node.expand(this._instanceDescriptor.propertySet, applicationName, this._resolver));
        }
        if (this._serverInstancePSDescriptor != null) {
            psList.add(node.expand(this._serverInstancePSDescriptor, applicationName, this._resolver));
        }
        return Utils.propertySetsToMap(psList, this._resolver);
    }

    private void createAdapters() {
        Iterator p = this._serviceDescriptor.adapters.iterator();
        while (p.hasNext()) {
            AdapterDescriptor descriptor = (AdapterDescriptor)p.next();
            String adapterName = Utils.substitute(descriptor.name, this._resolver);
            String adapterId = Utils.substitute(descriptor.id, this._resolver);
            ObjectPrx proxy = null;
            if (adapterId.length() > 0) {
                proxy = ((Node)this._parent.getParent()).getProxy(adapterId);
            }
            this.insertSortedChild(new Adapter(this, adapterName, this._resolver, adapterId, descriptor, proxy), this._adapters, null);
        }
    }

    private void createDbEnvs() {
        Iterator p = this._serviceDescriptor.dbEnvs.iterator();
        while (p.hasNext()) {
            DbEnvDescriptor descriptor = (DbEnvDescriptor)p.next();
            String dbEnvName = Utils.substitute(descriptor.name, this._resolver);
            this.insertSortedChild(new DbEnv(this, dbEnvName, this._resolver, descriptor), this._dbEnvs, null);
        }
    }

    static {
        $assertionsDisabled = !Service.class.desiredAssertionStatus();
    }
}

