// **********************************************************************
//
// Copyright (c) 2003-2011 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

#ifndef SERVERPRIVATE_AMD_ICE
#define SERVERPRIVATE_AMD_ICE

[["java:package:test.Ice.slicing.exceptions.serverAMD"]]
module Test
{

// Duplicate types from Test.ice. We cannot use #include since
// that will use the types from the same prefix.
exception Base
{
    string b;
};

exception KnownDerived extends Base
{
    string kd;
};

exception KnownIntermediate extends Base
{
    string ki;
};

exception KnownMostDerived extends KnownIntermediate
{
    string kmd;
};

["amd"] interface TestIntf
{
    void baseAsBase() throws Base;
    void unknownDerivedAsBase() throws Base;
    void knownDerivedAsBase() throws Base;
    void knownDerivedAsKnownDerived() throws KnownDerived;

    void unknownIntermediateAsBase() throws Base;
    void knownIntermediateAsBase() throws Base;
    void knownMostDerivedAsBase() throws Base;
    void knownIntermediateAsKnownIntermediate() throws KnownIntermediate;
    void knownMostDerivedAsKnownIntermediate() throws KnownIntermediate;
    void knownMostDerivedAsKnownMostDerived() throws KnownMostDerived;

    void unknownMostDerived1AsBase() throws Base;
    void unknownMostDerived1AsKnownIntermediate() throws KnownIntermediate;
    void unknownMostDerived2AsBase() throws Base;

    void shutdown();
};

// Additional server specific types (used for testing slicing).

exception UnknownDerived extends Base
{
    string ud;
};

exception UnknownIntermediate extends Base
{
   string ui;
};

exception UnknownMostDerived1 extends KnownIntermediate
{
   string umd1;
};

exception UnknownMostDerived2 extends UnknownIntermediate
{
   string umd2;
};

};

#endif
