/*____________________________________________________________________________

        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: mkdatabase.cpp,v 1.1 2003/09/16 17:58:14 kgk Exp $
____________________________________________________________________________*/

#include <assert.h>
#include <set>
#include <algorithm>

#include <boost/format.hpp>

#include "mkdatabase.h"

using namespace std;
using boost::format;


vector<string> MKDatabase::supported_tags;




MKDatabase::MKDatabase(const string&dbpath)
    : m_pUrl("url")
{
    string dbview;
    vector<string>::iterator tag;

    copy(Metadata::kStandardTags.begin(),
         Metadata::kStandardTags.end(),
         inserter(supported_tags, supported_tags.end()));

    bool firsttime = !(access (dbpath.c_str(), F_OK) == 0);

    m_database = new c4_Storage (dbpath.c_str(), true);
    log(format("opened %s with %d") %dbpath % m_database->GetSize());
    if (firsttime) {
        string taglist;
        for (tag = supported_tags.begin(); tag != supported_tags.end(); ++tag){
            if (taglist.size()) taglist+=',';
            taglist += *tag;
            taglist += ":S";
        }
        dbview = "dbview[";
        dbview += taglist;
        dbview += "]";

        m_database->SetStructure(dbview.c_str());
        m_database->Commit();
        log(format("creating new mkdatabase: %s with %s") % dbpath % dbview);
    } else {
        dbview = m_database->Description();
    }
    m_dbview = m_database->GetAs (dbview.c_str());

    // Speed up URL searches by hashing:  ASSUMES kUrl is first key.
    assert (supported_tags[0] == Metadata::kUrl);
    m_hash   = m_database->GetAs ("dbview_H1[_H:I,_R:I]");
    m_dbhash = m_dbview.Hash(m_hash, 1);

    // Initialize property map.
    for (tag = supported_tags.begin(); tag != supported_tags.end(); ++tag) {
        m_propmap.insert(propmap_type::value_type(*tag,
                                                  c4_StringProp((*tag).c_str())));
    }


}

MKDatabase::~MKDatabase()
{
    m_database->Commit();

    // Force the view to be killed (metakit tips and tricks).
    m_dbview = c4_View();
    m_hash = c4_View();
    m_dbhash = c4_View();

    if (m_database)
        delete m_database;
}

bool MKDatabase::add(const url_t& url, const Metadata&md)
{
    fprintf(stderr, "MKDatabase::add\n");

    setMetadata(url, md);

    return true;
}
bool MKDatabase::remove(const url_t& url)
{
    int index = m_dbview.Find (m_pUrl [url.c_str()]);
    if (index >= 0) {
        m_dbhash.RemoveAt (index);
        return true;
    }
    return false;
}
bool MKDatabase::contains(const url_t&url)
{
    int index = m_dbhash.Find (m_pUrl [url.c_str()]);
    if (index >= 0) {
        return true;
    }
    return false;
}
bool MKDatabase::getMetadata(const url_t&url, Metadata&m)
{
    log(string("MKDatabase::getMetadata : ")+ url);

    int index = m_dbhash.Find (m_pUrl [url.c_str()]);
    if (index >= 0) {
        c4_RowRef row = m_dbhash[index];
        propmap_type::iterator pi = m_propmap.begin();

        for (; pi != m_propmap.end(); pi++) {
            const string&  tag  = (*pi).first;
            c4_StringProp& prop = (*pi).second;

            m[tag] = prop(row);
        }
        return true;
    }
    return false;
}

bool MKDatabase::setMetadata(const url_t&url, const Metadata&m)
{
    c4_Row row;

    // For each supported tag get the element of metadata
    // and assign to row.
    vector<string>::iterator tag;
    string val;
    for (tag = supported_tags.begin(); tag != supported_tags.end(); ++tag) {
        propmap_type::iterator pi = m_propmap.find(*tag);
        c4_StringProp& prop = (*pi).second;

        if (m.hasKey(*tag)) {
            m.getTag(*tag, val);
            prop(row) = val.c_str();

            //log(format("adding %s : %s") % *tag % val);
        }
    }
    m_pUrl(row) = url.c_str();

    int index = m_dbhash.Find (m_pUrl [url.c_str()]);
    if (index >= 0) 
        m_dbhash[index] = row;
    else
        m_dbhash.Add (row);
    
    return true;
}
Error MKDatabase::query(const std::string& target, 
                        const params_t& params, 
                        result_t& results)
{
    // Create a row from the passed parameters
    c4_Row searchrow;

    params_t::const_iterator pi = params.begin();
    for (; pi != params.end(); pi++) {
        const string& tag = (*pi).first;
        const string& val = (*pi).second;
        
        propmap_type::iterator pi = m_propmap.find(tag);
        c4_StringProp& prop = (*pi).second;

        searchrow.ConcatRow(prop[val.c_str()]);
    }

    // Find the view with the set paramaters.

    c4_View found = m_dbhash.Select(searchrow);

    // Create the result set.
    set<string>  resultset;
    c4_StringProp prop (target.c_str());
    for (int32_t index = 0; index < found.GetSize(); index++) {
        resultset.insert (string(prop(found[index])));
    }

    // Copy the final set to the resultlist.
    copy(resultset.begin(), resultset.end(), inserter(results, results.end()));

    return kError_NoErr;
}


void MKDatabase::commit()
{
    m_database->Commit();
}


/* arch-tag: a34adca4-ba5c-423e-9fca-c27b4824547f */
