/* htmlmodify_jp2.l - part of ziproxy package
 * 2002 Juraj Variny<variny@naex.sk>
 *
 * Released subject to GNU General Public License
 *
 * HTML modification, text compression fuctions
 */
%{
#include <string.h>
#include <stdlib.h>
#include <unistd.h> //for off_t
#include <assert.h>
#include <stdio.h>
#include <zlib.h>

#include "text.h"

const char suff[] = ".or_jp2";

static int n, outsize;


#define YY_DECL int htmlmodify_yylex(char ** outbuf, gzFile gzfile, int out_type)

#define CHUNKSIZE 4050

#define MY_YY_OUTPUT(buf, size) \
{\
	if ((size == 1) && n + 1 < outsize){\
		(*outbuf)[n] = *buf;\
		n++;\
	}else if(outsize > size + n) {\
		memcpy(*outbuf + n, buf, size);\
		n += size;\
	}else switch(out_type){\
		case OChunked: \
			fprintf(stdout, "%X\r\n", size + n);\
		case OStream:\
			fwrite(*outbuf, n, 1, stdout);\
			fwrite(buf, size, 1, stdout);\
			if (out_type == OChunked) fputs("\r\n", stdout);\
			n = 0;\
			break;\
		case ONormal: {\
			char *new_outbuf;\
			outsize = (size + n)*1.1;\
			new_outbuf = malloc(outsize);\
			memcpy(new_outbuf, *outbuf, n);\
			memcpy(new_outbuf + n, buf, size);\
			n += size;\
			free(*outbuf);\
			*outbuf = new_outbuf;\
			break;\
			}\
		case OGzipStream: \
			gzwrite(gzfile, *outbuf, n);\
			gzwrite(gzfile, buf, size);\
			n = 0;\
			break;\
		default: assert("Invalid out_type parameter to htmlmodify()!\n");\
	}\
}

#define DEFAULT_OUT MY_YY_OUTPUT(yytext, yyleng)
#define MAX_ATTRS 20
#define SAVE_ORIG() strcat(original_tag, yytext)

%}

%option prefix="htmlmodify_yy"
%option never-interactive
%option noyywrap
%option nounput
%option caseless
%option stack

%s TAG

%x IMG_SRC
%x IMG_PARAM
%x SCRIPT
%x STRING
%x STRING_SQ
%x STRING_DQ



IMGSRC src[[:space:]]*=[[:space:]]*
IMGWH (width|height)[[:space:]]*=[[:space:]]*[\"'[:digit:]]+[[:space:]]* /* not used currently */
IMGPARAM [[:alpha:]]+[[:space:]]*=

%%


	char img_src[100] = "";
	char *img_param[MAX_ATTRS];
	char *img_vals[MAX_ATTRS];
	int params = 0;
	char img_wh[100] = "";
	char original_tag[4096] = "";


\<img[[:space:]]+	{
		SAVE_ORIG();
		yy_push_state(TAG);
		}

\<script[[:space:]]+	{
		fputs("Script\n", stderr);
		yy_push_state(SCRIPT);
		DEFAULT_OUT;
		}

<SCRIPT><\/script>	{
		fputs("End script\n", stderr);
		yy_pop_state();
		DEFAULT_OUT;
		}

<SCRIPT>.|\n	{
		DEFAULT_OUT;
		}

		
<TAG>\> 	{
		SAVE_ORIG();
		char *objtag;
		int i;
		yy_pop_state();
			objtag = IMGtoOBJ(img_src, original_tag,params, img_param, img_vals);
			img_src[0] = '\0';
			for(i = 0; i < params; i++) {
				free(img_param[i]);
				img_param[i] = NULL;
				free(img_vals[i]);
				img_vals[i] = NULL;
			}
			params = 0;
			i = strlen(objtag);
			fprintf(stderr, "Objtag: %s\n",objtag);
			MY_YY_OUTPUT(objtag, i);
			original_tag[0] = '\0';
		}
		
			
<IMG_PARAM>[[:space:]]*/[^[:space:]\"']	|
<TAG>{IMGSRC}	{ 
		SAVE_ORIG();
			yy_push_state(STRING);
		}
		
<IMG_PARAM>[[:space:]]*\"	|
<TAG>{IMGSRC}\"	{
		SAVE_ORIG();
			yy_push_state(STRING_DQ);
		}
		
<IMG_PARAM>[[:space:]]*'	|
<TAG>{IMGSRC}'	{
		SAVE_ORIG();
			yy_push_state(STRING_SQ);
		}


<TAG>{IMGPARAM} {
		SAVE_ORIG();
			img_param[params] = malloc(yyleng);
			strncpy(img_param[params], yytext, yyleng - 1);
			img_param[params][yyleng - 1] = '\0';
			fprintf(stderr, "Par: %s\n",img_param[params]);
			yy_push_state(IMG_PARAM);
		}
			
		
		
<TAG>[[:space:]]* {
		SAVE_ORIG();
}
		
 /*		<STRING_SQ>\\'	|
	<STRING_DQ>\\\"	{
		SAVE_ORIG();
				yymore();
			}*/

<STRING>[^[:space:]>]*[[:space:]>] |
<STRING_SQ>[^']*'		|
<STRING_DQ>[^"]*\"		{
		SAVE_ORIG();
		switch(yy_top_state()){
		case IMG_PARAM:
			img_vals[params] = malloc(yyleng);
			strncpy(img_vals[params], yytext, yyleng - 1);
			img_vals[params][yyleng - 1] = '\0';
			fprintf(stderr, "Val: %s\n",img_vals[params]);
			yy_pop_state(); //out of IMG_PARAM
			params++;
			break;
		case TAG:
			strncpy(img_src, yytext, yyleng - 1);
			img_src[yyleng - 1] = '\0';
			fprintf(stderr, "Src: %s\n",img_src);
			break;
		}
		yy_pop_state();
		if(yytext[yyleng- 1] == '>'){
			original_tag[strlen(original_tag) - 1 ] = '\0';	
			yyless(yyleng - 1);//rescan '>' and end tag properly
			}
		}

\<[^[:space:]<]+[[:space:]]*	|
[^<=>'\"[:space:]]+[[:space:]]*	| 

[\0-\xff]	DEFAULT_OUT;

<IMG_SRC,STRING,STRING_SQ,STRING_DQ,SCRIPT><<EOF>>	|
<<EOF>>			yyterminate();

%%

#undef DEFAULT_OUT
#undef MY_YY_OUTPUT
int htmlmodify(char* inbuf, char** outbuf, int out_type)
{
	gzFile gzfile =(gzFile)0;
	
	if(out_type == ONormal)	outsize = strlen(inbuf) * 1.1;
	else outsize = CHUNKSIZE;
	
	*outbuf = malloc(outsize);
	
	if(out_type == OGzipStream)
	{
		if((gzfile = gzdopen(dup(1), "wb9")) == Z_NULL) return 2;
		
	}

	htmlmodify_yy_scan_string(inbuf);

	htmlmodify_yylex(outbuf, gzfile, out_type);

	free(inbuf);

	switch(out_type){
	case OChunked:	if(n > 0)
		{
			printf("%X\r\n", n);
			fwrite(*outbuf, n, 1, stdout);
			free(*outbuf);
		}
		fputs("\r\n0\r\n", stdout);
		break;
	case ONormal: (*outbuf)[n]= '\0';
		break;
	case OGzipStream: 
		if(n > 0)
			gzwrite(gzfile, *outbuf, n);

		gzclose(gzfile);
		break;
	case OStream: if (n > 0)
		fwrite(*outbuf, n, 1, stdout);
		break;
	}

	return 0;
}
