/*
 * rename.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

int rename(__const char *file_name1, __const char *file_name2)
{
  int st;
  char newname1[MAXPATHLEN + MAXEXTLEN + 1];
  char newname2[MAXPATHLEN + MAXEXTLEN + 1];
  struct STAT32 buf;

  st = zlib_real_rename(file_name1, file_name2);

  if ( st >= 0 || errno != ENOENT )
    return st;

  zlib_initialise();
  if ( zlib_mode & CM_DISAB )
    return st;
  if ( (zlib_getfiletype(file_name1,-1) & PM_READ_MASK) == PM_LEAVE_COMPR)
    return st;
  
  strncpy(newname1,file_name1,1024);
  strcat(newname1,zlib_ext);
  
  strncpy(newname2,file_name2,1024);
  strcat(newname2,zlib_ext);
  
  errno = 0;
  st = zlib_real_rename(newname1, newname2);
  if ( st >= 0 || errno != EINVAL )
    return st;

  /* we have EINVAL. Does this come from the source or the target ? */
  st = ___zlibc_lstat(newname1, &buf);
  if ( st >= 0 ){
    /* old name exists. EINVAL is caused by target. keep it */
    errno = EINVAL ;
    return -1;
  } else
    return -1;  
  /* else the old name does not exist. return ENOENT (is already there) */    
}
