/*
 * smv.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define SLN
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

/*
 * statically linked mv, ln and symlink replacement.
 * Should be used when the libraries get hosed
 */


/* prototypes for those platforms where they might be missing */
int rename();
int symlink();

struct commands {
  char *name;
  int (*command)( __const char* old, __const char *new);
} table[] = {
  { "mv", rename },
  { "move", rename },
  { "rename", rename },
  { "sln", symlink },
  { "symlink", symlink },
  { "ln", link },
  { "link", link },
  { 0, 0} 
};

static void usage(char *prog)
{
  printf("Usage: %s old-name new-name\n", prog);
  exit(1);
}


int main(int argc, char **argv)
{
  char *command,*old,*new,*prog,*tmp;
  struct commands *ptr;

  prog = argv[0];
  tmp=strrchr(argv[0],'/');
  if(tmp)
    prog=tmp+1;
  switch(argc){
  case 3:
    command = prog+1;
    break;
  case 4:
    command = argv[1];
    argv++;
    break;
  default:
    usage(prog);
    return;
  }

  old = argv[1];
  new = argv[2];
  for(ptr = table; ptr->name; ptr++)
    if ( !strcmp(ptr->name, command))
      break;
  if ( !ptr->name )
    usage(prog);
  
  if(ptr->command(old, new) >= 0)
    exit(0);

  if (errno != EEXIST )
    perror(command);

  unlink(new);
  if(ptr->command(old, new) < 0)
    perror(command);

  return;
}

