##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
Revision information:
$Id: __init__.py,v 1.5 2002/07/21 22:36:46 chrism Exp $
"""

from BackTalk import BackTalkDocument, addDocumentForm, addDocument
from BackTalk import BackTalkBook, addBookForm, addBook

def initialize(context):
    context.registerClass(
        BackTalkDocument,
        permission='Add BackTalk Documents',
        constructors=(addDocumentForm,
                      addDocument),
        icon='www/backtalk.gif',
        )
    context.registerClass(
        BackTalkBook,
        permission='Add BackTalk Documents',
        constructors=(addBookForm,
                      addBook),
        icon='www/backtalk.gif',
        )

    """ register some simple example colorizers.
    In order to *not* get colorized examples by default, change
    registerDefault to 'simple_example' """

    from ExampleRegistry import example_registry
    from DefaultColorizers import tokenized_example, simple_example
    from DefaultColorizers import is_debugger

    example_registry.registerDefault(simple_example)
    example_registry.register(is_debugger, simple_example, 1)
    context.registerHelp()
    context.registerHelpTitle("BackTalk")
