import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Products.CMFMember.tests import CMFMemberTestCase
from unittest import TestSuite, makeSuite
from Products.CMFMember.storages import userfolderstorage
from Products.CMFMember.Extensions.Workflow import triggerAutomaticTransitions

class TestExternalStorages(CMFMemberTestCase.CMFMemberTestCase):

    def testRegisterExternalStorages(self):
        tmpUser = self.membership.getMemberById(self.portal_user_info['id'])
        storage = userfolderstorage.UserFolderStorage()
        tmpUser.getField('email').setStorage(tmpUser, storage)
        tmpUser.externalStorage = True
        tmpUser.setEmail('foo@bar.com')
        # We should have one storage ready for syncronization
        self.failUnless(len(tmpUser.externalStorages) == 1)
        triggerAutomaticTransitions(tmpUser)            
        tmpUser._updateExternalStorages()
        # All storages are syncronized
        self.failUnless(len(tmpUser.externalStorages) == 0)

def test_suite():
    suite = TestSuite()
    suite.addTest(makeSuite(TestExternalStorages))
    return suite


if __name__ == '__main__':
   framework(verbosity=1)
