# configuration for the ExtFile/ExtImage file repository

# repository location and umask

REPOSITORY_PATH = ['static','reposit']  # path to files (below INSTANCE_HOME)
REPOSITORY_UMASK = 022

# repository directory structure

FLAT = 0                # all files reside in the reposit directory
SYNC_ZODB = 1           # directories copy the ZODB folder structure
SLICED = 2              # sliced directories from ZOPEID
SLICED_REVERSE = 3      # sliced directories from reverse ZOPEID
SLICED_HASH = 4         # sliced directories from hash of ZOPEID

REPOSITORY = SLICED_HASH

PHYSICAL = 0            # SYNC_ZODB uses physical path
VIRTUAL = 1             # SYNC_ZODB uses path relative to virtual root

ZODB_PATH = VIRTUAL

SLICE_WIDTH = 1         # SLICED* uses this many characters per slice
SLICE_DEPTH = 2         # SLICED* goes this many slices (directories) deep

# repository file name handling

# %u=user, %p=path, %n=file name, %e=file extension, %c=counter, %t=time
FILE_FORMAT = "%n%c%e"

DISABLED = 0            # allow file names to begin with 'copy_of_'
ENABLED = 1             # remove 'copy_of_' prefixes from file names

COPY_OF_PROTECTION = ENABLED

# repository file extension handling

ZOPEID = 0              # use ZOPEID (even if it doesn't include an extension)
MIMETYPE_APPEND = 1     # append extension to ZOPEID according to mimetype
MIMETYPE_REPLACE = 2    # remove extension from ZOPEID, then append mime extension

REPOSITORY_EXTENSIONS = MIMETYPE_REPLACE

# repository undo policy

BACKUP_ON_DELETE = 0    # create a .undo copy only when a file is deleted 
ALWAYS_BACKUP = 1       # create a .undo copy (and a new filename) whenever 
                        # a file is uploaded or otherwise modified

UNDO_POLICY = BACKUP_ON_DELETE

