##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################

"""Implementation of the DOM Level 3 'Load' feature."""

import Core
import ExpatBuilder

import copy
import string
import xml.dom


__all__ = ["DOMBuilder", "DOMEntityResolver", "DOMInputSource"]


class DOMBuilder(Core.AttributeControl):
    entityResolver = None
    errorHandler = None
    filter = None

    def __init__(self):
        self.__dict__['_options'] = ExpatBuilder.Options()

    def _get_entityResolver(self):
        return self.entityResolver
    def _set_entityResolver(self, entityResolver):
        self.__dict__['entityResolver']

    def _get_errorHandler(self):
        return self.errorHandler
    def _set_errorHandler(self, errorHandler):
        self.__dict__['errorHandler'] = errorHandler

    def _get_filter(self):
        return self.filter
    def _set_filter(self, filter):
        self.__dict__['filter'] = filter

    def setFeature(self, name, state):
        if self.supportsFeature(name):
            try:
                settings = self._settings[(_name_xform(name), state)]
            except KeyError:
                raise xml.dom.NotSupportedErr(
                    "unsupported feature: " + `name`)
            else:
                for name, value in settings:
                    setattr(self._options, name, value)
        else:
            raise xml.dom.NotFoundErr("unknown feature: " + `name`)        

    def supportsFeature(self, name):
        return hasattr(self._options, _name_xform(name))

    def canSetFeature(self, name, state):
        key = (_name_xform(name), state and 1 or 0)
        return self._settings.has_key(key)

    _settings = {
        ("namespaces", 0): [("namespaces", 0)],
        ("namespaces", 1): [("namespaces", 1)],
        ("namespace_declarations", 0): [("namespace_declarations", 0)],
        ("namespace_declarations", 1): [("namespace_declarations", 1)],
        ("validation", 0): [("validation", 0)],
        ("external_general_entities", 0): [("external_general_entities", 0)],
        ("external_general_entities", 1): [("external_general_entities", 1)],
        ("external_parameter_entities", 0): [("external_parameter_entities", 0)],
        ("external_parameter_entities", 1): [("external_parameter_entities", 1)],
        ("validate_if_cm", 0): [("validate_if_cm", 0)],
        ("create_entity_ref_nodes", 0): [("create_entity_ref_nodes", 0)],
        ("create_entity_ref_nodes", 1): [("create_entity_ref_nodes", 1)],
        ("entity_nodes", 0): [("create_entity_ref_nodes", 0),
                              ("entity_nodes", 0)],
        ("entity_nodes", 1): [("entity_nodes", 1)],
        ("white_space_in_element_content", 0):
            [("white_space_in_element_content", 0)],
        ("white_space_in_element_content", 1):
            [("white_space_in_element_content", 1)],
        ("cdata_nodes", 0): [("cdata_nodes", 0)],
        ("cdata_nodes", 1): [("cdata_nodes", 1)],
        ("comments", 0): [("comments", 0)],
        ("comments", 1): [("comments", 1)],
        ("charset_overrides_xml_encoding", 0):
            [("charset_overrides_xml_encoding", 0)],
        ("charset_overrides_xml_encoding", 1):
            [("charset_overrides_xml_encoding", 1)],
    }

    def getFeature(self, name):
        try:
            return getattr(self._options, _name_xform(name))
        except AttributeError:
            raise xml.dom.NotFoundErr()

    def parseURI(self, uri):
        if self.entityResolver:
            input = self.entityResolver.resolveEntity(None, uri)
        else:
            input = DOMEntityResolver().resolveEntity(None, uri)
        return self.parseDOMInputSource(input)

    def parseDOMInputSource(self, input):
        options = copy.copy(self._options)
        options.filter = self.filter
        options.errorHandler = self.errorHandler
        fp = input.byteStream
        if fp is None and options.systemId:
            import urllib
            fp = urllib.urlopen(input.systemId)
        builder = ExpatBuilder.makeBuilder(options)
        return builder.parseFile(fp)


class DOMEntityResolver(Core.DOMImplementation):
    def resolveEntity(self, publicId, systemId):
        source = DOMInputSource()
        source.publicId = publicId
        source.systemId = systemId
        if systemId:
            import urllib
            self.byteStream = urllib.urlopen(systemId)
            # Should parse out the content-type: header to
            # get charset information so that we can set the
            # encoding attribute on the DOMInputSource.
        return source


class DOMInputSource(Core.AttributeControl):
    byteStream = None
    characterStream = None
    encoding = None
    publicId = None
    systemId = None

    def _get_byteStream(self):
        return self.byteStream
    def _set_byteStream(self, byteStream):
        self.__dict__['byteStream'] = byteStream

    def _get_characterStream(self):
        return self.characterStream
    def _set_characterStream(self, characterStream):
        self.__dict__['characterStream'] = characterStream

    def _get_encoding(self):
        return self.encoding
    def _set_encoding(self, encoding):
        self.__dict__['encoding'] = encoding

    def _get_publicId(self):
        return self.publicId
    def _set_publicId(self, publicId):
        self.__dict__['publicId'] = publicId

    def _get_systemId(self):
        return self.systemId
    def _set_systemId(self, systemId):
        self.__dict__['systemId'] = systemId


class DOMBuilderFilter:
    """Element filter which can be used to tailor construction of
    a DOM instance.
    """

    # There's really no need for this class; concrete implementations
    # should just implement the endElement() method as appropriate.

    def endElement(self, element):
        # Why this method is supposed to return anything at all
        # is a mystery; the result doesn't appear to be used.
        return 1


def _name_xform(name):
    return string.replace(string.lower(name), '-', '_')
