##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""PloneArticle"""
import AccessControl.Permissions
import PloneArticle
import PloneArticleTool

from global_symbols import *

from AccessControl.Permissions import *


from Products.CMFCore.DirectoryView import registerDirectory
from Products.CMFCore import utils, CMFCorePermissions

registerDirectory('skins', globals())
registerDirectory('skins/PloneArticle', globals())

install_globals = globals()          # Used only in the Extensions/Install.py script


# Classes & constructors declaration
contentClasses = (PloneArticle.PloneArticle, )
contentConstructors = (PloneArticle.addPloneArticle, )


# Initialization method
def initialize(context):
    utils.ContentInit(
        'PloneArticle',
        content_types = contentClasses,
        permission = PloneArticle_addPermission,
        extra_constructors = contentConstructors,
        fti = (PloneArticle.factory_type_information,),
        ).initialize(context)

    context.registerClass(
        PloneArticleTool.PloneArticleTool,
        meta_type="PloneArticle Tool",
        constructors=(PloneArticleTool.addPloneArticleTool,),
        icon = 'tool.gif')
