# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: IAttachment.py,v 1.5 2006/07/20 10:01:39 glenfant Exp $
"""
__author__  = ''
__docformat__ = 'restructuredtext'

from Interface import Attribute
try:
    from Interface import Interface
except ImportError:
    # for Zope versions before 2.6.0
    from Interface import Base as Interface

class IAttachmentContents(Interface):
    """To write
    """
    
    pass

class IAttachmentReferenceBrain(Interface):
    """Attachment brain structure :
       - title
       - description
       - object
    """
    
    def getTitle(self):
        """
        Get title.
        STORED IN REFERENCE.
        """
        
    def getDescription(self):
        """
        Get description.
        STORED IN REFERENCE.
        """
        
    def getObject(self):
        """
        Returns object.
        """
        
    def setTitle(self, title):
        """
        Set title.
        STORED IN REFERENCE.
        """
        
    def setDescription(self, description):
        """
        Set description.
        STORED IN REFERENCE.
        """
