## Controller Python Script "plonearticle_attachment_delete"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind state=state
##bind subpath=traverse_subpath
##parameters=title=None, items=[]
##title=Delete attachments

# define the charset : useful for utf-8 sites using translate.py (see for something smarter)
from Products.CMFCore.utils import getToolByName
charset = getToolByName(context, 'portal_properties')['site_properties'].default_charset
context.REQUEST.RESPONSE.setHeader('Content-Type','text/html; charset=%s'%charset)

message=""

context.removeAttachments(items)
if len(items) > 1:
  #message="%d attachments deleted" % len(attachs)
  attachCount = len(items)
  message = context.translate(
              domain='plonearticle', msgid='message_attachments_deleted',
              mapping={'attach_count': attachCount, }, 
              default = '%d attachments deleted.'%(attachCount)
            )
   
elif len(items) == 1:
  #message="Attachment deleted"
  message = context.translate(
                domain='plonearticle', msgid='message_attachment_deleted',
                mapping={}, 
                default = 'Attachment deleted.'
             )
   
else:
  #message="No attachments selected for deletion."
  message = context.translate(
               domain='plonearticle', msgid='message_delete_attachment_none_selected',
               mapping={}, 
               default = 'No attachment selected for deletion.'
            )

return state.set(status='success',\
                 context=context,\
                 portal_status_message=message)


