###################################################################################################
# zmslinkcontainer.py
#
# $Id: zmslinkcontainer.py,v 1.4 2004/02/24 19:57:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.4 $
#
# Implementation of class ZMSLinkContainer (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
import time
import urllib
# Product Imports.
from zmscontainerobject import ZMSContainerObject
import zmslinkelement
import _globals
import _zreferableitem


###################################################################################################
###################################################################################################
###   
###   C o n s t r u c t o r ( s )
###   
###################################################################################################
###################################################################################################

def manage_addZMSLinkContainer(self, lang, manage_lang, _sort_id, REQUEST, RESPONSE):
  """ manage_addZMSLinkContainer """
  
  ##### Create ####
  id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
  obj = ZMSLinkContainer(self.getNewId(id_prefix),_sort_id+1)
  self._setObject(obj.id, obj)
  
  obj = getattr(self,obj.id)
  ##### Object State ####
  obj.setObjStateNew(REQUEST)
  ##### Init Coverage ####
  coverage = self.getDCCoverage(REQUEST)
  if coverage.find('local.')==0:
    obj.setObjProperty('attr_dc_coverage',coverage)
  else:
    obj.setObjProperty('attr_dc_coverage','global.'+lang)
  ##### Init Properties ####
  obj.setObjProperty('active',1,lang)
  ##### VersionManager ####
  obj.onChangeObj(REQUEST)
  
  ##### Normalize Sort-IDs ####
  self.normalizeSortIds(id_prefix)
            
  # Return with message.        
  message = self.getLangStr('MSG_INSERTED',manage_lang)%obj.display_type(REQUEST)
  RESPONSE.redirect('%s/%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(self.absolute_url(),obj.id,lang,manage_lang,urllib.quote(message)))


###################################################################################################
###################################################################################################
###   
###   C l a s s
###   
###################################################################################################
###################################################################################################

class ZMSLinkContainer(ZMSContainerObject): 

    # Properties.
    # -----------
    meta_type = "ZMSLinkContainer"
    icon = "misc_/zms/zmslinkcontainer.gif"
    icon_disabled = "misc_/zms/zmslinkcontainer_disabled.gif"

    # Management Options.
    # -------------------
    manage_options = ( 
	{'label': 'TAB_EDIT',       'action': 'manage_main'},
	{'label': 'TAB_HISTORY',    'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_PREVIEW',    'action': 'preview_html'}, # empty string defaults to index_html
	)

    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
		'manage','manage_main','manage_workspace',
		'manage_deleteObjs',
		'manage_properties','manage_changeProperties',
		'manage_moveObjUp','manage_moveObjDown',
		'manage_wfTransition', 'manage_wfTransitionFinalize',
		'manage_userForm','manage_user',
		)
    __ac_permissions__=(
		('ZMS Author', __authorPermissions__),
		)

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string','multilang':1,'xml':0,'lang_inherit':0},
        'change_dt':{'datatype':'datetime','multilang':1,'xml':0,'lang_inherit':0},
        # Properties
        'sort_id':{'datatype':'string','xml':0},
        'active':{'datatype':'boolean','multilang':1},
        'attr_active_start':{'datatype':'datetime','multilang':1},
        'attr_active_end':{'datatype':'datetime','multilang':1},
        # Meta-Data
        'attr_dc_coverage':{'datatype':'string'},
    }


    # Management Interface.
    # ---------------------
    manage_main = HTMLFile('dtml/zmslinkcontainer/manage_main', globals())


    """
    ###############################################################################################    
    #
    #   CONSTRUCTOR
    #
    ###############################################################################################    
    """
    
    # ------------------------------------------------------------------------------------------
    #  ZMSLinkContainer.recurse_updateVersion:
    #
    #  Update version.
    # ------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''

      # Process super-objects.
      message += ZMSContainerObject.recurse_updateVersion(self,REQUEST)
        
      # Process object.
      # [...]

      # ---------------------------------------------------------------------
      # 29.08.2002 Build #102
      # Replace list of links by ZMSLinkElement.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '102':
        for lang in self.getLangIds():
          req = {'lang':lang,'manage_lang':self.getManageLanguage(lang),'AUTHENTICATED_USER':'update','preview':'preview'}
          ob = self.getObjVersion(req)
          key = 'attr_links_%s'%lang
          if hasattr(ob,key):
            links = getattr(ob,key,[])
            if type(links) is type([]):
              for i in range(len(links)):
                link = links[len(links)-i-1]
                url = link.get('url','')
                title = link.get('title','')
                description = link.get('description','')
                if _globals.debug: print "[%s.recurse_updateVersion]: url_%s=%s; title_%s=%s"%(self.meta_type,lang,url,lang,title)
                # Unregister ZMSLinkContainer.
                ref_obj = self.getLinkObj(url)
                if ref_obj is not None:
                  ref_obj.unregisterRefObj(self,req)
                # Create ZMSLinkElement.
                linkElmnt = zmslinkelement.addZMSLinkElement(self,title,url,description,req)
                linkElmnt.onChangeObj(req,forced=1)
            try: delattr(ob,key)
            except: pass
          if len(self.getObjProperty('change_uid',req)) == 0:
            self.setObjProperty('change_uid','zms',req['lang'])
          if self.getObjProperty('change_dt',req) is None:
            self.setObjProperty('change_dt',time.localtime(time.time()),req['lang'])
      
      # Recurse through child-nodes.
      for ob in self.objectValues(self.dGlobalAttrs.keys()):
        message += ob.recurse_updateVersion(REQUEST)
      
      # Return with message.
      return message


    """
    ###############################################################################################    
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################    
    """
    
    ###############################################################################################
    #  ZMSLinkContainer.manage_changeProperties: 
    #
    #  Change LinkContainer properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST, RESPONSE): 
        """ ZMSLinkContainer.manage_changeProperties """
        
        message = ''
        if REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):

          ##### Object State #####
          self.setObjStateModified(REQUEST)

          # Active.
          self.setReqProperty('active',REQUEST)
          self.setReqProperty('attr_active_start',REQUEST)
          self.setReqProperty('attr_active_end',REQUEST)
          
          ##### Change #####
          if REQUEST['btn'] == self.getLangStr('BTN_CHANGE',manage_lang):
            for ob in self.getChildNodes(REQUEST,['ZMSLinkElement']):
              id = ob.id
              url = REQUEST['url%s'%id]
              title = REQUEST['title%s'%id]
              description = REQUEST['description%s'%id]
              zmslinkelement.setZMSLinkElement(ob,title,url,description,REQUEST)
          
          ##### Add #####
          elif REQUEST['btn'] == self.getLangStr('BTN_INSERT',manage_lang):
            title = REQUEST['_title']
            url = REQUEST['_url']
            description = REQUEST['_description']
            zmslinkelement.addZMSLinkElement(self,title,url,description,REQUEST)
                
          ##### VersionManager ####
          self.onChangeObj(REQUEST)
          
          # Return with message.
          message = self.getLangStr("MSG_CHANGED",manage_lang)
          return RESPONSE.redirect('manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,urllib.quote(message)))
        
        else:
          # Return to parent.
          self.checkIn(REQUEST)
          return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s#_%s'%(self.getParentNode().absolute_url(),lang,manage_lang,self.id))


    # -------------------------------------------------------------------------------------------------
    #	ZMSLinkContainer.isPage
    # ---------------------------------------------------------------------------------------------
    def isPage(self): return 0

    # -------------------------------------------------------------------------------------------------
    #	ZMSLinkContainer.isPageElement
    # ---------------------------------------------------------------------------------------------
    def isPageElement(self): return 0

    # -------------------------------------------------------------------------------------------------
    #	ZMSLinkContainer.getTitlealt
    # ---------------------------------------------------------------------------------------------
    def getTitlealt(self,REQUEST): return self.display_type(REQUEST)

    # ------------------------------------------------------------------------------------------
    #	ZMSLinkContainer.getLinkList: 
    #
    #	Returns list of URLs of links.
    # ------------------------------------------------------------------------------------------
    def getLinkList(self, REQUEST, allow_none=0):
      
      #-- [ReqBuff]: Fetch buffered value from Http-Request.
      try:
        reqBuffId = 'getLinkList%i'%allow_none
        value = self.fetchReqBuff(reqBuffId,REQUEST)
        return value
      except:
      
        #-- Get value.
        value = []
        for ob in self.getChildNodes(REQUEST,['ZMSLinkElement']):
          visible = 1
          visible = visible and self.isCommitted(REQUEST) # Object has been committed.
          if visible:
            url = ob.getObjAttrValue(ob.getObjAttr('attr_ref'),REQUEST)
            dct = {}
            dct['src'] = ob
            dct['dst'] = ob.getLinkObj(url,REQUEST)
            dct['url'] = ob.getLinkUrl(url,REQUEST)
            dct['title'] = ob.getObjProperty('title',REQUEST)
            dct['description'] = ob.getObjProperty('attr_dc_description',REQUEST)
            dct['internal'] = _zreferableitem.isInternalLink(url)
            medline = dct['title'].lower()=='medline'
            if medline:
              dct['url'] = _zreferableitem.getMedlineLink(dct['url'])
            if dct['url'] is not None or allow_none:
              value.append(dct)
        
        #-- [ReqBuff]: Returns value and stores it in buffer of Http-Request.
        return self.storeReqBuff(reqBuffId,value,REQUEST)


    # ------------------------------------------------------------------------------------------
    # 	ZMSLinkContainer.__get_links__:
    #	
    #	Returns list of links.
    # ------------------------------------------------------------------------------------------
    def __get_links__(self, REQUEST):
      return self.getObjProperty('attr_links',REQUEST)


    """
    ###############################################################################################
    ###
    ###  H T M L - P r e s e n t a t i o n 
    ###
    ###############################################################################################
    """

    # ------------------------------------------------------------------------------------------
    #	ZMSLinkContainer.renderShort:
    #
    #	Renders short presentation of Link-Container.
    # ------------------------------------------------------------------------------------------
    def renderShort(self, REQUEST):
      s = ''
      # Retrieve properties.
      obs = self.getChildNodes(REQUEST,['ZMSLinkElement'])
      # Build <html>-presentation.
      if obs:
        s += '\n<table cellspacing="0" cellpadding="1" border="0" width="100%" class="zmiNeutralColorLight1">'
        for ob in obs:
          s += '\n<tr>'
          s += '\n<td>%s</td>'%ob.renderShort(REQUEST)
          s += '\n</tr>'
        s += '\n</table>'
      # Return <html>
      return s


    """
    ###############################################################################################    
    ###  
    ###  DOM-Methoden 
    ### 
    ###############################################################################################    
    """
    
    # ---------------------------------------------------------------------------------------------
    #	ZMSLinkContainer.getChildNodes:
    #
    #	Returns a NodeList that contains all children of this node in correct sort-order.
    #	If none, this is a empty NodeList. 
    # ---------------------------------------------------------------------------------------------
    def getChildNodes(self, REQUEST={}, meta_types=None):
      lang = REQUEST.get('lang',None)
      nodelist = ZMSContainerObject.getChildNodes(self,REQUEST,meta_types)
      if lang is None:
        return nodelist
      else:
        return filter(lambda ob: ob.getDCCoverage(REQUEST).find("."+lang)>0,nodelist)

###################################################################################################
