###################################################################################################
# _accessmanager.py
#
# $Id: _accessmanager.py,v 1.11 2004/10/04 19:57:06 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.11 $
#
# Implementation of class AccessManager (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
from AccessControl.User import UserFolder
from types import StringTypes
import copy
import time
import urllib
# Product Imports.
import _globals


# -------------------------------------------------------------------------------------------
#  _accessmanager.user_folder_meta_types:
#
#  User Folder Meta-Types.
# -------------------------------------------------------------------------------------------
user_folder_meta_types = ['LDAPUserFolder','User Folder','Simple User Folder']

# -------------------------------------------------------------------------------------------
#  _accessmanager.role_defs:
#
#  Role Definitions.
# -------------------------------------------------------------------------------------------
role_defs = {
   'ZMSAdministrator':{}
  ,'ZMSEditor':{'revoke':['Change DTML Methods','ZMS Administrator','ZMS UserAdministrator']}
  ,'ZMSAuthor':{'revoke':['Change DTML Methods','Import/Export objects','ZMS Administrator','ZMS UserAdministrator']}
  ,'ZMSSubscriber':{'grant':['Access contents information','View']}
  ,'ZMSUserAdministrator':{'revoke':['Change DTML Methods','Import/Export objects','ZMS Administrator','ZMS Author']}
}

# -------------------------------------------------------------------------------------------
#  _accessmanager.getUserId:
# -------------------------------------------------------------------------------------------
def getUserId(user):
  if type(user) is dict:
    user = user['__id__']
  elif user is not None and type(user) not in StringTypes:
    user = user.getId()
  return user

# -------------------------------------------------------------------------------------------
#  _accessmanager.role_permissions:
#
#  Role Permissions.
# -------------------------------------------------------------------------------------------
def role_permissions(self, role):
  permissions = map(lambda x: x['name'],self.permissionsOfRole('Manager'))
  if role_defs.has_key(role):
    role_def = role_defs[role]
    if role_def.has_key('revoke'):
      for revoke in role_def['revoke']:
        if revoke in permissions:
          permissions.remove(revoke)
    elif role_def.has_key('grant'):
      permissions = role_def['grant']
  return permissions

# -------------------------------------------------------------------------------------------
#  _accessmanager.insertUser:
# -------------------------------------------------------------------------------------------
def insertUser(self, newId, newPassword, newEmail, REQUEST):
  id = ''
  lang = REQUEST['lang']
  manage_lang = REQUEST['manage_lang']
  userFldr = self.getUserFolder()
  
  # Init user.
  # ----------
  newRoles =  []
  newDomains =  []
  userFldr.userFolderAddUser(newId,newPassword,newRoles,newDomains)
  userObj = userFldr.getUser(newId)
  if userObj is not None:
    
    # Set user.
    # ---------
    self.setUserAttr(userObj,'email',newEmail)
    id = getUserId(userObj)

  return id

# -------------------------------------------------------------------------------------------
#  _accessmanager.deleteUser:
# -------------------------------------------------------------------------------------------
def deleteUser(self, id, REQUEST):
  lang = REQUEST['lang']
  manage_lang = REQUEST['manage_lang']
  userFldr = self.getUserFolder()
  
  userObj = userFldr.getUser(id)
  if userObj is not None:
    
    # Delete local roles in node.
    # ---------------------------
    nodes = self.getUserAttr(userObj,'nodes',{})
    for node in nodes.keys():
      ob = self.getLinkObj(node,REQUEST)
      if ob is not None:
        ob.manage_delLocalRoles(userids=[getUserId(userObj)])
    
    # Delete user.
    # ------------
    self.delUserAttr(userObj)
    if userFldr.meta_type != 'LDAPUserFolder':
      userFldr.userFolderDelUsers([id])
    id = ''
  
  return id


###################################################################################################
###################################################################################################
###
###   C l a s s   A c c e s s a b l e O b j e c t
###
###################################################################################################
###################################################################################################
class AccessableObject: 

    # -------------------------------------------------------------------------------------------
    #  AccessableObject.hasAccess:
    # -------------------------------------------------------------------------------------------
    def hasAccess(self, REQUEST):
      access = True
      auth_user = REQUEST.get('AUTHENTICATED_USER')
      if REQUEST.get('URL','/manage').find('/manage') >= 0:
        if access:
          rights = self.getObjProperty( 'attr_dc_accessrights', REQUEST)
          if type( rights) is list and len( rights) > 0:
            access = False
            for right in self.getObjProperty('attr_dc_accessrights', REQUEST):
              access = access or auth_user.has_role( right)
              access = access or auth_user.has_permission( right, self)
        if access and self.meta_type == 'ZMSCustom':
          ob = self.getMetaobj( self.meta_id)
          access = access and ((ob.get( 'access') is None) or (len( self.intersection_list( self.concat_list( ob.get( 'access').get( 'edit'), [ 'Manager']), self.getUserRoles(auth_user))) > 0))
        access = access and auth_user.has_permission('ZMS Author', self)
      else:
        if access:
          has_access = self.getObjProperty( 'attr_has_access', REQUEST)
          if has_access == 0:
            has_access = False
          elif has_access == 1:
            has_access = True
          if has_access in [ True, False]:
            access = access and has_access
        if access:
          access = access and auth_user.has_permission( 'View', self)
      return access

    # -------------------------------------------------------------------------------------------
    #  AccessableObject.getUserRoles:
    # -------------------------------------------------------------------------------------------
    def getUserRoles(self, userObj, aq_parent=1):
      roles = []
      try:
        roles.extend(list(userObj.getRolesInContext(self)))
      except:
        pass
      nodes = self.getUserAttr(userObj,'nodes',{})
      ob = self
      while ob is not None:
        nodekey = self.getRefObjPath(ob)
        if nodekey in nodes.keys():
          roles = self.concat_list(roles,nodes[nodekey]['roles'])
          break
        if aq_parent:
          ob = ob.getParentNode()
        else:
          ob = None
      return roles

    # -------------------------------------------------------------------------------------------
    #  AccessableObject.getUserLangs:
    # -------------------------------------------------------------------------------------------
    def getUserLangs(self, userObj, aq_parent=1):
      langs = []
      try:
        langs.extend(list(getattr(userObj,'langs',['*'])))
      except:
        pass
      nodes = self.getUserAttr(userObj, 'nodes', {})
      ob = self
      while ob is not None:
        nodekey = self.getRefObjPath(ob)
        if nodekey in nodes.keys():
          langs = nodes[nodekey]['langs']
          break
        if aq_parent:
          ob = ob.getParentNode()
        else:
          ob = None
      return langs


    """
    ###############################################################################################
    ###
    ###   P u b l i c   A c c e s s   ( S u b s c r i b e r s )
    ###
    ###############################################################################################
    """
    
    # -------------------------------------------------------------------------------------------
    #  AccessableObject.viewPermission:
    #
    #  Raises exception.
    # -------------------------------------------------------------------------------------------
    viewPermission__roles__ = ['ZMSAdministrator','ZMSEditor','ZMSAuthor','ZMSSubscriber']
    def viewPermission(self): pass

    # -------------------------------------------------------------------------------------------
    #  AccessableObject.hasRestrictedAccess:
    # -------------------------------------------------------------------------------------------
    def hasRestrictedAccess(self):
      if 'attr_has_subscriber' in self.getObjAttrs().keys():
        req = {'lang':self.getPrimaryLanguage()}
        return self.getObjProperty('attr_has_subscriber',req) in [ 1, True]
      return False

    # -------------------------------------------------------------------------------------------
    #  AccessableObject.hasPublicAccess:
    # -------------------------------------------------------------------------------------------
    def hasPublicAccess(self):
      has_public_access = not self.hasRestrictedAccess()
      parent = self.getParentNode()
      if parent is not None:
        has_public_access = has_public_access and parent.hasPublicAccess()
      return has_public_access


    """
    ###############################################################################################
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################
    """

    ###############################################################################################
    #  AccessableObject.manage_user:
    #
    #  Change user.
    ###############################################################################################
    manage_userForm = HTMLFile('dtml/zms/manage_user', globals())
    def manage_user(self, btn, lang, manage_lang, REQUEST, RESPONSE):
      """ AccessManager.manage_user """
      message = ''
      
      # Change.
      # -------
      if btn == self.getLangStr('BTN_CHANGE',manage_lang):
        userObj = self.findUser(getUserId(REQUEST['AUTHENTICATED_USER']))
        password = REQUEST.get('password','******')
        confirm = REQUEST.get('confirm','')
        if password!='******' and password==confirm:
           userObj.__ = password
        self.setUserAttr(userObj,'email',REQUEST.get('email','').strip())
        #-- Assemble message.
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Return with message.
      message = urllib.quote(message)
      return RESPONSE.redirect('manage_userForm?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,message))


###################################################################################################
###################################################################################################
###
###   C l a s s   A c c e s s a b l e C o n t a i n e r
###
###################################################################################################
###################################################################################################
class AccessableContainer(AccessableObject): 
    
    # --------------------------------------------------------------------------------------------
    #  AccessableContainer.synchronizePublicAccess:
    #
    #  Grant/revoke public access.
    # --------------------------------------------------------------------------------------------
    def synchronizePublicAccess(self):
      if self.hasRestrictedAccess():
        self.revokePublicAccess()
      else:
        self.grantPublicAccess()

    # -------------------------------------------------------------------------------------------
    #  AccessableContainer.restrictAccess:
    # -------------------------------------------------------------------------------------------
    def restrictAccess(self):
      for lang in self.getLangIds():
        for key in ['index_%s.html','index_print_%s.html','search_%s.html','sitemap_%s.html']:
          id = key%lang
          if hasattr(self,id):
            ob = getattr(self,id)
            ob.manage_acquiredPermissions(permissions=['Access contents information','View'])
            for role in ['Manager']: 
              ob.manage_role(role_to_manage=role,permissions=role_permissions(ob,role))

    # -------------------------------------------------------------------------------------------
    #  AccessableContainer.grantPublicAccess:
    # -------------------------------------------------------------------------------------------
    def grantPublicAccess(self):
      self.restrictAccess()
      self.manage_acquiredPermissions(role_permissions(self,'Manager'))
      for role in role_defs.keys():
        permissions = []
        if self.getLevel() == 0:
          permissions = role_permissions(self,role)
        self.manage_role(role_to_manage=role,permissions=permissions)
      # Anonymous / Authenticated.
      permissions = []
      if self.getLevel() == 0:
        permissions = ['Access contents information','View']
      self.manage_role(role_to_manage='Anonymous',permissions=permissions)
      self.manage_role(role_to_manage='Authenticated',permissions=permissions)

    # -------------------------------------------------------------------------------------------
    #  AccessableContainer.revokePublicAccess:
    # -------------------------------------------------------------------------------------------
    def revokePublicAccess(self):
      self.restrictAccess()
      self.manage_acquiredPermissions([])
      for role in role_defs.keys():
        self.manage_role(role_to_manage=role,permissions=role_permissions(self,role))
      # Anonymous / Authenticated.
      permissions=['Access contents information']
      self.manage_role(role_to_manage='Anonymous',permissions=permissions)
      self.manage_role(role_to_manage='Authenticated',permissions=permissions)


###################################################################################################
###################################################################################################
###
###   C l a s s   A c c e s s M a n a g e r
###
###################################################################################################
###################################################################################################
class AccessManager(AccessableContainer): 

    # -------------------------------------------------------------------------------------------
    #  AccessManager.getValidUserids:
    # -------------------------------------------------------------------------------------------
    def getValidUserids(self):
      valid_userids = []
      for userFldr in self.getUserFolders():
        if userFldr.aq_parent.objectValues(['ZMS']):
          if userFldr.meta_type == 'LDAPUserFolder' and \
             userFldr.getProperty('_login_attr') == 'dn':
            for user in userFldr.findUser(search_param='sn',search_term=''):
              userName = user['dn']
              valid_userids.append({'localUserFldr':userFldr,'name':userName})
          else:
            for userName in userFldr.getUserNames():
              valid_userids.append({'localUserFldr':userFldr,'name':userName})
      return valid_userids

    # -------------------------------------------------------------------------------------------
    #  AccessManager.setUserAttr:
    # -------------------------------------------------------------------------------------------
    def setUserAttr(self, user, name, value):
      user = getUserId(user)
      d = self.getConfProperty('ZMS.security.users',{})
      i = d.get(user,{})
      i[name] = value
      d[user] = i.copy()
      self.setConfProperty('ZMS.security.users',d.copy())

    # -------------------------------------------------------------------------------------------
    #  AccessManager.getUserAttr:
    # -------------------------------------------------------------------------------------------
    def getUserAttr(self, user, name, default, flag=0):
      user = getUserId(user)
      d = self.getConfProperty('ZMS.security.users',{})
      i = d.get(user,{})
      v = i.get(name,default)
      # Process master.
      if flag == 0:
        portalMaster = self.getPortalMaster()
        if portalMaster is not None:
          w = portalMaster.getUserAttr(user, name, default, 1)
          if type(w) in StringTypes:
            if type(v) in StringTypes:
              if len(v) == 0:
                v = w
      # Process clients.
      if flag == 0:
        for portalClient in self.getPortalClients():
          w = portalClient.getUserAttr(user, name, default)
          if type(w) is dict:
            v = v.copy()
            for node in w.keys():
              ob = portalClient.getLinkObj(node)
              newNode = self.getRefObjPath(ob)
              v[newNode] = w[node]
      return v

    # -------------------------------------------------------------------------------------------
    #  AccessManager.delUserAttr:
    # -------------------------------------------------------------------------------------------
    def delUserAttr(self, user):
      user = getUserId(user)
      d = self.getConfProperty('ZMS.security.users',{})
      try:
        del d[user]
        self.setConfProperty('ZMS.security.users',d)
      except:
        _globals.writeException(self,'[delUserAttr]: user=%s not deleted!'%user)

    # -------------------------------------------------------------------------------------------
    #  AccessManager.initRoleDefs:
    #
    #  Init Role-Definitions and Permission Settings
    # -------------------------------------------------------------------------------------------
    def initRoleDefs(self):
    
      # Init Roles.
      for role in role_defs.keys():
        role_def = role_defs[role]
        # Add Local Role.
        if not role in self.valid_roles(): self._addRole(role)
        # Set permissions for Local Role.
        self.manage_role(role_to_manage=role,permissions=role_permissions(self,role))
      
      # Clear acquired permissions.
      self.manage_acquiredPermissions([])
      
      # Grant public access.
      self.synchronizePublicAccess()


    # -------------------------------------------------------------------------------------------
    #  AccessManager.findUser:
    # -------------------------------------------------------------------------------------------
    def findUser(self, name):
      for userFldr in self.getUserFolders():
        userObj = None
        if userFldr.meta_type=='LDAPUserFolder' and userFldr.getProperty('_login_attr')=='dn':
          ldapUsersObjs = userFldr.findUser(search_param=userFldr.getProperty('_login_attr'),search_term=name)
          if len(ldapUsersObjs) == 1:
            userObj = ldapUsersObjs[0]
            userObj['__id__'] = userObj[userFldr.getProperty( '_login_attr' )]
        else:
          userObj = userFldr.getUser(name)
        if userObj is not None:
          return userObj
      return None

    # -------------------------------------------------------------------------------------------
    #  AccessManager.getUserFolder:
    # -------------------------------------------------------------------------------------------
    def getUserFolder(self):
      homeElmnt = self.getHome()
      userFldrs = homeElmnt.objectValues(user_folder_meta_types)
      if len(userFldrs)==0:
        userFldr = UserFolder()
        homeElmnt._setObject(userFldr.id, userFldr)
      else:
        userFldr = userFldrs[0]
      return userFldr


    # -------------------------------------------------------------------------------------------
    #  AccessManager.getUserFolders:
    # -------------------------------------------------------------------------------------------
    def getUserFolders(self):
      userFolders = []
      ob = self
      while 1:
        if ob is None: break
        try:
          localUserFolders = ob.objectValues(user_folder_meta_types)
          if len(localUserFolders)==1:
            localUserFolder = localUserFolders[0]
            if localUserFolder not in userFolders:
              userFolders.append(localUserFolder)
          ob = ob.aq_parent
        except:
          ob = None
      return userFolders


    """
    ###############################################################################################
    ###
    ###   L o c a l   U s e r s
    ###
    ###############################################################################################
    """

    # -------------------------------------------------------------------------------------------
    #  AccessManager.setLocalUser:
    # -------------------------------------------------------------------------------------------
    def setLocalUser(self, id, node, roles, langs):
      #-- Insert node to user-properties.
      nodes = self.getUserAttr(id,'nodes',{})
      nodes[node] = {'langs':langs,'roles':roles}
      nodes = nodes.copy()
      self.setUserAttr(id,'nodes',nodes)
      roles = list(roles)
      if 'ZMSAdministrator' in roles: roles.append('Manager')
      #-- Set local roles in node.
      ob = self.getLinkObj(node,self.REQUEST)
      try:
        ob.manage_setLocalRoles(id,roles)
      except:
        _globals.writeException(self,'[setLocalUser]: node=%s does not exist!'%node)


    # -------------------------------------------------------------------------------------------
    #  AccessManager.delLocalUser:
    # -------------------------------------------------------------------------------------------
    def delLocalUser(self, id, node):
      #-- Delete node from user-properties.
      nodes = self.getUserAttr(id,'nodes',{})
      if nodes.has_key(node): del nodes[node]
      nodes = nodes.copy()
      self.setUserAttr(id,'nodes',nodes)
      #-- Delete local roles in node.
      ob = self.getLinkObj(node,self.REQUEST)
      try:
        ob.manage_delLocalRoles(userids=[id])
      except:
        _globals.writeException(self,'[delLocalUser]: node=%s does not exist!'%node)


    """
    ###############################################################################################
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################
    """

    # Management Interface.
    # ---------------------
    manage_users = HTMLFile('dtml/zms/manage_users', globals())
    manage_usersSitemap = HTMLFile('dtml/zms/manage_userssitemap', globals())

    ###############################################################################################
    #  AccessManager.manage_roleProperties:
    #
    #  Change or delete roles.
    ###############################################################################################
    def manage_roleProperties(self, btn, key, lang, manage_lang, REQUEST, RESPONSE=None):
      """ AccessManager.manage_roleProperties """
      message = ''
      id = REQUEST.get('id','')
      
      # Insert.
      # -------
      if btn == self.getLangStr('BTN_INSERT',manage_lang):
        if key=='obj':
          #-- Add local role.
          id = REQUEST.get('newId').strip()
          if id not in self.valid_roles(): self._addRole(role=id,REQUEST=REQUEST)
          #-- Prepare nodes from config-properties.
          security_roles = self.getConfProperty('ZMS.security.roles',{})
          security_roles[id] = {}
          security_roles = security_roles.copy()
          self.setConfProperty('ZMS.security.roles',security_roles)
          #-- Assemble message.
          message = self.getLangStr('MSG_INSERTED',manage_lang)%self.getLangStr('ATTR_ROLE',manage_lang)
        elif key=='attr':
          #-- Insert node to config-properties.
          node = REQUEST.get('node')
          roles = REQUEST.get('roles',[])
          if not type(roles) is list: roles = [roles]
          security_roles = self.getConfProperty('ZMS.security.roles',{})
          dict = security_roles.get(id,{})
          dict[node] = {'roles':roles}
          security_roles[id] = dict
          security_roles = security_roles.copy()
          self.setConfProperty('ZMS.security.roles',security_roles)
          #-- Set permissions in node.
          ob = self.getLinkObj(node,REQUEST)
          permissions = []
          for role in roles:
            permissions = ob.concat_list(permissions,role_permissions(self,role.replace(' ','')))
          ob.manage_role(role_to_manage=id,permissions=permissions)
          #-- Assemble message.
          message = self.getLangStr('MSG_INSERTED',manage_lang)%self.getLangStr('ATTR_NODE',manage_lang)
      
      # Delete.
      # -------
      elif btn in ['delete', self.getLangStr('BTN_DELETE',manage_lang)]:
        if key=='obj':
          #-- Delete local role.
          self._delRoles(roles=[id],REQUEST=REQUEST)
          #-- Delete nodes from config-properties.
          security_roles = self.getConfProperty('ZMS.security.roles',{})
          if security_roles.has_key(id): del security_roles[id]
          security_roles = security_roles.copy()
          self.setConfProperty('ZMS.security.roles',security_roles)
          id = ''
        elif key=='attr':
          #-- Delete node from config-properties.
          node = REQUEST.get('nodekey')
          security_roles = self.getConfProperty('ZMS.security.roles',{})
          dict = security_roles.get(id,{})
          if dict.has_key(node): del dict[node]
          security_roles[id] = dict
          security_roles = security_roles.copy()
          self.setConfProperty('ZMS.security.roles',security_roles)
          #-- Delete permissions in node.
          permissions = []
          ob = self.getLinkObj(node,REQUEST)
          if ob is not None:
            ob.manage_role(role_to_manage=id,permissions=permissions)
        #-- Assemble message.
        message = self.getLangStr('MSG_DELETED',manage_lang)%int(1)
      
      # Return with message.
      if RESPONSE:
        message = urllib.quote(message)
        return RESPONSE.redirect('manage_users?lang=%s&manage_lang=%s&manage_tabs_message=%s&id=%s'%(lang,manage_lang,message,id))


    ###############################################################################################
    #  AccessManager.manage_userProperties:
    #
    #  Change or delete users.
    ###############################################################################################
    def manage_userProperties(self, btn, key, lang, manage_lang, REQUEST, RESPONSE=None):
      """ AccessManager.manage_userProperties """
      message = ''
      id = REQUEST.get('id','')
      
      # Cancel.
      # -------
      if btn == self.getLangStr('BTN_CANCEL',manage_lang):
        id = ''

      # Insert.
      # -------
      if btn == self.getLangStr('BTN_INSERT',manage_lang):
        if key=='obj':
          #-- Insert user.
          newId = REQUEST.get('newId','').strip()
          newPassword = REQUEST.get('newPassword','').strip()
          newConfirm = REQUEST.get('newConfirm','').strip()
          newEmail = REQUEST.get('newEmail','').strip()
          id = insertUser(self,newId,newPassword,newEmail,REQUEST)
          #-- Assemble message.
          message = self.getLangStr('MSG_INSERTED',manage_lang)%self.getLangStr('ATTR_USER',manage_lang)
        elif key=='attr':
          #-- Insert local user.
          langs = REQUEST.get('langs',[])
          if not type(langs) is list: langs = [langs]
          roles = REQUEST.get('roles',[])
          if not type(roles) is list: roles = [roles]
          node = REQUEST.get('node')
          ob = self.getLinkObj(node,REQUEST)
          docElmnt = ob.getDocumentElement()
          node = docElmnt.getRefObjPath(ob)
          docElmnt.setLocalUser(id, node, roles, langs)
          #-- Assemble message.
          message = self.getLangStr('MSG_INSERTED',manage_lang)%self.getLangStr('ATTR_NODE',manage_lang)
      
      # Change.
      # -------
      elif btn == self.getLangStr('BTN_CHANGE',manage_lang):
        userObj = self.findUser(id)
        if key=='obj':
          password = REQUEST.get('password','******')
          confirm = REQUEST.get('confirm','')
          if password!='******' and password==confirm:
             userObj.__ = password
          self.setUserAttr(userObj,'email',REQUEST.get('email','').strip())
          self.setUserAttr(userObj,'profile',REQUEST.get('profile','').strip())
        elif key=='attr':
          pass
        #-- Assemble message.
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Delete.
      # -------
      elif btn in ['delete', self.getLangStr('BTN_DELETE',manage_lang)]:
        if key=='obj':
          #-- Delete user.
          id = deleteUser(self,id,REQUEST)
          #-- Assemble message.
          message = self.getLangStr('MSG_DELETED',manage_lang)%int(1)
        elif key=='attr':
          #-- Delete local user.
          node = REQUEST.get('nodekey')
          try:
            self.delLocalUser(id, node)
          except:
            pass
          try:
            docElmnt = self.getDocumentElement()
            ob = self.getLinkObj(node,REQUEST)
            if ob is not None:
              docElmnt = ob.getDocumentElement()
              node = docElmnt.getRefObjPath(ob)
            docElmnt.delLocalUser(id, node)
          except:
            pass
          #-- Assemble message.
          message = self.getLangStr('MSG_DELETED',manage_lang)%int(1)
      
      # Invite.
      # -------
      elif btn == self.getLangStr('BTN_INVITE',manage_lang):
        if key=='obj':
          email = self.getUserAttr(id,'email','')
          nodekeys = REQUEST.get('nodekeys',[])
          if len(email) > 0 and len(nodekeys) > 0:
            # Send notification.
            # ------------------
            #-- Recipient
            mto = email
            #-- Body
            userObj = self.findUser(id)
            mbody = []
            mbody.append(self.getTitle(REQUEST)+' '+self.getHref2IndexHtml(REQUEST))
            mbody.append('\n')
            mbody.append('\n%s: %s'%(self.getLangStr('ATTR_ID',manage_lang),id))
            try:
              mbody.append('\n%s: %s'%(self.getLangStr('ATTR_PASSWORD',manage_lang),userObj._getPassword()))
            except:
              pass
            mbody.append('\n')
            for nodekey in nodekeys:
              ob = self.getLinkObj(nodekey,REQUEST)
              mbody.append('\n * '+ob.getTitlealt(REQUEST)+' ['+ob.display_type(REQUEST)+']: '+ob.absolute_url()+'/manage')
            mbody.append('\n')
            mbody.append('\n' + self.getLangStr('WITH_BEST_REGARDS',manage_lang))
            mbody.append('\n' + str(REQUEST['AUTHENTICATED_USER']))
            mbody.append('\n-------------------------------')
            mbody = ''.join(mbody)
            #-- Subject
            msubject = '%s (invitation)'%self.getTitlealt(REQUEST)
            #-- Send
            self.sendMail(mto,msubject,mbody,REQUEST)
            #-- Assemble message.
            message = self.getLangStr('MSG_CHANGED',manage_lang)

      # Return with message.
      if RESPONSE:
        message = urllib.quote(message)
        return RESPONSE.redirect('manage_users?lang=%s&manage_lang=%s&manage_tabs_message=%s&id=%s'%(lang,manage_lang,message,id))

###################################################################################################