###################################################################################################
# _metadata.py
#
# $Id: _metadata.py,v 1.1 2003/08/31 13:29:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.1 $
#
# Implementation of class Metadata (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
# Product Imports.
import _globals


###################################################################################################
###################################################################################################
###
###   C L A S S   M E T A D A T A
###
###################################################################################################
###################################################################################################
class Metadata:


    # Management Interface.
    # ---------------------
    f_metaHeader = HTMLFile('dtml/metadict/f_metaheader', globals()) 
    f_metaInputFields = HTMLFile('dtml/metadict/f_metainputfields', globals()) 
    f_metaInputField = HTMLFile('dtml/metadict/f_metainputfield', globals()) 
    f_metaInputJS = HTMLFile('dtml/metadict/input_js', globals()) 


    # ---------------------------------------------------------------------------------------------
    #  Metadata.getDCCoverageOptions:
    #
    #  Values for select-list of DC.Coverage.
    # ---------------------------------------------------------------------------------------------
    def getDCCoverageOptions(self, REQUEST, meta_type=None):
      obs = []
      lang = REQUEST['lang']
      meta_type = _globals.nvl(meta_type,self.meta_type)
      coverage = self.getDCCoverage(REQUEST)
      if REQUEST.get('ZMS_INSERT',None) is None:
        coverage_lang = coverage[coverage.find('.')+1:]
        if lang != coverage_lang:
          obs.append(coverage)
        else:
          if meta_type != 'ZMSLinkElement': # and coverage.find('local.') != 0:
            obs.append('global.'+coverage_lang)
          obs.append('local.'+coverage_lang)
      else:
        if meta_type != 'ZMSLinkElement': # and coverage.find('local.') != 0:
          obs.append('global.'+lang)
        obs.append('local.'+lang)
      return obs


    # ---------------------------------------------------------------------------------------------
    #	Metadata.acquireMetadata:
    #
    #	Acquires Metadata from parent.
    # ---------------------------------------------------------------------------------------------
    def acquireMetadata(self, key, lang, manage_lang, REQUEST):
      parent = self.getParentNode()
      if parent is not None and key in parent.getObjAttrs().keys():
        # Set property.          
        self.setObjStateModified(REQUEST)
        self.setObjProperty(key,parent.getObjProperty(key,REQUEST),lang)
        self.onChangeObj(REQUEST)


    # ---------------------------------------------------------------------------------------------
    #	Metadata.inheritMetadata:
    #
    #	Inherits Metadata recursive to children.
    # ---------------------------------------------------------------------------------------------
    def inheritMetadata(self, key, lang, manage_lang, REQUEST):
      for child in self.getChildNodes(REQUEST):
        if key in child.getObjAttrs().keys():
          # Set property.          
          child.setObjStateModified(REQUEST)
          child.setObjProperty(key,self.getObjProperty(key,REQUEST),lang)
          child.onChangeObj(REQUEST)
          # Process tree.          
          child.inheritMetadata(key,lang,manage_lang,REQUEST)


    # ---------------------------------------------------------------------------------------------
    #	Metadata.setMetadata:
    #
    #	Changes Metadata.
    # ---------------------------------------------------------------------------------------------
    def setMetadata(self, lang, manage_lang, REQUEST):
    
      # Acquire from top.
      if REQUEST.get('aq_dir','') == 'top':
        if REQUEST.has_key('aq_ids'):
          for key in REQUEST['aq_ids']:
            self.acquireMetadata(key,lang,manage_lang,REQUEST)
                
      # Inherit to bottom.
      elif REQUEST.get('aq_dir','') == 'bottom':
        if REQUEST.has_key('aq_ids'):
          for key in REQUEST['aq_ids']:
            self.inheritMetadata(key,lang,manage_lang,REQUEST)
                
      # Change.
      elif REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):
        if 'attr_dc_coverage' in self.getObjAttrs().keys():
          self.setReqProperty('attr_dc_coverage',REQUEST)
        for attr in self.getMetadictAttrs(self.meta_type):
          objAttr = self.getMetadictAttr(attr)
          if objAttr['type'] in self.getMetaobjIds(sort=0) and \
             self.getMetaobj(objAttr['type'])['type']=='ZMSResource':
            for ob in self.getObjChildren(objAttr['id'],REQUEST):
              ob.setObjStateModified(REQUEST)
              for key in self.getMetaobjAttrIds(objAttr['type']):
                ob.setReqProperty(key,REQUEST)
              ob.onChangeObj(REQUEST)
          else:
            self.setReqProperty(objAttr['key'],REQUEST)

###################################################################################################
