# zwiki mailin - post an email message to a wiki page
#
# This method expects at least one argument, msg, an RFC822 email
# message. This will be formatted as a wiki comment and appended to
# the appropriate zwiki page.  The page is selected as follows:
#
# - if called in a page context, use that page
# - if called in a folder context, look for
#   1. a zwiki page name appearing before @ in a recipient hdr (To,Cc,etc)
#   2. or, the first page name appearing in the subject 
#   3. or, the defaultpage argument
#   4. or, defaultpage hardcoded below (FrontPage)
#
# 1 & 2 may be turned off if you don't want them
#
# This is intended to receive email messages from a procmail recipe
# like the following:
#
# # forward messages to a zwiki web
# # assumes an entry for site in ~/.netrc
# # processing only messages whose recipient contains 'wiki':
# * ^TO.*wiki
# * !^FROM_MAILER
# :0 i
# | curl -n -F 'msg=<-' http://site/wiki_folder/mailin
#
# todo:
# in procmail, forward message+error to a human if post fails
# support checking of sender against a member list
# support size limits


from types import *
import re
from DocumentTemplate.DT_Util import html_quote
try:
    from Products.ZWiki.ZWikiRegexes import wikiname1,wikiname2,bracketedexpr
except ImportError:
    # pre-0.9.4 ZWiki :
    from Products.ZWiki.ZWikiPage import wikiname1,wikiname2,bracketedexpr
    

#wikinameexp = r'(%s|%s|%s)' % (wikiname1,wikiname2,bracketedexpr)
wikinameexp = r'(%s|%s)' % (wikiname1,wikiname2)
defaultpage = 'FrontPage'

def mailin(self, msg, pagenameexp=wikinameexp, defaultpage=defaultpage,
         separator='\n\n', checkrecipient=1, checksubject=1):

    # extract essential fields

    # could use rfc822 ?
    #    mo=rfc822.Message(mfile)
    #
    #    hd={}
    #    hd['to']=[]
    #    for header in (mo.getaddrlist('to'),
    #                   mo.getaddrlist('cc'),
    #                   mo.getaddrlist('bcc')):
    #        if not header: continue
    #        for name, addr in header:
    #            hd['to'].append(addr)
    #    
    #    hd['from']=mo.getaddr('from')[1]
    #    hd['subject']=mo.getheader('subject') or ''

    author = re.search(r'(?m)^From: (.*)',msg)
    if author: author = author.group(1)
    else: author = ''

    date = re.search(r'(?m)^Date: (.*)',msg)
    if date: date = date.group(1)
    else: date = ''

    text = re.search(r'(?s)\n\n(.*)',msg)
    if text: text = text.group(1)
    else: text = ''

    # & do just a little html-prettification for web display.
    # If this comment gets sent out again to subscribers, zwiki
    # will try to strip this again.
    #comment = "<hr><b>%s, %s (via mail):</b><br>\n%s" % \
    #          (html_quote(author), html_quote(date), text)
    #comment = re.sub(r'(?m)^>(.*)',r'<br>><i>\1</i>',comment)
    # the comment() method takes care of this now

    # figure out the best page to use
    if self.meta_type is 'ZWiki Page':
        # if we are called on a page, use that
        page = self
    else:
        # if we are called on a folder,

        pagename = None
        if (not pagename) and checkrecipient:
            # look in recipient(s)
            pagename = re.search(
                # simple recipient regexp:
                # r'(?m)^(To|Cc|Bcc):.*(%s).*'
                # using procmail's TO regexp, search all recipients
                #r'(?m)(^((Original-)?(Resent-)?(To|Cc|Bcc)|(X-Envelope|Apparently(-Resent)?)-To):.*(?P<pagename>%s).*)' \
                #% (pagenameexp), msg)
                # same, but look only at the mail acct. name before the @
                r'(?m)(^((Original-)?(Resent-)?(To|Cc|Bcc)|(X-Envelope|Apparently(-Resent)?)-To):.*(?P<pagename>%s)@.*)' \
                % (pagenameexp), msg)
            if pagename:
                pagename = pagename.group('pagename')

        if (not pagename) and checksubject:
            # look in subject
            subject = re.search(r'(?m)^Subject: (.*)',msg)
            if subject:
                subject = subject.group(1)
                pagename = re.search(pagenameexp,subject)
                if pagename:
                    pagename = pagename.group(1)

        if not pagename:
            # use default page
            pagename = defaultpage
                
        page = getattr(self,pagename)

    # add the comment
    # use the time of sending, or
    #page.comment(use_heading=1, text=text, username=author, time=date, note=' (via mail)')
    # use the time of posting to the wiki - see how this works out
    page.comment(use_heading=1, text=text, username=author, note=' (via mail)')
