"""
doctest support

Doctests are represented as python snippets within docstrings, and
appear throughout the zwiki code.  See doctest.py for more info.
Each of the tests below invokes doctest on a module and passes if all
the doctests pass.

notes:

- we need to use a hacked version of doctest to see the ZWikiPage
class, because it's based on an extension class.

- the zope context is available in doctests as "zc"

- exceptions in doctests don't work because zunit catches them first

- when reporting the number of tests, doctest counts contiguous
non-blank >>> lines as one test


old todos:

  I suspect we're running the doctests twice, an undesirable slowdown

  it would be nice to make zunit count each doctest separately

  get zunit to leave exceptions for doctest ?

  get zunit to display line of code like doctest, instead of having to
  define assertion strings ?

  get doctest to print line numbers in such a way that emacs can jump there

"""

from Products.ZWiki.tests import simpletestrunner
import unittest
#import Zope
#from Products.ZWiki.ZWikiPage import *
from cStringIO import StringIO
import sys
from Products.ZWiki.tests import doctest

class DocTests(simpletestrunner.TestCase):

    def setUp(self):
        # aborting the transaction breaks the DeleteMe tests
        # for some reason
        #get_transaction().begin()

        # create a dummy page for doctests to play with
        self.ZopeContext.manage_addProduct['ZWiki'].manage_addZWikiPage(
            'TestPage', file='testing testing 1 2 3')

    def tearDown(self):
        self.ZopeContext.manage_delObjects(['TestPage'])
        
        #get_transaction().abort()

    def _runDoctest(self, module, verbose=0, report=0):
        """
        helper method to invoke doctest on a module from within a
        zunit test
        """
        doctest.master = None   # to get rid of merge warnings
        saveout=sys.stdout
        sys.stdout=StringIO()  # XXX some streaming here perhaps
        failures, tests = doctest.testmod(
            module,
            globs={'zc':self.ZopeContext,
                   'self':self.ZopeContext,
                   'ZWiki':self.ZopeContext.manage_addProduct['ZWiki'],
                   }, 
            verbose=verbose,
            report=report,
            isprivate=lambda x,y: 0 # test private things too
            )
        sys.stdout.flush()
        output = sys.stdout.getvalue()
        sys.stdout=saveout
        assert failures == 0, 'module %s (%d doctests):\n%s' % \
               (module.__name__,tests,output)
        return

    # run any doctests in the main modules
    # should scan for these automatically 

    def testZWikiPageDoctests(self):
        "doctests in ZWikiPage.py"
        from Products.ZWiki import ZWikiPage
        self._runDoctest(ZWikiPage)

    # runs ZWikiPage.py's doctests a second time ?
    #def testInitDoctests(self):
    #    "doctests in __init.py__"
    #    from Products.ZWiki import __init__
    #    self._runDoctest(__init__)

    def testCatalogAwarenessDoctests(self):
        "doctests in CatalogAwareness.py"
        from Products.ZWiki import CatalogAwareness
        self._runDoctest(CatalogAwareness)

    def testDefaultsDoctests(self):
        "doctests in Defaults.py"
        from Products.ZWiki import Defaults
        self._runDoctest(Defaults)

    def testDiffDoctests(self):
        "doctests in Diff.py"
        from Products.ZWiki import Diff
        self._runDoctest(Diff)

    def testParentsDoctests(self):
        "doctests in Parents.py"
        from Products.ZWiki import Parents
        self._runDoctest(Parents)

    def testPermissionsDoctests(self):
        "doctests in Permissions.py"
        from Products.ZWiki import Permissions
        self._runDoctest(Permissions)

    def testRegexpsDoctests(self):
        "doctests in Regexps.py"
        from Products.ZWiki import Regexps
        self._runDoctest(Regexps)

    def testZWikiWebDoctests(self):
        "doctests in ZWikiWeb.py"
        from Products.ZWiki import ZWikiWeb
        #ack this is a pain.. ZWikiWeb imports ZWikiPage causing (a) those
        #tests to be run twice and (b) trouble
        #self._runDoctest(ZWikiWeb)
        pass

    def testWwmlDoctests(self):
        "doctests in wwml.py"
        from Products.ZWiki import wwml
        self._runDoctest(wwml)

    # some doctests may fit better down here in the test modules ?

# getting some tests repeated
#    def test000TestDoctestsDoctests(self):
#        "doctests in tests/testDoctests.py"
#        from Products.ZWiki.tests import testDoctests
#        self._runDoctest(testDoctests) # yup, doctesting ourself
#
#    def test001TestZWikiPageDoctests(self):
#        "doctests in tests/testZWikiPage.py"
#        from Products.ZWiki.tests import testZWikiPage
#        self._runDoctest(testZWikiPage)
#    
#    def test002TestZWikiWebDoctests(self):
#        "doctests in tests/testZWikiWeb.py"
#        from Products.ZWiki.tests import testZWikiWeb
#        self._runDoctest(testZWikiWeb)

    #quicktest1 = testTestZWikiPageDoctests
    #quicktest2 = testZWikiPageDoctests
    

def test_suite():
    ts = (
        simpletestrunner.makeSuite(DocTests),
        #simpletestrunner.makeSuite(DocTests,'testZWikiWeb'),
    )
    return simpletestrunner.TestSuite(ts)

def main():
    unittest.TextTestRunner().run(test_suite())

if __name__ == '__main__':
    main()
