; $Id: rx-ranges.scm 345 2004-01-25 09:44:04Z dvd $
; character classes and ranges

(define rx-ranges '(
  (U-IsBasicLatin . #((#x0000 . #x007F)))
  (U-IsLatin-1Supplement #((#x0080 . #x00FF)))
  (U-IsLatinExtended-A . #((#x0100 . #x017F)))
  (U-IsLatinExtended-B . #((#x0180 . #x024F)))
  (U-IsIPAExtensions . #((#x0250 . #x02AF)))
  (U-IsSpacingModifierLetters . #((#x02B0 . #x02FF)))
  (U-IsCombiningDiacriticalMarks . #((#x0300 . #x036F)))
  (U-IsGreek . #((#x0370 . #x03FF)))
  (U-IsCyrillic . #((#x0400 . #x04FF)))
  (U-IsArmenian . #((#x0530 . #x058F)))
  (U-IsHebrew . #((#x0590 . #x05FF)))
  (U-IsArabic . #((#x0600 . #x06FF)))
  (U-IsSyriac . #((#x0700 . #x074F)))
  (U-IsThaana . #((#x0780 . #x07BF)))
  (U-IsDevanagari . #((#x0900 . #x097F)))
  (U-IsBengali . #((#x0980 . #x09FF)))
  (U-IsGurmukhi . #((#x0A00 . #x0A7F)))
  (U-IsGujarati . #((#x0A80 . #x0AFF)))
  (U-IsOriya . #((#x0B00 . #x0B7F)))
  (U-IsTamil . #((#x0B80 . #x0BFF)))
  (U-IsTelugu . #((#x0C00 . #x0C7F)))
  (U-IsKannada . #((#x0C80 . #x0CFF)))
  (U-IsMalayalam . #((#x0D00 . #x0D7F)))
  (U-IsSinhala . #((#x0D80 . #x0DFF)))
  (U-IsThai . #((#x0E00 . #x0E7F)))
  (U-IsLao . #((#x0E80 . #x0EFF)))
  (U-IsTibetan . #((#x0F00 . #x0FFF)))
  (U-IsMyanmar . #((#x1000 . #x109F)))
  (U-IsGeorgian . #((#x10A0 . #x10FF)))
  (U-IsHangulJamo . #((#x1100 . #x11FF)))
  (U-IsEthiopic . #((#x1200 . #x137F)))
  (U-IsCherokee . #((#x13A0 . #x13FF)))
  (U-IsUnifiedCanadianAboriginalSyllabics . #((#x1400 . #x167F)))
  (U-IsOgham . #((#x1680 . #x169F)))
  (U-IsRunic . #((#x16A0 . #x16FF)))
  (U-IsKhmer . #((#x1780 . #x17FF)))
  (U-IsMongolian . #((#x1800 . #x18AF)))
  (U-IsLatinExtendedAdditional . #((#x1E00 . #x1EFF)))
  (U-IsGreekExtended . #((#x1F00 . #x1FFF)))
  (U-IsGeneralPunctuation . #((#x2000 . #x206F)))
  (U-IsSuperscriptsandSubscripts . #((#x2070 . #x209F)))
  (U-IsCurrencySymbols . #((#x20A0 . #x20CF)))
  (U-IsCombiningMarksforSymbols . #((#x20D0 . #x20FF)))
  (U-IsLetterlikeSymbols . #((#x2100 . #x214F)))
  (U-IsNumberForms . #((#x2150 . #x218F)))
  (U-IsArrows . #((#x2190 . #x21FF)))
  (U-IsMathematicalOperators . #((#x2200 . #x22FF)))
  (U-IsMiscellaneousTechnical . #((#x2300 . #x23FF)))
  (U-IsControlPictures . #((#x2400 . #x243F)))
  (U-IsOpticalCharacterRecognition . #((#x2440 . #x245F)))
  (U-IsEnclosedAlphanumerics . #((#x2460 . #x24FF)))
  (U-IsBoxDrawing . #((#x2500 . #x257F)))
  (U-IsBlockElements . #((#x2580 . #x259F)))
  (U-IsGeometricShapes . #((#x25A0 . #x25FF)))
  (U-IsMiscellaneousSymbols . #((#x2600 . #x26FF)))
  (U-IsDingbats . #((#x2700 . #x27BF)))
  (U-IsBraillePatterns . #((#x2800 . #x28FF)))
  (U-IsCJKRadicalsSupplement . #((#x2E80 . #x2EFF)))
  (U-IsKangxiRadicals . #((#x2F00 . #x2FDF)))
  (U-IsIdeographicDescriptionCharacters . #((#x2FF0 . #x2FFF)))
  (U-IsCJKSymbolsandPunctuation . #((#x3000 . #x303F)))
  (U-IsHiragana . #((#x3040 . #x309F)))
  (U-IsKatakana . #((#x30A0 . #x30FF)))
  (U-IsBopomofo . #((#x3100 . #x312F)))
  (U-IsHangulCompatibilityJamo . #((#x3130 . #x318F)))
  (U-IsKanbun . #((#x3190 . #x319F)))
  (U-IsBopomofoExtended . #((#x31A0 . #x31BF)))
  (U-IsEnclosedCJKLettersandMonths . #((#x3200 . #x32FF)))
  (U-IsCJKCompatibility . #((#x3300 . #x33FF)))
  (U-IsCJKUnifiedIdeographsExtensionA . #((#x3400 . #x4DB5)))
  (U-IsCJKUnifiedIdeographs . #((#x4E00 . #x9FFF)))
  (U-IsYiSyllables . #((#xA000 . #xA48F)))
  (U-IsYiRadicals . #((#xA490 . #xA4CF)))
  (U-IsHangulSyllables . #((#xAC00 . #xD7A3)))
  (U-IsCJKCompatibilityIdeographs . #((#xF900 . #xFAFF)))
  (U-IsAlphabeticPresentationForms . #((#xFB00 . #xFB4F)))
  (U-IsArabicPresentationForms-A . #((#xFB50 . #xFDFF)))
  (U-IsCombiningHalfMarks . #((#xFE20 . #xFE2F)))
  (U-IsCJKCompatibilityForms . #((#xFE30 . #xFE4F)))
  (U-IsSmallFormVariants . #((#xFE50 . #xFE6F)))
  (U-IsArabicPresentationForms-B . #((#xFE70 . #xFEFE)))
  (U-IsSpecials . #((#xFEFF . #xFEFF) (#xFFF0 . #xFFFD)))
  (U-IsHalfwidthandFullwidthForms . #((#xFF00 . #xFFEF)))
  (U-IsOldItalic . #((#x10300 . #x1032F)))
  (U-IsGothic . #((#x10330 . #x1034F)))
  (U-IsDeseret . #((#x10400 . #x1044F)))
  (U-IsByzantineMusicalSymbols . #((#x1D000 . #x1D0FF)))
  (U-IsMusicalSymbols . #((#x1D100 . #x1D1FF)))
  (U-IsMathematicalAlphanumericSymbols . #((#x1D400 . #x1D7FF)))
  (U-IsCJKUnifiedIdeographsExtensionB . #((#x20000 . #x2A6D6)))
  (U-IsCJKCompatibilityIdeographsSupplement . #((#x2F800 . #x2FA1F)))
  (U-IsTags . #((#xE0000 . #xE007F)))
  (U-IsPrivateUse . #((#xE000 . #xF8FF) (#xF0000 . #xFFFFD) (#x100000 . #x10FFFD)))

  (U-L)

  (U-Lu . #((#x41 . #x5A) (#xC0 . #xD6) (#xD8 . #xDE) (#x100 . #x100) (#x102 . #x102)
  (#x104 . #x104) (#x106 . #x106) (#x108 . #x108) (#x10A . #x10A) (#x10C . #x10C)
  (#x10E . #x10E) (#x110 . #x110) (#x112 . #x112) (#x114 . #x114) (#x116 . #x116)
  (#x118 . #x118) (#x11A . #x11A) (#x11C . #x11C) (#x11E . #x11E) (#x120 . #x120)
  (#x122 . #x122) (#x124 . #x124) (#x126 . #x126) (#x128 . #x128) (#x12A . #x12A)
  (#x12C . #x12C) (#x12E . #x12E) (#x130 . #x130) (#x132 . #x132) (#x134 . #x134)
  (#x136 . #x136) (#x139 . #x139) (#x13B . #x13B) (#x13D . #x13D) (#x13F . #x13F)
  (#x141 . #x141) (#x143 . #x143) (#x145 . #x145) (#x147 . #x147) (#x14A . #x14A)
  (#x14C . #x14C) (#x14E . #x14E) (#x150 . #x150) (#x152 . #x152) (#x154 . #x154)
  (#x156 . #x156) (#x158 . #x158) (#x15A . #x15A) (#x15C . #x15C) (#x15E . #x15E)
  (#x160 . #x160) (#x162 . #x162) (#x164 . #x164) (#x166 . #x166) (#x168 . #x168)
  (#x16A . #x16A) (#x16C . #x16C) (#x16E . #x16E) (#x170 . #x170) (#x172 . #x172)
  (#x174 . #x174) (#x176 . #x176) (#x178 . #x179) (#x17B . #x17B) (#x17D . #x17D)
  (#x181 . #x182) (#x184 . #x184) (#x186 . #x187) (#x189 . #x18B) (#x18E . #x191)
  (#x193 . #x194) (#x196 . #x198) (#x19C . #x19D) (#x19F . #x1A0) (#x1A2 . #x1A2)
  (#x1A4 . #x1A4) (#x1A6 . #x1A7) (#x1A9 . #x1A9) (#x1AC . #x1AC) (#x1AE . #x1AF)
  (#x1B1 . #x1B3) (#x1B5 . #x1B5) (#x1B7 . #x1B8) (#x1BC . #x1BC) (#x1C4 . #x1C4)
  (#x1C7 . #x1C7) (#x1CA . #x1CA) (#x1CD . #x1CD) (#x1CF . #x1CF) (#x1D1 . #x1D1)
  (#x1D3 . #x1D3) (#x1D5 . #x1D5) (#x1D7 . #x1D7) (#x1D9 . #x1D9) (#x1DB . #x1DB)
  (#x1DE . #x1DE) (#x1E0 . #x1E0) (#x1E2 . #x1E2) (#x1E4 . #x1E4) (#x1E6 . #x1E6)
  (#x1E8 . #x1E8) (#x1EA . #x1EA) (#x1EC . #x1EC) (#x1EE . #x1EE) (#x1F1 . #x1F1)
  (#x1F4 . #x1F4) (#x1F6 . #x1F8) (#x1FA . #x1FA) (#x1FC . #x1FC) (#x1FE . #x1FE)
  (#x200 . #x200) (#x202 . #x202) (#x204 . #x204) (#x206 . #x206) (#x208 . #x208)
  (#x20A . #x20A) (#x20C . #x20C) (#x20E . #x20E) (#x210 . #x210) (#x212 . #x212)
  (#x214 . #x214) (#x216 . #x216) (#x218 . #x218) (#x21A . #x21A) (#x21C . #x21C)
  (#x21E . #x21E) (#x222 . #x222) (#x224 . #x224) (#x226 . #x226) (#x228 . #x228)
  (#x22A . #x22A) (#x22C . #x22C) (#x22E . #x22E) (#x230 . #x230) (#x232 . #x232)
  (#x386 . #x386) (#x388 . #x38A) (#x38C . #x38C) (#x38E . #x38F) (#x391 . #x3A1)
  (#x3A3 . #x3AB) (#x3D2 . #x3D4) (#x3DA . #x3DA) (#x3DC . #x3DC) (#x3DE . #x3DE)
  (#x3E0 . #x3E0) (#x3E2 . #x3E2) (#x3E4 . #x3E4) (#x3E6 . #x3E6) (#x3E8 . #x3E8)
  (#x3EA . #x3EA) (#x3EC . #x3EC) (#x3EE . #x3EE) (#x3F4 . #x3F4) (#x400 . #x42F)
  (#x460 . #x460) (#x462 . #x462) (#x464 . #x464) (#x466 . #x466) (#x468 . #x468)
  (#x46A . #x46A) (#x46C . #x46C) (#x46E . #x46E) (#x470 . #x470) (#x472 . #x472)
  (#x474 . #x474) (#x476 . #x476) (#x478 . #x478) (#x47A . #x47A) (#x47C . #x47C)
  (#x47E . #x47E) (#x480 . #x480) (#x48C . #x48C) (#x48E . #x48E) (#x490 . #x490)
  (#x492 . #x492) (#x494 . #x494) (#x496 . #x496) (#x498 . #x498) (#x49A . #x49A)
  (#x49C . #x49C) (#x49E . #x49E) (#x4A0 . #x4A0) (#x4A2 . #x4A2) (#x4A4 . #x4A4)
  (#x4A6 . #x4A6) (#x4A8 . #x4A8) (#x4AA . #x4AA) (#x4AC . #x4AC) (#x4AE . #x4AE)
  (#x4B0 . #x4B0) (#x4B2 . #x4B2) (#x4B4 . #x4B4) (#x4B6 . #x4B6) (#x4B8 . #x4B8)
  (#x4BA . #x4BA) (#x4BC . #x4BC) (#x4BE . #x4BE) (#x4C0 . #x4C1) (#x4C3 . #x4C3)
  (#x4C7 . #x4C7) (#x4CB . #x4CB) (#x4D0 . #x4D0) (#x4D2 . #x4D2) (#x4D4 . #x4D4)
  (#x4D6 . #x4D6) (#x4D8 . #x4D8) (#x4DA . #x4DA) (#x4DC . #x4DC) (#x4DE . #x4DE)
  (#x4E0 . #x4E0) (#x4E2 . #x4E2) (#x4E4 . #x4E4) (#x4E6 . #x4E6) (#x4E8 . #x4E8)
  (#x4EA . #x4EA) (#x4EC . #x4EC) (#x4EE . #x4EE) (#x4F0 . #x4F0) (#x4F2 . #x4F2)
  (#x4F4 . #x4F4) (#x4F8 . #x4F8) (#x531 . #x556) (#x10A0 . #x10C5) (#x1E00 . #x1E00)
  (#x1E02 . #x1E02) (#x1E04 . #x1E04) (#x1E06 . #x1E06) (#x1E08 . #x1E08)
  (#x1E0A . #x1E0A) (#x1E0C . #x1E0C) (#x1E0E . #x1E0E) (#x1E10 . #x1E10)
  (#x1E12 . #x1E12) (#x1E14 . #x1E14) (#x1E16 . #x1E16) (#x1E18 . #x1E18)
  (#x1E1A . #x1E1A) (#x1E1C . #x1E1C) (#x1E1E . #x1E1E) (#x1E20 . #x1E20)
  (#x1E22 . #x1E22) (#x1E24 . #x1E24) (#x1E26 . #x1E26) (#x1E28 . #x1E28)
  (#x1E2A . #x1E2A) (#x1E2C . #x1E2C) (#x1E2E . #x1E2E) (#x1E30 . #x1E30)
  (#x1E32 . #x1E32) (#x1E34 . #x1E34) (#x1E36 . #x1E36) (#x1E38 . #x1E38)
  (#x1E3A . #x1E3A) (#x1E3C . #x1E3C) (#x1E3E . #x1E3E) (#x1E40 . #x1E40)
  (#x1E42 . #x1E42) (#x1E44 . #x1E44) (#x1E46 . #x1E46) (#x1E48 . #x1E48)
  (#x1E4A . #x1E4A) (#x1E4C . #x1E4C) (#x1E4E . #x1E4E) (#x1E50 . #x1E50)
  (#x1E52 . #x1E52) (#x1E54 . #x1E54) (#x1E56 . #x1E56) (#x1E58 . #x1E58)
  (#x1E5A . #x1E5A) (#x1E5C . #x1E5C) (#x1E5E . #x1E5E) (#x1E60 . #x1E60)
  (#x1E62 . #x1E62) (#x1E64 . #x1E64) (#x1E66 . #x1E66) (#x1E68 . #x1E68)
  (#x1E6A . #x1E6A) (#x1E6C . #x1E6C) (#x1E6E . #x1E6E) (#x1E70 . #x1E70)
  (#x1E72 . #x1E72) (#x1E74 . #x1E74) (#x1E76 . #x1E76) (#x1E78 . #x1E78)
  (#x1E7A . #x1E7A) (#x1E7C . #x1E7C) (#x1E7E . #x1E7E) (#x1E80 . #x1E80)
  (#x1E82 . #x1E82) (#x1E84 . #x1E84) (#x1E86 . #x1E86) (#x1E88 . #x1E88)
  (#x1E8A . #x1E8A) (#x1E8C . #x1E8C) (#x1E8E . #x1E8E) (#x1E90 . #x1E90)
  (#x1E92 . #x1E92) (#x1E94 . #x1E94) (#x1EA0 . #x1EA0) (#x1EA2 . #x1EA2)
  (#x1EA4 . #x1EA4) (#x1EA6 . #x1EA6) (#x1EA8 . #x1EA8) (#x1EAA . #x1EAA)
  (#x1EAC . #x1EAC) (#x1EAE . #x1EAE) (#x1EB0 . #x1EB0) (#x1EB2 . #x1EB2)
  (#x1EB4 . #x1EB4) (#x1EB6 . #x1EB6) (#x1EB8 . #x1EB8) (#x1EBA . #x1EBA)
  (#x1EBC . #x1EBC) (#x1EBE . #x1EBE) (#x1EC0 . #x1EC0) (#x1EC2 . #x1EC2)
  (#x1EC4 . #x1EC4) (#x1EC6 . #x1EC6) (#x1EC8 . #x1EC8) (#x1ECA . #x1ECA)
  (#x1ECC . #x1ECC) (#x1ECE . #x1ECE) (#x1ED0 . #x1ED0) (#x1ED2 . #x1ED2)
  (#x1ED4 . #x1ED4) (#x1ED6 . #x1ED6) (#x1ED8 . #x1ED8) (#x1EDA . #x1EDA)
  (#x1EDC . #x1EDC) (#x1EDE . #x1EDE) (#x1EE0 . #x1EE0) (#x1EE2 . #x1EE2)
  (#x1EE4 . #x1EE4) (#x1EE6 . #x1EE6) (#x1EE8 . #x1EE8) (#x1EEA . #x1EEA)
  (#x1EEC . #x1EEC) (#x1EEE . #x1EEE) (#x1EF0 . #x1EF0) (#x1EF2 . #x1EF2)
  (#x1EF4 . #x1EF4) (#x1EF6 . #x1EF6) (#x1EF8 . #x1EF8) (#x1F08 . #x1F0F)
  (#x1F18 . #x1F1D) (#x1F28 . #x1F2F) (#x1F38 . #x1F3F) (#x1F48 . #x1F4D)
  (#x1F59 . #x1F59) (#x1F5B . #x1F5B) (#x1F5D . #x1F5D) (#x1F5F . #x1F5F)
  (#x1F68 . #x1F6F) (#x1FB8 . #x1FBB) (#x1FC8 . #x1FCB) (#x1FD8 . #x1FDB)
  (#x1FE8 . #x1FEC) (#x1FF8 . #x1FFB) (#x2102 . #x2102) (#x2107 . #x2107)
  (#x210B . #x210D) (#x2110 . #x2112) (#x2115 . #x2115) (#x2119 . #x211D)
  (#x2124 . #x2124) (#x2126 . #x2126) (#x2128 . #x2128) (#x212A . #x212D)
  (#x2130 . #x2131) (#x2133 . #x2133) (#xFF21 . #xFF3A) (#x10400 . #x10425)
  (#x1D400 . #x1D419) (#x1D434 . #x1D44D) (#x1D468 . #x1D481) (#x1D49C . #x1D49C)
  (#x1D49E . #x1D49F) (#x1D4A2 . #x1D4A2) (#x1D4A5 . #x1D4A6) (#x1D4A9 . #x1D4AC)
  (#x1D4AE . #x1D4B5) (#x1D4D0 . #x1D4E9) (#x1D504 . #x1D505) (#x1D507 . #x1D50A)
  (#x1D50D . #x1D514) (#x1D516 . #x1D51C) (#x1D538 . #x1D539) (#x1D53B . #x1D53E)
  (#x1D540 . #x1D544) (#x1D546 . #x1D546) (#x1D54A . #x1D550) (#x1D56C . #x1D585)
  (#x1D5A0 . #x1D5B9) (#x1D5D4 . #x1D5ED) (#x1D608 . #x1D621) (#x1D63C . #x1D655)
  (#x1D670 . #x1D689) (#x1D6A8 . #x1D6C0) (#x1D6E2 . #x1D6FA) (#x1D71C . #x1D734)
  (#x1D756 . #x1D76E) (#x1D790 . #x1D7A8)))

  (U-Ll . #((#x61 . #x7A) (#xAA . #xAA) (#xB5 . #xB5) (#xBA . #xBA) (#xDF . #xF6)
  (#xF8 . #xFF) (#x101 . #x101) (#x103 . #x103) (#x105 . #x105) (#x107 . #x107)
  (#x109 . #x109) (#x10B . #x10B) (#x10D . #x10D) (#x10F . #x10F) (#x111 . #x111)
  (#x113 . #x113) (#x115 . #x115) (#x117 . #x117) (#x119 . #x119) (#x11B . #x11B)
  (#x11D . #x11D) (#x11F . #x11F) (#x121 . #x121) (#x123 . #x123) (#x125 . #x125)
  (#x127 . #x127) (#x129 . #x129) (#x12B . #x12B) (#x12D . #x12D) (#x12F . #x12F)
  (#x131 . #x131) (#x133 . #x133) (#x135 . #x135) (#x137 . #x138) (#x13A . #x13A)
  (#x13C . #x13C) (#x13E . #x13E) (#x140 . #x140) (#x142 . #x142) (#x144 . #x144)
  (#x146 . #x146) (#x148 . #x149) (#x14B . #x14B) (#x14D . #x14D) (#x14F . #x14F)
  (#x151 . #x151) (#x153 . #x153) (#x155 . #x155) (#x157 . #x157) (#x159 . #x159)
  (#x15B . #x15B) (#x15D . #x15D) (#x15F . #x15F) (#x161 . #x161) (#x163 . #x163)
  (#x165 . #x165) (#x167 . #x167) (#x169 . #x169) (#x16B . #x16B) (#x16D . #x16D)
  (#x16F . #x16F) (#x171 . #x171) (#x173 . #x173) (#x175 . #x175) (#x177 . #x177)
  (#x17A . #x17A) (#x17C . #x17C) (#x17E . #x180) (#x183 . #x183) (#x185 . #x185)
  (#x188 . #x188) (#x18C . #x18D) (#x192 . #x192) (#x195 . #x195) (#x199 . #x19B)
  (#x19E . #x19E) (#x1A1 . #x1A1) (#x1A3 . #x1A3) (#x1A5 . #x1A5) (#x1A8 . #x1A8)
  (#x1AA . #x1AB) (#x1AD . #x1AD) (#x1B0 . #x1B0) (#x1B4 . #x1B4) (#x1B6 . #x1B6)
  (#x1B9 . #x1BA) (#x1BD . #x1BF) (#x1C6 . #x1C6) (#x1C9 . #x1C9) (#x1CC . #x1CC)
  (#x1CE . #x1CE) (#x1D0 . #x1D0) (#x1D2 . #x1D2) (#x1D4 . #x1D4) (#x1D6 . #x1D6)
  (#x1D8 . #x1D8) (#x1DA . #x1DA) (#x1DC . #x1DD) (#x1DF . #x1DF) (#x1E1 . #x1E1)
  (#x1E3 . #x1E3) (#x1E5 . #x1E5) (#x1E7 . #x1E7) (#x1E9 . #x1E9) (#x1EB . #x1EB)
  (#x1ED . #x1ED) (#x1EF . #x1F0) (#x1F3 . #x1F3) (#x1F5 . #x1F5) (#x1F9 . #x1F9)
  (#x1FB . #x1FB) (#x1FD . #x1FD) (#x1FF . #x1FF) (#x201 . #x201) (#x203 . #x203)
  (#x205 . #x205) (#x207 . #x207) (#x209 . #x209) (#x20B . #x20B) (#x20D . #x20D)
  (#x20F . #x20F) (#x211 . #x211) (#x213 . #x213) (#x215 . #x215) (#x217 . #x217)
  (#x219 . #x219) (#x21B . #x21B) (#x21D . #x21D) (#x21F . #x21F) (#x223 . #x223)
  (#x225 . #x225) (#x227 . #x227) (#x229 . #x229) (#x22B . #x22B) (#x22D . #x22D)
  (#x22F . #x22F) (#x231 . #x231) (#x233 . #x233) (#x250 . #x2AD) (#x390 . #x390)
  (#x3AC . #x3CE) (#x3D0 . #x3D1) (#x3D5 . #x3D7) (#x3DB . #x3DB) (#x3DD . #x3DD)
  (#x3DF . #x3DF) (#x3E1 . #x3E1) (#x3E3 . #x3E3) (#x3E5 . #x3E5) (#x3E7 . #x3E7)
  (#x3E9 . #x3E9) (#x3EB . #x3EB) (#x3ED . #x3ED) (#x3EF . #x3F3) (#x3F5 . #x3F5)
  (#x430 . #x45F) (#x461 . #x461) (#x463 . #x463) (#x465 . #x465) (#x467 . #x467)
  (#x469 . #x469) (#x46B . #x46B) (#x46D . #x46D) (#x46F . #x46F) (#x471 . #x471)
  (#x473 . #x473) (#x475 . #x475) (#x477 . #x477) (#x479 . #x479) (#x47B . #x47B)
  (#x47D . #x47D) (#x47F . #x47F) (#x481 . #x481) (#x48D . #x48D) (#x48F . #x48F)
  (#x491 . #x491) (#x493 . #x493) (#x495 . #x495) (#x497 . #x497) (#x499 . #x499)
  (#x49B . #x49B) (#x49D . #x49D) (#x49F . #x49F) (#x4A1 . #x4A1) (#x4A3 . #x4A3)
  (#x4A5 . #x4A5) (#x4A7 . #x4A7) (#x4A9 . #x4A9) (#x4AB . #x4AB) (#x4AD . #x4AD)
  (#x4AF . #x4AF) (#x4B1 . #x4B1) (#x4B3 . #x4B3) (#x4B5 . #x4B5) (#x4B7 . #x4B7)
  (#x4B9 . #x4B9) (#x4BB . #x4BB) (#x4BD . #x4BD) (#x4BF . #x4BF) (#x4C2 . #x4C2)
  (#x4C4 . #x4C4) (#x4C8 . #x4C8) (#x4CC . #x4CC) (#x4D1 . #x4D1) (#x4D3 . #x4D3)
  (#x4D5 . #x4D5) (#x4D7 . #x4D7) (#x4D9 . #x4D9) (#x4DB . #x4DB) (#x4DD . #x4DD)
  (#x4DF . #x4DF) (#x4E1 . #x4E1) (#x4E3 . #x4E3) (#x4E5 . #x4E5) (#x4E7 . #x4E7)
  (#x4E9 . #x4E9) (#x4EB . #x4EB) (#x4ED . #x4ED) (#x4EF . #x4EF) (#x4F1 . #x4F1)
  (#x4F3 . #x4F3) (#x4F5 . #x4F5) (#x4F9 . #x4F9) (#x561 . #x587) (#x1E01 . #x1E01)
  (#x1E03 . #x1E03) (#x1E05 . #x1E05) (#x1E07 . #x1E07) (#x1E09 . #x1E09)
  (#x1E0B . #x1E0B) (#x1E0D . #x1E0D) (#x1E0F . #x1E0F) (#x1E11 . #x1E11)
  (#x1E13 . #x1E13) (#x1E15 . #x1E15) (#x1E17 . #x1E17) (#x1E19 . #x1E19)
  (#x1E1B . #x1E1B) (#x1E1D . #x1E1D) (#x1E1F . #x1E1F) (#x1E21 . #x1E21)
  (#x1E23 . #x1E23) (#x1E25 . #x1E25) (#x1E27 . #x1E27) (#x1E29 . #x1E29)
  (#x1E2B . #x1E2B) (#x1E2D . #x1E2D) (#x1E2F . #x1E2F) (#x1E31 . #x1E31)
  (#x1E33 . #x1E33) (#x1E35 . #x1E35) (#x1E37 . #x1E37) (#x1E39 . #x1E39)
  (#x1E3B . #x1E3B) (#x1E3D . #x1E3D) (#x1E3F . #x1E3F) (#x1E41 . #x1E41)
  (#x1E43 . #x1E43) (#x1E45 . #x1E45) (#x1E47 . #x1E47) (#x1E49 . #x1E49)
  (#x1E4B . #x1E4B) (#x1E4D . #x1E4D) (#x1E4F . #x1E4F) (#x1E51 . #x1E51)
  (#x1E53 . #x1E53) (#x1E55 . #x1E55) (#x1E57 . #x1E57) (#x1E59 . #x1E59)
  (#x1E5B . #x1E5B) (#x1E5D . #x1E5D) (#x1E5F . #x1E5F) (#x1E61 . #x1E61)
  (#x1E63 . #x1E63) (#x1E65 . #x1E65) (#x1E67 . #x1E67) (#x1E69 . #x1E69)
  (#x1E6B . #x1E6B) (#x1E6D . #x1E6D) (#x1E6F . #x1E6F) (#x1E71 . #x1E71)
  (#x1E73 . #x1E73) (#x1E75 . #x1E75) (#x1E77 . #x1E77) (#x1E79 . #x1E79)
  (#x1E7B . #x1E7B) (#x1E7D . #x1E7D) (#x1E7F . #x1E7F) (#x1E81 . #x1E81)
  (#x1E83 . #x1E83) (#x1E85 . #x1E85) (#x1E87 . #x1E87) (#x1E89 . #x1E89)
  (#x1E8B . #x1E8B) (#x1E8D . #x1E8D) (#x1E8F . #x1E8F) (#x1E91 . #x1E91)
  (#x1E93 . #x1E93) (#x1E95 . #x1E9B) (#x1EA1 . #x1EA1) (#x1EA3 . #x1EA3)
  (#x1EA5 . #x1EA5) (#x1EA7 . #x1EA7) (#x1EA9 . #x1EA9) (#x1EAB . #x1EAB)
  (#x1EAD . #x1EAD) (#x1EAF . #x1EAF) (#x1EB1 . #x1EB1) (#x1EB3 . #x1EB3)
  (#x1EB5 . #x1EB5) (#x1EB7 . #x1EB7) (#x1EB9 . #x1EB9) (#x1EBB . #x1EBB)
  (#x1EBD . #x1EBD) (#x1EBF . #x1EBF) (#x1EC1 . #x1EC1) (#x1EC3 . #x1EC3)
  (#x1EC5 . #x1EC5) (#x1EC7 . #x1EC7) (#x1EC9 . #x1EC9) (#x1ECB . #x1ECB)
  (#x1ECD . #x1ECD) (#x1ECF . #x1ECF) (#x1ED1 . #x1ED1) (#x1ED3 . #x1ED3)
  (#x1ED5 . #x1ED5) (#x1ED7 . #x1ED7) (#x1ED9 . #x1ED9) (#x1EDB . #x1EDB)
  (#x1EDD . #x1EDD) (#x1EDF . #x1EDF) (#x1EE1 . #x1EE1) (#x1EE3 . #x1EE3)
  (#x1EE5 . #x1EE5) (#x1EE7 . #x1EE7) (#x1EE9 . #x1EE9) (#x1EEB . #x1EEB)
  (#x1EED . #x1EED) (#x1EEF . #x1EEF) (#x1EF1 . #x1EF1) (#x1EF3 . #x1EF3)
  (#x1EF5 . #x1EF5) (#x1EF7 . #x1EF7) (#x1EF9 . #x1EF9) (#x1F00 . #x1F07)
  (#x1F10 . #x1F15) (#x1F20 . #x1F27) (#x1F30 . #x1F37) (#x1F40 . #x1F45)
  (#x1F50 . #x1F57) (#x1F60 . #x1F67) (#x1F70 . #x1F7D) (#x1F80 . #x1F87)
  (#x1F90 . #x1F97) (#x1FA0 . #x1FA7) (#x1FB0 . #x1FB4) (#x1FB6 . #x1FB7)
  (#x1FBE . #x1FBE) (#x1FC2 . #x1FC4) (#x1FC6 . #x1FC7) (#x1FD0 . #x1FD3)
  (#x1FD6 . #x1FD7) (#x1FE0 . #x1FE7) (#x1FF2 . #x1FF4) (#x1FF6 . #x1FF7)
  (#x207F . #x207F) (#x210A . #x210A) (#x210E . #x210F) (#x2113 . #x2113)
  (#x212F . #x212F) (#x2134 . #x2134) (#x2139 . #x2139) (#xFB00 . #xFB06)
  (#xFB13 . #xFB17) (#xFF41 . #xFF5A) (#x10428 . #x1044D) (#x1D41A . #x1D433)
  (#x1D44E . #x1D454) (#x1D456 . #x1D467) (#x1D482 . #x1D49B) (#x1D4B6 . #x1D4B9)
  (#x1D4BB . #x1D4BB) (#x1D4BD . #x1D4C0) (#x1D4C2 . #x1D4C3) (#x1D4C5 . #x1D4CF)
  (#x1D4EA . #x1D503) (#x1D51E . #x1D537) (#x1D552 . #x1D56B) (#x1D586 . #x1D59F)
  (#x1D5BA . #x1D5D3) (#x1D5EE . #x1D607) (#x1D622 . #x1D63B) (#x1D656 . #x1D66F)
  (#x1D68A . #x1D6A3) (#x1D6C2 . #x1D6DA) (#x1D6DC . #x1D6E1) (#x1D6FC . #x1D714)
  (#x1D716 . #x1D71B) (#x1D736 . #x1D74E) (#x1D750 . #x1D755) (#x1D770 . #x1D788)
  (#x1D78A . #x1D78F) (#x1D7AA . #x1D7C2) (#x1D7C4 . #x1D7C9)))

  (U-Lt . #((#x1C5 . #x1C5) (#x1C8 . #x1C8) (#x1CB . #x1CB) (#x1F2 . #x1F2)
  (#x1F88 . #x1F8F) (#x1F98 . #x1F9F) (#x1FA8 . #x1FAF) (#x1FBC . #x1FBC)
  (#x1FCC . #x1FCC) (#x1FFC . #x1FFC)))

  (U-Lm . #((#x2B0 . #x2B8) (#x2BB . #x2C1) (#x2D0 . #x2D1) (#x2E0 . #x2E4)
  (#x2EE . #x2EE) (#x37A . #x37A) (#x559 . #x559) (#x640 . #x640) (#x6E5 . #x6E6)
  (#xE46 . #xE46) (#xEC6 . #xEC6) (#x1843 . #x1843) (#x3005 . #x3005)
  (#x3031 . #x3035) (#x309D . #x309E) (#x30FC . #x30FE) (#xFF70 . #xFF70)
  (#xFF9E . #xFF9F)))

  (U-Lo . #((#x1BB . #x1BB) (#x1C0 . #x1C3) (#x5D0 . #x5EA) (#x5F0 . #x5F2)
  (#x621 . #x63A) (#x641 . #x64A) (#x671 . #x6D3) (#x6D5 . #x6D5) (#x6FA . #x6FC)
  (#x710 . #x710) (#x712 . #x72C) (#x780 . #x7A5) (#x905 . #x939) (#x93D . #x93D)
  (#x950 . #x950) (#x958 . #x961) (#x985 . #x98C) (#x98F . #x990) (#x993 . #x9A8)
  (#x9AA . #x9B0) (#x9B2 . #x9B2) (#x9B6 . #x9B9) (#x9DC . #x9DD) (#x9DF . #x9E1)
  (#x9F0 . #x9F1) (#xA05 . #xA0A) (#xA0F . #xA10) (#xA13 . #xA28) (#xA2A . #xA30)
  (#xA32 . #xA33) (#xA35 . #xA36) (#xA38 . #xA39) (#xA59 . #xA5C) (#xA5E . #xA5E)
  (#xA72 . #xA74) (#xA85 . #xA8B) (#xA8D . #xA8D) (#xA8F . #xA91) (#xA93 . #xAA8)
  (#xAAA . #xAB0) (#xAB2 . #xAB3) (#xAB5 . #xAB9) (#xABD . #xABD) (#xAD0 . #xAD0)
  (#xAE0 . #xAE0) (#xB05 . #xB0C) (#xB0F . #xB10) (#xB13 . #xB28) (#xB2A . #xB30)
  (#xB32 . #xB33) (#xB36 . #xB39) (#xB3D . #xB3D) (#xB5C . #xB5D) (#xB5F . #xB61)
  (#xB85 . #xB8A) (#xB8E . #xB90) (#xB92 . #xB95) (#xB99 . #xB9A) (#xB9C . #xB9C)
  (#xB9E . #xB9F) (#xBA3 . #xBA4) (#xBA8 . #xBAA) (#xBAE . #xBB5) (#xBB7 . #xBB9)
  (#xC05 . #xC0C) (#xC0E . #xC10) (#xC12 . #xC28) (#xC2A . #xC33) (#xC35 . #xC39)
  (#xC60 . #xC61) (#xC85 . #xC8C) (#xC8E . #xC90) (#xC92 . #xCA8) (#xCAA . #xCB3)
  (#xCB5 . #xCB9) (#xCDE . #xCDE) (#xCE0 . #xCE1) (#xD05 . #xD0C) (#xD0E . #xD10)
  (#xD12 . #xD28) (#xD2A . #xD39) (#xD60 . #xD61) (#xD85 . #xD96) (#xD9A . #xDB1)
  (#xDB3 . #xDBB) (#xDBD . #xDBD) (#xDC0 . #xDC6) (#xE01 . #xE30) (#xE32 . #xE33)
  (#xE40 . #xE45) (#xE81 . #xE82) (#xE84 . #xE84) (#xE87 . #xE88) (#xE8A . #xE8A)
  (#xE8D . #xE8D) (#xE94 . #xE97) (#xE99 . #xE9F) (#xEA1 . #xEA3) (#xEA5 . #xEA5)
  (#xEA7 . #xEA7) (#xEAA . #xEAB) (#xEAD . #xEB0) (#xEB2 . #xEB3) (#xEBD . #xEBD)
  (#xEC0 . #xEC4) (#xEDC . #xEDD) (#xF00 . #xF00) (#xF40 . #xF47) (#xF49 . #xF6A)
  (#xF88 . #xF8B) (#x1000 . #x1021) (#x1023 . #x1027) (#x1029 . #x102A)
  (#x1050 . #x1055) (#x10D0 . #x10F6) (#x1100 . #x1159) (#x115F . #x11A2)
  (#x11A8 . #x11F9) (#x1200 . #x1206) (#x1208 . #x1246) (#x1248 . #x1248)
  (#x124A . #x124D) (#x1250 . #x1256) (#x1258 . #x1258) (#x125A . #x125D)
  (#x1260 . #x1286) (#x1288 . #x1288) (#x128A . #x128D) (#x1290 . #x12AE)
  (#x12B0 . #x12B0) (#x12B2 . #x12B5) (#x12B8 . #x12BE) (#x12C0 . #x12C0)
  (#x12C2 . #x12C5) (#x12C8 . #x12CE) (#x12D0 . #x12D6) (#x12D8 . #x12EE)
  (#x12F0 . #x130E) (#x1310 . #x1310) (#x1312 . #x1315) (#x1318 . #x131E)
  (#x1320 . #x1346) (#x1348 . #x135A) (#x13A0 . #x13F4) (#x1401 . #x166C)
  (#x166F . #x1676) (#x1681 . #x169A) (#x16A0 . #x16EA) (#x1780 . #x17B3)
  (#x1820 . #x1842) (#x1844 . #x1877) (#x1880 . #x18A8) (#x2135 . #x2138)
  (#x3006 . #x3006) (#x3041 . #x3094) (#x30A1 . #x30FA) (#x3105 . #x312C)
  (#x3131 . #x318E) (#x31A0 . #x31B7) (#x3400 . #x4DB5) (#x4E00 . #x9FA5)
  (#xA000 . #xA48C) (#xAC00 . #xD7A3) (#xF900 . #xFA2D) (#xFB1D . #xFB1D)
  (#xFB1F . #xFB28) (#xFB2A . #xFB36) (#xFB38 . #xFB3C) (#xFB3E . #xFB3E)
  (#xFB40 . #xFB41) (#xFB43 . #xFB44) (#xFB46 . #xFBB1) (#xFBD3 . #xFD3D)
  (#xFD50 . #xFD8F) (#xFD92 . #xFDC7) (#xFDF0 . #xFDFB) (#xFE70 . #xFE72)
  (#xFE74 . #xFE74) (#xFE76 . #xFEFC) (#xFF66 . #xFF6F) (#xFF71 . #xFF9D)
  (#xFFA0 . #xFFBE) (#xFFC2 . #xFFC7) (#xFFCA . #xFFCF) (#xFFD2 . #xFFD7)
  (#xFFDA . #xFFDC) (#x10300 . #x1031E) (#x10330 . #x10349) (#x20000 . #x2A6D6)
  (#x2F800 . #x2FA1D)))

  (U-M)

  (U-Mn . #((#x300 . #x34E) (#x360 . #x362) (#x483 . #x486) (#x591 . #x5A1)
  (#x5A3 . #x5B9) (#x5BB . #x5BD) (#x5BF . #x5BF) (#x5C1 . #x5C2) (#x5C4 . #x5C4)
  (#x64B . #x655) (#x670 . #x670) (#x6D6 . #x6DC) (#x6DF . #x6E4) (#x6E7 . #x6E8)
  (#x6EA . #x6ED) (#x711 . #x711) (#x730 . #x74A) (#x7A6 . #x7B0) (#x901 . #x902)
  (#x93C . #x93C) (#x941 . #x948) (#x94D . #x94D) (#x951 . #x954) (#x962 . #x963)
  (#x981 . #x981) (#x9BC . #x9BC) (#x9C1 . #x9C4) (#x9CD . #x9CD) (#x9E2 . #x9E3)
  (#xA02 . #xA02) (#xA3C . #xA3C) (#xA41 . #xA42) (#xA47 . #xA48) (#xA4B . #xA4D)
  (#xA70 . #xA71) (#xA81 . #xA82) (#xABC . #xABC) (#xAC1 . #xAC5) (#xAC7 . #xAC8)
  (#xACD . #xACD) (#xB01 . #xB01) (#xB3C . #xB3C) (#xB3F . #xB3F) (#xB41 . #xB43)
  (#xB4D . #xB4D) (#xB56 . #xB56) (#xB82 . #xB82) (#xBC0 . #xBC0) (#xBCD . #xBCD)
  (#xC3E . #xC40) (#xC46 . #xC48) (#xC4A . #xC4D) (#xC55 . #xC56) (#xCBF . #xCBF)
  (#xCC6 . #xCC6) (#xCCC . #xCCD) (#xD41 . #xD43) (#xD4D . #xD4D) (#xDCA . #xDCA)
  (#xDD2 . #xDD4) (#xDD6 . #xDD6) (#xE31 . #xE31) (#xE34 . #xE3A) (#xE47 . #xE4E)
  (#xEB1 . #xEB1) (#xEB4 . #xEB9) (#xEBB . #xEBC) (#xEC8 . #xECD) (#xF18 . #xF19)
  (#xF35 . #xF35) (#xF37 . #xF37) (#xF39 . #xF39) (#xF71 . #xF7E) (#xF80 . #xF84)
  (#xF86 . #xF87) (#xF90 . #xF97) (#xF99 . #xFBC) (#xFC6 . #xFC6) (#x102D . #x1030)
  (#x1032 . #x1032) (#x1036 . #x1037) (#x1039 . #x1039) (#x1058 . #x1059)
  (#x17B7 . #x17BD) (#x17C6 . #x17C6) (#x17C9 . #x17D3) (#x18A9 . #x18A9)
  (#x20D0 . #x20DC) (#x20E1 . #x20E1) (#x302A . #x302F) (#x3099 . #x309A)
  (#xFB1E . #xFB1E) (#xFE20 . #xFE23) (#x1D167 . #x1D169) (#x1D17B . #x1D182)
  (#x1D185 . #x1D18B) (#x1D1AA . #x1D1AD)))

  (U-Mc . #((#x903 . #x903) (#x93E . #x940) (#x949 . #x94C) (#x982 . #x983)
  (#x9BE . #x9C0) (#x9C7 . #x9C8) (#x9CB . #x9CC) (#x9D7 . #x9D7) (#xA3E . #xA40)
  (#xA83 . #xA83) (#xABE . #xAC0) (#xAC9 . #xAC9) (#xACB . #xACC) (#xB02 . #xB03)
  (#xB3E . #xB3E) (#xB40 . #xB40) (#xB47 . #xB48) (#xB4B . #xB4C) (#xB57 . #xB57)
  (#xB83 . #xB83) (#xBBE . #xBBF) (#xBC1 . #xBC2) (#xBC6 . #xBC8) (#xBCA . #xBCC)
  (#xBD7 . #xBD7) (#xC01 . #xC03) (#xC41 . #xC44) (#xC82 . #xC83) (#xCBE . #xCBE)
  (#xCC0 . #xCC4) (#xCC7 . #xCC8) (#xCCA . #xCCB) (#xCD5 . #xCD6) (#xD02 . #xD03)
  (#xD3E . #xD40) (#xD46 . #xD48) (#xD4A . #xD4C) (#xD57 . #xD57) (#xD82 . #xD83)
  (#xDCF . #xDD1) (#xDD8 . #xDDF) (#xDF2 . #xDF3) (#xF3E . #xF3F) (#xF7F . #xF7F)
  (#x102C . #x102C) (#x1031 . #x1031) (#x1038 . #x1038) (#x1056 . #x1057)
  (#x17B4 . #x17B6) (#x17BE . #x17C5) (#x17C7 . #x17C8) (#x1D165 . #x1D166)
  (#x1D16D . #x1D172)))

  (U-Me . #((#x488 . #x489) (#x6DD . #x6DE) (#x20DD . #x20E0) (#x20E2 . #x20E3)))

  (U-N)

  (U-Nd . #((#x30 . #x39) (#x660 . #x669) (#x6F0 . #x6F9) (#x966 . #x96F)
  (#x9E6 . #x9EF) (#xA66 . #xA6F) (#xAE6 . #xAEF) (#xB66 . #xB6F) (#xBE7 . #xBEF)
  (#xC66 . #xC6F) (#xCE6 . #xCEF) (#xD66 . #xD6F) (#xE50 . #xE59) (#xED0 . #xED9)
  (#xF20 . #xF29) (#x1040 . #x1049) (#x1369 . #x1371) (#x17E0 . #x17E9)
  (#x1810 . #x1819) (#xFF10 . #xFF19) (#x1D7CE . #x1D7FF)))

  (U-Nl . #((#x16EE . #x16F0) (#x2160 . #x2183) (#x3007 . #x3007) (#x3021 . #x3029)
  (#x3038 . #x303A) (#x1034A . #x1034A)))

  (U-No . #((#xB2 . #xB3) (#xB9 . #xB9) (#xBC . #xBE) (#x9F4 . #x9F9) (#xBF0 . #xBF2)
  (#xF2A . #xF33) (#x1372 . #x137C) (#x2070 . #x2070) (#x2074 . #x2079)
  (#x2080 . #x2089) (#x2153 . #x215F) (#x2460 . #x249B) (#x24EA . #x24EA)
  (#x2776 . #x2793) (#x3192 . #x3195) (#x3220 . #x3229) (#x3280 . #x3289)
  (#x10320 . #x10323)))

  (U-P)

  (U-Pc . #((#x5F . #x5F) (#x203F . #x2040) (#x30FB . #x30FB) (#xFE33 . #xFE34)
  (#xFE4D . #xFE4F) (#xFF3F . #xFF3F) (#xFF65 . #xFF65)))

  (U-Pd . #((#x2D . #x2D) (#xAD . #xAD) (#x58A . #x58A) (#x1806 . #x1806)
  (#x2010 . #x2015) (#x301C . #x301C) (#x3030 . #x3030) (#xFE31 . #xFE32)
  (#xFE58 . #xFE58) (#xFE63 . #xFE63) (#xFF0D . #xFF0D)))

  (U-Ps . #((#x28 . #x28) (#x5B . #x5B) (#x7B . #x7B) (#xF3A . #xF3A) (#xF3C . #xF3C)
  (#x169B . #x169B) (#x201A . #x201A) (#x201E . #x201E) (#x2045 . #x2045)
  (#x207D . #x207D) (#x208D . #x208D) (#x2329 . #x2329) (#x3008 . #x3008)
  (#x300A . #x300A) (#x300C . #x300C) (#x300E . #x300E) (#x3010 . #x3010)
  (#x3014 . #x3014) (#x3016 . #x3016) (#x3018 . #x3018) (#x301A . #x301A)
  (#x301D . #x301D) (#xFD3E . #xFD3E) (#xFE35 . #xFE35) (#xFE37 . #xFE37)
  (#xFE39 . #xFE39) (#xFE3B . #xFE3B) (#xFE3D . #xFE3D) (#xFE3F . #xFE3F)
  (#xFE41 . #xFE41) (#xFE43 . #xFE43) (#xFE59 . #xFE59) (#xFE5B . #xFE5B)
  (#xFE5D . #xFE5D) (#xFF08 . #xFF08) (#xFF3B . #xFF3B) (#xFF5B . #xFF5B)
  (#xFF62 . #xFF62)))

  (U-Pe . #((#x29 . #x29) (#x5D . #x5D) (#x7D . #x7D) (#xF3B . #xF3B) (#xF3D . #xF3D)
  (#x169C . #x169C) (#x2046 . #x2046) (#x207E . #x207E) (#x208E . #x208E)
  (#x232A . #x232A) (#x3009 . #x3009) (#x300B . #x300B) (#x300D . #x300D)
  (#x300F . #x300F) (#x3011 . #x3011) (#x3015 . #x3015) (#x3017 . #x3017)
  (#x3019 . #x3019) (#x301B . #x301B) (#x301E . #x301F) (#xFD3F . #xFD3F)
  (#xFE36 . #xFE36) (#xFE38 . #xFE38) (#xFE3A . #xFE3A) (#xFE3C . #xFE3C)
  (#xFE3E . #xFE3E) (#xFE40 . #xFE40) (#xFE42 . #xFE42) (#xFE44 . #xFE44)
  (#xFE5A . #xFE5A) (#xFE5C . #xFE5C) (#xFE5E . #xFE5E) (#xFF09 . #xFF09)
  (#xFF3D . #xFF3D) (#xFF5D . #xFF5D) (#xFF63 . #xFF63)))

  (U-Pi . #((#xAB . #xAB) (#x2018 . #x2018) (#x201B . #x201C) (#x201F . #x201F)
  (#x2039 . #x2039)))

  (U-Pf . #((#xBB . #xBB) (#x2019 . #x2019) (#x201D . #x201D) (#x203A . #x203A)))

  (U-Po . #((#x21 . #x23) (#x25 . #x27) (#x2A . #x2A) (#x2C . #x2C) (#x2E . #x2F)
  (#x3A . #x3B) (#x3F . #x40) (#x5C . #x5C) (#xA1 . #xA1) (#xB7 . #xB7) (#xBF . #xBF)
  (#x37E . #x37E) (#x387 . #x387) (#x55A . #x55F) (#x589 . #x589) (#x5BE . #x5BE)
  (#x5C0 . #x5C0) (#x5C3 . #x5C3) (#x5F3 . #x5F4) (#x60C . #x60C) (#x61B . #x61B)
  (#x61F . #x61F) (#x66A . #x66D) (#x6D4 . #x6D4) (#x700 . #x70D) (#x964 . #x965)
  (#x970 . #x970) (#xDF4 . #xDF4) (#xE4F . #xE4F) (#xE5A . #xE5B) (#xF04 . #xF12)
  (#xF85 . #xF85) (#x104A . #x104F) (#x10FB . #x10FB) (#x1361 . #x1368)
  (#x166D . #x166E) (#x16EB . #x16ED) (#x17D4 . #x17DA) (#x17DC . #x17DC)
  (#x1800 . #x1805) (#x1807 . #x180A) (#x2016 . #x2017) (#x2020 . #x2027)
  (#x2030 . #x2038) (#x203B . #x203E) (#x2041 . #x2043) (#x2048 . #x204D)
  (#x3001 . #x3003) (#xFE30 . #xFE30) (#xFE49 . #xFE4C) (#xFE50 . #xFE52)
  (#xFE54 . #xFE57) (#xFE5F . #xFE61) (#xFE68 . #xFE68) (#xFE6A . #xFE6B)
  (#xFF01 . #xFF03) (#xFF05 . #xFF07) (#xFF0A . #xFF0A) (#xFF0C . #xFF0C)
  (#xFF0E . #xFF0F) (#xFF1A . #xFF1B) (#xFF1F . #xFF20) (#xFF3C . #xFF3C)
  (#xFF61 . #xFF61) (#xFF64 . #xFF64)))

  (U-Z)

  (U-Zs . #((#x20 . #x20) (#xA0 . #xA0) (#x1680 . #x1680) (#x2000 . #x200B)
  (#x202F . #x202F) (#x3000 . #x3000)))

  (U-Zl . #((#x2028 . #x2028)))

  (U-Zp . #((#x2029 . #x2029)))

  (U-S)

  (U-Sm . #((#x2B . #x2B) (#x3C . #x3E) (#x7C . #x7C) (#x7E . #x7E) (#xAC . #xAC)
  (#xB1 . #xB1) (#xD7 . #xD7) (#xF7 . #xF7) (#x2044 . #x2044) (#x207A . #x207C)
  (#x208A . #x208C) (#x2190 . #x2194) (#x219A . #x219B) (#x21A0 . #x21A0)
  (#x21A3 . #x21A3) (#x21A6 . #x21A6) (#x21AE . #x21AE) (#x21CE . #x21CF)
  (#x21D2 . #x21D2) (#x21D4 . #x21D4) (#x2200 . #x22F1) (#x2308 . #x230B)
  (#x2320 . #x2321) (#x25B7 . #x25B7) (#x25C1 . #x25C1) (#x266F . #x266F)
  (#xFB29 . #xFB29) (#xFE62 . #xFE62) (#xFE64 . #xFE66) (#xFF0B . #xFF0B)
  (#xFF1C . #xFF1E) (#xFF5C . #xFF5C) (#xFF5E . #xFF5E) (#xFFE2 . #xFFE2)
  (#xFFE9 . #xFFEC) (#x1D6C1 . #x1D6C1) (#x1D6DB . #x1D6DB) (#x1D6FB . #x1D6FB)
  (#x1D715 . #x1D715) (#x1D735 . #x1D735) (#x1D74F . #x1D74F) (#x1D76F . #x1D76F)
  (#x1D789 . #x1D789) (#x1D7A9 . #x1D7A9) (#x1D7C3 . #x1D7C3)))

  (U-Sc . #((#x24 . #x24) (#xA2 . #xA5) (#x9F2 . #x9F3) (#xE3F . #xE3F) (#x17DB . #x17DB)
  (#x20A0 . #x20AF) (#xFE69 . #xFE69) (#xFF04 . #xFF04) (#xFFE0 . #xFFE1)
  (#xFFE5 . #xFFE6)))

  (U-Sk . #((#x5E . #x5E) (#x60 . #x60) (#xA8 . #xA8) (#xAF . #xAF) (#xB4 . #xB4)
  (#xB8 . #xB8) (#x2B9 . #x2BA) (#x2C2 . #x2CF) (#x2D2 . #x2DF) (#x2E5 . #x2ED)
  (#x374 . #x375) (#x384 . #x385) (#x1FBD . #x1FBD) (#x1FBF . #x1FC1)
  (#x1FCD . #x1FCF) (#x1FDD . #x1FDF) (#x1FED . #x1FEF) (#x1FFD . #x1FFE)
  (#x309B . #x309C) (#xFF3E . #xFF3E) (#xFF40 . #xFF40) (#xFFE3 . #xFFE3)))

  (U-So . #((#xA6 . #xA7) (#xA9 . #xA9) (#xAE . #xAE) (#xB0 . #xB0) (#xB6 . #xB6)
  (#x482 . #x482) (#x6E9 . #x6E9) (#x6FD . #x6FE) (#x9FA . #x9FA) (#xB70 . #xB70)
  (#xF01 . #xF03) (#xF13 . #xF17) (#xF1A . #xF1F) (#xF34 . #xF34) (#xF36 . #xF36)
  (#xF38 . #xF38) (#xFBE . #xFC5) (#xFC7 . #xFCC) (#xFCF . #xFCF) (#x2100 . #x2101)
  (#x2103 . #x2106) (#x2108 . #x2109) (#x2114 . #x2114) (#x2116 . #x2118)
  (#x211E . #x2123) (#x2125 . #x2125) (#x2127 . #x2127) (#x2129 . #x2129)
  (#x212E . #x212E) (#x2132 . #x2132) (#x213A . #x213A) (#x2195 . #x2199)
  (#x219C . #x219F) (#x21A1 . #x21A2) (#x21A4 . #x21A5) (#x21A7 . #x21AD)
  (#x21AF . #x21CD) (#x21D0 . #x21D1) (#x21D3 . #x21D3) (#x21D5 . #x21F3)
  (#x2300 . #x2307) (#x230C . #x231F) (#x2322 . #x2328) (#x232B . #x237B)
  (#x237D . #x239A) (#x2400 . #x2426) (#x2440 . #x244A) (#x249C . #x24E9)
  (#x2500 . #x2595) (#x25A0 . #x25B6) (#x25B8 . #x25C0) (#x25C2 . #x25F7)
  (#x2600 . #x2613) (#x2619 . #x266E) (#x2670 . #x2671) (#x2701 . #x2704)
  (#x2706 . #x2709) (#x270C . #x2727) (#x2729 . #x274B) (#x274D . #x274D)
  (#x274F . #x2752) (#x2756 . #x2756) (#x2758 . #x275E) (#x2761 . #x2767)
  (#x2794 . #x2794) (#x2798 . #x27AF) (#x27B1 . #x27BE) (#x2800 . #x28FF)
  (#x2E80 . #x2E99) (#x2E9B . #x2EF3) (#x2F00 . #x2FD5) (#x2FF0 . #x2FFB)
  (#x3004 . #x3004) (#x3012 . #x3013) (#x3020 . #x3020) (#x3036 . #x3037)
  (#x303E . #x303F) (#x3190 . #x3191) (#x3196 . #x319F) (#x3200 . #x321C)
  (#x322A . #x3243) (#x3260 . #x327B) (#x327F . #x327F) (#x328A . #x32B0)
  (#x32C0 . #x32CB) (#x32D0 . #x32FE) (#x3300 . #x3376) (#x337B . #x33DD)
  (#x33E0 . #x33FE) (#xA490 . #xA4A1) (#xA4A4 . #xA4B3) (#xA4B5 . #xA4C0)
  (#xA4C2 . #xA4C4) (#xA4C6 . #xA4C6) (#xFFE4 . #xFFE4) (#xFFE8 . #xFFE8)
  (#xFFED . #xFFEE) (#xFFFC . #xFFFD) (#x1D000 . #x1D0F5) (#x1D100 . #x1D126)
  (#x1D12A . #x1D164) (#x1D16A . #x1D16C) (#x1D183 . #x1D184) (#x1D18C . #x1D1A9)
  (#x1D1AE . #x1D1DD)))

  (U-C)

  (U-Cc . #((#x0 . #x1F) (#x7F . #x9F)))

  (U-Cf . #((#x70F . #x70F) (#x180B . #x180E) (#x200C . #x200F) (#x202A . #x202E)
  (#x206A . #x206F) (#xFEFF . #xFEFF) (#xFFF9 . #xFFFB) (#x1D173 . #x1D17A)
  (#xE0001 . #xE0001) (#xE0020 . #xE007F)))

  (U-Co . #((#xE000 . #xF8FF) (#xF0000 . #xFFFFD) (#x100000 . #x10FFFD)))))





