/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008-2010 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#include "Util.h"
#include "GriddedReader.h"

//------------------------------------------------------------
bool GriddedReader::hasDataType (int dataType)
{
	int type;
	if (dataType == GRB_WIND_XY2D)
		type = GRB_WIND_VX;
	else if (dataType == GRB_DIFF_TEMPDEW)
		type = GRB_DEWPOINT;
	else
		type = dataType;
	bool found = false;
	std::set<DataCode> setdata = getAllDataCode ();
	std::set<DataCode>::iterator it;
	for (it=setdata.begin(); !found && it!=setdata.end(); it++) {
		DataCode dt2 = *it;
		if (dt2.dataType == type)
			found = true;
	}
	return found;  
}

//------------------------------------------------------------
bool GriddedReader::hasData (const DataCode &dtc)
{
	int type;
	if (dtc.dataType == GRB_WIND_XY2D)
		type = GRB_WIND_VX;
	else if (dtc.dataType == GRB_DIFF_TEMPDEW)
		type = GRB_DEWPOINT;
	else
		type = dtc.dataType;
	DataCode dtcsearch (type, dtc.getAltitude());
	bool found = false;
	std::set<DataCode> setdata = getAllDataCode ();
	std::set<DataCode>::iterator it;
	for (it=setdata.begin(); !found && it!=setdata.end(); it++) {
		DataCode dt2 = *it;
		if (dt2 == dtcsearch)
			found = true;
	}
	return found;  
}

//------------------------------------------------------------
std::set<Altitude> GriddedReader::getAllAltitudes (int dataType)
{
	//DBG("%d", dataType);
	if (dataType == GRB_WIND_XY2D)
			dataType = GRB_WIND_VX;
	else if (dataType == GRB_DIFF_TEMPDEW)
			dataType = GRB_DEWPOINT;
	std::set<Altitude> res;
	std::set<DataCode> setdata = getAllDataCode ();
	std::set<DataCode>::iterator it;
	for (it=setdata.begin(); it!=setdata.end(); it++) {
		DataCode dtc = *it;
		if (dtc.dataType == dataType)
			res.insert (dtc.getAltitude());
	}
	return res; 
}

//------------------------------------------------------------
time_t  GriddedReader::getClosestDateFromNow ()
{
	time_t now = time(NULL);
	struct tm *pstm;
	pstm = gmtime(&now);
	now = mktime(pstm);
	return getClosestDateFromDate (now);
}

//------------------------------------------------------------
time_t  GriddedReader::getClosestDateFromDate (time_t date)
{
	std::set<time_t> sdates = getListDates();
	std::set<time_t>::iterator iter;

	time_t closestdate = 0;
	uint difftime, difftimemin=0xFFFFFFFF;
	
	for (iter=sdates.begin(); iter!=sdates.end(); iter++)
	{
		time_t daterecord = *iter;
		difftime = abs (daterecord-date);
		// find closets date +- 2*24h
		if (difftimemin>difftime && (difftime/3600)<=24*2) {
			difftimemin = difftime;
			closestdate = daterecord;
			//DBG("%d", closestdate);
		}
	}
	
	return closestdate;
}
