static char dqs_start_TCGMSG_rcsid[]="$Id: dqs_start_TCGMSG.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_start_TCGMSG.c Neil Lincoln Jan  9 09:35:08 CST 1995
 *
 * Copyright 1995
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_start_TCGMSG.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.3  1996/11/20 23:04:35  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.2  1995/02/19  22:37:55  nrl
 * Simplified pvm and tcgmsg interface to a minimalist scheme requiring
 * user scripts to start the daemons
 *
 * Revision 3.1  1995/02/17  02:58:55  nrl
 * Subroutine skeletons for PVM and TCGMSG modes
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"
#include "prognames.h"


/************************************************************************/
void dqs_start_TCGMSG(shell_path,job,queue)
     char           *shell_path;
     dqs_job_type   *job;
     dqs_queue_type *queue;
     
     /*
       dqs_start_TCGMSG - is used soley by the dqs_execd.
       
       this routine is responsible for starting the remote P4/MPI processes
       prior to the execl of the "master" script.
       
       /margit/c/users/rbutler/TCGMSG-1.4a.2/messages/systest1 \
       -TCGMSGdbg 11 -TCGMSGrdbg 11 \
       -TCGMSGpginfo 0 dirac 1 dirac 5555 3 \
       ibm11 1 \
       ibm11 1
       
       
     */
     
{
  
  string        tmpstr;
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_start_TCGMSG"));
  
  
  lp=job->granted_destin_identifier_list;
  
  if (!job->granted_destin_identifier_list->str3)
    job->granted_destin_identifier_list->str3=dqs_malloc(MAX_STRING_SIZE);
  
  strcat(job->granted_destin_identifier_list->str3," -pvmhosts");
  
  while (lp)
    {
      strcat(job->granted_destin_identifier_list->str3," ");
      strcat(job->granted_destin_identifier_list->str3,lp->str1);
      lp=lp->next;
    }
  
  DEXIT;
  return;
  
}
