static char dqs_unpack_rcsid[]="$Id: dqs_unpack.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_unpack.c Tom Green Mon Jan 31 10:43:06 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_unpack.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.20  1997/03/26 00:48:24  nrl
 * removed "compatability" code with earlier DQS 3.1.3 to clear
 * up a problem in some installations.
 *
 * Revision 3.19  1996/11/20 23:04:47  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.18  1996/08/26  14:21:02  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.17  1996/03/17  00:57:56  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.16  1996/03/12  17:12:45  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.15  1996/02/19  19:02:28  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.14  1996/02/07  13:08:19  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.13  1996/01/14  22:26:39  nrl
 * Added job_status_info to contain detailed information about
 * the job status
 *
 * Revision 3.12  1996/01/14  22:16:06  nrl
 * Added last_user delay function and consumables list to
 * queue definitions
 *
 * Revision 3.11  1995/06/21  16:58:01  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.10  1995/03/05  03:47:40  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.9  1995/02/06  16:31:58  nrl
 * Added "account" info to rusage structure and to the "acc_file"
 * for analysis by user.
 *
 * Revision 3.8  1994/08/02  23:11:12  green
 * added support for a crude job staging mechanism
 *
 * Revision 3.7  1994/06/15  12:49:48  green
 * additional DEBUG info
 *
 * Revision 3.6  1994/06/12  04:45:40  green
 * yanked conf.dqs_dshd_service
 *
 * Revision 3.5  1994/06/05  16:53:56  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.4  1994/06/04  14:54:59  green
 * added the variable "job->parallel_package"
 *
 * Revision 3.3  1994/06/03  00:25:51  green
 * replaced "DQSX_STR12" with "master_queue_exec_str" in support of MPI
 * mods
 *
 * Revision 3.2  1994/04/01  02:59:34  green
 * added "qalter" support
 *
 * Revision 3.1  1994/03/23  19:21:09  green
 * forgot to malloc space for queue->load_avg_ptr in dqs_unpack.c -
 * causing segvs when dqs_show_queue() was called outside of qmaster -
 * fixed.
 *
 * re-made func.h to relect dqs_am_chdir();
 *
 * Revision 3.0  1994/03/07  04:14:48  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:48  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*****************************************************************/
void dqs_unpack_header(buf_ptr,nibbles,total_bytes_packed)
     char *buf_ptr;
     int  *nibbles;
     int  *total_bytes_packed;
     
{
  PACK_MACRO_DEFS;
  
  int  bytes_unpacked=0;
  int  tbytes_packed=OFFSET;
  char *cur_ptr;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_header"));
  cur_ptr=buf_ptr;
  UNPACKINT(cur_ptr,*nibbles,bytes_unpacked,tbytes_packed);
  UNPACKINT(cur_ptr,*total_bytes_packed,bytes_unpacked,tbytes_packed);
  
  DPRINTF((DQS_EVENT,"<=====dqs_unpack_header() nibbles %d total_bytes_packed %d",*nibbles,*total_bytes_packed));
  
  DEXIT;
  return;
  
}

/*****************************************************************/
dqs_list_type *dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed)
     char          *buf_ptr;
     char          **cur_ptr;
     int           *bytes_unpacked;
     int           bytes_packed;
     
     /* 
	!NOTE THAT mem_size may be greater than bytes_packed
	THIS IS TO ACCOMONDATE DES!
     */
     
{
  
  PACK_MACRO_DEFS;
  
  u_long32      i;
  dqs_list_type *head;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_list"));
  
  UNPACKINT(*cur_ptr,i,*bytes_unpacked,bytes_packed);
  if (!i)
    {
      DPRINTF((DQS_EVENT,"NULL encountered"));
      DEXIT;
      return(NULL);
    }
  else
    {
      head=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
    }
  
  UNPACKINT(*cur_ptr,head->who,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->type,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->status,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->int0,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->int1,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->int2,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->int3,*bytes_unpacked,bytes_packed);
  UNPACKINT(*cur_ptr,head->bufsize,*bytes_unpacked,bytes_packed);
  UNPACKBUF(*cur_ptr,head->buf,head->bufsize,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->user,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->str0,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->str1,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->str2,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->str3,*bytes_unpacked,bytes_packed);
  
  head->rusage=dqs_unpack_rusage(cur_ptr,bytes_unpacked,bytes_packed);
  head->queue=dqs_unpack_queue(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
  head->conf=dqs_unpack_conf(cur_ptr,bytes_unpacked,bytes_packed);
  head->job=dqs_unpack_job(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
  head->me=dqs_unpack_me(cur_ptr,bytes_unpacked,bytes_packed); 
  
  head->chain=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
  head->tid=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
  head->next=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
  
  DEXIT;
  return(head);
  
}

/*****************************************************************/
dqs_rusage_type *dqs_unpack_rusage(cur_ptr,bytes_unpacked,bytes_packed)
     char            **cur_ptr;
     int           *bytes_unpacked;
     int           bytes_packed;
     
{
  
  PACK_MACRO_DEFS;
  
  u_long32        i;
  int New_Version= 0;
  dqs_rusage_type *rusage=NULL;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_rusage"));
  
  UNPACKINT(*cur_ptr,i,*bytes_unpacked,bytes_packed);
  
  if (!i)
    {
      DEXIT;
      return(NULL);
    }
  else
    {
      rusage=(dqs_rusage_type *)dqs_malloc(sizeof(dqs_rusage_type));
      
      UNPACKSTR(*cur_ptr,rusage->Version,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->qname,*bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,rusage->hostname,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->master,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->group,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->owner,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->job_name,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->dqs_job_name,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->account,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->priority,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->job_number,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->submission_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->start_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->end_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->exit_status,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_wallclock,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_utime,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_stime,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_maxrss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_ixrss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_ismrss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_idrss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_isrss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_minflt,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_majflt,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_nswap,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_inblock,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_oublock,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_msgsnd,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_msgrcv,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_nsignals,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_nvcsw,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->ru_nivcsw,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->DQSX_STR6,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->DQSX_STR7,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->DQSX_STR8,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->DQSX_STR9,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,rusage->DQSX_STR10,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->pid,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->DQSX_INT7,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->DQSX_INT8,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->DQSX_INT9,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,rusage->DQSX_INT10,*bytes_unpacked,bytes_packed);
    }
  
  DEXIT;
  return(rusage);
  
}

/*****************************************************************/
dqs_queue_type *dqs_unpack_queue(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed)
     char  *buf_ptr;
     char  **cur_ptr;
     int   *bytes_unpacked;
     int   bytes_packed;
{
  PACK_MACRO_DEFS;
  int New_Version= 0;
  u_long32        i;
  dqs_queue_type *queue;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_queue"));
  
  UNPACKINT(*cur_ptr,i,*bytes_unpacked,bytes_packed);
  if (!i)
    {
      DEXIT;
      return(NULL);
    }
  else
    {
      queue=(dqs_queue_type *)dqs_malloc(sizeof(dqs_queue_type));
      
      UNPACKSTR(*cur_ptr,queue->Version,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->qname,*bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,queue->qhostname,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->hostname,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->tmpdir,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->shell,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->klog,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->DQSX_STR22,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->DQSX_STR23,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->DQSX_STR24,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,queue->DQSX_STR25,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->seq_no,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->load_massage,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->load_alarm,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->priority,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->rerun,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->qtype,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->qty,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->qty_active,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_rt,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_rt,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_cpu,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_cpu,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_fsize,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_fsize,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_data,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_data,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_stack,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_stack,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_core,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_core,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->s_rss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->h_rss,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->status,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->prev_status,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->load_avg,*bytes_unpacked,bytes_packed);
      queue->load_avg_ptr=(u_long32 *)dqs_malloc(sizeof(u_long32 *));
      *queue->load_avg_ptr=queue->load_avg;
      UNPACKINT(*cur_ptr,queue->alive,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->lt_heard_from,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->soc,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->master,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->dirty,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->reauth_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->state,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->notify,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->last_user_delay,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->max_user_jobs,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,queue->DQSX_INT25,*bytes_unpacked,bytes_packed);
      
      
      queue->acl=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->xacl=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->owner_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->subordinate_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->q_activation_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->complex_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->job_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      queue->last_user=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->consumables=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      queue->DQSX_L23=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->DQSX_L24=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      queue->DQSX_L25=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
    }
  
  DEXIT;
  return(queue);
  
}

/*****************************************************************/
dqs_conf_type *dqs_unpack_conf(cur_ptr,bytes_unpacked,bytes_packed)
     char          **cur_ptr;
     int           *bytes_unpacked;
     int           bytes_packed;
     
{
  
  PACK_MACRO_DEFS;
  
  u_long32        i;
  int  New_Version=0;
  dqs_conf_type  *conf;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_conf"));
  
  UNPACKINT(*cur_ptr,i,*bytes_unpacked,bytes_packed);
  if (!i)
    {
      DEXIT;
      return(NULL);
    }
  else
    {
      conf=(dqs_conf_type *)dqs_malloc(sizeof(dqs_conf_type));
      
      UNPACKSTR(*cur_ptr,conf->Version,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->qmaster_spool_dir,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->execd_spool_dir,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->default_cell,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->reserved_port,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->qmaster_service,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->dqs_execd_service,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->intercell_service,*bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,conf->klog,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->reauth_time,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->mailer,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->dqs_bin,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->administrator,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->default_account,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->min_gid,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->min_uid,*bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,conf->maxujobs,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->output_handling,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->addon_script,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->addon_info,*bytes_unpacked,bytes_packed);          
      
      UNPACKINT(*cur_ptr,conf->user_access,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->default_rerun,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->sort_seq_no,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->sync_io,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->loglevel,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->logfacility,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->load_log_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->stat_log_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->schedule_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->max_unheard,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->logmail,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->alarms,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->alarmm,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->alarml,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->DQSX_STR1,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->DQSX_STR2,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->DQSX_STR3,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->DQSX_STR4,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,conf->DQSX_STR5,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->DQSX_INT1,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->DQSX_INT2,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->DQSX_INT3,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->DQSX_INT4,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,conf->DQSX_INT5,*bytes_unpacked,bytes_packed);
    }
  
  DEXIT;
  return(conf);
  
}

/*****************************************************************/

dqs_job_type *dqs_unpack_job(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed)
     char  *buf_ptr;
     char  **cur_ptr;
     int   *bytes_unpacked;
     int    bytes_packed;
     
{
  
  PACK_MACRO_DEFS;
  
  u_long32     i;
  dqs_job_type *job;
  int New_Version= 0;
  int DQS3134_version=0;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_job"));
  
  UNPACKINT(*cur_ptr,i,*bytes_unpacked,bytes_packed);
  if (!i)
    {
      DEXIT;
      return(NULL);
    }
  else
    {
      job=(dqs_job_type *)dqs_malloc(sizeof(dqs_job_type));
      
      UNPACKINT(*cur_ptr,job->job_number,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->Version,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_job_name,*bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,job->job_file,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->exec_file,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->status,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->submission_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->start_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->end_time,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->owner,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->uid,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->euid,*bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->jobs_per_user,*bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,job->dqs_o_home,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_log_name,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_path,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_mail,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_shell,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_tz,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_workdir,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->dqs_o_host,*bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->execution_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->execution_time_op,*bytes_unpacked,bytes_packed);
      
      job->account_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->server_name,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->checkpoint_attr,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->checkpoint_attr_op,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->checkpoint_interval,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->cell,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->cwd,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->directive_prefix,*bytes_unpacked,bytes_packed);
      
      job->stderr_path_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->exec_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->send_msg_to_stderr,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->full_listing,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->force_submission,*bytes_unpacked,bytes_packed);          
      
      job->group_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->hold,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->merge_stderr,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->maint_local_output,*bytes_unpacked,bytes_packed);
      
      job->hard_resource_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->soft_resource_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->mail_options,*bytes_unpacked,bytes_packed);
      
      job->hard_master_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->soft_master_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->mail_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->notify,*bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,job->job_name,*bytes_unpacked,bytes_packed);
      
      job->stdout_path_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->send_msg_to_stdout,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->priority,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->priority_op,*bytes_unpacked,bytes_packed);
      
      job->passwd_list=dqs_unpack_token_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,job->Passwd,*bytes_unpacked,bytes_packed);
      
      job->hard_queue_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->soft_queue_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->op_is_destin_id,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->reauth_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->restart,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->state,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->states,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->signal,*bytes_unpacked,bytes_packed);
      
      job->shell_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->user_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->unlog,*bytes_unpacked,bytes_packed);
      
      job->variable_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->verify,*bytes_unpacked,bytes_packed);
      
      job->env_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKINT(*cur_ptr,job->silent,*bytes_unpacked,bytes_packed);
      
      job->destin_identifier_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->granted_destin_identifier_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->consumable_resources_used=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);          
      
      job->job_identifier_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,job->message,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->script_size,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->script_file,*bytes_unpacked,bytes_packed);
      UNPACKBUF(*cur_ptr,job->script_ptr,job->script_size,*bytes_unpacked,bytes_packed);
      job->srvr_nm_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      UNPACKSTR(*cur_ptr,job->master_queue,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->master_queue_exec_str,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->DQSX_STR13,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->DQSX_STR14,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->DQSX_STR15,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->ext,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->state,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->clean,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->parallel_package,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->scheduling_flags,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->subpriority,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->schedule_seq_num,*bytes_unpacked,bytes_packed);
      
      job->jid_hold_list=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      /* if this is an old version this field would have been DQSX_L12 */          
      job->job_status_info=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      job->DQSX_L13=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->DQSX_L14=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      job->DQSX_L15=dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      
      
      UNPACKINT(*cur_ptr,job->pid,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->pvm_pid,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->sig_time,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->sig,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->notified,*bytes_unpacked,bytes_packed);
      UNPACKSTR(*cur_ptr,job->machine,*bytes_unpacked,bytes_packed);
      
      job->script_argv_list = dqs_unpack_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->suspend_enable,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->soc_xsoc,*bytes_unpacked,bytes_packed);
      UNPACKINT(*cur_ptr,job->force,*bytes_unpacked,bytes_packed);
      
    }     
  
  DEXIT;
  return(job);
  
}

/*****************************************************************/
dqs_me_type *dqs_unpack_me(cur_ptr,bytes_unpacked,bytes_packed)
     char            **cur_ptr;
     int           *bytes_unpacked;
     int           bytes_packed;
     
{
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_me"));
  DEXIT;
  return(NULL);
  
}

/*****************************************************************/
dqs_list_type *dqs_unpack_token_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed)
     char          *buf_ptr;
     char          **cur_ptr;
     int           *bytes_unpacked;
     int           bytes_packed;
     
     /* 
	!NOTE THAT mem_size may be greater than bytes_packed
	THIS IS TO ACCOMONDATE DES!
     */
     
{
  
  PACK_MACRO_DEFS;
  
  u_long32      i;
  dqs_list_type *head;
  
  DENTER_EXT((DQS_EVENT,"dqs_unpack_token_list"));
  
  UNPACKINT(*cur_ptr,i,*bytes_unpacked,bytes_packed);
  if (!i)
    {
      DPRINTF((DQS_EVENT,"NULL encountered"));
      DEXIT;
      return(NULL);
    }
  else
    {
      head=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
    }
  UNPACKBUF(*cur_ptr,head->buf,TOKEN_SIZE,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->str0,*bytes_unpacked,bytes_packed);
  UNPACKSTR(*cur_ptr,head->str1,*bytes_unpacked,bytes_packed);
  
  head->next=dqs_unpack_token_list(buf_ptr,cur_ptr,bytes_unpacked,bytes_packed);
  
  DEXIT;
  return(head);
  
}

