.\" Copyright 2002 by FireGL, ATI
.\" 
.\" All Rights Reserved.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.TH fgl_xgamma 1 version_1.0
.SH NAME
fgl_xgamma - Alter a monitor's gamma correction for XFree86
.SH SYNOPSIS
.B "fgl_xgamma"
[-display \fIdisplay\fP] [-screen \fIscreen\fP] [-quiet] [-table \fIn\fP]
.SH DESCRIPTION
.PP
.B fgl_xgamma
allows X users to query and alter the gamma correction of a monitor via
the XFree86 X server video mode extension (XFree86-VidModeExtension).
.SH OPTIONS
.PP
.TP 8
.B "-display \fIdisplay\fP"
This argument allows you to specify the server to connect to, i.e. localhost:0.0 is a valid term.
.PP
.TP 8
.B "-screen \fIscreen\fP"
When multiple displays are configured as a single logical display, this option
allows you to select the screen you wish to change.
.PP
.TP 8
.B "-quiet"
Silence the verbose output of
.B fgl_xgamma
 . This does not affect error messages.
.PP
.TP 8
.B "-table \fIn\fP"
Select predefined table \fIn\fP as the current gamma palette. Currently only table 1
with gamma = 1.0 and table 4 with gamma = 4.4 are coded.
.PP
.TP 8
.B "-help"
Print out the `Usage:' command syntax summary.
.SH BUGS
.PP
This client changes the internal values of the gamma correction for the
Xserver. Whether or not these values are respected depends on the video
drivers.
.PP
The gamma values are passed to the Xserver with 12 bits (1024 values) of
accuracy.
.PP
The effectivness of the gamma table can be tuned by the config file to
affect 2D windows only or 2D and 3D while disabling support for anti
aliased lines at the same time.
.SH SEE ALSO
xvidtune(1)
.SH AUTHORS
FIREGL, ATI
