/*****************************************************************************/
/*                                                                           */
/* NAME:      fglrx_gamma.c                                                  */
/*                                                                           */
/*            FGLRXGAMMA extension interface library                      */
/*                                                                           */
/* Copyright (c) 2001, ATI, ATI Research, Starnberg, Germany                 */
/*                                                                           */
/*****************************************************************************/

//////////////////////////////////////////////////////////////////////////////
// includes

// third party includes
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xlibint.h>
#include <X11/extensions/XTest.h>
#include <X11/extensions/sync.h>
#include <X11/Xproto.h>
#include <X11/extensions/Xdbe.h>
#include <X11/extensions/record.h>
#include <X11/extensions/shape.h>

#ifdef XF86MISC
#include <X11/extensions/xf86misc.h>
#include <X11/extensions/xf86mscstr.h>
#include <include/extensions/extutil.h>
#endif

#ifdef XINPUT
#include <X11/extensions/XInput.h>
#endif

#include <X11/Xos.h>
#include <stdio.h>
#include <stdlib.h>

// self created includes
#include "fglrx_gamma.h"

//////////////////////////////////////////////////////////////////////////////
// type defines

// -- none --

//////////////////////////////////////////////////////////////////////////////
// macro defines

#if 0
// for DEBUG
#define TRACE_XEXT(msg)  printf("[xexttst] %s\n", msg);
#define PRINT_XEXT(msg)  printf("["__FUNCTION__"] %s\n", msg);
#else
// for RELEASE
#define TRACE_XEXT(msg)
#define PRINT_XEXT(msg)
#endif

//////////////////////////////////////////////////////////////////////////////
// constant defines

// -- none --

//////////////////////////////////////////////////////////////////////////////
// extension related defines

#define ATIFGL_EXTENSION_NAME    "ATIFGLEXTENSION"
#define ATIFGL_NUMBER_EVENTS     7
#define ATIFGL_NUMBER_ERRORS     0

#define X_FGLVidModeSetGammaRamp        4
#define X_FGL_VidModeGetGammaRamp       5
#define X_FGL_VidModeGetGammaRampSize   6   

static XExtensionInfo _fglrx_gamma_info_data;
static XExtensionInfo *fglrx_gamma_info = &_fglrx_gamma_info_data;
static /* const */ char *fglrx_gamma_extension_name = ATIFGL_EXTENSION_NAME;

// extension protocoll defines

#define XREP_SZ(name)       sizeof(x##name##Reply)
#define XREQ_SZ(name)       sizeof(x##name##Req)

// structures for FGLVidModeSetGammaRamp extensions

typedef struct _FGLVidModeSetGammaRamp {
    CARD8   reqType;                /* Major Opcode - id code of the extension */
    CARD8   fireglReqType;          /* Minor Opcode X_* - Request Type Value */
    CARD16  length B16;             /* length of package in 4 byte units */
    /* X_FGLVidModeSetGammaRamp specific data */
    CARD32  screen B32;             /* handle of the screen to program */
    CARD32  ulController;       /* display controller */
    CARD16  RGamma[256];            /* red color value */
    CARD16  GGamma[256];            /* green color value */
    CARD16  BGamma[256];            /* blue color value */
} xFGLVidModeSetGammaRampReq;       /* size = 0xC08 */

typedef struct {
    BYTE    type;                   /* always X_Reply */
    BOOL    pad1;                   /* not used */
    CARD16  sequenceNumber B16;     /* reference to respective request */
    CARD32  length B32;             /* length of package in 4 byte units */
    /* X_Reply to X_FGLVidModeSetGammaRamp specific data */
    CARD32  pad2 B32;               /* offset 0x08 */
    CARD32  pad3 B32;               /* offset 0x0C */
    CARD32  pad4 B32;               /* offset 0x10 */
    CARD32  pad5 B32;               /* offset 0x14 */
    CARD32  pad6 B32;               /* offset 0x18 */
    CARD32  pad7 B32;               /* offset 0x1C */
} xFGLVidModeSetGammaRampReply;     /* size = 0x20 */

#define sz_xFGLVidModeSetGammaRampReq      XREQ_SZ(FGLVidModeSetGammaRamp)
#define sz_xFGLVidModeSetGammaRampReply    XREP_SZ(FGLVidModeSetGammaRamp)

//////////////////////////////////////////////////////////////////////////////
// private functions

// X shutdown hook function that will cleanup the opened extension
static XEXT_GENERATE_CLOSE_DISPLAY (close_display_fglrx_gamma, fglrx_gamma_info);

// table with X hooks
static /* const */ XExtensionHooks fglrx_gamma_extension_hooks = {
    NULL,               /* create_gc */
    NULL,               /* copy_gc */
    NULL,               /* flush_gc */
    NULL,               /* free_gc */
    NULL,               /* create_font */
    NULL,               /* free_font */
    close_display_fglrx_gamma,    /* close_display */
    NULL,               /* wire_to_event */
    NULL,               /* event_to_wire */
    NULL,               /* error */
    NULL,               /* error_string */
};

/*
 * find_display_fglrx_gamma - get the display info block for fglrx_gamme extension
 */
static XEXT_GENERATE_FIND_DISPLAY (find_display_fglrx_gamma, fglrx_gamma_info,
                   fglrx_gamma_extension_name, 
                   &fglrx_gamma_extension_hooks, 
                   ATIFGL_NUMBER_EVENTS, NULL);


/*****************************************************************************/
/*                                                                           */
/* NAME:      init_fglrx_gamma_extension                                       */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:     Display *dpy                                                   */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
static BOOL fglrx_gamma_extension_init(Display *dpy, XExtDisplayInfo **ppInfo)
{
    BOOL bSuccess = FALSE;

    (*ppInfo) = find_display_fglrx_gamma(dpy);

    if (XextHasExtension(*ppInfo))
    {
        bSuccess = TRUE;
    }
    else
    {
        TRACE_XEXT("FGLRXGAMMA extension *not* found");
    }

    return bSuccess;
} // === check_gamma_extension ===


//////////////////////////////////////////////////////////////////////////////
// exported functions

// array of float triples of R,G,B - almost identical to XF86 interface
Bool                                                                              
FGLRX_X11SetGammaRamp_float
    (Display *dpy, int screen, int controller, int size, FGLRX_X11Gamma_float *Gamma)
{
    XExtDisplayInfo *pInfo;
    xFGLVidModeSetGammaRampReq *req;
    xFGLVidModeSetGammaRampReply rep;
    int i;
    BOOL bSuccess = FALSE;

    // [First step] Check whether the extension exists
   
    if( !fglrx_gamma_extension_init(dpy, &pInfo) )
    {
        return FALSE;
    }

    if (size != FGLRX_GAMMA_RAMP_SIZE)
    {
        return FALSE;
    }

    // [Second step] Lock display
    LockDisplay(dpy);

    // [Third step] Get a pointer to a new request structure
    GetReq(FGLVidModeSetGammaRamp, req);

    // [Fourth step] Fill in the request structure
    req->reqType = pInfo->codes->major_opcode;
    /* calculate size of request structure in 4 byte units */
    req->length = (sizeof(*req)+3) / 4;
    req->fireglReqType = X_FGLVidModeSetGammaRamp;
    req->screen = screen;
    req->ulController = controller;
    // duplicate gamma data into request structure
    for (i=0; i<256; i++)
    {
        req->RGamma[i] = (CARD16)(Gamma[i].red * 1024);
        req->GGamma[i] = (CARD16)(Gamma[i].green * 1024);
        req->BGamma[i] = (CARD16)(Gamma[i].blue * 1024);
    }

    // [Fifth step] Carry out the extension function and wait for reply
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse))
    {
        TRACE_XEXT("something went wrong");
        // [Sixth step] Unlock display
        UnlockDisplay(dpy);
        SyncHandle();
        TRACE_XEXT("something went wrong - end");
        return FALSE;
    }

    // [Sixth step] Unlock display
    PRINT_XEXT("Unlock");
    UnlockDisplay(dpy);
    PRINT_XEXT("SyncHandle");
    SyncHandle();
    bSuccess = TRUE;

    return bSuccess;
}

// array of unsigned int triples of R,G,B - values need to be in range 0..1023
Bool                                                                              
FGLRX_X11SetGammaRamp_uint_1024
    (Display *dpy, int screen, int controller, int size, FGLRX_X11Gamma_uint_1024 *Gamma)
{
    XExtDisplayInfo *pInfo;
    xFGLVidModeSetGammaRampReq *req;
    xFGLVidModeSetGammaRampReply rep;
    int i;
    BOOL bSuccess = FALSE;

    // [First step] Check whether the extension exists
   
    if( !fglrx_gamma_extension_init(dpy, &pInfo) )
    {
        return FALSE;
    }

    if (size != FGLRX_GAMMA_RAMP_SIZE)
    {
        return FALSE;
    }

    // [Second step] Lock display
    LockDisplay(dpy);

    // [Third step] Get a pointer to a new request structure
    GetReq(FGLVidModeSetGammaRamp, req);

    // [Fourth step] Fill in the request structure
    req->reqType = pInfo->codes->major_opcode;
    /* calculate size of request structure in 4 byte units */
    req->length = (sizeof(*req)+3) / 4;
    req->fireglReqType = X_FGLVidModeSetGammaRamp;
    req->screen = screen;
    req->ulController = controller;
    // duplicate gamma data into request structure
    for (i=0; i<256; i++)
    {
        req->RGamma[i] = Gamma[i].red;
        req->GGamma[i] = Gamma[i].green;
        req->BGamma[i] = Gamma[i].blue;
    }

    // [Fifth step] Carry out the extension function and wait for reply
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse))
    {
        TRACE_XEXT("something went wrong");
        // [Sixth step] Unlock display
        UnlockDisplay(dpy);
        SyncHandle();
        TRACE_XEXT("something went wrong - end");
        return FALSE;
    }

    // [Sixth step] Unlock display
    PRINT_XEXT("Unlock");
    UnlockDisplay(dpy);
    PRINT_XEXT("SyncHandle");
    SyncHandle();
    bSuccess = TRUE;

    return bSuccess;
}

// array of CARD16 triples of R,G,B - values need to be in range 0..1023
Bool                                                                              
FGLRX_X11SetGammaRamp_C16_1024
    (Display *dpy, int screen, int controller, int size, FGLRX_X11Gamma_C16_1024 *Gamma)
{
    XExtDisplayInfo *pInfo;
    xFGLVidModeSetGammaRampReq *req;
    xFGLVidModeSetGammaRampReply rep;
    int i;
    BOOL bSuccess = FALSE;

    // [First step] Check whether the extension exists
   
    if( !fglrx_gamma_extension_init(dpy, &pInfo) )
    {
        return FALSE;
    }

    if (size != FGLRX_GAMMA_RAMP_SIZE)
    {
        return FALSE;
    }

    // [Second step] Lock display
    LockDisplay(dpy);

    // [Third step] Get a pointer to a new request structure
    GetReq(FGLVidModeSetGammaRamp, req);

    // [Fourth step] Fill in the request structure
    req->reqType = pInfo->codes->major_opcode;
    /* calculate size of request structure in 4 byte units */
    req->length = (sizeof(*req)+3) / 4;
    req->fireglReqType = X_FGLVidModeSetGammaRamp;
    req->screen = screen;
    req->ulController = controller;

    // duplicate gamma data into request structure
    for (i=0; i<256; i++)
    {
        req->RGamma[i] = Gamma[i].red;
        req->GGamma[i] = Gamma[i].green;
        req->BGamma[i] = Gamma[i].blue;
    }

    // [Fifth step] Carry out the extension function and wait for reply
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse))
    {
        TRACE_XEXT("something went wrong");
        // [Sixth step] Unlock display
        UnlockDisplay(dpy);
        SyncHandle();
        TRACE_XEXT("something went wrong - end");
        return FALSE;
    }

    // [Sixth step] Unlock display
    PRINT_XEXT("Unlock");
    UnlockDisplay(dpy);
    PRINT_XEXT("SyncHandle");
    SyncHandle();
    bSuccess = TRUE;

    return bSuccess;
}

// three 256-member arrays of CARD16 - R,G,B values need to be in range 0..1023
Bool
FGLRX_X11SetGammaRamp_C16native_1024
    (Display *dpy, int screen, int controller, int size, FGLRX_X11Gamma_C16native_1024 *Gamma)
{
    XExtDisplayInfo *pInfo;
    xFGLVidModeSetGammaRampReq *req;
    xFGLVidModeSetGammaRampReply rep;
    int i;
    BOOL bSuccess = FALSE;

    // [First step] Check whether the extension exists
   
    if( !fglrx_gamma_extension_init(dpy, &pInfo) )
    {
        return FALSE;
    }

    if (size != FGLRX_GAMMA_RAMP_SIZE)
    {
        return FALSE;
    }

    // [Second step] Lock display
    LockDisplay(dpy);

    // [Third step] Get a pointer to a new request structure
    GetReq(FGLVidModeSetGammaRamp, req);

    // [Fourth step] Fill in the request structure
    req->reqType = pInfo->codes->major_opcode;
    /* calculate size of request structure in 4 byte units */
    req->length = (sizeof(*req)+3) / 4;
    req->fireglReqType = X_FGLVidModeSetGammaRamp;
    req->screen = screen;
    req->ulController = controller;

    // duplicate gamma data into request structure
    for (i=0; i<256; i++)
    {
        req->RGamma[i] = Gamma->RGamma[i];
        req->GGamma[i] = Gamma->GGamma[i];
        req->BGamma[i] = Gamma->BGamma[i];
    }

    // [Fifth step] Carry out the extension function and wait for reply
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse))
    {
        TRACE_XEXT("something went wrong");
        // [Sixth step] Unlock display
        UnlockDisplay(dpy);
        SyncHandle();
        TRACE_XEXT("something went wrong - end");
        return FALSE;
    }

    // [Sixth step] Unlock display
    PRINT_XEXT("Unlock");
    UnlockDisplay(dpy);
    PRINT_XEXT("SyncHandle");
    SyncHandle();
    bSuccess = TRUE;

    return bSuccess;
}


Bool FGLRX_X11GetGammaRampSize(Display *dpy, int screen, int *size)
{
    XExtDisplayInfo *pInfo;

    // [First step] Check whether the extension exists
   
    if( !fglrx_gamma_extension_init(dpy, &pInfo) )
    {
        if( size )
            *size = 0;
        return FALSE;
    }

    if( !size )
    {
        return FALSE;
    }
        
    *size = FGLRX_GAMMA_RAMP_SIZE;
    return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// EOF
