/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __DEBUG_H__
#define __DEBUG_H__

#include "floater.h"
#include <signal.h>
#include <assert.h>

#ifndef USER_TCL
#define USER_TCL 1
#endif

#ifndef CORE_DUMPS
#define CORE_DUMPS 1
#endif

#define MAKING_TUTORIAL 0
#define log(s) fputs(TEMPCAT((s), "\n"), logfile);

/* whether to create a log file of messages and other good stuff */
#define LOGGING 0

/* controls for various debugging output */
#define DBG 0
#define DBGu 0
#define DEBUGMSG 0
#define DEBUGMSG0 0
#define DEBUGCONN 0
#define DEBUGBR 0
#define DEBUGRES 0
#define DEBUGSEEN 0
#define DEBUGHEARTS 0

#define ANY_DBG (DBG||DEBUGCONN||DEBUGMSG||DEBUGBR||DEBUGRES||DEBUGSEEN||DEBUGHEARTS)

#define RANDOMPLAY 1 /* whether randomplay is an option */

extern bool debugprint;

#if CORE_DUMPS
#define floater_abort abort()
#else
#define floater_abort exit(-2)
#endif

#if ANY_DBG
#ifdef NO_X11
#define DEBUG(x) (TclDo("gset debugprinting 1"), (x), \
		  (TclDo("gset debugprinting 0")))
#else /* NO_X11 */
#define DEBUG(x) ((debugprint=TRUE), TclDo("gset debugprinting 1"), (x), \
		  (TclDo("gset debugprinting 0")), (debugprint=FALSE))
#endif /* NO_X11 */

#else /* ANY_DBG */
#define DEBUG(x)
#endif /* if ANY_DBG */

#undef _assert
#undef assert
# define _assert(ex)	{if (!(ex)){endcurses(); mail_bug("Assertion failed: file \"%s\", line %d\n", __FILE__, __LINE__); floater_abort;}}
# define assert(ex)	_assert(ex)

#if LOGGING||MAKING_TUTORIAL
extern FILE *logfile;
#endif

#endif /* __DEBUG_H__ */
