# 1 "tclcode/floatert.TCL"
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

# 1 "tclcode/floater.TCL" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 


if {[info tclversion] < 8.0} {
    puts stderr "You have compiled Floater with Tcl [info tclversion]"
    puts stderr "You must recompile with Tcl 8.0 or higher"
    exit 1
}








# 1 "tclcode/gset.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
proc tryset {a b} {
    if {[set x [string first "(" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    if [catch {set $a}] {set $a $b}
}

 
proc gset {a {b salami_on_rye}} {
    if {[set x [string first "(" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    if ![string compare $b salami_on_rye] {set $a} {set $a $b}
}

 
proc gunset {a} {
    if {[set x [string first "(" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    unset $a
}

# 36 "tclcode/floater.TCL" 2

gset floater_version "Floater 1.2b1"
# 1 "tclcode/errorhandle.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
proc bgerror {m} {catch {debugmsg $m}}
# 38 "tclcode/floater.TCL" 2

# 1 "tclcode/files.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 
 
proc lseenhand {root number scoring} {
    global seenhands maxseenhand 	    Nseen$scoring Sseen$scoring Eseen$scoring Wseen$scoring


 


    set seen seen
    foreach d {N S E W} {
	if [info exists $d$seen$scoring] {
	    eval "set old $$d$seen$scoring"
	    set $d$seen$scoring $old$number-
 
	}
    }
    set seenhands($root,$number) 1
    if [info exists maxseenhand($root)] 	    {if {$maxseenhand($root) > $number} return}

    set maxseenhand($root) $number
}

 
proc seen {root {silent 0}} {
    global seenhands maxseenhand youveseen

    if ![info exists maxseenhand($root)] {
	if {$youveseen && !$silent} 		{talkmsg "You haven't seen any hands from $root"}

	return ""
    }
    set m $maxseenhand($root)
    set s ""
    set t ""
    for {set i 1} {$i <= $m} {incr i} {
	if [info exists seenhands($root,$i)] {
	    append s "$i-"
	    append t "$i "
	}
    }
    if {$youveseen && !$silent} {talkmsg "From set $root, you've seen: $t"}
    if {$silent} {return $t} {return $s}
}







proc floater_mkdir {s} {
    if {[info tclversion] < 7.6} {exec mkdir $s} {file mkdir $s}
}

proc floater_delete {s} {
    if {[info tclversion] < 7.6} {exec /bin/rm $s} {file delete $s}
}

if [info exists env(DOT_FLOATER)] {
    tryset floaterdir $env(DOT_FLOATER)
}
tryset floaterdir [set env(HOME)]/.floater
tryset startupfile $floaterdir/startup.tcl
tryset seenfileroot $floaterdir/seenhands

if {[file exists $floaterdir] == 0} {catch {floater_mkdir $floaterdir}}
if {[file exists $seenfileroot] == 0} {catch {floater_mkdir $seenfileroot}}

 
proc tclfiles {dir {recurse 1}} {
    set slashstar "\/\*"
    set pattern $dir$slashstar
    set files ""
    while 1 {
	if ![catch {glob $pattern.tcl} newfiles] {append files " $newfiles"}
	if {!$recurse || [catch {glob $pattern}]} {return $files}
	set pattern $pattern$slashstar
    }
}

proc source_all_tclfiles {dir {recurse 1}} {
    global startupfile

    foreach file [tclfiles $dir $recurse] {
	if {$file != $startupfile} { 





	    if [catch {source $file} err] {
		puts stderr $err
	    }
	}
    }
}

 

proc setprioruse {name} {
    global usedname startupfile

    if [info exists usedname($name)] return
    set "usedname($name)" 1
    set u "\"usedname("
    catch {exec cat << "set $u$name)\" 1\n" >> $startupfile}
}

 
 
 

set seenname _everyone_

proc seenfile {root} {
    global seenfileroot seenname
    return $seenfileroot/$seenname/$root.tcl
}

 
proc seenhand {root number scoring} {
    global seenhands

    if [info exists seenhands($root,$number)] return
    lseenhand $root $number $scoring
    if [catch {exec cat << "lseenhand $root $number $scoring\n" >> 	    [seenfile $root]}] {

	floatererror "Floater error: unable to make permanent note of what hands you've seen!"
	set e1 "Floater error: unable to write to file "
	set e2 [seenfile $root]
	floatererror "$e1$e2"
    }
}

proc loadseen {} {
    global seenhands maxseenhand seenname seenfileroot 	    globaldate previousglobaldate


    debugmsg "loadseen with seenname=$seenname"

     
    if {[info exists globaldate] && [info exists previousglobaldate]} {
	cleanseen $seenfileroot/$seenname $globaldate $previousglobaldate
	if {$seenname != "_everyone_"} {
	    cleanseen $seenfileroot/_everyone_ $globaldate $previousglobaldate
	}
    }

    catch {unset seenhands; unset maxseenhand}
    if {[file exists $seenfileroot/_everyone_] == 0} 	    {catch {floater_mkdir $seenfileroot/_everyone_}}

    if {[file exists $seenfileroot/$seenname] == 0} 	    {catch {floater_mkdir $seenfileroot/$seenname}}

    source_all_tclfiles $seenfileroot/_everyone_

     
    source_all_tclfiles $seenfileroot 0

    if {$seenname != "_everyone_"} 	    {source_all_tclfiles $seenfileroot/$seenname}

}

proc cleanseen {dir except1 except2} {
    debugmsg "cleanseen $dir $except1 $except2"
    foreach file [tclfiles $dir 0] {
	if {![string match "$dir/$except1*" $file]
	    && ![string match "$dir/$except2*" $file]} {
		debugmsg "Removing $file"
		floater_delete $file
	}
    }
}



 
 
 

 
proc validfile {filename} {
    global floaterdir

    regexp $floaterdir/.* [file dirname $filename]/
}
# 39 "tclcode/floater.TCL" 2

# 1 "tclcode/connect.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset conn_number 0

gset default_handshake "Floater 'shake"
gset silent_handshake "Floater silent 'shake"


 
proc FloaterListen {{port 0}} {
    global localIPaddr0
    PortNumber [socket -server FloaterAcceptConnection 	    -myaddr $localIPaddr0 $port]

}

proc FloaterAcceptConnection {sock addr port} {
    debugmsg "AcceptConnection $sock $addr $port"
    return [FloaterNewSocket $sock]
}

proc FloaterReadable {conn sock} {
    global expecting_handshake floater_silent default_handshake

    debugmsg "FloaterReadable $conn $sock"
    set s [gets $sock]
    debugmsg "Got $s from $conn"
    if [info exists expecting_handshake($conn)] {
	debugmsg "expecting handshake"
	if {$s == $default_handshake} {
	     
	    unset expecting_handshake($conn)
	    return
	} else {
	    if $floater_silent {
		global silent_handshake
		if {$s == $silent_handshake} {
		    global floater_silent_conns
		    set floater_silent_conns($conn) 1
		    unset expecting_handshake($conn)
		    return
		}
	    }
	    debugmsg "Expecting handshake but got $s"
	}
	 
	FloaterClose $conn
	return
    }

    if {$s == "" && [eof $sock]} 	    {FloaterClose $conn} 	    {debugmsg "received $s"; floaterreceive $s $conn}


}

 
proc FloaterWritable {conn sock} {
    debugmsg "FloaterWritable $conn $sock"
}

 
proc FloaterConnect {addr port {handshake default}} {
    debugmsg "FloaterConnect $addr $port"
    FloaterNewSocket [socket $addr $port] $handshake
}

 
 
proc FloaterNewSocket {sock {handshake default}} {
    global sock_to_conn conn_to_sock conn_number expecting_handshake

    if {$handshake == "default"} {
	global default_handshake
	set handshake $default_handshake
    }
    debugmsg "NewSocket $sock $handshake"
    fconfigure $sock -blocking 0 -buffering line
    set conn [incr conn_number]
    set sock_to_conn($sock) $conn
    set conn_to_sock($conn) $sock
    set expecting_handshake($conn) 1
 
    fileevent $sock readable "FloaterReadable $conn $sock"
    if {$handshake != ""} {
	puts $sock $handshake
	debugmsg "sent handshake ($handshake) to $conn"
    }
    return $conn
}

proc PortNumber {sock} {
    lindex [fconfigure $sock -sockname] 2
}

 

 
tryset failedsendwait 3000
 

 
proc FloaterSend {to msg} {
    global conn_to_sock

    catch {set s $conn_to_sock($to)}






    debugmsg "Send $to ($s) $msg"

    if [catch {puts $s $msg}] {
	global failedsendwait

	after $failedsendwait 	    debugmsg \"Closing $s due to failed send\"; 	    catch \{close $s\}


    }
}

 

proc FloaterCloseName {name} {
    global name_to_conn

    set s "<none>"
    catch {set s $name_to_conn($name)}
    debugmsg "FloaterCloseName $name ($s)"
    if {$s != "<none>"} {
	catch {
	    FloaterClose $s
	    unset "name_to_conn($name)"
	}
    }
}

 
 
 

#f is a filename (or "|program args ...").  r is a regular expression with
#one parenthesized component.  For each line, if the regexp matches,
#lappend the parenthesized component of the match to the result.
proc filter_regexp {f r} {
    set f [open $f r]
    set result ""
    while {[gets $f s] >= 0} {
	if [regexp $r $s all a] { lappend result $a; set q yes } { set q no }
	#puts "Checking $s against regexp $r: $q"
    }
    catch { close $f }
    #puts "filter result: $result"
    return $result
}

 
 
 
 
proc IP_from_ifconfig {} {
    set r {inet addr:([0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)}
    set s ""
    catch {set s [filter_regexp "|ifconfig ppp0" $r]}
    if {$s == ""} {
	catch {set s [filter_regexp "|ifconfig" $r]}
    }

    set result ""
    foreach p $s {
	if {$p != "127.0.0.1"} {
	    if {$result == ""} {set result $p} {set result $p!$result}
	}
    }
    return $result
}

 
proc bogusIP {s} {
    if {$s == "localhost"} { return 1 }
    if {$s == "localhost.localdomain"} { return 1 }
    if {$s == "127.0.0.1"} { return 1 }
    if {$s == "0.0.0.0"} { return 1 }
    if {$s == "255.255.255.255"} { return 1 }
    return 0
}

proc filter_and_join {s filter joiner} {
    set result ""
    foreach k $s {
	if ![$filter $k] { lappend result $k }
    }
    join $result $joiner
}

proc nothing {sock ipaddr port} {}

set localIPaddr 127.0.0.1
set localIPaddr0 127.0.0.1
catch {
    set server [socket -server nothing 0]
    set socket [socket [info hostname] [PortNumber $server]]
    set localIPaddr0 [lindex [fconfigure $socket -peername] 0]
    set localIPaddr1 [lindex [fconfigure $socket -peername] 1]
    catch {close $socket}
    catch {close $server}
    set localIPaddr 	    [filter_and_join "$localIPaddr0 $localIPaddr1" bogusIP !]

    puts $localIPaddr
    if {$localIPaddr == ""} {
	set localIPaddr [set localIPaddr0 [IP_from_ifconfig]]
	puts $localIPaddr
    }
}

# 40 "tclcode/floater.TCL" 2

# 1 "tclcode/mail.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 
 
 

 



set to_be_emailed_n 0

 
proc emailresult {result} {
    global resultparser errorstring to_be_emailed to_be_emailed_n

    if {[set q [what_to_send]] != ""} {set result "$result\nMagic cookie!$q"}
    if {$result == ""} {return 0}
    set r [

    pseudomail $result $resultparser



    ]
    if $r {
	 
	set to_be_emailed([incr to_be_emailed_n]) $result
    } else {
	while {$to_be_emailed_n > 0} {
	     
	     
	     
	     
	     
	    set result $to_be_emailed($to_be_emailed_n)
	    unset to_be_emailed($to_be_emailed_n)
	    incr to_be_emailed_n -1
	    if [emailresult $result] {return $r}
	}
    }
    return $r
}

proc emailseens {} {emailresult {}}

 
proc mail_bug {bug} {
    global bugmail errorstring


    pseudomail $bug $bugmail



}

 
proc pseudomail {what where} {
    global errorstring pseudomailaddr pseudomailport

    catch {
	set conn [FloaterConnect $pseudomailaddr $pseudomailport]
	FloaterSend $conn ozzie_and_harriet
	FloaterSend $conn "$where $what"
	FloaterClose $conn
    } errorstring
}
# 41 "tclcode/floater.TCL" 2

# 1 "tclcode/seen.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
proc query_have_seen {name set} {
    set x "$name $set"
    global $x
    array names $x
}

 
proc a_h_s {name set num} {
    global "have_seen_sets_$name"
    eval "set \"have_seen_sets_$name\($set)\" 1"

    set x "$name $set"
    global $x
    eval "set \{$x\($num)\} 1"
}

proc have_seen_sets {name} {
    global "have_seen_sets_$name"
    array names "have_seen_sets_$name"
}

proc discard_data_except_from {date} {
    global nameset

    foreach name $nameset {
	global "have_seen_sets_$name"
	foreach set [have_seen_sets $name] {
	    if ![string match *$date* $set] {
		set x "$name $set"
		global $x
		unset $x
 
		eval "unset \"have_seen_sets_$name\($set)\""
 
	    }
	}
    }
}

 

set to_be_sent_n 0

proc want_to_send {name set num} {
    global to_be_sent_n to_be_sent

 
    set to_be_sent([incr to_be_sent_n]) $name
    set to_be_sent([incr to_be_sent_n]) $set
    set to_be_sent([incr to_be_sent_n]) $num
}

 
 
proc what_to_send {} {
    global to_be_sent_n to_be_sent

    if {$to_be_sent_n == 0} {return ""}
    set s $to_be_sent(1)
    for {set i 2} {$i <= $to_be_sent_n} {incr i} {
	set s "$s	$to_be_sent($i)"
	unset to_be_sent($i)
    }
    set to_be_sent_n 0
    return $s
}
# 42 "tclcode/floater.TCL" 2

# 1 "tclcode/logo.deq" 1

global floater_version
tryset about_text "version [lrange $floater_version 1 end]\nCopyright (c) 1996-1999 Geoff Pike\nhttp:\/\/www.floater.org/\nThis is free software."



proc about {{timeout 0}} {
    global about_text
    talkmsg "About Floater:\n$about_text"
}
# 45 "tclcode/logo.deq"


# 43 "tclcode/floater.TCL" 2

# 1 "tclcode/texts.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
# 1 "tclcode/the_texts.deq" 1
gset Copyright {Copyright (c) 1996--1999 Geoff Pike.
All rights reserved.

Floater is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

This software is provided "as is" and comes with absolutely no
warranties.  Geoff Pike is not liable for damages under any
circumstances.  Support is not provided.  Use at your own risk.

Personal, non-commercial use is allowed.  Attempting to make money
from Floater or products or code derived from Floater is not allowed
without prior written consent from Geoff Pike.  Anything that remotely
involves commercialism, including (but not limited to) systems that
show advertisements while being used and systems that collect
information on users that is later sold or traded require prior
written consent from Geoff Pike.
}
gset Readme {			    Floater 1.2b1
		  for Unix and for Microsoft Windows
			  September 14, 1999

		       http:slashslashwww.floater.org/

                            by Geoff Pike
			  geoff@floater.org


Please check the ever growing Floater web page at
http:slashslashwww.floater.org/ for the most up-to-date
documentation and information, including everything here and much more.

Floater is a free program for duplicate bridge play on the Internet.
It also supports non-duplicate bridge and 3-player hearts.

Floater 1.2 is a minor upgrade to 1.1 that includes several changes:
  o  Faster server
  o  New installer for Microsoft Windows users
  o  Some bug fixes

Version 1.2 is not interoperable with older versions.

To install, Microsoft Windows users should download and run the
installer from the Floater web page.  Unix users will need to rebuild
from scratch as described below.

Please report bugs to bugs@floater.org.

Floater for Macintosh will be available soon.  Sorry for the delay.

Please read this file as well as the files called BUGS and CONFUSING.

Microsoft Windows Installation Instructions:
--------------------------------------------

Download and run the installer, inst12b1.exe, available at
http:slashslashwww.floater.org/inst12b1.exe.  The installer has two basic
steps.  Step 1: the installer checks for Tcl/Tk 8.0 and offers to
download and install it for you if necessary.  Step 2: the installer
downloads the Floater executable and associated files from floater.org
and creates a shortcut to Floater from the Desktop and from the
Start Menu.

After installing Floater, you may delete the installer.

Unix Installation instructions:
-------------------------------

Please be aware that these instructions are for installation only.
See the web page for other, ultimately more useful, information.

Please read carefully.  Unlike the Mac and Microsoft Windows versions,
you must compile Floater yourself for Unix.  If you have never edited
a Makefile before, you may find this difficult.

If you have problems, please consult the web page to see if there are
notes from others who may have tried compiling Floater on your
architecture/OS.  Send bugs to bugs@floater.org, and also please send
descriptions of what you had to modify to get Floater to work on your
system.  When sending email about problems that you have not yet been
able to solve, please clearly indicate what you have tried so far.
Due to the high volume of email, responses may be slow.

Almost all of the difficult-to-port features of Floater are
implemented by using Tcl and Tk, which have already been ported to
many different machines.  Floater should run on a variety of machines
with no problem.  It is known to compile on SunOS, Solaris,
Linux, HPs (HP/UX), and Silicon Graphics (IRIX), among others.  Don't
be intimidated by the amount of software you may need to install---the
autoconf scripts really work and next to nothing needs to be fixed by hand.

Floater for Unix has two versions---textual and graphical.  Both
require Tcl and Tk, which are freely available.  In addition, the text
version requires System V style curses or ncurses (GNU's free
replacement for curses).  Tcl/Tk 8.0 is required.  You should use the
latest patch level, which as of September, 1999, is 8.0.5.  (Floater
does not work with Tcl/Tk 8.1 or 8.2.  If you port it to Tcl/Tk 8.2
let us know!)

By default, the graphical and textual versions are in the same
executable.  You may build an executable that does not include the
textual version, which is useful if you have X and don't want to deal
with curses (see Makefile for details).

BSD users without ncurses should have it installed anyway, as the
maintainer of BSD curses has publically announced that he is no longer
supporting it and he encourages people to switch to ncurses.  If you
are unsure whether you need ncurses to use Floater, try it first
without ncurses.  You may get ncurses by anonymous ftp from
prep.ai.mit.edu in the /pub/gnu directory.  Or, it is too much
trouble, you may compile only the X user interface (see Makefile for
details).

Detailed instructions follow.  For easier ftp'ing, the Floater
web page (http:slashslashwww.cs.berkeley.edu/~pike/floater/release.html)
allows you to download the appropriate files.

To install Floater 1.2b1 for Unix:
----------------------------------

0. Floater more or less requires UNIX and 32-bit integers.  Brave
souls who try to install it without those things may succeed but with
some difficulty.

1. If your site doesn't have it, install Tcl/Tk, available from the
Tcl/Tk web page at http:slashslashwww.scriptics.com.  Note that Tcl/Tk 8.0.5
is what you should try to use, but 8.0.x is fine.  See above.

2. You may or may not need ncurses.  System V users and many BSD users
should either not need it or already have it.  See above.

3. Get the compressed Floater tar file from the Floater web page.
Uncompress and untar the file by doing:
        gzip -c -d floater1.2b1.tar.gz | tar xvf -

(You may remove floater1.2b1.tar.gz now.)

4. Run the configure script by doing changing to the floater1.2b1
directory and running ./configure.  The flags accepted by the
configure script are as follows:
  --with-tcl=/some/path
     will look for tcl headers files and libs in /some/path/include
     and /some/path/lib

  --with-tk=/some/path
     same as --with-tcl but for tk

  --with-curses=/some/path
     same as above but for curses (it tries to look for ncurses and
     then curses but may not be perfect...)

  --without-curses
     doesn't look for curses at all and defines GUI_ONLY when
     building.

If the configure script runs successfully, it creates a Makefile.
(Thanks to Andrew Swan for creating the new and improved configure script!)

5. Do "make".  It may or may not work.  If it doesn't work, edit the
file Makefile.in to try to set up the paths for various libraries,
etc., as necessary.  More instructions are in that file.  Each time
you edit Makefile.in, do "make Makefile" to regenerate the Makefile,
and then do (just) "make" again.  (On some systems you can just do
"make" and it will automatically recreate the Makefile and then try to
recompile.)  If desperate, you may also want to refer to
Makefile.pike, which is a Makefile that is known to work on at least
one system somewhere.

6. Once you have successfully built Floater, a common problem when you
first run it is an error message about being unable to find init.tcl
in certain directories.  The easiest solution, if you have Tcl and Tk
in sibling directories, is to create a directory called lib, sibling
to those two, and do:
        cd lib
        ln -s ../tk8.0/library tk8.0
        ln -s ../tcl8.0/library tcl8.0

Another solution is to find init.tcl and put a copy of it in one of
the directories in which it is looking when you start up Floater.
Another is, before running Floater, to do "setenv TCL_LIBRARY <dir>"
where <dir> is the directory containing init.tcl (typically
<something>/tcl8.0/library).  A third is to properly install Tcl by
doing "make install" in the tcl8.0/ 1  directory---but you probably
have to be root to do this.

(Once you fix that, the analogous problem will likely crop up with Tk.
It will complain that it can't find a usable tk.tcl.  The same fixes
apply, but be sure to copy all the .tcl files in tk8.0/library if you
choose that solution.)
}
gset Confusing {This file is intended to list some of the more confusing aspects of
using Floater.

1. Floater relies on self-alerts.  If playing formally, you are
expected to explain your bidding and carding agreements as carefully
as you would at a tournament.  In any case, you alert by using the
commands `alert,' `redalert' and `explain.'   You should alert
at the same time or before you take an alertable action.  There are no
fixed rules as to what agreements are alertable---use your judgment
and do unto others as you would have them do unto you.

The easy way to alert an action is to type "!" (or "!!" for redalert)
on the same line as the command to perform that action---and
optionally put an explanation at the end.  For example, you could type
"2D!weak two in either major" to bid and alert your own bid
simultaneously.  See also the help on `alert,' `redalert' and
`explain.'

If you are using the graphical user interface, you may click on the
"Alert" or "Redalert" checkboxes BEFORE clicking on the call you wish
to make.  For example, clicking on "1C" when the "Alert" checkbox is
highlighted will have the same effect as typing "1C!" on the keyboard.

Everyone at the table except partner sees your alerts.

2. See also the file called BUGS.
}
gset Bugs {This file lists some of the known bugs and limitations of Floater.
Please read it.  You may assume everything listed here is being worked
on and will be eventually fixed.  Older bugs are at toward the bottom;
newer bugs are toward the top.  An asterisk after the numeral
indicates that the bug has been fixed.  (Some of the listings may be
cryptic or incomprehensible---my apologies.)

Send bug reports to bugs@floater.org.

8. When I host, scoring method defaults to whatever it was at the
previous table.  Furthermore, when I do, say, "score imp," the list of
tables isn't updated immediately.

7. When using the GUI, occasionally I have had the menu bar at the
top disappear and not come back.  This appears to be a Tcl/Tk bug.  If
it happens, iconify Floater and then restore it, and the menu bar
will reappear.

6. The review command sometimes puts your side's actions in parens.
I think it should always put the other guys' actions in parens.

5.. Pseudomail works but doesn't correctly report whether it succeeded.
(It always reports success.)

4. The documentation is a work in progress.  For the latest, look at:
     http:slashslashwww.floater.org/doc

3. Curses may be confused about your screen size or terminal attributes.
Putting the following in your .cshrc may do the trick:
    setenv TERM vt100

    set noglob
    eval `tset -s`
    unset noglob

Another possible fix is to try doing:
    eval `resize`

2. Logging in disconnects you from the table.  (This is becuase the other
players would become confused if your name suddenly changed.  But it
can be fixed.)

1. Sometimes after being shunted (when you do the `host' command) you
find that you do not get connected properly to the table tree.  When
this happens, try again a few times.  As a last resort, you may do
`host <tablename>' to try to join the table tree at that location.
}
gset help_texts {Copyright Readme Confusing Bugs}
# 19 "tclcode/texts.deq" 2

proc display_text {name s} {
    global fixedfont
     
    set slash /
    regsub -all slashslash $s $slash$slash text

    talkmsg $text
# 44 "tclcode/texts.deq"

}
# 44 "tclcode/floater.TCL" 2






gset floaterclock 0
gset table_arrival_time 0
gset snooze 0


# 63 "tclcode/floater.TCL"



 

gset ntalklines 0  

gset dtalklines 0  
		   

gset talklineattop 0  
 
 

gset showerrors 1
gset debugprinting 0


if $floater_silent {
    proc clearrect {x y} {puts stdout "clearrect $x $y"}
    proc anchor {l} {puts stdout "anchor $l"}
    proc down_and_anchor {{l 1}} {puts stdout "down_and_anchor $l"}
    proc right {{l 1}} {puts stdout "right $l"}
    proc str {l} {puts stdout "str `$l'"}
    proc ch {l} {puts stdout "ch $l"}
}

proc talkmsg {s {draw 1} {allowPrefix 1}} {
    global talklines ntalklines talkwidth debugprinting showerrors
    global dtalklines scrolllock talktop floater_silent floater_silent_conns

    if $floater_silent {
	puts $s
	global conn_to_sock
	foreach conn [array names floater_silent_conns] {
	    catch {puts $conn_to_sock($conn) $s}
	}
	return
    }




    if $debugprinting return

    if {$talktop < 0} return
    if {!$showerrors && [regexp -nocase error $s]} return
    
     
    if [regexp "(.*)\n(.*)" $s whole a b] {
	talkmsg $a
	talkmsg $b
	return
    }
    
    if {[string length $s] > $talkwidth} {
	 
	for {set i $talkwidth} {[incr i -1] > 0} {} {
	    if {[string index $s $i] == " "} {
		incr i -1
		talkmsg [string range $s 0 $i] 0 0
		talkmsg [string range $s [expr $i + 2] end] $draw 0
		return
	    }
	}
	 
	talkmsg [string range $s 0 [expr $talkwidth - 1]] 0 0
	talkmsg [string range $s $talkwidth end] $draw 0
	return
    }

    set talklines($ntalklines) $s
    incr ntalklines
    if !$scrolllock {set dtalklines $ntalklines}
    if $draw {drawtalkregion}
}
# 152 "tclcode/floater.TCL"


proc floatererror {s} { talkmsg "ERROR: $s" }

 


 
if {[catch {source $startupfile} err] 	&& ![regexp -nocase {no such file} $err]} {


    talkmsg "ERROR: $err"



}







tryset loginservername "loginserver"
tryset loginserveraddr "128.32.131.251"
tryset loginserverport "2210"
tryset resultservername "resultserver"
tryset resultserveraddr "128.32.131.251"
tryset resultserverport "1430"
tryset pseudomailaddr "128.32.131.251"
tryset pseudomailport "1440"
tryset resultparserprogram /home/cs/pike/floater/floatres/parsemail
tryset resultparser "floater@floater.org"
tryset bugmail "pike@cs.berkeley.edu" ; # "bugs@floater.org"

 
tryset defaultnote ""

 
tryset tricktime 2000

 
 



tryset autonewdeal_default 35


 
tryset autonewdeal_seconds $autonewdeal_default

tryset nokibitzers 0
tryset jointableservertree 1

tryset youveseen 1

tryset newbie [expr ![info exists usedname]]

 
 
 
# 240 "tclcode/floater.TCL"


 
 
 
# 400 "tclcode/floater.TCL"

 

gset tcl_interactive 1

set needAuctionUpdate 0

# 1 "tclcode/options_common.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
 

 
 
 

set beepAtMyTurn_ 0
proc beepAtMyTurn {{toggle 0}} {
    global beepAtMyTurn_

    if $toggle {set beepAtMyTurn_ [expr !$beepAtMyTurn_]}
}

# 407 "tclcode/floater.TCL" 2






# 1 "tclcode/matrix0.deq" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset newstyle_matrix 0

proc redrawmatrixcards {} {}

proc togglepassedcard {suit card} {
    global togglepassedaction

    if [info exists togglepassedaction([string toupper $suit$card])] 	    {catch $togglepassedaction([string toupper $suit$card])}

}

proc removecardfromhand {suit card} {
    global removecard

    if [info exists removecard([string toupper $suit$card])] 	    {catch $removecard([string toupper $suit$card])}

}

# 48 "tclcode/matrix0.deq"



 
proc rmcard {x y suit card} {
    set f "$x $y"
    anchor $f
    set suit [string toupper $suit]
    if {$suit == "S"} {rmcard2 $f $suit $card} {down_and_anchor}
    if {$suit == "H"} {rmcard2 $f $suit $card} {down_and_anchor}
    if {$suit == "D"} {rmcard2 $f $suit $card} {down_and_anchor}
    if {$suit == "C"} {rmcard2 $f $suit $card}
}

proc rmcard2 {f suit card} {
    global cursuit

    right 2  
    set w [set "cursuit($f$suit)" [zap $card $cursuit($f$suit)]]
    str "$w "
}

 
proc zap {char text} {
    set i [string first $char $text]
    if {$i < 0} {  
	return $text
    } elseif {$i == 0} {
	return [string range $text 1 end]
    } else {
	incr i -1
	set j [expr $i + 2]
	 
	return "[string range $text 0 $i][string range $text $j end]"
    }
}

  

 
proc suit {f cards suit} {

    global cursuit removecard

    set suit [string toupper $suit]
    set cards [string toupper $cards]
    str "$suit $cards"
    down_and_anchor
    set "cursuit($f$suit)" $cards
    for {set i [expr [string length $cards] - 1]} {$i >= 0} {incr i -1} {
	set card [string index $cards $i]
	set removecard([string toupper $suit$card]) "rmcard $f $suit $card"
    }
# 122 "tclcode/matrix0.deq"

}

 
 
proc hand {f s h d c} {
# 148 "tclcode/matrix0.deq"

    global handwidth
    anchor $f
    clearrect $handwidth 4

    suit $f $s s
    suit $f $h h
    suit $f $d d
    suit $f $c c 
}

# 184 "tclcode/matrix0.deq"


# 195 "tclcode/matrix0.deq"


 
 
 
proc fulldeal {s h d c LHOs LHOh LHOd LHOc 		   Ps Ph Pd Pc RHOs RHOh RHOd RHOc} {

    global mframe

    hand $mframe(self) $s $h $d $c
    hand $mframe(pard) $Ps $Ph $Pd $Pc
    hand $mframe(lho) $LHOs $LHOh $LHOd $LHOc
    hand $mframe(rho) $RHOs $RHOh $RHOd $RHOc
}

gset tricktimeOK 1

 
 
proc startshowtricktimer {} {
    global tricktime tricktimeOK

    set tricktimeOK 0
    after $tricktime set tricktimeOK 1
}

 
 
proc delayedclearmatrix {} {
    global needtoerase

    set needtoerase 1
    after 5000 clearmatrixtimer
}

proc clearmatrixtimer {} {
    global needtoerase

    if $needtoerase {erasebidplay all}
}

 
 
proc erasebidplay {who} {
    global tricktimeOK

    while {!$tricktimeOK} {
	update
	after 100
    }
    if {$who == "all"} {
	global needtoerase

	set needtoerase 0
	erasebidplay lho
	erasebidplay rho
	erasebidplay pard
	erasebidplay self
    } else {

	global matrixtext
	
	anchor $matrixtext($who)
	clearrect 2 1




    }
}

 
 
 
proc showplay {player suit card} {

    global matrixtext

    anchor $matrixtext($player)
    if {$suit == "?"} {
	str "? "
    } else {
	str $suit$card
    }
# 298 "tclcode/matrix0.deq"

}

 
 
 
 
proc showbid {player level strain} {
 

    global matrixtext

    anchor $matrixtext($player)
    if {$strain == "-"} {
	str "  "
    } elseif {$strain == "?"} {
	str "? "
    } elseif {$level > 0} {
	str "$level$strain "
    } else {	
	str "$strain "
    }



}


proc drawbid {x y level strain} {
    global auctionx auctiony auctionbot

 

    if {[expr $auctiony + $y + 2] <= $auctionbot} {
	anchor "[expr $auctionx + 1 + 4 * $x] [expr $auctiony + $y + 2]"

	 
	if {$strain == "x"} {
	    set s "X "
	} elseif {$strain == "xx"} {
	    set s "XX"
	} elseif {$strain == "p"} {
	    set s "P "
	} elseif {$strain == "-"} {
	    set s "  "
	} elseif {$strain == "?"} {
	    set s "? "
	} else {
	    set s $level$strain
	}
	
	clearrect 2 1
	if {$s != "  "} {str [string toupper $s]}
    }
}
# 396 "tclcode/matrix0.deq"


 
 
proc setname {player compassdir name} {

    global namepos namewidth

    anchor $namepos($player)
    if {[string first "(" $name] == -1} {set name "$name ($compassdir)"}
    if {[string length $name] > $namewidth} {
	set name [string range $name 0 [expr $namewidth - 1]]
    }
    if {$player == "self" || $player == "pard"} {
	rightjustify $name $namewidth
    } else {
	clearrect $namewidth 1
    }
    str $name
# 427 "tclcode/matrix0.deq"

}

# 413 "tclcode/floater.TCL" 2



gset showingauction 0

 

proc showauction {bool} {
    global auctionx auctiony auctionwidth auctionheight auctionright auctionbot
    global showingauction

    set showingauction $bool
    anchor "$auctionx $auctiony"
    clearrect $auctionwidth $auctionheight
    if $bool {
	hline . $auctionx $auctionright $auctiony
	vline . $auctionx $auctiony $auctionbot
    }
    textseated
}
# 444 "tclcode/floater.TCL"



 
proc rightjustify {s width {r 1}} {
    while {[string length $s] < $width} {
	set s " $s"
	if $r {ch " "}
    }
    return $s
}



proc hline {c xlo xhi y} {
    anchor "$xlo $y"
    for {} {$xlo <= $xhi} {incr xlo} {ch $c}
}

proc vline {c x ylo yhi} {
    anchor "$x $ylo"
    for {} {$ylo <= $yhi} {incr ylo} {ch $c; down_and_anchor}
}

 
hline - 30 46 4
hline - 30 46 10
vline | 29 5 9
vline | 47 5 9
 
 
gset mframe(self) {30 11}
gset mframe(pard) {30 0}
gset mframe(lho) {15 6}
gset mframe(rho) {49 6}
gset handwidth 14
 
gset namewidth 14
gset namepos(self) {15 11}
gset namepos(pard) {15 0}
gset namepos(lho) {15 5}
gset namepos(rho) {49 5}
 
gset matrixtext(self) {37 9}
gset matrixtext(pard) {37 5}
gset matrixtext(lho) {31 7}
gset matrixtext(rho) {43 7}
 
gset auctionx 64
gset auctiony 5
gset auctionright 79
gset auctionbot 14
gset auctionwidth [expr $auctionright - $auctionx + 1]
gset auctionheight [expr $auctionbot - $auctiony + 1]


# 570 "tclcode/floater.TCL"









 
set x [expr ![catch {regexp -nocase "Apr 1 " [exec date]} y]]
if !$x {set y 0}
if [expr $x && $y] {
 fulldeal AKQJ AKQJ AKQJ AK T98 T98 T98 QJT9 765 765 765 876 432 432 432 5432
 showbid self 8 n
} else {
 fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2
 showbid self 7 n
}

# 801 "tclcode/floater.TCL"



 
 
 
 

gset previous_trick_index 0
gset previous_trick {}

proc reset_previous_trick {{index -999}} {
    global previous_trick previous_trick_index

    if {$index == -999 || $index == $previous_trick_index} {
	set previous_trick {}
    }
}

proc set_previous_trick {s {erase 1}} {
    global previous_trick previous_trick_index

    set previous_trick $s
    incr previous_trick_index

     
    if $erase {after 10000 "reset_previous_trick $previous_trick_index"}
}

 


gset oldpov S
gset oldseated 0

proc textseated {{seated -1} {pov S}} {
    global auctionx auctiony showingauction oldseated oldpov

    if {$seated == -1} {set seated $oldseated; set pov $oldpov}
    set oldseated $seated
    set oldpov $pov
    if !$showingauction return

    anchor "$auctionx $auctiony"
    down_and_anchor
    right 1
    if $seated {
	str "LHO Par RHO you"
    } else {
	if {$pov == "S"} {
	    str "(W) (N) (E) (S)"
	} elseif {$pov == "N"} {
	    str "(E) (S) (W) (N)"
	} elseif {$pov == "E"} {
	    str "(S) (W) (N) (E)"
	} elseif {$pov == "W"} {
	    str "(N) (E) (S) (W)"
	}
    }
}


 
proc newauction {} {

    showauction 1







}


 
 
 
 

 
set statusline {}
set infoline {}

gset leftwidth 14
gset rightwidth 30
gset rightpos 50

proc strinfield {s x y width} {
    anchor "$x $y"
    clearrect $width 1
    if {[string length $s] > $width} 	    {set s [string range $s 0 [expr $width - 1]]}

    str $s
}

strinfield $floater_version 0 0 15

 
proc connstat {{s {}}} {
    global leftwidth
    strinfield $s 0 1 $leftwidth 
}

 
proc displayhandname {{s {}}} {
    global leftwidth
    strinfield $s 0 2 $leftwidth
}

proc statushandvul {{s {}}} {
    global leftwidth
    strinfield $s 0 3 $leftwidth
}

proc statushanddlr {{s {}}} {
    global leftwidth
    strinfield $s 0 4 $leftwidth
}

proc statuscontract {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 0 $rightwidth
}

proc statustolead {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 1 $rightwidth
}

proc displaytrickswon {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 2 $rightwidth
}

 
proc statusclaim {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 3 $rightwidth
}

proc statusresult {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 4 $rightwidth
}

 
proc statusscore {{s {}}} {
    global leftwidth
    
    set x 0
    set y 5
    
    if {$s == ""} {set s " ; ; ; ; "}  

    while {[regexp {([^;]*); (.*)} $s whole t s]} {
	strinfield $t $x $y $leftwidth
	incr y
    }
    strinfield $s $x $y $leftwidth
}



gset oldntalklines 0
gset scrolllock 0




proc drawtalkregion {{must_redraw 0}} {
    global talklines dtalklines talktop talklineattop talkbottom oldntalklines
    global scrolllock ntalklines
    
    draw_on_current_display +

    set talksize [expr $talkbottom - $talktop + 1]

    if {($dtalklines >= $ntalklines) || ($ntalklines < $talksize)} {
	set dtalklines $ntalklines
	set scrolllock 0
    }

    set want_to_redraw 	   [expr ($dtalklines - $talklineattop) > $talksize]

    if {$must_redraw || ($want_to_redraw && !$scrolllock)} {
	 
	set y $talktop
	set i [set talklineattop [expr $dtalklines - $talksize]]
	if {$i < 0} {
	    if $scrolllock {set dtalklines $talksize}
	    set i 0
	}
	for {set talklineattop $i} 	    {($y <= $talkbottom) && ($i < $dtalklines) && ($i < $ntalklines)} 	    {incr i; incr y} {


		drawtalkline $y $talklines($i)
	}
	
	 
	if {$i == $ntalklines} {set scrolllock 0}
    } elseif !$scrolllock {
	 
	for {set y $talktop; set i $talklineattop} 		{$y <= $talkbottom && $i < $dtalklines} 		{incr i; incr y} {


	    if {$i >= $oldntalklines} {drawtalkline $y $talklines($i)}
	}
    }
    set oldntalklines $ntalklines
    reset_cursor_position
    draw_on_current_display -
}

proc talkscroll {n} {
    global scrolllock dtalklines

    incr dtalklines $n
    set scrolllock 1
    drawtalkregion 1
}

proc turn_off_scrolllock {} {
    talkscroll 1000000
}

proc talkregion {top bottom} {
    global talktop talkbottom talklineattop scrolllock

    set talktop $top
    set talkbottom $bottom
    drawtalkregion 1
}

proc drawtalkline {y s} {
    anchor "0 $y"
    str "$s\n"
}






proc debugmsg {s} {
    global debugprinting floater_silent

    set old $debugprinting
    set debugprinting 1
    talkmsg $s
    set debugprinting $old
    if $floater_silent {puts $s}
}

 
 
 

proc setcursor {cursor w} {









}

proc unsetcursor {w} {

# 1083 "tclcode/floater.TCL"

}

proc patientcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel] == 1} {setcursor watch .}
}

proc normalcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel -1] == 0} {unsetcursor .}
}
set cursorlevel 0
	








 
 
 

 
 

 



tryset tabletimeout 600


 
tryset tablereannounce 90


 
 

set receiveiamalivelist {}
set sendiamalivelist {}

 
tryset sendiamaliveinterval 40000

 
tryset receiveiamaliveinterval 20000

 



tryset iamalivetimeout 450


proc shouldreceiveiamalive {conn} {
    global receiveiamalivelist

    set receiveiamalivelist [linsert $receiveiamalivelist 0 $conn]
}

proc shouldnotreceiveiamalive {conn} {
    global receiveiamalivelist

    catch {
	set i [lsearch $receiveiamalivelist $conn]
	set receiveiamalivelist [lreplace $receiveiamalivelist $i $i]
    }
}

proc shouldsendiamalive {conn} {
    global sendiamalivelist

    set sendiamalivelist [linsert $sendiamalivelist 0 $conn]
}

proc shouldnotsendiamalive {conn} {
    global sendiamalivelist

    catch {
	set i [lsearch $sendiamalivelist $conn]
	set sendiamalivelist [lreplace $sendiamalivelist $i $i]
    }
}

proc sendiamalives {} {
    global sendiamalivelist sendiamaliveinterval

    after $sendiamaliveinterval sendiamalives
    foreach conn $sendiamalivelist {
	debugmsg "Sending iamalive to $conn"
	catch {FloaterSend $conn *alive*}
    }
}

proc checkreceiveiamalive {conn} {
    global iamalivetimeout timeofmostrecent floaterclock

 
    catch {
	debugmsg "seconds since most recent msg on $conn: [expr ($floaterclock - $timeofmostrecent($conn))]"
	if [expr ($floaterclock - $timeofmostrecent($conn)) > $iamalivetimeout] 		{floatertimeout $conn}

    }
}

proc checkreceiveiamalives {} {
    global receiveiamalivelist receiveiamaliveinterval

    after $receiveiamaliveinterval checkreceiveiamalives
    foreach conn $receiveiamalivelist { checkreceiveiamalive $conn }
}

sendiamalives
checkreceiveiamalives

 
 
 
 
 

gset MyTurnTimer -99
tryset MyTurnTimerCountdown 20
proc startMyTurnTimer {} {
    global MyTurnTimerCountdown MyTurnTimer
    set MyTurnTimer $MyTurnTimerCountdown
}    

proc MyTurnTimerRing {} {
    global showingauction
    if $showingauction {
	showauction 0
	showauction 1
	startMyTurnTimer
    }
}

proc stopMyTurnTimer {} {
    global MyTurnTimer
    set MyTurnTimer -99
}

 

proc floaterclockbump {} {
    global floaterclock MyTurnTimer

    incr floaterclock
    if {$MyTurnTimer > 0} {if {[incr MyTurnTimer -1] == 0} MyTurnTimerRing}
    after 1000 floaterclockbump
     
     
    if {[expr $floaterclock % 3] == 0} {command {}}
}

after 1000 floaterclockbump


proc countdown {x} {
    global $x

    if {[set $x] > 0} then "after 1000 \"countdown $x\"" else return
    incr $x -1
}

proc reset_rejoinnow {} {
    global rejoinclock rejoinclockincrement

    set rejoinclock 0
    set rejoinclockincrement 1
}

proc rejoinnow {} {
    global rejoinclock rejoinclockincrement

    if {$rejoinclock <= 0} then {
	if {$rejoinclockincrement < 1800} 		{set rejoinclockincrement [expr 2 * $rejoinclockincrement]}

	set rejoinclock $rejoinclockincrement
	countdown rejoinclock
	return 1
    } else {return 0}
}

proc reset_find_rho {} {
    global rhoclock rhoclockincrement

    set rhoclock 0
    set rhoclockincrement 1
}

proc findrhonow {} {
    global rhoclock rhoclockincrement

    if {$rhoclock <= 0} then {
	if {$rhoclockincrement < 1800} 		{set rhoclockincrement [expr 2 * $rhoclockincrement]}

	set rhoclock $rhoclockincrement
	countdown rhoclock
	return 1
    } else {return 0}
}

reset_find_rho
reset_rejoinnow

 
gset autodealing 0

proc autonewdeal {} {
    global autonewdeal_seconds autodealing

    if $autodealing return
    if {$autonewdeal_seconds >= 0} {
	set autodealing 1
	after [expr 1000 * $autonewdeal_seconds] {
	    global autodealing
	    
	    if $autodealing {
		set autodealing 0
		if {$autonewdeal_seconds >= 0} {command autodeal_now}
	    } else {





	    }
	}
    }
}

proc updateloc {} {
    global updateloc_seconds

    after [expr 1000 * $updateloc_seconds] updateloc
    catch {command iupdatelocation}
}

tryset updateloc_seconds 300
updateloc

 
 
 

 
 
gset should_defer 0

proc command args {
    global should_defer

    if $should_defer {deferpush "commandn $args"} else {eval "commandn $args"}
}










proc floaterreceive {msg conn} {
    global should_defer timeofmostrecent floaterclock

    set timeofmostrecent($conn) $floaterclock
     
    if {$msg == "*alive*"} return

    if $should_defer {
	deferpush "floaterreceiven {$msg} {$conn}"
    } else {
	floaterreceiven $msg $conn
    }
}

proc talk args {
    global should_defer

    if $should_defer {deferpush "talkn $args"} else {eval "talkn $args"}
}

proc FloaterClose args {
    global should_defer

    if $should_defer {deferpush "FloaterClosen $args"} 	    else {eval "FloaterClosen $args"}

}










proc floatertimeout args {
    global should_defer

    if $should_defer {deferpush "floatertimeoutn $args"} 	    else {eval "floatertimeoutn $args"}

}

 
 
 

 
 
proc defer {n} {
    global should_defer

    if {[incr should_defer $n] == 0} {
	while {![deferempty]} {eval [deferpop]}
    }
}

gset deferqueuelo 0
gset deferqueuehi 0

proc deferempty {} {
    global deferqueuehi deferqueuelo

    return [expr $deferqueuelo == $deferqueuehi]
}

proc deferpush {s} {
    global deferqueue deferqueuehi
    
    set deferqueue($deferqueuehi) $s
    incr deferqueuehi



}

proc deferpop {} {
    global deferqueue deferqueuelo
    
    set temp $deferqueue($deferqueuelo)
    unset deferqueue($deferqueuelo)
    incr deferqueuelo



    return $temp
}

 
 
 

set executing_index 0

proc Floater_execute {file} {
    global executing_index executing_command
    if {[set n [gets $file s]] >= 0} {
	if {$n > 0} {
	    deferpush "show_executing [incr executing_index]; Floater_execute $file"
	    set executing_command($executing_index) $s
	    return
	}
    }
    catch {close $file}
}    

proc show_executing {n} {
    global executing_command

    talkmsg "Execute: $executing_command($n)"
    commandn $executing_command($n)
    unset executing_command($n)
}
 
 
 

proc untabify {s} {
    if [regexp {([^	]*)	(.*)} $s whole left right] {
	set i [string length $left]
	while 1 {
	    set right " $right"
	    incr i
	    if [expr $i % 8 == 0] {return [untabify $left$right]}
	}
    } else {return $s}
}

proc truncate {s {n 80}} {
    if {[string length $s] > $n} {
	return [string range $s 0 [expr $n - 1]]
    } else {
	return $s
    }
}

proc unbraceclean {s} {
    regsub -all {\\(\[|\]|\{|\})} $s {\1} x
    return $x
}

proc beginnewcc {direction} {
    global newcc newccline newccignoring

    set newccline 0
    set newccignoring 0
    set newcc $direction
}

proc addnewcc {s {bracecleaned 1}} {
    global newcc newccline cc newccignoring

    set s [untabify [truncate $s]]
    if $bracecleaned {set s [unbraceclean $s]}
    if {$newccline == 40} {set newccignoring 1; return}
    set cc($newcc,[incr newccline]) $s
}

proc endnewcc {} {
    global newcc newccline newccignoring cclines

    set cclines($newcc) $newccline
     
    if $newccignoring {
	return "Warning: Ignored lines beyond the first 40"
    } else {
	return ""
    }
}

 
 
proc ccstr {direction} {
    global cc cclines

    set s ""
    catch {
	if {$cclines($direction) < 1} {return ""}
	set s $cc($direction,1)
	for {set i 2} {$i <= $cclines($direction)} {incr i} {
	    set s "$s\t$cc($direction,$i)"
	}
    }
    return $s
}

gset lastrange ""  
proc inrange {n range} {
    global lastrange lastrangelow lastrangehigh  

    if {$range != $lastrange} {
	set lastrange $range
	if [regexp {^([0-9]+)-([0-9]+)$} $range x lastrangelow lastrangehigh] {
	     
	} elseif [regexp {^([0-9]+)$} $range lastrangelow] {
	    set lastrangehigh $lastrangelow
	} elseif [regexp {^([0-9]+)-$} $range x lastrangelow] {
	    set lastrangehigh 1000000
	} elseif [regexp {^-([0-9]+)$} $range x lastrangehigh] {
	    set lastrangelow -1000000
	} else {error "Invalid range: $range"}
    }
    expr ($n >= $lastrangelow) && ($n <= $lastrangehigh)
}

proc ccdump {direction {range 1-}} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	if [inrange $i $range] {
	    talkmsg $cc($direction,$i)
	}
    }
}

proc ccsave {file direction} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	puts $file $cc($direction,$i)
    }
    close $file
}

proc getccline {direction line} {
    global cc cclines

    if ![info exists cclines($direction)] {return ""}
    if {$line <= $cclines($direction)} {
	return $cc($direction,$line)
    } else {
	return ""
    }
}

 
 
 

 
 
proc reverse_init {} {
    global reverse_n

    set reverse_n 0
}

proc reverse_print {s} {
    global reverse_n reverse_lines

    set reverse_lines($reverse_n) $s
    incr reverse_n
}

proc reverse_done {} {
    global reverse_n reverse_lines

    while {[incr reverse_n -1] >= 0} {
	talkmsg $reverse_lines($reverse_n)
	unset reverse_lines($reverse_n)
    }
}

 
proc Floater_login {} {
    global loginname loginpassword newbie

    toplevel .login

    frame .login.left
    frame .login.right
    frame .login.bottom

    button .login.bottom.cancel -text "Cancel" 	-command {set loginname ""; set loginpassword ""; destroy .login}

    button .login.bottom.clear -text "Clear" 	-command {set loginname ""; set loginpassword ""; focus .login.right.n}

    button .login.bottom.ok -text "OK" 	-command {destroy .login}


    proc newbietr {name el op} {
	global pw_or_email newbie

	if $newbie {set pw_or_email "Email address: "} 		{set pw_or_email "Password: "}

    }

    checkbutton .login.new -text "New User" -variable newbie
    trace variable newbie w newbietr
    if [info exists newbie] {set newbie $newbie} {set newbie 0}

    label .login.left.n -text "Name: "
    label .login.left.p -textvariable pw_or_email -width 13

    entry .login.right.n -bd 2 -relief sunken -textvariable loginname
    entry .login.right.p -bd 2 -relief sunken -textvariable loginpassword

    pack .login.bottom.cancel .login.bottom.clear .login.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m

    pack .login.left.n .login.left.p
    pack .login.right.n .login.right.p
    pack .login.bottom -side bottom
    pack .login.new -side bottom -pady 2m
    pack .login.left -side left -fill x -expand yes
    pack .login.right .login.right -side right -fill x -expand yes
    wm title .login "Floater login"

    bindsetup .login.right.n .login.right.p {focus .login.right.p}
    bindsetup .login.right.p .login.right.n {destroy .login}
    bind .login.right.n \\ {set loginname ""}

    grab set .login
    tkwait window .login
    trace vdelete newbie w newbietr
    set loginname [string trim $loginname]
    catch focus_cmdline
    if $newbie {return "N$loginname\\$loginpassword"} 	    {return "O$loginname\\$loginpassword"}

}

proc Floater_changepw {} {
    global changepwname oldpassword newpassword

    toplevel .changepw

    frame .changepw.left
    frame .changepw.right
    frame .changepw.bottom


    button .changepw.bottom.cancel -text "Cancel" 	-command {set changepwname ""; set oldpassword ""; 	set newpassword ""; destroy .changepw}


    button .changepw.bottom.clear -text "Clear" 	-command {set changepwname ""; set oldpassword ""; 	set newpassword ""; focus .changepw.right.n}


    button .changepw.bottom.ok -text "OK" 	-command {destroy .changepw}


    label .changepw.left.n -text "Name: "
    label .changepw.left.o -text "Old password: "
    label .changepw.left.p -text "New password: "

    entry .changepw.right.n -bd 2 -relief sunken -textvariable changepwname
    entry .changepw.right.o -bd 2 -relief sunken -textvariable oldpassword
    entry .changepw.right.p -bd 2 -relief sunken -textvariable newpassword

    pack .changepw.bottom.cancel .changepw.bottom.clear .changepw.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m

    pack .changepw.left.n .changepw.left.o .changepw.left.p
    pack .changepw.right.n .changepw.right.o .changepw.right.p
    pack .changepw.bottom -side bottom
    pack .changepw.left -side left -fill x -expand yes
    pack .changepw.right .changepw.right -side right -fill x -expand yes
    wm title .changepw "change password"

    bindsetup .changepw.right.n .changepw.right.o {focus .changepw.right.o}
    bindsetup .changepw.right.o .changepw.right.p {focus .changepw.right.p}
    bindsetup .changepw.right.p .changepw.right.n {destroy .changepw}
    bind .changepw.right.n \\ {set changepwname ""}

    grab set .changepw
    tkwait window .changepw
    catch {focus .cmd; focus .cmd.talk}
    return "$changepwname\\$oldpassword\\$newpassword"
}
# 20 "tclcode/floatert.TCL" 2

