/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __TEXT_H__
#define __TEXT_H__

#if GUI_ONLY||SILENT

extern bool needrefresh;

/* #define ch(a,b,c,d) */
#define down_and_anchor 
#define move_to_curyx()
#define update_statusbar()
#define COLS 
#define noecho 
#define draw_on_current_display 
#define reset_cursor_position 
#define LINES 
#define nonl 
#define raw 
#define wrefresh 
#define halfdelay 
#define stdscr 0
#define str 
#define gotch 
#define clearrect 
#define floaterscroll 
#define initscr 
#define beginedit 
#define endwin() 0
#define drawscrn 
#define right(a,b,c,d) 0
#define inittextio 
#define anchor 
#define keypad 
#define intrflush 
#define wgetch 
#define draw_on_matrix_screen() 0
#define turn_off_scrolllock() 0
#define textrefresh() 0
#define text2fieldinput(a,b,c,d,e,f) 0

#else /* not GUI_ONLY */

#ifdef NCURSES_VERSION

#define USE_NODELAY 0 /* because ncurses has halfdelay(), which we prefer */

#else /* not ncurses */

#ifdef NO_HALFDELAY
#define USE_NODELAY 1
#else
#define USE_NODELAY 0
#endif /* NO_HALFDELAY */

#endif /* NCURSES_VERSION */

extern bool needrefresh;

#define textrefresh() { \
			UIsetstatusline(); \
			move_to_curyx(); \
			refresh(); \
			needrefresh = FALSE; \
		      }

int draw_on_current_display(ClientData clientData, Tcl_Interp *interp,
			    int argc, char *argv[]);
int reset_cursor_position(ClientData clientData, Tcl_Interp *interp,
			  int argc, char *argv[]);

int clearrect(ClientData clientData, Tcl_Interp *interp,
	      int argc, char *argv[]);
int anchor(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
int down_and_anchor(ClientData clientData, Tcl_Interp *interp,
		     int argc, char *argv[]);
int right(ClientData clientData, Tcl_Interp *interp,
	  int argc, char *argv[]);
int str(ClientData clientData, Tcl_Interp *interp,
	int argc, char *argv[]);
int ch(ClientData clientData, Tcl_Interp *interp,
       int argc, char *argv[]);

void text2fieldinput(char *label1, char *init1, 
		     char *label2, char *init2,
		     char **result1, char **result2);
void gotch(int c);
void inittextio(void);

void move_to_curyx(void);

#define MATRIX_SCREEN 0
#define NO_MATRIX_SCREEN 1
#define EDIT_SCREEN 2
void drawscrn(int scrn);
void displayscrn(int scrn);
#define draw_on_matrix_screen() \
	(hasWindows ? 0 : (drawscrn(MATRIX_SCREEN), 1))

#define turn_off_scrolllock() TclDo("turn_off_scrolllock")

void floaterscroll(int n);

void update_statusbar(void);

void beginedit(char *, char);

#endif /* GUI_ONLY */
#endif /* ifndef __TEXT_H__ */
