/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.io.ProgramClassWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class ClassDataEntryWriter
implements DataEntryWriter {
    private final ClassPool classPool;
    private final DataEntryWriter dataEntryWriter;

    public ClassDataEntryWriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        String string = dataEntry.getName();
        String string2 = dataEntry.getName();
        if (string2.endsWith(".class")) {
            String string3 = string.substring(0, string.length() - ".class".length());
            Clazz clazz = this.classPool.getClass(string3);
            if (clazz != null) {
                OutputStream outputStream;
                String string4 = clazz.getName();
                if (!string3.equals(string4)) {
                    dataEntry = new RenamedDataEntry(dataEntry, string4 + ".class");
                }
                if ((outputStream = this.dataEntryWriter.createOutputStream(dataEntry)) != null) {
                    DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                    try {
                        clazz.accept(new ProgramClassWriter(dataOutputStream));
                    }
                    catch (RuntimeException runtimeException) {
                        throw (RuntimeException)new RuntimeException("Unexpected error while writing class [" + string3 + "] (" + runtimeException.getMessage() + ")").initCause(runtimeException);
                    }
                    finally {
                        dataOutputStream.close();
                    }
                }
            }
            return new FilterOutputStream(null);
        }
        return this.dataEntryWriter.createOutputStream(dataEntry);
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "ClassDataEntryWriter");
        this.dataEntryWriter.println(printWriter, string + "  ");
    }
}

