/****************************************************************************
 **
 ** $Id: Patch.cpp,v 1.5 2004/12/20 02:42:11 frank Exp $
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "Patch.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"
#include "PatchDialogImpl.h"

Patch * Patch::patchFile(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, QStringList * currentTagList)
{
   return setup(whatsThisIconSet, parent, workBench, false, currentTagList);
}

Patch * Patch::patchDir(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, QStringList * currentTagList) {
   return setup(whatsThisIconSet, parent, workBench, true, currentTagList);
}

Patch * Patch::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, bool isDir, QStringList * currentTagList) {

   DirBase * dir = workBench->selectedItem();
   if (!dir) return NULL;

   if (dir->getType() == DirBase::Cvs) {

      Patch * p = new Patch(whatsThisIconSet, parent, workBench, dir, isDir);

      if (isDir) {
	 p->m_dlg = new PatchDialogImpl(p->m_dir->fullName(),
	       p->m_dir->shortName(),
	       currentTagList,
	       p->m_dir->topControlledDir()->relativeName(),
	       p->m_whatsThisIconSet,
	       p->m_parent);
      } else {
	 p->m_dlg = new PatchDialogImpl(p->m_dir->fullName(),
	       p->m_dir->getSelectedFiles(),
	       currentTagList,
	       p->m_dir->topControlledDir()->relativeName(),
	       p->m_whatsThisIconSet,
	       p->m_parent);

      }
	 
      connect(p->m_dlg,SIGNAL(accept()),p,SLOT(acceptCvs()));
      connect(p->m_dlg,SIGNAL(reject()),p,SLOT(reject()));
      p->m_dlg->show();

      return p;

   } else {
      
      qDebug("Patch: Method not implemented");
      return NULL;
   }

}

Patch::Patch(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_isDir(isDir)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(showWarning(const QString &,const QString &)),parent,SLOT(showWarning(const QString &,const QString &)));
}

Patch::~Patch() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Patch::acceptCvs() {

   if (!m_dir) {
      emit showWarning(tr("Warning"),tr("The former selected dir has\nbeen modified or removed,\naborting"));
      reject();
      return; //show warning
   }

   PatchDialogImpl * dlg = static_cast<PatchDialogImpl*>(m_dlg);
   assert(dlg);
   QString tag = dlg->getCvsCmd();
   QString patchFile = dlg->getPatchFile();
   delete m_dlg;
   m_dlg = NULL;

   QString hlp;
   QString cvsRoot = CvsOptions::cmprStr() + " -Q diff -N ";
   if (bDiffIgnoreWhiteSpace) cvsRoot += "-b -B ";
   if (CvsOptions::g_bUnifiedDiffOutput) cvsRoot += "-u ";
   if (!tag.isEmpty()) cvsRoot += tag + " ";
   if (!m_isDir) cvsRoot += masqWs(m_dir->getSelectedFiles().join("\" \"")) + " ";
   cvsRoot +=  "> " + patchFile;
   QString file = "";
   QString dir = m_dir->fullName();
   QString topModule = m_dir->topControlledDir()->relativeName();
   
   callInteractive( topModule, dir, cvsRoot,
	 file, CVS_PATCH_FILE,
	 ExtApps::g_cvsRsh.path,  //additional options of cvsRsh not supported yet
	 NOROOT);
}

void Patch::reject() {
   emit deleteObject(this);
}

void Patch::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Patch::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Patch::afterCall(int cmd,CvsBuffer*,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject();
      return;
   }
   switch( cmd) {
      case CVS_PATCH_FILE: {
	 break;
      }
      default: {
	 qDebug("Patch::afterCall: Unknown cmd");
      }
   }
   reject();
}
